// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js";import"chrome://resources/ash/common/cr_elements/cr_lottie/cr_lottie.js";import"chrome://resources/cros_components/lottie_renderer/lottie-renderer.js";import"/shared/nearby_page_template.js";import"/shared/nearby_preview.js";import"/shared/nearby_progress.js";import"/strings.m.js";import{TransferStatus,TransferUpdateListenerReceiver}from"/shared/nearby_share.mojom-webui.js";import{CloseReason}from"/shared/types.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getDiscoveryManager}from"./discovery_manager.js";import{getTemplate}from"./nearby_confirmation_page.html.js";class TransferUpdateListener{constructor(page,transferUpdateListener){this.page_=page;this.transferUpdateListenerReceiver_=new TransferUpdateListenerReceiver(this);this.transferUpdateListenerReceiver_.$.bindHandle(transferUpdateListener.handle)}onTransferUpdate(status,token){this.page_.onTransferUpdate(status,token)}}const PROGRESS_BAR_URL="nearby_share_progress_bar.json";const NearbyConfirmationPageElementBase=I18nMixin(PolymerElement);export class NearbyConfirmationPageElement extends NearbyConfirmationPageElementBase{constructor(){super(...arguments);this.transferUpdateListener_=null}static get is(){return"nearby-confirmation-page"}static get template(){return getTemplate()}static get properties(){return{confirmationManager:{type:Object,value:null},transferUpdateListener:{type:Object,value:null,observer:"onTransferUpdateListenerChanged_"},shareTarget:{type:Object,value:null},payloadPreview:{type:Object,value:null},confirmationToken_:{type:String,value:null},errorTitle_:{type:String,value:null},errorDescription_:{type:String,value:null},needsConfirmation_:{type:Boolean,value:false},lastTransferStatus_:{type:TransferStatus,value:null}}}ready(){super.ready();this.addEventListener("accept",this.onAccept_);this.addEventListener("reject",this.onReject_);this.addEventListener("cancel",this.onCancel_)}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}getTransferInfoForTesting(){return{confirmationToken:this.confirmationToken_,transferStatus:this.lastTransferStatus_,errorTitle:this.errorTitle_,errorDescription:this.errorDescription_}}onTransferUpdateListenerChanged_(transferUpdateListener){if(!transferUpdateListener){return}this.transferUpdateListener_=new TransferUpdateListener(this,transferUpdateListener)}onTransferUpdate(status,token){if(token){this.confirmationToken_=token}this.lastTransferStatus_=status;switch(status){case TransferStatus.kAwaitingLocalConfirmation:this.needsConfirmation_=true;break;case TransferStatus.kAwaitingRemoteAcceptance:this.needsConfirmation_=false;break;case TransferStatus.kInProgress:getDiscoveryManager().stopDiscovery().then((()=>this.fire_("close",{reason:CloseReason.TRANSFER_STARTED})));break;case TransferStatus.kComplete:getDiscoveryManager().stopDiscovery().then((()=>this.fire_("close",{reason:CloseReason.TRANSFER_SUCCEEDED})));break;case TransferStatus.kRejected:this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorRejected");break;case TransferStatus.kTimedOut:this.errorTitle_=this.i18n("nearbyShareErrorTimeOut");this.errorDescription_=this.i18n("nearbyShareErrorNoResponse");break;case TransferStatus.kUnsupportedAttachmentType:this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorUnsupportedFileType");break;case TransferStatus.kMediaUnavailable:case TransferStatus.kNotEnoughSpace:case TransferStatus.kFailed:case TransferStatus.kAwaitingRemoteAcceptanceFailed:case TransferStatus.kDecodeAdvertisementFailed:case TransferStatus.kMissingTransferUpdateCallback:case TransferStatus.kMissingShareTarget:case TransferStatus.kMissingEndpointId:case TransferStatus.kMissingPayloads:case TransferStatus.kPairedKeyVerificationFailed:case TransferStatus.kInvalidIntroductionFrame:case TransferStatus.kIncompletePayloads:case TransferStatus.kFailedToCreateShareTarget:case TransferStatus.kFailedToInitiateOutgoingConnection:case TransferStatus.kFailedToReadOutgoingConnectionResponse:case TransferStatus.kUnexpectedDisconnection:this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorSomethingWrong");break}}contactName_(){const contactName=null;if(!contactName||this.errorTitle_){return""}return this.i18n("nearbyShareConfirmationPageAddContactTitle",contactName)}onAccept_(){this.confirmationManager.accept().then((_result=>{}))}onReject_(){this.confirmationManager.reject().then((_result=>{this.fire_("close",{reason:CloseReason.REJECTED})}))}onCancel_(){this.confirmationManager.cancel().then((_result=>{this.fire_("close",{reason:CloseReason.CANCELLED})}))}getActionButtonLabel_(){return this.needsConfirmation_?this.i18n("nearbyShareActionsConfirm"):null}getCancelButtonLabel_(){return this.needsConfirmation_?this.i18n("nearbyShareActionsReject"):this.i18n("nearbyShareActionsCancel")}getCancelEventName_(){return this.needsConfirmation_?"reject":"cancel"}attachmentTitle_(){return this.payloadPreview&&this.payloadPreview.description?this.payloadPreview.description:"Unknown file"}getAnimationUrl_(){return PROGRESS_BAR_URL}}customElements.define(NearbyConfirmationPageElement.is,NearbyConfirmationPageElement);