// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_lottie/cr_lottie.js";import"chrome://resources/cros_components/lottie_renderer/lottie-renderer.js";import"chrome://resources/polymer/v3_0/iron-media-query/iron-media-query.js";import"chrome://resources/polymer/v3_0/iron-list/iron-list.js";import"/shared/nearby_device.js";import"/shared/nearby_page_template.js";import"/shared/nearby_preview.js";import"/strings.m.js";import{SelectShareTargetResult,ShareTargetListenerCallbackRouter,StartDiscoveryResult}from"/shared/nearby_share.mojom-webui.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{sanitizeInnerHtml}from"chrome://resources/js/parse_html_subset.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getDiscoveryManager,observeDiscoveryManager}from"./discovery_manager.js";import{getTemplate}from"./nearby_discovery_page.html.js";const PULSE_ANIMATION_URL="nearby_share_pulse_animation.json";const NearbyDiscoveryPageElementBase=I18nMixin(PolymerElement);export class NearbyDiscoveryPageElement extends NearbyDiscoveryPageElementBase{constructor(){super(...arguments);this.mojoEventTarget_=null;this.listenerIds_=null;this.shareTargetMap_=null;this.discoveryObserver_=null}static get is(){return"nearby-discovery-page"}static get template(){return getTemplate()}static get properties(){return{payloadPreview:{notify:true,type:Object,value:null},confirmationManager:{notify:true,type:Object,value:null},transferUpdateListener:{notify:true,type:Object,value:null},selectedShareTarget:{notify:true,type:Object,value:null},shareTargets_:{type:Array,value:()=>[]},selfShareTargets_:{type:Array,value:()=>[]},nonSelfShareTargets_:{type:Array,value:()=>[]},errorTitle_:{type:String,value:null},errorDescription_:{type:String,value:null}}}connectedCallback(){super.connectedCallback();this.shareTargetMap_=new Map;this.clearShareTargets_();this.discoveryObserver_=observeDiscoveryManager(this)}ready(){super.ready();this.addEventListener("next",this.onNext_);this.addEventListener("view-enter-start",this.onViewEnterStart_);this.addEventListener("view-exit-finish",this.onViewExitFinish_)}disconnectedCallback(){super.disconnectedCallback();this.stopDiscovery_();if(this.discoveryObserver_){this.discoveryObserver_.$.close()}}getShareTargetsForTesting(){return this.shareTargets_}selectShareTargetForTesting(shareTarget){const token=shareTarget.id;assert(this.shareTargetMap_);if(this.shareTargetMap_.has(token)){this.selectShareTarget_(this.shareTargetMap_.get(token));return true}return false}onViewEnterStart_(){this.startDiscovery_()}onViewExitFinish_(){this.stopDiscovery_()}startDiscovery_(){if(this.mojoEventTarget_){return}this.clearShareTargets_();this.mojoEventTarget_=new ShareTargetListenerCallbackRouter;this.listenerIds_=[this.mojoEventTarget_.onShareTargetDiscovered.addListener(this.onShareTargetDiscovered_.bind(this)),this.mojoEventTarget_.onShareTargetLost.addListener(this.onShareTargetLost_.bind(this))];getDiscoveryManager().getPayloadPreview().then((result=>{this.payloadPreview=result.payloadPreview}));getDiscoveryManager().startDiscovery(this.mojoEventTarget_.$.bindNewPipeAndPassRemote()).then((response=>{switch(response.result){case StartDiscoveryResult.kErrorGeneric:this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorSomethingWrong");return;case StartDiscoveryResult.kErrorInProgressTransferring:this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorTransferInProgress");return;case StartDiscoveryResult.kNoConnectionMedium:this.errorTitle_=this.i18n("nearbyShareErrorNoConnectionMedium");this.errorDescription_=this.i18n("nearbyShareErrorNoConnectionMediumDescription");return}}))}stopDiscovery_(){if(!this.mojoEventTarget_){return}this.clearShareTargets_();assert(this.listenerIds_);this.listenerIds_.forEach((id=>assert(this.mojoEventTarget_.removeListener(id))));this.mojoEventTarget_.$.close();this.mojoEventTarget_=null}onNearbyProcessStopped(){if(!this.errorTitle_){this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorSomethingWrong")}}onStartDiscoveryResult(success){if(!success&&!this.errorTitle_){this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorSomethingWrong")}}clearShareTargets_(){if(this.shareTargetMap_){this.shareTargetMap_.clear()}this.shareTargets_=[];this.selfShareTargets_=[];this.nonSelfShareTargets_=[]}onKeyDownForShareTarget_(event){const currentShareTarget=event.currentTarget.shareTarget;assert(currentShareTarget);const currentIndex=this.shareTargets_.findIndex((target=>target.id===currentShareTarget.id));event.stopPropagation();switch(event.code){case"ArrowDown":this.focusShareTarget_(currentIndex+1);break;case"ArrowUp":this.focusShareTarget_(currentIndex-1);break;case"Space":case"Enter":this.selectShareTargetOnUserInput_(currentShareTarget);break}}focusShareTarget_(index){const container=this.shadowRoot.querySelector("#deviceLists");assert(container);const nearbyDeviceElements=container.querySelectorAll("nearby-device");if(index>=0&&index<nearbyDeviceElements.length){nearbyDeviceElements[index].focus()}}onShareTargetClicked_(event){event.preventDefault();const currentShareTarget=event.currentTarget.shareTarget;assert(currentShareTarget);this.selectShareTargetOnUserInput_(currentShareTarget)}selectShareTargetOnUserInput_(shareTarget){if(this.isShareTargetSelected_(shareTarget)){return}this.selectedShareTarget=shareTarget;const selector=this.shadowRoot.querySelector(".selector");assert(selector);selector.select(this.selectedShareTarget)}isShareTargetSelected_(shareTarget){return!!this.selectedShareTarget&&!!shareTarget&&this.selectedShareTarget.id===shareTarget.id}onShareTargetDiscovered_(shareTarget){assert(this.shareTargetMap_);if(shareTarget.forSelfShare){this.updateShareTargetList_(this.selfShareTargets_,"selfShareTargets_",shareTarget)}else{this.updateShareTargetList_(this.nonSelfShareTargets_,"nonSelfShareTargets_",shareTarget)}this.shareTargets_=this.selfShareTargets_.concat(this.nonSelfShareTargets_);this.shareTargetMap_.set(shareTarget.id,shareTarget)}updateShareTargetList_(shareTargetList,shareTargetListString,shareTarget){assert(this.shareTargetMap_);if(this.shareTargetMap_.has(shareTarget.id)){const index=shareTargetList.findIndex((target=>target.id===shareTarget.id));assert(index!==-1);this.splice(shareTargetListString,index,1,shareTarget);this.updateSelectedShareTarget_(shareTarget.id,shareTarget)}else{this.push(shareTargetListString,shareTarget)}}onShareTargetLost_(shareTarget){if(shareTarget.forSelfShare){const index=this.selfShareTargets_.findIndex((target=>target.id===shareTarget.id));assert(index!==-1);this.splice("selfShareTargets_",index,1)}else{const index=this.nonSelfShareTargets_.findIndex((target=>target.id===shareTarget.id));assert(index!==-1);this.splice("nonSelfShareTargets_",index,1)}this.set("shareTargets_",this.selfShareTargets_.concat(this.nonSelfShareTargets_));assert(this.shareTargetMap_);this.shareTargetMap_.delete(shareTarget.id);this.updateSelectedShareTarget_(shareTarget.id,null)}onNext_(){if(this.selectedShareTarget){this.selectShareTarget_(this.selectedShareTarget)}}selectShareTarget_(shareTarget){getDiscoveryManager().selectShareTarget(shareTarget.id).then((response=>{const{result:result,transferUpdateListener:transferUpdateListener,confirmationManager:confirmationManager}=response;if(result!==SelectShareTargetResult.kOk){this.errorTitle_=this.i18n("nearbyShareErrorCantShare");this.errorDescription_=this.i18n("nearbyShareErrorSomethingWrong");return}this.confirmationManager=confirmationManager;this.transferUpdateListener=transferUpdateListener;this.dispatchEvent(new CustomEvent("change-page",{bubbles:true,composed:true,detail:{page:"confirmation"}}))}))}onSelectedShareTargetChanged_(){const deviceList=this.shadowRoot.querySelector("#deviceList");if(!deviceList){return}const selector=this.shadowRoot.querySelector(".selector");assert(selector);this.selectedShareTarget=selector.selectedItem}isShareTargetSelectedToString_(shareTarget){return this.isShareTargetSelected_(shareTarget).toString()}isShareTargetsEmpty_(){return this.shareTargets_.length===0}updateSelectedShareTarget_(id,shareTarget){if(this.selectedShareTarget&&this.selectedShareTarget.id===id){this.selectedShareTarget=shareTarget;const selector=this.shadowRoot.querySelector(".selector");assert(selector);selector.select(this.selectedShareTarget)}}getTabIndexOfShareTarget_(shareTarget){if(this.selectedShareTarget&&shareTarget===this.selectedShareTarget){return"0"}if(this.selfShareTargets_.length!==0&&shareTarget===this.selfShareTargets_[0]){return"0"}if(this.nonSelfShareTargets_.length!==0&&shareTarget===this.nonSelfShareTargets_[0]){return"0"}return"-1"}getAriaLabelledHelpText_(){const tempEl=document.createElement("div");const localizedString=this.i18nAdvanced("nearbyShareDiscoveryPageInfo");const linkUrl=this.i18n("nearbyShareLearnMoreLink");tempEl.innerHTML=localizedString;const ariaLabelledByIds=[];tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`helpText${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"){const n=node;n.id=`helpLink`;ariaLabelledByIds.push(n.id);return}assertNotReached("nearbyShareDiscoveryPageInfo has invalid node types")}));const anchorTags=tempEl.getElementsByTagName("a");if(anchorTags.length===0){return localizedString}assert(anchorTags.length===1,"nearbyShareDiscoveryPageInfo should contain exactly one anchor tag");const anchorTag=anchorTags[0];anchorTag.setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));anchorTag.href=linkUrl;anchorTag.target="_blank";return sanitizeInnerHtml(tempEl.innerHTML,{attrs:["id","aria-hidden","aria-labelledby"]})}getAnimationUrl_(){return PULSE_ANIMATION_URL}}customElements.define(NearbyDiscoveryPageElement.is,NearbyDiscoveryPageElement);