// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_shared_style.css.js";import"chrome://resources/ash/common/cr_elements/cr_radio_group/cr_radio_group.js";import"chrome://resources/ash/common/cr_elements/cr_radio_button/cr_card_radio_button.js";import"chrome://resources/ash/common/cr_elements/cr_icons.css.js";import"chrome://resources/ash/common/cr_elements/cr_toggle/cr_toggle.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/polymer/v3_0/iron-media-query/iron-media-query.js";import"./nearby_page_template.js";import"./nearby_shared_icons.html.js";import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{sanitizeInnerHtml}from"chrome://resources/js/parse_html_subset.js";import{Visibility}from"chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_settings.mojom-webui.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getContactManager,observeContactManager}from"./nearby_contact_manager.js";import{getTemplate}from"./nearby_contact_visibility.html.js";var ContactsState;(function(ContactsState){ContactsState["PENDING"]="pending";ContactsState["FAILED"]="failed";ContactsState["HAS_CONTACTS"]="hascontacts";ContactsState["ZERO_CONTACTS"]="zerocontacts"})(ContactsState||(ContactsState={}));function isHtmlAnchorElement(node){return node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"}const DEVICE_VISIBILITY_LIGHT_ICON="nearby-images:nearby-device-visibility-light";const DEVICE_VISIBILITY_DARK_ICON="nearby-images:nearby-device-visibility-dark";const NearbyContactVisibilityElementBase=I18nMixin(PolymerElement);export class NearbyContactVisibilityElement extends NearbyContactVisibilityElementBase{static get is(){return"nearby-contact-visibility"}static get template(){return getTemplate()}static get properties(){return{ContactsState:{type:Object,value:ContactsState},contactsState:{type:String,value:ContactsState.PENDING},settings:{type:Object,notify:true},selectedVisibility:{type:String,value:null,notify:true},contacts:{type:Array,value:null},numUnreachable_:{type:Number,value:0,observer:"updateNumUnreachableMessage_"},numUnreachableMessage_:{type:String,value:"",notify:true},isVisibilitySelected:{type:Boolean,computed:"isVisibilitySelected_(selectedVisibility)",notify:true},isDarkModeActive_:{type:Boolean,value:false},isAllContactsToggledOn_:{type:Boolean,value(){return true}},profileEmail:{type:String,value:""},isQuickShareV2Enabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("isQuickShareV2Enabled")}}}static get observers(){return["settingsChanged_(settings.visibility)"]}constructor(){super();this.contactManager_=null;this.downloadContactsObserverReceiver_=null;this.downloadTimeoutId_=null}connectedCallback(){super.connectedCallback();this.contactManager_=getContactManager();this.downloadContactsObserverReceiver_=observeContactManager(this);this.downloadContacts_()}disconnectedCallback(){super.disconnectedCallback();if(this.downloadContactsObserverReceiver_){this.downloadContactsObserverReceiver_.$.close()}}isVisibilitySelected_(){return this.selectedVisibility!==null}isVisibility_(selectedVisibility,visibilityString){return selectedVisibility===visibilityString}visibilityStringToValue(visibilityString){switch(visibilityString){case"contacts":if(this.isQuickShareV2Enabled_){return Visibility.kAllContacts}if(this.isAllContactsToggledOn_){return Visibility.kAllContacts}return Visibility.kSelectedContacts;case"yourDevices":return Visibility.kYourDevices;case"none":return Visibility.kNoOne;default:return null}}visibilityValueToString(visibility){switch(visibility){case Visibility.kAllContacts:return"contacts";case Visibility.kSelectedContacts:return"contacts";case Visibility.kYourDevices:return"yourDevices";case Visibility.kNoOne:return"none";default:return null}}downloadContacts_(){if(!this.contacts){this.contactsState=ContactsState.PENDING}this.contactManager_.downloadContacts();this.downloadTimeoutId_=setTimeout(this.onContactsDownloadFailed.bind(this),30*1e3)}toNearbyVisibilityContact_(allowed,contactRecord){assert(contactRecord.identifiers.length>0);const description=contactRecord.identifiers[0].accountName||contactRecord.identifiers[0].phoneNumber||"";return{id:contactRecord.id,description:description,name:contactRecord.personName,checked:allowed}}onContactsDownloaded(allowedContacts,contactRecords,numUnreachableExcluded){clearTimeout(this.downloadTimeoutId_);const allowed=new Set(allowedContacts);const items=[];for(const contact of contactRecords){const visibilityContact=this.toNearbyVisibilityContact_(allowed.has(contact.id),contact);items.push(visibilityContact)}this.contacts=items;this.contactsState=items.length>0?ContactsState.HAS_CONTACTS:ContactsState.ZERO_CONTACTS;this.numUnreachable_=numUnreachableExcluded}onContactsDownloadFailed(){this.contactsState=ContactsState.FAILED;clearTimeout(this.downloadTimeoutId_)}showContactCheckBoxes_(){if(this.isQuickShareV2Enabled_){return false}return this.getSelectedVisibility()===Visibility.kSelectedContacts}getContactAriaHidden_(){if(this.showContactCheckBoxes_()){return"true"}return undefined}inContactsState_(contactsState,expectedState){return contactsState===expectedState}settingsChanged_(){if(this.settings&&this.settings.visibility!==null){this.selectedVisibility=this.visibilityValueToString(this.settings.visibility);this.isAllContactsToggledOn_=this.settings.visibility===Visibility.kAllContacts}else{this.selectedVisibility=null}}disableRadioGroup_(contactsState){return contactsState===ContactsState.PENDING||contactsState===ContactsState.FAILED}showZeroState_(selectedVisibility,contactsState){return!selectedVisibility&&contactsState!==ContactsState.PENDING&&contactsState!==ContactsState.FAILED}showContactsContainer_(selectedVisibility,contactsState){return this.showExplanationState_(selectedVisibility,contactsState)||this.showContactList_(selectedVisibility,contactsState)}showExplanationState_(selectedVisibility,contactsState){if(!selectedVisibility||contactsState===ContactsState.PENDING||contactsState===ContactsState.FAILED){return false}return selectedVisibility==="none"||selectedVisibility==="yourDevices"||contactsState===ContactsState.HAS_CONTACTS}showEmptyState_(selectedVisibility,contactsState){return selectedVisibility==="contacts"&&contactsState===ContactsState.ZERO_CONTACTS}showContactList_(selectedVisibility,contactsState){return selectedVisibility==="contacts"&&contactsState===ContactsState.HAS_CONTACTS}showAllContactsToggle_(selectedVisibility,contactsState){if(this.isQuickShareV2Enabled_){return false}return selectedVisibility==="contacts"&&contactsState===ContactsState.HAS_CONTACTS}toggleAllContacts_(){this.isAllContactsToggledOn_=!this.isAllContactsToggledOn_}domChangeDownloadFailed_(){const contactsFailedMessage=this.shadowRoot.querySelector("#contactsFailedMessage");if(!contactsFailedMessage){return}const localizedString=this.i18nAdvanced("nearbyShareContactVisibilityDownloadFailed");contactsFailedMessage.innerHTML=localizedString;const ariaLabelledByIds=[];contactsFailedMessage.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`contactsFailedMessage${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(isHtmlAnchorElement(node)){node.id=`tryAgainLink`;ariaLabelledByIds.push(node.id);return}assertNotReached("nearbyShareContactVisibilityDownloadFailed has invalid node types")}));const anchorTags=contactsFailedMessage.getElementsByTagName("a");if(anchorTags.length===0){contactsFailedMessage.innerHTML=localizedString;return}assert(anchorTags.length===1,"string should contain exactly one anchor tag");const anchorTag=anchorTags[0];anchorTag.setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));anchorTag.href="#";anchorTag.addEventListener("click",(event=>{event.preventDefault();this.downloadContacts_()}))}getAriaLabelledZeroStateText_(){const tempEl=document.createElement("div");const localizedString=this.i18nAdvanced("nearbyShareContactVisibilityZeroStateText");const linkUrl=this.i18n("nearbyShareLearnMoreLink");tempEl.innerHTML=localizedString;const ariaLabelledByIds=[];tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`zeroStateText${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(isHtmlAnchorElement(node)){node.id=`zeroStateHelpLink`;ariaLabelledByIds.push(node.id);return}assertNotReached("nearbyShareContactVisibilityZeroStateText has invalid node types")}));const anchorTags=tempEl.getElementsByTagName("a");if(anchorTags.length===0){return localizedString}assert(anchorTags.length===1,"nearbyShareContactVisibilityZeroStateText should contain exactly"+" one anchor tag");const anchorTag=anchorTags[0];anchorTag.setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));anchorTag.href=linkUrl;anchorTag.target="_blank";return sanitizeInnerHtml(tempEl.innerHTML,{attrs:["id","aria-hidden","aria-labelledby"]})}showUnreachableContactsMessage_(){return this.numUnreachable_>0}updateNumUnreachableMessage_(){if(this.numUnreachable_===0){this.numUnreachableMessage_="";return}sendWithPromise("getPluralString","nearbyShareContactVisibilityNumUnreachable",this.numUnreachable_).then((labelTemplate=>{this.numUnreachableMessage_=loadTimeData.substituteString(labelTemplate,this.numUnreachable_,this.i18n("nearbyShareFeatureName"))}))}getVisibilityDescription_(){switch(this.getSelectedVisibility()){case Visibility.kAllContacts:return this.i18nAdvanced("nearbyShareContactVisibilityOwnAllSelfShare",{substitutions:[this.profileEmail]});case Visibility.kSelectedContacts:return this.i18nAdvanced("nearbyShareContactVisibilityOwnSomeSelfShare",{substitutions:[this.profileEmail]});case Visibility.kYourDevices:return this.i18nAdvanced("nearbyShareContactVisibilityOwnYourDevices",{substitutions:[this.profileEmail]});case Visibility.kNoOne:return this.i18nAdvanced("nearbyShareContactVisibilityOwnNone");default:assert(window.trustedTypes);return window.trustedTypes.emptyHTML}}saveVisibilityAndAllowedContacts(){const visibility=this.getSelectedVisibility();if(visibility){this.set("settings.visibility",visibility)}if(!this.contacts){this.contactManager_.setAllowedContacts([]);return}const allowedContacts=[];switch(visibility){case Visibility.kAllContacts:for(const contact of this.contacts){allowedContacts.push(contact.id)}break;case Visibility.kSelectedContacts:for(const contact of this.contacts){if(contact.checked){allowedContacts.push(contact.id)}}break;default:break}this.contactManager_.setAllowedContacts(allowedContacts)}getSelectedVisibility(){return this.visibilityStringToValue(this.selectedVisibility)}getDeviceVisibilityIcon_(){return this.isDarkModeActive_?DEVICE_VISIBILITY_DARK_ICON:DEVICE_VISIBILITY_LIGHT_ICON}}customElements.define(NearbyContactVisibilityElement.is,NearbyContactVisibilityElement);