// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assertNotReached}from"chrome://resources/js/assert.js";import{Visibility}from"chrome://resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_settings.mojom-webui.js";export var NearbyShareOnboardingFinalState;(function(NearbyShareOnboardingFinalState){NearbyShareOnboardingFinalState[NearbyShareOnboardingFinalState["DEVICE_NAME_PAGE"]=0]="DEVICE_NAME_PAGE";NearbyShareOnboardingFinalState[NearbyShareOnboardingFinalState["VISIBILITY_PAGE"]=1]="VISIBILITY_PAGE";NearbyShareOnboardingFinalState[NearbyShareOnboardingFinalState["COMPLETE"]=2]="COMPLETE";NearbyShareOnboardingFinalState[NearbyShareOnboardingFinalState["INITIAL_PAGE"]=3]="INITIAL_PAGE";NearbyShareOnboardingFinalState[NearbyShareOnboardingFinalState["MAX"]=4]="MAX"})(NearbyShareOnboardingFinalState||(NearbyShareOnboardingFinalState={}));export var NearbyShareOnboardingEntryPoint;(function(NearbyShareOnboardingEntryPoint){NearbyShareOnboardingEntryPoint[NearbyShareOnboardingEntryPoint["SETTINGS"]=0]="SETTINGS";NearbyShareOnboardingEntryPoint[NearbyShareOnboardingEntryPoint["TRAY"]=1]="TRAY";NearbyShareOnboardingEntryPoint[NearbyShareOnboardingEntryPoint["SHARE_SHEET"]=2]="SHARE_SHEET";NearbyShareOnboardingEntryPoint[NearbyShareOnboardingEntryPoint["NEARBY_DEVICE_TRYING_TO_SHARE_NOTIFICATION"]=3]="NEARBY_DEVICE_TRYING_TO_SHARE_NOTIFICATION";NearbyShareOnboardingEntryPoint[NearbyShareOnboardingEntryPoint["MAX"]=4]="MAX"})(NearbyShareOnboardingEntryPoint||(NearbyShareOnboardingEntryPoint={}));var NearbyShareOnboardingFlowEvent;(function(NearbyShareOnboardingFlowEvent){NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["ONBOARDING_SHOWN"]=1]="ONBOARDING_SHOWN";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["CONFIRM_ON_INITIAL_PAGE"]=12]="CONFIRM_ON_INITIAL_PAGE";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["CANCEL_ON_INITIAL_PAGE"]=13]="CANCEL_ON_INITIAL_PAGE";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["VISIBILITY_CLICKED_ON_INITIAL_PAGE"]=14]="VISIBILITY_CLICKED_ON_INITIAL_PAGE";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["DEVICE_VISIBILITY_PAGE_SHOWN"]=141]="DEVICE_VISIBILITY_PAGE_SHOWN";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["ALL_CONTACTS_SELECTED_AND_CONFIRMED"]=1412]="ALL_CONTACTS_SELECTED_AND_CONFIRMED";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["SOME_CONTACTS_SELECTED_AND_CONFIRMED"]=1413]="SOME_CONTACTS_SELECTED_AND_CONFIRMED";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["HIDDEN_SELECTED_AND_CONFIRMED"]=1414]="HIDDEN_SELECTED_AND_CONFIRMED";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["MANAGE_CONTACTS_SELECTED"]=1415]="MANAGE_CONTACTS_SELECTED";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["CANCEL_SELECTED_ON_VISIBILITY_PAGE"]=1416]="CANCEL_SELECTED_ON_VISIBILITY_PAGE";NearbyShareOnboardingFlowEvent[NearbyShareOnboardingFlowEvent["YOUR_DEVICES_SELECTED_AND_CONFIRMED"]=1417]="YOUR_DEVICES_SELECTED_AND_CONFIRMED"})(NearbyShareOnboardingFlowEvent||(NearbyShareOnboardingFlowEvent={}));const NearbyShareOnboardingResultHistogramName="Nearby.Share.Onboarding.Result";const NearbyShareOnboardingEntryPointHistogramName="Nearby.Share.Onboarding.EntryPoint";const NearbyShareOnboardingDurationHistogramName="Nearby.Share.Onboarding.Duration";const NearbyShareOnboardingFlowEventHistogramName="Nearby.Share.Onboarding.FlowEvent";const NearbyShareOnboardingEntryPointResultPrefix="Nearby.Share.Onboarding.";const NearbyShareOnboardingEntryPointResultSuffix=".Result";let onboardingInitiatedTimestamp;function processOnboardingEntryPointResultMetrics(nearbyShareOnboardingEntryPoint,nearbyShareOnboardingFinalState){let entryPointString;switch(nearbyShareOnboardingEntryPoint){case NearbyShareOnboardingEntryPoint.SETTINGS:entryPointString="Settings";break;case NearbyShareOnboardingEntryPoint.TRAY:entryPointString="Tray";break;case NearbyShareOnboardingEntryPoint.SHARE_SHEET:entryPointString="ShareSheet";break;case NearbyShareOnboardingEntryPoint.NEARBY_DEVICE_TRYING_TO_SHARE_NOTIFICATION:entryPointString="NearbyDeviceTryingToShareNotification";break;default:assertNotReached("Invalid nearbyShareOnboardingEntryPoint")}chrome.send("metricsHandler:recordInHistogram",[NearbyShareOnboardingEntryPointResultPrefix+entryPointString+NearbyShareOnboardingEntryPointResultSuffix,nearbyShareOnboardingFinalState,NearbyShareOnboardingFinalState.MAX])}export function getOnboardingEntryPoint(url){let nearbyShareOnboardingEntryPoint=NearbyShareOnboardingEntryPoint.MAX;if(url.hostname==="nearby"){nearbyShareOnboardingEntryPoint=NearbyShareOnboardingEntryPoint.SHARE_SHEET}else if(url.hostname==="os-settings"){const urlParams=new URLSearchParams(url.search);nearbyShareOnboardingEntryPoint=getOnboardingEntrypointFromQueryParam(urlParams.get("entrypoint"))}else{assertNotReached("Invalid nearbyShareOnboardingEntryPoint")}return nearbyShareOnboardingEntryPoint}export function processOnboardingInitiatedMetrics(nearbyShareOnboardingEntryPoint){chrome.send("metricsHandler:recordInHistogram",[NearbyShareOnboardingEntryPointHistogramName,nearbyShareOnboardingEntryPoint,NearbyShareOnboardingEntryPoint.MAX]);onboardingInitiatedTimestamp=window.performance.now()}export function processOnePageOnboardingInitiatedMetrics(nearbyShareOnboardingEntryPoint){chrome.send("metricsHandler:recordInHistogram",[NearbyShareOnboardingEntryPointHistogramName,nearbyShareOnboardingEntryPoint,NearbyShareOnboardingEntryPoint.MAX]);chrome.send("metricsHandler:recordSparseHistogram",[NearbyShareOnboardingFlowEventHistogramName,NearbyShareOnboardingFlowEvent.ONBOARDING_SHOWN]);onboardingInitiatedTimestamp=window.performance.now()}function getOnboardingEntrypointFromQueryParam(queryParam){switch(queryParam){case"settings":return NearbyShareOnboardingEntryPoint.SETTINGS;case"notification":return NearbyShareOnboardingEntryPoint.NEARBY_DEVICE_TRYING_TO_SHARE_NOTIFICATION;default:return NearbyShareOnboardingEntryPoint.TRAY}}export function processOnePageOnboardingCancelledMetrics(nearbyShareOnboardingEntryPointState,nearbyShareOnboardingFinalState){if(!onboardingInitiatedTimestamp){return}chrome.send("metricsHandler:recordInHistogram",[NearbyShareOnboardingResultHistogramName,nearbyShareOnboardingFinalState,NearbyShareOnboardingFinalState.MAX]);chrome.send("metricsHandler:recordSparseHistogram",[NearbyShareOnboardingFlowEventHistogramName,getOnboardingCancelledFlowEvent(nearbyShareOnboardingFinalState)]);processOnboardingEntryPointResultMetrics(nearbyShareOnboardingEntryPointState,nearbyShareOnboardingFinalState);onboardingInitiatedTimestamp=null}function getOnboardingCancelledFlowEvent(nearbyShareOnboardingFinalState){switch(nearbyShareOnboardingFinalState){case NearbyShareOnboardingFinalState.INITIAL_PAGE:return NearbyShareOnboardingFlowEvent.CANCEL_ON_INITIAL_PAGE;case NearbyShareOnboardingFinalState.VISIBILITY_PAGE:return NearbyShareOnboardingFlowEvent.CANCEL_SELECTED_ON_VISIBILITY_PAGE;default:assertNotReached("Invalid final state for cancel event")}}export function processOnePageOnboardingCompleteMetrics(nearbyShareOnboardingEntryPointState,nearbyShareOnboardingFinalState,visibility){if(!onboardingInitiatedTimestamp){return}chrome.send("metricsHandler:recordSparseHistogram",[NearbyShareOnboardingFlowEventHistogramName,getOnboardingCompleteFlowEvent(nearbyShareOnboardingFinalState,visibility)]);chrome.send("metricsHandler:recordInHistogram",[NearbyShareOnboardingResultHistogramName,NearbyShareOnboardingFinalState.COMPLETE,NearbyShareOnboardingFinalState.MAX]);chrome.send("metricsHandler:recordMediumTime",[NearbyShareOnboardingDurationHistogramName,window.performance.now()-onboardingInitiatedTimestamp]);processOnboardingEntryPointResultMetrics(nearbyShareOnboardingEntryPointState,NearbyShareOnboardingFinalState.COMPLETE);onboardingInitiatedTimestamp=null}function getOnboardingCompleteFlowEvent(nearbyShareOnboardingFinalState,visibility){switch(nearbyShareOnboardingFinalState){case NearbyShareOnboardingFinalState.INITIAL_PAGE:return NearbyShareOnboardingFlowEvent.CONFIRM_ON_INITIAL_PAGE;case NearbyShareOnboardingFinalState.VISIBILITY_PAGE:return getOnboardingCompleteFlowEventOnVisibilityPage(visibility);default:assertNotReached("Invalid final state")}}function getOnboardingCompleteFlowEventOnVisibilityPage(visibility){switch(visibility){case Visibility.kAllContacts:return NearbyShareOnboardingFlowEvent.ALL_CONTACTS_SELECTED_AND_CONFIRMED;case Visibility.kSelectedContacts:return NearbyShareOnboardingFlowEvent.SOME_CONTACTS_SELECTED_AND_CONFIRMED;case Visibility.kYourDevices:return NearbyShareOnboardingFlowEvent.YOUR_DEVICES_SELECTED_AND_CONFIRMED;case Visibility.kNoOne:return NearbyShareOnboardingFlowEvent.HIDDEN_SELECTED_AND_CONFIRMED;default:assertNotReached("Invalid visibility")}}export function processOnePageOnboardingVisibilityButtonOnInitialPageClickedMetrics(){chrome.send("metricsHandler:recordSparseHistogram",[NearbyShareOnboardingFlowEventHistogramName,NearbyShareOnboardingFlowEvent.VISIBILITY_CLICKED_ON_INITIAL_PAGE])}export function processOnePageOnboardingVisibilityPageShownMetrics(){chrome.send("metricsHandler:recordSparseHistogram",[NearbyShareOnboardingFlowEventHistogramName,NearbyShareOnboardingFlowEvent.DEVICE_VISIBILITY_PAGE_SHOWN])}export function processOnePageOnboardingManageContactsMetrics(){chrome.send("metricsHandler:recordSparseHistogram",[NearbyShareOnboardingFlowEventHistogramName,NearbyShareOnboardingFlowEvent.MANAGE_CONTACTS_SELECTED])}