// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{dedupingMixin}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getNearbyShareSettings,observeNearbyShareSettings}from"./nearby_share_settings.js";export const NearbyShareSettingsMixin=dedupingMixin((superClass=>{class NearbyShareSettingsMixinInternal extends superClass{static get properties(){return{settings:{type:Object,notify:true,value:{}}}}static get observers(){return["settingsChanged_(settings.*)"]}constructor(...args){super(...args);this.nearbyShareSettings_=null;this.observerReceiver_=null}connectedCallback(){super.connectedCallback();this.nearbyShareSettings_=getNearbyShareSettings();this.observerReceiver_=observeNearbyShareSettings(this);Promise.all([this.nearbyShareSettings_.getEnabled(),this.nearbyShareSettings_.getDeviceName(),this.nearbyShareSettings_.getDataUsage(),this.nearbyShareSettings_.getVisibility(),this.nearbyShareSettings_.getAllowedContacts(),this.nearbyShareSettings_.isOnboardingComplete(),this.nearbyShareSettings_.getFastInitiationNotificationState(),this.nearbyShareSettings_.getIsFastInitiationHardwareSupported()]).then((results=>{this.set("settings.enabled",results[0].enabled);this.set("settings.deviceName",results[1].deviceName);this.set("settings.dataUsage",results[2].dataUsage);this.set("settings.visibility",results[3].visibility);this.set("settings.allowedContacts",results[4].allowedContacts);this.set("settings.isOnboardingComplete",results[5].completed);this.set("settings.fastInitiationNotificationState",results[6].state);this.set("settings.isFastInitiationHardwareSupported",results[7].supported);this.onSettingsRetrieved()}))}disconnectedCallback(){super.disconnectedCallback();if(this.observerReceiver_){this.observerReceiver_.$.close()}if(this.nearbyShareSettings_){this.nearbyShareSettings_.$.close()}}onEnabledChanged(enabled){this.set("settings.enabled",enabled)}onIsFastInitiationHardwareSupportedChanged(supported){this.set("settings.isFastInitiationHardwareSupported",supported)}onFastInitiationNotificationStateChanged(state){this.set("settings.fastInitiationNotificationState",state)}onDeviceNameChanged(deviceName){this.set("settings.deviceName",deviceName)}onDataUsageChanged(dataUsage){this.set("settings.dataUsage",dataUsage)}onVisibilityChanged(visibility){this.set("settings.visibility",visibility)}onAllowedContactsChanged(allowedContacts){this.set("settings.allowedContacts",allowedContacts)}onIsOnboardingCompleteChanged(isComplete){this.set("settings.isOnboardingComplete",isComplete)}settingsChanged_(change){switch(change.path){case"settings.enabled":this.nearbyShareSettings_.setEnabled(change.value);break;case"settings.fastInitiationNotificationState":this.nearbyShareSettings_.setFastInitiationNotificationState(change.value);break;case"settings.deviceName":this.nearbyShareSettings_.setDeviceName(change.value);break;case"settings.dataUsage":this.nearbyShareSettings_.setDataUsage(change.value);break;case"settings.visibility":this.nearbyShareSettings_.setVisibility(change.value);break;case"settings.allowedContacts":this.nearbyShareSettings_.setAllowedContacts(change.value);break;case"settings.isOnboardingComplete":this.nearbyShareSettings_.setIsOnboardingComplete(change.value);break}}onSettingsRetrieved(){}}return NearbyShareSettingsMixinInternal}));