import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-icons cr-shared-style"></style>
<style include="cros-color-overrides"></style>
<style>:host{--nearby-page-linear-gradient-color-start:var(--google-blue-50);--nearby-page-space-block:24px;--nearby-page-space-inline:24px}@media (prefers-color-scheme:dark){:host{--nearby-page-linear-gradient-color-start:rgba(var(--google-blue-300-rgb),0.2)}}:host-context(body.jelly-enabled):host{--nearby-page-linear-gradient-color-start:var(--cros-sys-highlight_shape)}#pageContainer{display:flex;flex-direction:column;height:100%}#pageContainer:focus{outline:none}#header{margin-inline-end:var(--nearby-page-space-inline);margin-inline-start:var(--nearby-page-space-inline);padding-block-end:16px;padding-block-start:var(--nearby-page-space-block);position:relative}#contentContainer{box-sizing:border-box;display:flex;flex-grow:1;justify-content:center;overflow:hidden}#pageTitle{margin:0}:host-context(body:not(.jelly-enabled)) #pageTitle{font-family:'Google Sans';font-size:16px;font-weight:normal;line-height:24px;color:var(--cros-text-color-primary)}:host-context(body.jelly-enabled) #pageTitle{color:var(--cros-sys-on_surface);font:var(--cros-title-1-font)}#pageSubTitle{margin:0}:host-context(body:not(.jelly-enabled)) #pageSubTitle{color:var(--cros-text-color-secondary);font-size:14px;font-weight:inherit;line-height:20px}:host-context(body.jelly-enabled) #pageSubTitle{color:var(--cros-sys-on_surface_variant);font:var(--cros-body-2-font)}#a11yAnnouncedPageSubTitle{bottom:16px;clip:rect(0,0,0,0);font-size:14px;position:absolute}#actions{display:flex;justify-content:flex-end;padding-block-end:var(--nearby-page-space-block);padding-block-start:var(--nearby-page-space-block);padding-inline-end:var(--nearby-page-space-inline);padding-inline-start:var(--nearby-page-space-inline)}#utilityButton{margin-inline-end:auto}#utilityButton iron-icon{--iron-icon-fill-color:var(--text-color);margin-inline-end:8px}</style>
<div id="pageContainer" role="dialog" aria-modal="true"
    aria-labelledby$="[[getDialogAriaLabelledBy_(a11yAnnouncedSubTitle)]]"
    tabindex="-1">
  <div id="header">
    <h2 id="pageTitle">[[title]]</h2>
    <h3 id="pageSubTitle"
        aria-hidden$="[[getSubTitleAriaHidden_(a11yAnnouncedSubTitle)]]">
      [[subTitle]]
    </h3>
    <div id="a11yAnnouncedPageSubTitle" aria-live="polite">
      [[a11yAnnouncedSubTitle]]
    </div>
  </div>

  <div id="contentContainer">
    <slot name="content"></slot>
  </div>

  <div id="actions">
    <template is="dom-if" if="[[!closeOnly]]">
      <template is="dom-if" if="[[utilityButtonLabel]]">
        <cr-button id="utilityButton" class="cancel-button"
            on-click="onUtilityClick_" aria-label="[[utilityButtonLabel]]">
          <template is="dom-if" if="[[utilityButtonOpenInNew]]">
            <iron-icon id="openInNewIcon" icon="cr:open-in-new"></iron-icon>
          </template>
          <span>[[utilityButtonLabel]]</span>
        </cr-button>
      </template>
      <template is="dom-if" if="[[cancelButtonLabel]]">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelClick_" aria-label="[[cancelButtonLabel]]">
          [[cancelButtonLabel]]
        </cr-button>
      </template>
      <template is="dom-if" if="[[actionButtonLabel]]">
        <cr-button id="actionButton" class="action-button"
            on-click="onActionClick_" disabled="[[actionDisabled]]"
            aria-label="[[actionButtonLabel]]">
          [[actionButtonLabel]]
        </cr-button>
      </template>
    </template>
    <template is="dom-if" if="[[closeOnly]]">
      <cr-button id="closeButton" class="action-button"
          on-click="onCloseClick_"
          aria-label="$i18n{nearbyShareActionsClose}">
        $i18n{nearbyShareActionsClose}
      </cr-button>
    </template>
  </div>
</div>
<!--_html_template_end_-->`;
}
