// chrome/browser/ui/webui/nearby_share/nearby_share.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ShareTypeSpec as nearbyShare_mojom_ShareTypeSpec } from './nearby_share_share_type.mojom-webui.js';
import { ShareTargetTypeSpec as nearbyShare_mojom_ShareTargetTypeSpec } from '//resources/mojo/chromeos/ash/services/nearby/public/mojom/nearby_share_target_types.mojom-webui.js';
import { UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec } from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const SelectShareTargetResultSpec = { $: mojo.internal.Enum() };
export var SelectShareTargetResult;
(function (SelectShareTargetResult) {
    SelectShareTargetResult[SelectShareTargetResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    SelectShareTargetResult[SelectShareTargetResult["MAX_VALUE"] = 2] = "MAX_VALUE";
    SelectShareTargetResult[SelectShareTargetResult["kOk"] = 0] = "kOk";
    SelectShareTargetResult[SelectShareTargetResult["kError"] = 1] = "kError";
    SelectShareTargetResult[SelectShareTargetResult["kInvalidShareTarget"] = 2] = "kInvalidShareTarget";
})(SelectShareTargetResult || (SelectShareTargetResult = {}));
export const TransferStatusSpec = { $: mojo.internal.Enum() };
export var TransferStatus;
(function (TransferStatus) {
    TransferStatus[TransferStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    TransferStatus[TransferStatus["MAX_VALUE"] = 25] = "MAX_VALUE";
    TransferStatus[TransferStatus["kUnknown"] = 0] = "kUnknown";
    TransferStatus[TransferStatus["kConnecting"] = 1] = "kConnecting";
    TransferStatus[TransferStatus["kAwaitingLocalConfirmation"] = 2] = "kAwaitingLocalConfirmation";
    TransferStatus[TransferStatus["kAwaitingRemoteAcceptance"] = 3] = "kAwaitingRemoteAcceptance";
    TransferStatus[TransferStatus["kAwaitingRemoteAcceptanceFailed"] = 4] = "kAwaitingRemoteAcceptanceFailed";
    TransferStatus[TransferStatus["kInProgress"] = 5] = "kInProgress";
    TransferStatus[TransferStatus["kComplete"] = 6] = "kComplete";
    TransferStatus[TransferStatus["kFailed"] = 7] = "kFailed";
    TransferStatus[TransferStatus["kRejected"] = 8] = "kRejected";
    TransferStatus[TransferStatus["kCancelled"] = 9] = "kCancelled";
    TransferStatus[TransferStatus["kTimedOut"] = 10] = "kTimedOut";
    TransferStatus[TransferStatus["kMediaUnavailable"] = 11] = "kMediaUnavailable";
    TransferStatus[TransferStatus["kNotEnoughSpace"] = 12] = "kNotEnoughSpace";
    TransferStatus[TransferStatus["kUnsupportedAttachmentType"] = 13] = "kUnsupportedAttachmentType";
    TransferStatus[TransferStatus["kDecodeAdvertisementFailed"] = 14] = "kDecodeAdvertisementFailed";
    TransferStatus[TransferStatus["kMissingTransferUpdateCallback"] = 15] = "kMissingTransferUpdateCallback";
    TransferStatus[TransferStatus["kMissingShareTarget"] = 16] = "kMissingShareTarget";
    TransferStatus[TransferStatus["kMissingEndpointId"] = 17] = "kMissingEndpointId";
    TransferStatus[TransferStatus["kMissingPayloads"] = 18] = "kMissingPayloads";
    TransferStatus[TransferStatus["kPairedKeyVerificationFailed"] = 19] = "kPairedKeyVerificationFailed";
    TransferStatus[TransferStatus["kInvalidIntroductionFrame"] = 20] = "kInvalidIntroductionFrame";
    TransferStatus[TransferStatus["kIncompletePayloads"] = 21] = "kIncompletePayloads";
    TransferStatus[TransferStatus["kFailedToCreateShareTarget"] = 22] = "kFailedToCreateShareTarget";
    TransferStatus[TransferStatus["kFailedToInitiateOutgoingConnection"] = 23] = "kFailedToInitiateOutgoingConnection";
    TransferStatus[TransferStatus["kFailedToReadOutgoingConnectionResponse"] = 24] = "kFailedToReadOutgoingConnectionResponse";
    TransferStatus[TransferStatus["kUnexpectedDisconnection"] = 25] = "kUnexpectedDisconnection";
})(TransferStatus || (TransferStatus = {}));
export const StartDiscoveryResultSpec = { $: mojo.internal.Enum() };
export var StartDiscoveryResult;
(function (StartDiscoveryResult) {
    StartDiscoveryResult[StartDiscoveryResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    StartDiscoveryResult[StartDiscoveryResult["MAX_VALUE"] = 3] = "MAX_VALUE";
    StartDiscoveryResult[StartDiscoveryResult["kSuccess"] = 0] = "kSuccess";
    StartDiscoveryResult[StartDiscoveryResult["kErrorInProgressTransferring"] = 1] = "kErrorInProgressTransferring";
    StartDiscoveryResult[StartDiscoveryResult["kNoConnectionMedium"] = 2] = "kNoConnectionMedium";
    StartDiscoveryResult[StartDiscoveryResult["kErrorGeneric"] = 3] = "kErrorGeneric";
})(StartDiscoveryResult || (StartDiscoveryResult = {}));
export const RegisterReceiveSurfaceResultSpec = { $: mojo.internal.Enum() };
export var RegisterReceiveSurfaceResult;
(function (RegisterReceiveSurfaceResult) {
    RegisterReceiveSurfaceResult[RegisterReceiveSurfaceResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    RegisterReceiveSurfaceResult[RegisterReceiveSurfaceResult["MAX_VALUE"] = 3] = "MAX_VALUE";
    RegisterReceiveSurfaceResult[RegisterReceiveSurfaceResult["kSuccess"] = 0] = "kSuccess";
    RegisterReceiveSurfaceResult[RegisterReceiveSurfaceResult["kFailure"] = 1] = "kFailure";
    RegisterReceiveSurfaceResult[RegisterReceiveSurfaceResult["kNoConnectionMedium"] = 2] = "kNoConnectionMedium";
    RegisterReceiveSurfaceResult[RegisterReceiveSurfaceResult["kTransferInProgress"] = 3] = "kTransferInProgress";
})(RegisterReceiveSurfaceResult || (RegisterReceiveSurfaceResult = {}));
export class ShareTargetListenerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.ShareTargetListener', scope);
    }
}
export class ShareTargetListenerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ShareTargetListenerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onShareTargetDiscovered(shareTarget) {
        this.proxy.sendMessage(0, ShareTargetListener_OnShareTargetDiscovered_ParamsSpec.$, null, [
            shareTarget
        ], false);
    }
    onShareTargetLost(shareTarget) {
        this.proxy.sendMessage(1, ShareTargetListener_OnShareTargetLost_ParamsSpec.$, null, [
            shareTarget
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ShareTargetListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShareTargetListenerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShareTargetListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ShareTargetListener_OnShareTargetDiscovered_ParamsSpec.$, null, impl.onShareTargetDiscovered.bind(impl), false);
        this.helper_internal_.registerHandler(1, ShareTargetListener_OnShareTargetLost_ParamsSpec.$, null, impl.onShareTargetLost.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ShareTargetListener {
    static get $interfaceName() {
        return "nearby_share.mojom.ShareTargetListener";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ShareTargetListenerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ShareTargetListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShareTargetListenerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ShareTargetListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onShareTargetDiscovered =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ShareTargetListener_OnShareTargetDiscovered_ParamsSpec.$, null, this.onShareTargetDiscovered.createReceiverHandler(false /* expectsResponse */), false);
        this.onShareTargetLost =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ShareTargetListener_OnShareTargetLost_ParamsSpec.$, null, this.onShareTargetLost.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class TransferUpdateListenerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.TransferUpdateListener', scope);
    }
}
export class TransferUpdateListenerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TransferUpdateListenerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onTransferUpdate(status, token) {
        this.proxy.sendMessage(0, TransferUpdateListener_OnTransferUpdate_ParamsSpec.$, null, [
            status,
            token
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TransferUpdateListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TransferUpdateListenerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TransferUpdateListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TransferUpdateListener_OnTransferUpdate_ParamsSpec.$, null, impl.onTransferUpdate.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TransferUpdateListener {
    static get $interfaceName() {
        return "nearby_share.mojom.TransferUpdateListener";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TransferUpdateListenerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TransferUpdateListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TransferUpdateListenerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TransferUpdateListenerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onTransferUpdate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TransferUpdateListener_OnTransferUpdate_ParamsSpec.$, null, this.onTransferUpdate.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DiscoveryObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.DiscoveryObserver', scope);
    }
}
export class DiscoveryObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DiscoveryObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onNearbyProcessStopped() {
        this.proxy.sendMessage(0, DiscoveryObserver_OnNearbyProcessStopped_ParamsSpec.$, null, [], false);
    }
    onStartDiscoveryResult(success) {
        this.proxy.sendMessage(1, DiscoveryObserver_OnStartDiscoveryResult_ParamsSpec.$, null, [
            success
        ], false);
    }
}
;
/**
 * An object which receives request messages for the DiscoveryObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DiscoveryObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoveryObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DiscoveryObserver_OnNearbyProcessStopped_ParamsSpec.$, null, impl.onNearbyProcessStopped.bind(impl), false);
        this.helper_internal_.registerHandler(1, DiscoveryObserver_OnStartDiscoveryResult_ParamsSpec.$, null, impl.onStartDiscoveryResult.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DiscoveryObserver {
    static get $interfaceName() {
        return "nearby_share.mojom.DiscoveryObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DiscoveryObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DiscoveryObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DiscoveryObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoveryObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onNearbyProcessStopped =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DiscoveryObserver_OnNearbyProcessStopped_ParamsSpec.$, null, this.onNearbyProcessStopped.createReceiverHandler(false /* expectsResponse */), false);
        this.onStartDiscoveryResult =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, DiscoveryObserver_OnStartDiscoveryResult_ParamsSpec.$, null, this.onStartDiscoveryResult.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class DiscoveryManagerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.DiscoveryManager', scope);
    }
}
export class DiscoveryManagerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(DiscoveryManagerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addDiscoveryObserver(observer) {
        this.proxy.sendMessage(0, DiscoveryManager_AddDiscoveryObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    startDiscovery(listener) {
        return this.proxy.sendMessage(1, DiscoveryManager_StartDiscovery_ParamsSpec.$, DiscoveryManager_StartDiscovery_ResponseParamsSpec.$, [
            listener
        ], false);
    }
    stopDiscovery() {
        return this.proxy.sendMessage(2, DiscoveryManager_StopDiscovery_ParamsSpec.$, DiscoveryManager_StopDiscovery_ResponseParamsSpec.$, [], false);
    }
    selectShareTarget(shareTargetId) {
        return this.proxy.sendMessage(3, DiscoveryManager_SelectShareTarget_ParamsSpec.$, DiscoveryManager_SelectShareTarget_ResponseParamsSpec.$, [
            shareTargetId
        ], false);
    }
    getPayloadPreview() {
        return this.proxy.sendMessage(4, DiscoveryManager_GetPayloadPreview_ParamsSpec.$, DiscoveryManager_GetPayloadPreview_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the DiscoveryManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DiscoveryManagerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoveryManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, DiscoveryManager_AddDiscoveryObserver_ParamsSpec.$, null, impl.addDiscoveryObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, DiscoveryManager_StartDiscovery_ParamsSpec.$, DiscoveryManager_StartDiscovery_ResponseParamsSpec.$, impl.startDiscovery.bind(impl), false);
        this.helper_internal_.registerHandler(2, DiscoveryManager_StopDiscovery_ParamsSpec.$, DiscoveryManager_StopDiscovery_ResponseParamsSpec.$, impl.stopDiscovery.bind(impl), false);
        this.helper_internal_.registerHandler(3, DiscoveryManager_SelectShareTarget_ParamsSpec.$, DiscoveryManager_SelectShareTarget_ResponseParamsSpec.$, impl.selectShareTarget.bind(impl), false);
        this.helper_internal_.registerHandler(4, DiscoveryManager_GetPayloadPreview_ParamsSpec.$, DiscoveryManager_GetPayloadPreview_ResponseParamsSpec.$, impl.getPayloadPreview.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class DiscoveryManager {
    static get $interfaceName() {
        return "nearby_share.mojom.DiscoveryManager";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new DiscoveryManagerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the DiscoveryManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DiscoveryManagerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DiscoveryManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addDiscoveryObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, DiscoveryManager_AddDiscoveryObserver_ParamsSpec.$, null, this.addDiscoveryObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.startDiscovery =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, DiscoveryManager_StartDiscovery_ParamsSpec.$, DiscoveryManager_StartDiscovery_ResponseParamsSpec.$, this.startDiscovery.createReceiverHandler(true /* expectsResponse */), false);
        this.stopDiscovery =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, DiscoveryManager_StopDiscovery_ParamsSpec.$, DiscoveryManager_StopDiscovery_ResponseParamsSpec.$, this.stopDiscovery.createReceiverHandler(true /* expectsResponse */), false);
        this.selectShareTarget =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, DiscoveryManager_SelectShareTarget_ParamsSpec.$, DiscoveryManager_SelectShareTarget_ResponseParamsSpec.$, this.selectShareTarget.createReceiverHandler(true /* expectsResponse */), false);
        this.getPayloadPreview =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, DiscoveryManager_GetPayloadPreview_ParamsSpec.$, DiscoveryManager_GetPayloadPreview_ResponseParamsSpec.$, this.getPayloadPreview.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ConfirmationManagerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.ConfirmationManager', scope);
    }
}
export class ConfirmationManagerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ConfirmationManagerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    accept() {
        return this.proxy.sendMessage(0, ConfirmationManager_Accept_ParamsSpec.$, ConfirmationManager_Accept_ResponseParamsSpec.$, [], false);
    }
    reject() {
        return this.proxy.sendMessage(1, ConfirmationManager_Reject_ParamsSpec.$, ConfirmationManager_Reject_ResponseParamsSpec.$, [], false);
    }
    cancel() {
        return this.proxy.sendMessage(2, ConfirmationManager_Cancel_ParamsSpec.$, ConfirmationManager_Cancel_ResponseParamsSpec.$, [], false);
    }
}
;
/**
 * An object which receives request messages for the ConfirmationManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ConfirmationManagerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ConfirmationManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ConfirmationManager_Accept_ParamsSpec.$, ConfirmationManager_Accept_ResponseParamsSpec.$, impl.accept.bind(impl), false);
        this.helper_internal_.registerHandler(1, ConfirmationManager_Reject_ParamsSpec.$, ConfirmationManager_Reject_ResponseParamsSpec.$, impl.reject.bind(impl), false);
        this.helper_internal_.registerHandler(2, ConfirmationManager_Cancel_ParamsSpec.$, ConfirmationManager_Cancel_ResponseParamsSpec.$, impl.cancel.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ConfirmationManager {
    static get $interfaceName() {
        return "nearby_share.mojom.ConfirmationManager";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ConfirmationManagerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ConfirmationManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ConfirmationManagerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ConfirmationManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.accept =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ConfirmationManager_Accept_ParamsSpec.$, ConfirmationManager_Accept_ResponseParamsSpec.$, this.accept.createReceiverHandler(true /* expectsResponse */), false);
        this.reject =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ConfirmationManager_Reject_ParamsSpec.$, ConfirmationManager_Reject_ResponseParamsSpec.$, this.reject.createReceiverHandler(true /* expectsResponse */), false);
        this.cancel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ConfirmationManager_Cancel_ParamsSpec.$, ConfirmationManager_Cancel_ResponseParamsSpec.$, this.cancel.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ReceiveObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.ReceiveObserver', scope);
    }
}
export class ReceiveObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ReceiveObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onHighVisibilityChanged(inHighVisibility) {
        this.proxy.sendMessage(0, ReceiveObserver_OnHighVisibilityChanged_ParamsSpec.$, null, [
            inHighVisibility
        ], false);
    }
    onTransferUpdate(shareTarget, metadata) {
        this.proxy.sendMessage(1, ReceiveObserver_OnTransferUpdate_ParamsSpec.$, null, [
            shareTarget,
            metadata
        ], false);
    }
    onNearbyProcessStopped() {
        this.proxy.sendMessage(2, ReceiveObserver_OnNearbyProcessStopped_ParamsSpec.$, null, [], false);
    }
    onStartAdvertisingFailure() {
        this.proxy.sendMessage(3, ReceiveObserver_OnStartAdvertisingFailure_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the ReceiveObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ReceiveObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ReceiveObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ReceiveObserver_OnHighVisibilityChanged_ParamsSpec.$, null, impl.onHighVisibilityChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, ReceiveObserver_OnTransferUpdate_ParamsSpec.$, null, impl.onTransferUpdate.bind(impl), false);
        this.helper_internal_.registerHandler(2, ReceiveObserver_OnNearbyProcessStopped_ParamsSpec.$, null, impl.onNearbyProcessStopped.bind(impl), false);
        this.helper_internal_.registerHandler(3, ReceiveObserver_OnStartAdvertisingFailure_ParamsSpec.$, null, impl.onStartAdvertisingFailure.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ReceiveObserver {
    static get $interfaceName() {
        return "nearby_share.mojom.ReceiveObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ReceiveObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ReceiveObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ReceiveObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ReceiveObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onHighVisibilityChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ReceiveObserver_OnHighVisibilityChanged_ParamsSpec.$, null, this.onHighVisibilityChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onTransferUpdate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ReceiveObserver_OnTransferUpdate_ParamsSpec.$, null, this.onTransferUpdate.createReceiverHandler(false /* expectsResponse */), false);
        this.onNearbyProcessStopped =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ReceiveObserver_OnNearbyProcessStopped_ParamsSpec.$, null, this.onNearbyProcessStopped.createReceiverHandler(false /* expectsResponse */), false);
        this.onStartAdvertisingFailure =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ReceiveObserver_OnStartAdvertisingFailure_ParamsSpec.$, null, this.onStartAdvertisingFailure.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ReceiveManagerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'nearby_share.mojom.ReceiveManager', scope);
    }
}
export class ReceiveManagerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ReceiveManagerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addReceiveObserver(observer) {
        this.proxy.sendMessage(0, ReceiveManager_AddReceiveObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    isInHighVisibility() {
        return this.proxy.sendMessage(1, ReceiveManager_IsInHighVisibility_ParamsSpec.$, ReceiveManager_IsInHighVisibility_ResponseParamsSpec.$, [], false);
    }
    registerForegroundReceiveSurface() {
        return this.proxy.sendMessage(2, ReceiveManager_RegisterForegroundReceiveSurface_ParamsSpec.$, ReceiveManager_RegisterForegroundReceiveSurface_ResponseParamsSpec.$, [], false);
    }
    unregisterForegroundReceiveSurface() {
        return this.proxy.sendMessage(3, ReceiveManager_UnregisterForegroundReceiveSurface_ParamsSpec.$, ReceiveManager_UnregisterForegroundReceiveSurface_ResponseParamsSpec.$, [], false);
    }
    accept(shareTargetId) {
        return this.proxy.sendMessage(4, ReceiveManager_Accept_ParamsSpec.$, ReceiveManager_Accept_ResponseParamsSpec.$, [
            shareTargetId
        ], false);
    }
    reject(shareTargetId) {
        return this.proxy.sendMessage(5, ReceiveManager_Reject_ParamsSpec.$, ReceiveManager_Reject_ResponseParamsSpec.$, [
            shareTargetId
        ], false);
    }
    recordFastInitiationNotificationUsage(success) {
        this.proxy.sendMessage(6, ReceiveManager_RecordFastInitiationNotificationUsage_ParamsSpec.$, null, [
            success
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ReceiveManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ReceiveManagerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ReceiveManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ReceiveManager_AddReceiveObserver_ParamsSpec.$, null, impl.addReceiveObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, ReceiveManager_IsInHighVisibility_ParamsSpec.$, ReceiveManager_IsInHighVisibility_ResponseParamsSpec.$, impl.isInHighVisibility.bind(impl), false);
        this.helper_internal_.registerHandler(2, ReceiveManager_RegisterForegroundReceiveSurface_ParamsSpec.$, ReceiveManager_RegisterForegroundReceiveSurface_ResponseParamsSpec.$, impl.registerForegroundReceiveSurface.bind(impl), false);
        this.helper_internal_.registerHandler(3, ReceiveManager_UnregisterForegroundReceiveSurface_ParamsSpec.$, ReceiveManager_UnregisterForegroundReceiveSurface_ResponseParamsSpec.$, impl.unregisterForegroundReceiveSurface.bind(impl), false);
        this.helper_internal_.registerHandler(4, ReceiveManager_Accept_ParamsSpec.$, ReceiveManager_Accept_ResponseParamsSpec.$, impl.accept.bind(impl), false);
        this.helper_internal_.registerHandler(5, ReceiveManager_Reject_ParamsSpec.$, ReceiveManager_Reject_ResponseParamsSpec.$, impl.reject.bind(impl), false);
        this.helper_internal_.registerHandler(6, ReceiveManager_RecordFastInitiationNotificationUsage_ParamsSpec.$, null, impl.recordFastInitiationNotificationUsage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ReceiveManager {
    static get $interfaceName() {
        return "nearby_share.mojom.ReceiveManager";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ReceiveManagerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ReceiveManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ReceiveManagerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ReceiveManagerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addReceiveObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ReceiveManager_AddReceiveObserver_ParamsSpec.$, null, this.addReceiveObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.isInHighVisibility =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ReceiveManager_IsInHighVisibility_ParamsSpec.$, ReceiveManager_IsInHighVisibility_ResponseParamsSpec.$, this.isInHighVisibility.createReceiverHandler(true /* expectsResponse */), false);
        this.registerForegroundReceiveSurface =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ReceiveManager_RegisterForegroundReceiveSurface_ParamsSpec.$, ReceiveManager_RegisterForegroundReceiveSurface_ResponseParamsSpec.$, this.registerForegroundReceiveSurface.createReceiverHandler(true /* expectsResponse */), false);
        this.unregisterForegroundReceiveSurface =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ReceiveManager_UnregisterForegroundReceiveSurface_ParamsSpec.$, ReceiveManager_UnregisterForegroundReceiveSurface_ResponseParamsSpec.$, this.unregisterForegroundReceiveSurface.createReceiverHandler(true /* expectsResponse */), false);
        this.accept =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ReceiveManager_Accept_ParamsSpec.$, ReceiveManager_Accept_ResponseParamsSpec.$, this.accept.createReceiverHandler(true /* expectsResponse */), false);
        this.reject =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ReceiveManager_Reject_ParamsSpec.$, ReceiveManager_Reject_ResponseParamsSpec.$, this.reject.createReceiverHandler(true /* expectsResponse */), false);
        this.recordFastInitiationNotificationUsage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ReceiveManager_RecordFastInitiationNotificationUsage_ParamsSpec.$, null, this.recordFastInitiationNotificationUsage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PayloadPreviewSpec = { $: {} };
export const ShareTargetSpec = { $: {} };
export const TransferMetadataSpec = { $: {} };
export const ShareTargetListener_OnShareTargetDiscovered_ParamsSpec = { $: {} };
export const ShareTargetListener_OnShareTargetLost_ParamsSpec = { $: {} };
export const TransferUpdateListener_OnTransferUpdate_ParamsSpec = { $: {} };
export const DiscoveryObserver_OnNearbyProcessStopped_ParamsSpec = { $: {} };
export const DiscoveryObserver_OnStartDiscoveryResult_ParamsSpec = { $: {} };
export const DiscoveryManager_AddDiscoveryObserver_ParamsSpec = { $: {} };
export const DiscoveryManager_StartDiscovery_ParamsSpec = { $: {} };
export const DiscoveryManager_StartDiscovery_ResponseParamsSpec = { $: {} };
export const DiscoveryManager_StopDiscovery_ParamsSpec = { $: {} };
export const DiscoveryManager_StopDiscovery_ResponseParamsSpec = { $: {} };
export const DiscoveryManager_SelectShareTarget_ParamsSpec = { $: {} };
export const DiscoveryManager_SelectShareTarget_ResponseParamsSpec = { $: {} };
export const DiscoveryManager_GetPayloadPreview_ParamsSpec = { $: {} };
export const DiscoveryManager_GetPayloadPreview_ResponseParamsSpec = { $: {} };
export const ConfirmationManager_Accept_ParamsSpec = { $: {} };
export const ConfirmationManager_Accept_ResponseParamsSpec = { $: {} };
export const ConfirmationManager_Reject_ParamsSpec = { $: {} };
export const ConfirmationManager_Reject_ResponseParamsSpec = { $: {} };
export const ConfirmationManager_Cancel_ParamsSpec = { $: {} };
export const ConfirmationManager_Cancel_ResponseParamsSpec = { $: {} };
export const ReceiveObserver_OnHighVisibilityChanged_ParamsSpec = { $: {} };
export const ReceiveObserver_OnTransferUpdate_ParamsSpec = { $: {} };
export const ReceiveObserver_OnNearbyProcessStopped_ParamsSpec = { $: {} };
export const ReceiveObserver_OnStartAdvertisingFailure_ParamsSpec = { $: {} };
export const ReceiveManager_AddReceiveObserver_ParamsSpec = { $: {} };
export const ReceiveManager_IsInHighVisibility_ParamsSpec = { $: {} };
export const ReceiveManager_IsInHighVisibility_ResponseParamsSpec = { $: {} };
export const ReceiveManager_RegisterForegroundReceiveSurface_ParamsSpec = { $: {} };
export const ReceiveManager_RegisterForegroundReceiveSurface_ResponseParamsSpec = { $: {} };
export const ReceiveManager_UnregisterForegroundReceiveSurface_ParamsSpec = { $: {} };
export const ReceiveManager_UnregisterForegroundReceiveSurface_ResponseParamsSpec = { $: {} };
export const ReceiveManager_Accept_ParamsSpec = { $: {} };
export const ReceiveManager_Accept_ResponseParamsSpec = { $: {} };
export const ReceiveManager_Reject_ParamsSpec = { $: {} };
export const ReceiveManager_Reject_ResponseParamsSpec = { $: {} };
export const ReceiveManager_RecordFastInitiationNotificationUsage_ParamsSpec = { $: {} };
mojo.internal.Struct(PayloadPreviewSpec.$, 'PayloadPreview', [
    mojo.internal.StructField('description', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fileCount', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('shareType', 12, 0, nearbyShare_mojom_ShareTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ShareTargetSpec.$, 'ShareTarget', [
    mojo.internal.StructField('id', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 16, 0, nearbyShare_mojom_ShareTargetTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('imageUrl', 24, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('payloadPreview', 32, 0, PayloadPreviewSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('forSelfShare', 20, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(TransferMetadataSpec.$, 'TransferMetadata', [
    mojo.internal.StructField('status', 0, 0, TransferStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('progress', 4, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('token', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isOriginal', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isFinalStatus', 16, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(ShareTargetListener_OnShareTargetDiscovered_ParamsSpec.$, 'ShareTargetListener_OnShareTargetDiscovered_Params', [
    mojo.internal.StructField('shareTarget', 0, 0, ShareTargetSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ShareTargetListener_OnShareTargetLost_ParamsSpec.$, 'ShareTargetListener_OnShareTargetLost_Params', [
    mojo.internal.StructField('shareTarget', 0, 0, ShareTargetSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TransferUpdateListener_OnTransferUpdate_ParamsSpec.$, 'TransferUpdateListener_OnTransferUpdate_Params', [
    mojo.internal.StructField('status', 0, 0, TransferStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('token', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DiscoveryObserver_OnNearbyProcessStopped_ParamsSpec.$, 'DiscoveryObserver_OnNearbyProcessStopped_Params', [], [[0, 8],]);
mojo.internal.Struct(DiscoveryObserver_OnStartDiscoveryResult_ParamsSpec.$, 'DiscoveryObserver_OnStartDiscoveryResult_Params', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DiscoveryManager_AddDiscoveryObserver_ParamsSpec.$, 'DiscoveryManager_AddDiscoveryObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(DiscoveryObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DiscoveryManager_StartDiscovery_ParamsSpec.$, 'DiscoveryManager_StartDiscovery_Params', [
    mojo.internal.StructField('listener', 0, 0, mojo.internal.InterfaceProxy(ShareTargetListenerRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DiscoveryManager_StartDiscovery_ResponseParamsSpec.$, 'DiscoveryManager_StartDiscovery_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, StartDiscoveryResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DiscoveryManager_StopDiscovery_ParamsSpec.$, 'DiscoveryManager_StopDiscovery_Params', [], [[0, 8],]);
mojo.internal.Struct(DiscoveryManager_StopDiscovery_ResponseParamsSpec.$, 'DiscoveryManager_StopDiscovery_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(DiscoveryManager_SelectShareTarget_ParamsSpec.$, 'DiscoveryManager_SelectShareTarget_Params', [
    mojo.internal.StructField('shareTargetId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DiscoveryManager_SelectShareTarget_ResponseParamsSpec.$, 'DiscoveryManager_SelectShareTarget_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, SelectShareTargetResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('transferUpdateListener', 4, 0, mojo.internal.InterfaceRequest(TransferUpdateListenerPendingReceiver), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('confirmationManager', 8, 0, mojo.internal.InterfaceProxy(ConfirmationManagerRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DiscoveryManager_GetPayloadPreview_ParamsSpec.$, 'DiscoveryManager_GetPayloadPreview_Params', [], [[0, 8],]);
mojo.internal.Struct(DiscoveryManager_GetPayloadPreview_ResponseParamsSpec.$, 'DiscoveryManager_GetPayloadPreview_ResponseParams', [
    mojo.internal.StructField('payloadPreview', 0, 0, PayloadPreviewSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConfirmationManager_Accept_ParamsSpec.$, 'ConfirmationManager_Accept_Params', [], [[0, 8],]);
mojo.internal.Struct(ConfirmationManager_Accept_ResponseParamsSpec.$, 'ConfirmationManager_Accept_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConfirmationManager_Reject_ParamsSpec.$, 'ConfirmationManager_Reject_Params', [], [[0, 8],]);
mojo.internal.Struct(ConfirmationManager_Reject_ResponseParamsSpec.$, 'ConfirmationManager_Reject_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConfirmationManager_Cancel_ParamsSpec.$, 'ConfirmationManager_Cancel_Params', [], [[0, 8],]);
mojo.internal.Struct(ConfirmationManager_Cancel_ResponseParamsSpec.$, 'ConfirmationManager_Cancel_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveObserver_OnHighVisibilityChanged_ParamsSpec.$, 'ReceiveObserver_OnHighVisibilityChanged_Params', [
    mojo.internal.StructField('inHighVisibility', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveObserver_OnTransferUpdate_ParamsSpec.$, 'ReceiveObserver_OnTransferUpdate_Params', [
    mojo.internal.StructField('shareTarget', 0, 0, ShareTargetSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('metadata', 8, 0, TransferMetadataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ReceiveObserver_OnNearbyProcessStopped_ParamsSpec.$, 'ReceiveObserver_OnNearbyProcessStopped_Params', [], [[0, 8],]);
mojo.internal.Struct(ReceiveObserver_OnStartAdvertisingFailure_ParamsSpec.$, 'ReceiveObserver_OnStartAdvertisingFailure_Params', [], [[0, 8],]);
mojo.internal.Struct(ReceiveManager_AddReceiveObserver_ParamsSpec.$, 'ReceiveManager_AddReceiveObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(ReceiveObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_IsInHighVisibility_ParamsSpec.$, 'ReceiveManager_IsInHighVisibility_Params', [], [[0, 8],]);
mojo.internal.Struct(ReceiveManager_IsInHighVisibility_ResponseParamsSpec.$, 'ReceiveManager_IsInHighVisibility_ResponseParams', [
    mojo.internal.StructField('inHighVisibility', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_RegisterForegroundReceiveSurface_ParamsSpec.$, 'ReceiveManager_RegisterForegroundReceiveSurface_Params', [], [[0, 8],]);
mojo.internal.Struct(ReceiveManager_RegisterForegroundReceiveSurface_ResponseParamsSpec.$, 'ReceiveManager_RegisterForegroundReceiveSurface_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, RegisterReceiveSurfaceResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_UnregisterForegroundReceiveSurface_ParamsSpec.$, 'ReceiveManager_UnregisterForegroundReceiveSurface_Params', [], [[0, 8],]);
mojo.internal.Struct(ReceiveManager_UnregisterForegroundReceiveSurface_ResponseParamsSpec.$, 'ReceiveManager_UnregisterForegroundReceiveSurface_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_Accept_ParamsSpec.$, 'ReceiveManager_Accept_Params', [
    mojo.internal.StructField('shareTargetId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_Accept_ResponseParamsSpec.$, 'ReceiveManager_Accept_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_Reject_ParamsSpec.$, 'ReceiveManager_Reject_Params', [
    mojo.internal.StructField('shareTargetId', 0, 0, mojoBase_mojom_UnguessableTokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_Reject_ResponseParamsSpec.$, 'ReceiveManager_Reject_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ReceiveManager_RecordFastInitiationNotificationUsage_ParamsSpec.$, 'ReceiveManager_RecordFastInitiationNotificationUsage_Params', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
