import '//resources/polymer/v3_0/iron-iconset-svg/iron-iconset-svg.js';
import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
const template = html `<iron-iconset-svg name="nearby20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="". See also http://goo.gl/Y1OdAq
      -->
      <g id="checked">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18ZM6.16667 9.40426L8.33333 11.617L13.8333 6L15 7.19149L8.33333 14L5 10.5957L6.16667 9.40426Z"></path>
      </g>
      <g id="chevron-right">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M6.667 13.825 10.787 10l-4.12-3.825L7.934 5l5.398 5-5.398 5-1.268-1.175Z"></path>
      </g>
      <g id="contact-all">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M12.9981 6C12.9981 4.935 12.6229 3.9525 12 3.18C12.3152 3.075 12.6454 3 12.9981 3C14.6567 3 16 4.3425 16 6C16 7.6575 14.6567 9 12.9981 9C12.6754 9 12.3677 8.9325 12.075 8.8425C12.0525 8.835 12.03 8.8275 12 8.82C12.6229 8.0475 12.9981 7.065 12.9981 6ZM13.6602 10.1309C15.0302 11.0609 16.0002 12.3209 16.0002 14.0009V17.0009H20.0002V14.0009C20.0002 11.8209 16.4202 10.5309 13.6602 10.1309ZM7.5 5C6.675 5 6 5.675 6 6.5C6 7.325 6.675 8 7.5 8C8.325 8 9 7.325 9 6.5C9 5.675 8.325 5 7.5 5V5ZM7.5 13C5.475 13 3.15 13.86 3 14.34V15H12V14.3333C11.85 13.86 9.525 13 7.5 13V13ZM7.5 3C9.43375 3 11 4.56625 11 6.5C11 8.43375 9.43375 10 7.5 10C5.56625 10 4 8.43375 4 6.5C4 4.56625 5.56625 3 7.5 3ZM7.5 11C9.66938 11 14 12.1486 14 14.4286V17H1V14.4286C1 12.1486 5.33062 11 7.5 11Z"></path>
      </g>
      <g id="contact-group">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 3C9.425 3 11 4.575 11 6.5C11 8.425 9.425 10 7.5 10C5.575 10 4 8.425 4 6.5C4 4.575 5.575 3 7.5 3ZM7.5 5C6.67957 5 6 5.67957 6 6.5C6 7.32043 6.67957 8 7.5 8C8.32043 8 9 7.32043 9 6.5C9 5.67957 8.32043 5 7.5 5Z"></path>
        <path d="M15 6H17V8H19V10H17V12H15V10H13V8H15V6Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M7.5 11C9.60583 11 13.7789 12.0336 13.9916 14.0859L14 14.25V17H1V14.25C1 12.0887 5.33875 11 7.5 11ZM11.9947 14.3433C11.9867 14.3476 11.9693 14.3346 11.9329 14.3011L11.8432 14.2246C11.6159 14.0441 11.2636 13.85 10.8172 13.6713C9.79154 13.2607 8.42752 13 7.5 13C6.57248 13 5.20846 13.2607 4.18279 13.6713C3.73641 13.85 3.38414 14.0441 3.15679 14.2246L3.0671 14.3011C3.01855 14.3458 3.00384 14.3539 3 14.3335V15H12V14.3335L11.9947 14.3433Z"></path>
      </g>
      <g id="info">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M9 14H11V10H9V14ZM10 2C5.584 2 2 5.584 2 10C2 14.416 5.584 18 10 18C14.416 18 18 14.416 18 10C18 5.584 14.416 2 10 2ZM10 16C6.6925 16 4 13.3075 4 10C4 6.6925 6.6925 4 10 4C13.3075 4 16 6.6925 16 10C16 13.3075 13.3075 16 10 16ZM9 8H11V6H9V8Z"></path>
      </g>
      <g id="radar">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.0353 15.096C12.9268 15.975 11.5247 16.5 10 16.5C6.41015 16.5 3.5 13.5899 3.5 10C3.5 6.41015 6.41015 3.5 10 3.5C13.5899 3.5 16.5 6.41015 16.5 10C16.5 11.5247 15.975 12.9268 15.096 14.0354L14.0261 12.9654C14.6382 12.1358 15 11.1101 15 10C15 7.23858 12.7614 5 10 5C7.23858 5 5 7.23858 5 10C5 12.7614 7.23858 15 10 15C11.1101 15 12.1358 14.6382 12.9654 14.0261L14.0353 15.096ZM12.948 11.8874C13.2974 11.3428 13.5 10.6951 13.5 10C13.5 8.067 11.933 6.5 10 6.5C8.067 6.5 6.5 8.067 6.5 10C6.5 11.933 8.067 13.5 10 13.5C10.6951 13.5 11.3428 13.2974 11.8874 12.948L10.3885 11.4492C10.2646 11.4823 10.1344 11.5 10 11.5C9.17157 11.5 8.5 10.8284 8.5 10C8.5 9.17157 9.17157 8.5 10 8.5C10.8284 8.5 11.5 9.17157 11.5 10C11.5 10.1344 11.4823 10.2646 11.4492 10.3885L12.948 11.8874ZM18 10C18 14.4183 14.4183 18 10 18C5.58172 18 2 14.4183 2 10C2 5.58172 5.58172 2 10 2C14.4183 2 18 5.58172 18 10Z"></path>
      </g>
      <g id="visibility">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13 10C13 11.6569 11.6569 13 10 13C8.34315 13 7 11.6569 7 10C7 8.34315 8.34315 7 10 7C11.6569 7 13 8.34315 13 10ZM11 10C11 10.5523 10.5523 11 10 11C9.44772 11 9 10.5523 9 10C9 9.44772 9.44772 9 10 9C10.5523 9 11 9.44772 11 10ZM10 16C14.3333 16 17.3333 14 19 10C17 6 14 4 10 4C6 4 3 6 1 10C2.66667 14 5.66667 16 10 16ZM10 6C12.9373 6 15.1315 7.29402 16.7641 10.0695C15.3775 12.7465 13.2078 14 10 14C6.79225 14 4.6225 12.7465 3.2359 10.0695C4.8685 7.29402 7.06265 6 10 6Z"></path>
      </g>
      <g id="visibility-off">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M17.3897 18.0247L1.9895 2.62442L2.01413 2.59979L2.00015 2.58582L0.585938 4.00003L3.29316 6.70725C2.42105 7.5893 1.65672 8.6869 1.00015 10C2.66682 14 5.66682 16 10.0002 16C10.8372 16 11.6245 15.9254 12.3621 15.7761L16.0002 19.4142L17.3897 18.0247ZM3.23605 10.0696C3.68277 9.31012 4.17153 8.66159 4.70605 8.12014L7.03328 10.4474C7.22745 11.7461 8.25408 12.7727 9.55281 12.9669L10.5721 13.9862C10.3852 13.9954 10.1946 14 10.0002 14C6.7924 14 4.62265 12.7465 3.23605 10.0696Z"></path>
        <path d="M16.1839 13.9904C17.3593 13.0152 18.298 11.6851 19.0002 10C17.0002 6.00003 14.0002 4.00003 10.0002 4.00003C8.81854 4.00003 7.7242 4.17455 6.71711 4.5236L8.34623 6.15272C8.86951 6.05045 9.42035 6.00003 10.0002 6.00003C12.9375 6.00003 15.1317 7.29405 16.7643 10.0696C16.2217 11.117 15.5593 11.9465 14.7617 12.5682L16.1839 13.9904Z"></path>
        <path d="M12.9133 10.7198L9.28043 7.08692C9.511 7.03014 9.75206 7.00003 10.0002 7.00003C11.657 7.00003 13.0002 8.34317 13.0002 10C13.0002 10.2481 12.97 10.4892 12.9133 10.7198Z"></path>
      </g>
      <g id="your-devices">
        <path d="M11 15H5V5.00208L19 4.96094V4C19 3.72386 18.8881 3.47386 18.7071 3.29289C18.5261 3.11193 18.2761 3 18 3H4C3.44772 3 3 3.44772 3 4V15H2C1.44772 15 1 15.4477 1 16C1 16.5523 1.44772 17 2 17H11V15Z"></path>
        <path fill-rule="evenodd" clip-rule="evenodd" d="M13.1667 6L17.8333 6.00611C18.475 6.00611 19 6.55 19 7.22222V15.7778C19 16.45 18.475 17 17.8333 17H13.1667C12.525 17 12 16.45 12 15.7778V7.22222C12 6.55 12.525 6 13.1667 6ZM13.5 15H17.5V7.5H13.5V15Z"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
<iron-iconset-svg name="nearby-share" size="24">
  <svg>
    <defs>
      <!-- Nearby Share icons -->
      <g id="checked">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M19 10C19 14.9706 14.9706 19 10 19C5.02944 19 1 14.9706 1 10C1 5.02944 5.02944 1 10 1C14.9706 1 19 5.02944 19 10ZM14.1705 6.9545C13.7312 6.51516 13.0188 6.51516 12.5795 6.9545L8.875 10.659L7.4205 9.2045C6.98116 8.76517 6.26884 8.76517 5.8295 9.2045C5.39016 9.64384 5.39016 10.3562 5.8295 10.7955L8.0795 13.0455C8.51884 13.4848 9.23116 13.4848 9.6705 13.0455L14.1705 8.5455C14.6098 8.10616 14.6098 7.39384 14.1705 6.9545Z"></path>
      </g>

      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="laptop" width="20" height="20" viewBox="0 0 20 20"><path clip-rule="evenodd" d="M18 15H19C19.5523 15 20 15.4477 20 16C20 16.5523 19.5523 17 19 17H1C0.447715 17 0 16.5523 0 16C0 15.4477 0.447715 15 1 15H2V4C2 3.44772 2.44772 3 3 3H17C17.2761 3 17.5261 3.11193 17.7071 3.29289C17.8881 3.47386 18 3.72386 18 4V15ZM16 12V5H4V12H16ZM8 14V15H12V14H8Z" fill="var(--nearby-device-icon-color, var(--cros-sys-on_primary_container, var(--google-blue-600)))"/></g>
      <g id="smartphone" width="20" height="20" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M14 1.01L6 1C4.9 1 4 1.9 4 3V17C4 18.1 4.9 19 6 19H14C15.1 19 16 18.1 16 17V3C16 1.9 15.1 1.01 14 1.01ZM14 17H6V16H14V17ZM14 14H6V6H14V14ZM6 4V3H14V4H6Z" fill="var(--nearby-device-icon-color, var(--cros-sys-on_primary_container, var(--google-blue-600)))"/></g>
      <g id="tablet" width="20" height="20" viewBox="0 0 20 20"><path fill-rule="evenodd" clip-rule="evenodd" d="M18.99 15L19 5C19 3.9 18.1 3 17 3L3 3C1.9 3 1 3.9 1 5L0.999999 15C0.999999 16.1 1.9 17 3 17L17 17C18.1 17 18.99 16.1 18.99 15ZM3 15L3 5L4 5L4 15L3 15ZM6 15L6 5L14 5L14 15L6 15ZM16 5L17 5L17 15L16 15L16 5Z" fill="var(--nearby-device-icon-color, var(--cros-sys-on_primary_container, var(--google-blue-600)))"/></g>
    </defs>
  </svg>
</iron-iconset-svg>
<iron-iconset-svg name="nearby-images" size="200">
  <svg>
    <defs>
      <g id="contacts-download-failed" fill="none" width="200px" height="200px" viewBox="0 0 200 200">
        <path d="M166.582 74.9455L149.742 58.5899C147.642 56.5976 146.413 53.8306 146.326 50.8969C146.239 47.9632 147.301 45.1031 149.277 42.9451V42.9451C150.256 41.876 151.43 41.0116 152.733 40.4012C154.036 39.7909 155.441 39.4466 156.869 39.3881C158.297 39.3295 159.72 39.5578 161.056 40.0599C162.392 40.562 163.615 41.3281 164.656 42.3144L181.49 58.6685C183.591 60.6601 184.821 63.4271 184.909 66.3611C184.997 69.2951 183.936 72.156 181.96 74.3147V74.3147C179.983 76.4725 177.252 77.7511 174.368 77.8694C171.484 77.9877 168.683 76.936 166.582 74.9455V74.9455Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M35.1661 82.2527L26.8901 92.1156C25.8462 93.3597 26.0085 95.2144 27.2526 96.2583L36.9988 104.436C38.2429 105.48 40.0977 105.318 41.1416 104.074L49.4175 94.211C50.4614 92.967 50.2992 91.1122 49.0551 90.0683L39.3088 81.8902C38.0648 80.8463 36.21 81.0086 35.1661 82.2527Z" fill="var(--cros-sys-illo-color5)"/><path d="M43.6447 163.767C47.2669 162.97 50.8439 161.978 54.3597 160.795C59.2507 159.334 64.5083 159.831 68.978 162.176C71.4193 163.578 73.9366 164.851 76.5192 165.989C85.7173 169.587 96.3816 164.707 98.7791 154.969C100.885 146.416 95.1283 137.147 86.1533 135.822C82.0065 135.191 77.7912 135.976 73.623 135.71C69.1855 135.473 64.9895 133.727 61.7544 130.772C58.9888 128.216 56.4531 125.41 53.3343 123.2C50.3118 121.036 46.7797 119.649 43.0549 119.164C37.1699 118.412 31.1874 119.915 26.3472 123.362C21.507 126.808 18.1803 131.934 17.0567 137.676C15.9331 143.419 17.0988 149.338 20.312 154.206C23.5253 159.075 28.5398 162.519 34.3161 163.826C37.3875 164.446 40.5653 164.426 43.6447 163.767V163.767Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M169.806 163.198C169.637 163.573 169.391 163.908 169.083 164.18C168.775 164.452 168.413 164.655 168.019 164.777C167.626 164.898 167.211 164.934 166.801 164.883C166.391 164.833 165.995 164.696 165.64 164.482C159.406 160.752 154.742 154.866 152.541 147.949C150.34 141.033 150.757 133.572 153.711 126.994C156.666 120.417 161.951 115.184 168.555 112.297C175.16 109.411 182.619 109.073 189.507 111.349C189.9 111.479 190.263 111.69 190.571 111.968C190.879 112.246 191.126 112.586 191.295 112.964C191.464 113.343 191.552 113.752 191.553 114.166C191.554 114.579 191.468 114.987 191.301 115.363L169.806 163.198Z" stroke="var(--cros-sys-illo-secondary)" stroke-width="3" stroke-miterlimit="10"/><path d="M134 164C141.18 164 147 158.404 147 151.5C147 144.596 141.18 139 134 139C126.82 139 121 144.596 121 151.5C121 158.404 126.82 164 134 164Z" stroke="var(--cros-sys-illo-color4)" stroke-width="3" stroke-miterlimit="10"/><circle cx="103" cy="84" r="46" fill="var(--cros-sys-illo-secondary)"/><path d="M96.3245 94.2509L97.4105 91.0713C97.9384 89.5256 98.5676 88.2611 99.298 87.2777C100.088 86.2652 101.075 85.3944 102.261 84.6653C103.507 83.9071 105.032 83.1214 106.839 82.3083C108.112 81.7569 109.26 81.2119 110.282 80.6734C111.304 80.1349 112.165 79.4919 112.864 78.7444C113.623 77.9679 114.198 77.0055 114.59 75.8573C115.299 73.7817 115.195 71.8476 114.279 70.0552C113.406 68.2778 111.733 66.9668 109.26 66.1222C107.671 65.5792 106.211 65.4503 104.88 65.7357C103.55 66.021 102.38 66.5585 101.371 67.3479C100.361 68.1374 99.5066 68.9797 98.8064 69.8747L94.3861 65.924C95.3395 64.7209 96.6246 63.5571 98.2415 62.4327C99.8583 61.3083 101.753 60.5253 103.926 60.0838C106.098 59.6424 108.487 59.8666 111.093 60.7565C113.787 61.6766 115.939 63.028 117.549 64.8108C119.219 66.5645 120.281 68.5794 120.737 70.8554C121.251 73.1024 121.101 75.4183 120.287 77.803C119.653 79.6578 118.69 81.1781 117.398 82.364C116.149 83.5649 114.836 84.5218 113.458 85.2348C112.096 85.9036 110.918 86.4631 109.926 86.9133C108.712 87.4356 107.66 87.9887 106.771 88.5724C105.881 89.1562 105.131 89.8369 104.52 90.6145C103.909 91.3922 103.415 92.333 103.038 93.4371L102.088 96.2193L96.3245 94.2509ZM94.3296 109.621C93.1373 109.214 92.2573 108.469 91.6897 107.388C91.1814 106.277 91.1308 105.126 91.5381 103.934C91.9302 102.785 92.6595 101.95 93.7259 101.426C94.8516 100.874 96.0106 100.801 97.203 101.208C98.3512 101.6 99.1795 102.352 99.6878 103.462C100.255 104.544 100.343 105.659 99.9509 106.807C99.5437 107.999 98.7772 108.872 97.6516 109.424C96.5851 109.948 95.4778 110.013 94.3296 109.621Z" fill="var(--cros-sys-illo-base)"/>
      </g>

      <g id="contacts-empty" fill="none" width="200px" height="100px" viewBox="0 0 200 100">
        <path d="M102 16.506L104.346 13.4036C106.201 10.9313 110.021 10.2527 112.803 11.9008L113.295 12.1917C116.077 13.8398 116.841 17.2331 114.986 19.7053L106.474 31" fill="var(--cros-sys-illo-color3)"/><path d="M66.1329 89.416C66.6505 91.2611 68.5656 92.3886 70.4289 91.8761L116.39 79.6783C118.254 79.1658 119.392 77.2695 118.875 75.4245L100.656 9.5666C100.138 7.72155 98.2232 6.64527 96.3599 7.10654L59.1455 16.998C58.2139 17.2543 57.3857 17.8693 56.8681 18.6893L51.537 29.5546C51.0194 30.4259 50.8641 31.5021 51.1229 32.5272L66.1329 89.416Z" fill="var(--cros-sys-illo-base)" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2" stroke-miterlimit="10"/><path d="M58.6092 17L60.8637 25.3774C61.4274 27.4151 60.1874 29.5094 58.1583 30.0755L51 32" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2" stroke-miterlimit="10"/><path d="M60 67C57.534 66.8452 55.0156 66.1225 52.7595 64.7805C45.8337 60.703 43.2104 52.2897 46.2535 45.1668C46.7257 44.0829 48.0374 43.67 49.0343 44.2893L54.7532 47.6959" fill="var(--cros-sys-illo-color5)"/><path d="M55 48L73.0575 58.4995C74.052 59.1082 74.3137 60.4269 73.5809 61.2892C70.2834 65.2456 65.2588 67.2744 60.2341 66.9701" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2" stroke-miterlimit="10" stroke-dasharray="4 4"/><path d="M137 38.6228C138.332 38.2076 139.766 38 141.199 38C149.394 38 156 44.7474 156 53C156 61.2526 149.342 68 141.199 68C139.817 68 138.434 67.7924 137.154 67.4291" fill="var(--cros-sys-illo-color1-2)"/><rect x="84" y="37" width="53" height="53" rx="5" fill="var(--cros-sys-illo-base)" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2"/><path d="M137 66C131.218 64.3489 127 58.9101 127 52.4514C127 46.0899 131.123 40.6996 136.81 39" stroke="var(--cros-sys-illo-color1-1)" stroke-width="2" stroke-miterlimit="10" stroke-dasharray="4 4"/><path d="M107 31.3948C105.09 34.0744 101.157 34.81 98.2915 33.0236L97.7858 32.7083C94.9204 30.9219 94.1338 27.244 96.0441 24.5643L102.224 16" stroke="var(--cros-sys-illo-color1-2)" stroke-width="2" stroke-miterlimit="10" stroke-dasharray="4 4"/><path d="M118.556 53H101.444C100.088 53 99 54.0878 99 55.4444V72.5556C99 73.9 100.088 75 101.444 75H118.556C119.9 75 121 73.9 121 72.5556V55.4444C121 54.0878 119.9 53 118.556 53ZM110 56.6667C112.017 56.6667 113.667 58.3167 113.667 60.3333C113.667 62.3622 112.017 64 110 64C107.983 64 106.333 62.3622 106.333 60.3333C106.333 58.3167 107.983 56.6667 110 56.6667ZM117.333 71.3333H102.667V70.1111C102.667 67.6667 107.556 66.3222 110 66.3222C112.444 66.3222 117.333 67.6667 117.333 70.1111V71.3333Z" fill="var(--cros-sys-illo-color1-1)"/>
      </g>

      <g id="nearby-device-visibility-light" fill="none" fill-rule="evenodd">
        <path d="M102.293 143.27C126.19 143.27 145.563 123.897 145.563 100C145.563 76.1028 126.19 56.7302 102.293 56.7302C78.3955 56.7302 59.023 76.1028 59.023 100C59.023 123.897 78.3955 143.27 102.293 143.27Z" fill="#D2E3FC"/><path d="M172.025 45.479L161.088 42.5486C160.606 42.4194 160.111 42.7055 159.982 43.1876L157.055 54.1088C156.926 54.5909 157.212 55.0864 157.694 55.2156L168.631 58.146C169.113 58.2752 169.608 57.9891 169.738 57.507L172.664 46.5858C172.793 46.1037 172.507 45.6082 172.025 45.479Z" fill="#34A853"/><path d="M48.3131 145.305L48.2866 145.259C46.7159 142.539 43.2373 141.607 40.5169 143.177L32.028 148.078C29.3076 149.649 28.3755 153.128 29.9461 155.848L29.9727 155.894C31.5433 158.615 35.0219 159.547 37.7424 157.976L46.2313 153.075C48.9517 151.504 49.8838 148.026 48.3131 145.305Z" stroke="#EA4335" stroke-width="2" stroke-linejoin="round"/><path d="M35.4213 59.1755L30.2119 53.9661C29.9161 53.6629 29.7061 53.2866 29.6034 52.8757C29.5007 52.4647 29.5089 52.0339 29.6273 51.6272L31.4878 44.5041C31.6155 44.0911 31.8419 43.7155 32.1476 43.4098C32.4532 43.1041 32.8288 42.8776 33.2418 42.75L40.365 40.8895C40.7717 40.7711 41.2025 40.7629 41.6134 40.8656C42.0244 40.9683 42.4006 41.1784 42.7038 41.4742L47.9132 46.6836C48.2182 46.9925 48.4374 47.3756 48.5493 47.795C48.6611 48.2145 48.6617 48.6559 48.5511 49.0756L46.6375 56.1987C46.52 56.6024 46.3024 56.97 46.0051 57.2674C45.7077 57.5647 45.3402 57.7822 44.9364 57.8997L37.8134 59.8133C37.3936 59.924 36.9522 59.9234 36.5327 59.8115C36.1133 59.6997 35.7303 59.4804 35.4213 59.1755Z" fill="#FBBC04"/><path d="M38.9875 130.96L34.0926 127.298C33.881 127.14 33.5812 127.183 33.423 127.395L29.7738 132.273C29.6156 132.484 29.6587 132.784 29.8703 132.942L34.7652 136.604C34.9768 136.762 35.2765 136.719 35.4348 136.508L39.0839 131.63C39.2422 131.418 39.1991 131.118 38.9875 130.96Z" fill="#EE5FFA"/><path d="M102.293 162.566C136.847 162.566 164.859 134.554 164.859 100C164.859 65.4459 136.847 37.4342 102.293 37.4342C67.7386 37.4342 39.727 65.4459 39.727 100C39.727 134.554 67.7386 162.566 102.293 162.566Z" stroke="#4285F4" stroke-width="2" stroke-linejoin="round"/><path fill-rule="evenodd" clip-rule="evenodd" d="M104.419 75.654L121.429 81.9797C121.95 82.0983 122.416 82.3877 122.753 82.802C123.091 83.2162 123.279 83.7314 123.29 84.2654V96.8105C123.29 107.123 118.187 117.01 109.31 123.389C106.333 125.515 103.675 126.685 102.293 126.685C100.911 126.685 98.2529 125.515 95.2761 123.389C86.3989 117.01 81.2958 107.123 81.2958 96.8105V84.2654C81.3062 83.7314 81.495 83.2162 81.8322 82.802C82.1694 82.3877 82.6355 82.0983 83.1563 81.9797L100.167 75.654C101.562 75.3007 103.024 75.3007 104.419 75.654ZM113.403 99.9999C113.403 106.136 108.429 111.11 102.293 111.11C96.157 111.11 91.183 106.136 91.183 99.9999C91.183 93.8642 96.157 88.8901 102.293 88.8901C108.429 88.8901 113.403 93.8642 113.403 99.9999Z" fill="#4285F4"/><path fill-rule="evenodd" clip-rule="evenodd" d="M105.287 100.037C105.287 101.69 103.946 103.031 102.293 103.031C100.639 103.031 99.2989 101.69 99.2989 100.037C99.2989 98.3834 100.639 97.0429 102.293 97.0429C103.946 97.0429 105.287 98.3834 105.287 100.037ZM103.291 100.037C103.291 100.588 102.844 101.035 102.293 101.035C101.742 101.035 101.295 100.588 101.295 100.037C101.295 99.4857 101.742 99.0389 102.293 99.0389C102.844 99.0389 103.291 99.4857 103.291 100.037ZM102.293 106.025C106.617 106.025 109.611 104.029 111.275 100.037C109.279 96.0449 106.285 94.049 102.293 94.049C98.3009 94.049 95.3069 96.0449 93.3109 100.037C94.9742 104.029 97.9682 106.025 102.293 106.025ZM102.293 96.0449C105.224 96.0449 107.414 97.3364 109.043 100.106C107.66 102.778 105.494 104.029 102.293 104.029C99.0915 104.029 96.9261 102.778 95.5423 100.106C97.1716 97.3364 99.3614 96.0449 102.293 96.0449Z" fill="#4285F4"/>
      </g>

      <g id="nearby-device-visibility-dark" fill="none" fill-rule="evenodd">
        <path d="M102.293 143.77C126.19 143.77 145.563 124.397 145.563 100.5C145.563 76.6028 126.19 57.2302 102.293 57.2302C78.3955 57.2302 59.023 76.6028 59.023 100.5C59.023 124.397 78.3955 143.77 102.293 143.77Z" fill="#8AB4F8" fill-opacity="0.4"/><path d="M172.025 45.979L161.088 43.0486C160.606 42.9194 160.111 43.2055 159.982 43.6876L157.055 54.6088C156.926 55.0909 157.212 55.5864 157.694 55.7156L168.631 58.646C169.113 58.7752 169.608 58.4891 169.738 58.007L172.664 47.0858C172.793 46.6037 172.507 46.1082 172.025 45.979Z" fill="#5BB974"/><path d="M48.3131 145.805L48.2866 145.759C46.7159 143.039 43.2373 142.107 40.5169 143.677L32.028 148.578C29.3076 150.149 28.3755 153.628 29.9461 156.348L29.9727 156.394C31.5433 159.115 35.0219 160.047 37.7424 158.476L46.2313 153.575C48.9517 152.004 49.8838 148.526 48.3131 145.805Z" stroke="#EA4335" stroke-width="2" stroke-linejoin="round"/><path d="M35.4213 59.6755L30.2119 54.4661C29.9161 54.1629 29.7061 53.7866 29.6034 53.3757C29.5007 52.9647 29.5089 52.5339 29.6273 52.1272L31.4878 45.0041C31.6155 44.5911 31.8419 44.2155 32.1476 43.9098C32.4532 43.6041 32.8288 43.3776 33.2418 43.25L40.365 41.3895C40.7717 41.2711 41.2025 41.2629 41.6134 41.3656C42.0244 41.4683 42.4006 41.6784 42.7038 41.9742L47.9132 47.1836C48.2182 47.4925 48.4374 47.8756 48.5493 48.295C48.6611 48.7145 48.6617 49.1559 48.5511 49.5756L46.6375 56.6987C46.52 57.1024 46.3024 57.47 46.0051 57.7674C45.7077 58.0647 45.3402 58.2822 44.9364 58.3997L37.8134 60.3133C37.3936 60.424 36.9522 60.4234 36.5327 60.3115C36.1133 60.1997 35.7303 59.9804 35.4213 59.6755Z" fill="#FCC934"/><path d="M38.9875 131.46L34.0926 127.798C33.881 127.64 33.5812 127.683 33.423 127.895L29.7738 132.773C29.6156 132.984 29.6587 133.284 29.8703 133.442L34.7652 137.104C34.9768 137.262 35.2765 137.219 35.4348 137.008L39.0839 132.13C39.2422 131.918 39.1991 131.618 38.9875 131.46Z" fill="#F882FE"/><path d="M102.293 163.066C136.847 163.066 164.859 135.054 164.859 100.5C164.859 65.9459 136.847 37.9342 102.293 37.9342C67.7386 37.9342 39.727 65.9459 39.727 100.5C39.727 135.054 67.7386 163.066 102.293 163.066Z" stroke="#669DF6" stroke-width="2" stroke-linejoin="round"/><path fill-rule="evenodd" clip-rule="evenodd" d="M104.419 76.154L121.429 82.4797C121.95 82.5983 122.416 82.8877 122.753 83.302C123.091 83.7162 123.279 84.2314 123.29 84.7654V97.3105C123.29 107.623 118.187 117.51 109.31 123.889C106.333 126.015 103.675 127.185 102.293 127.185C100.911 127.185 98.2529 126.015 95.2761 123.889C86.3989 117.51 81.2958 107.623 81.2958 97.3105V84.7654C81.3062 84.2314 81.495 83.7162 81.8322 83.302C82.1694 82.8877 82.6355 82.5983 83.1563 82.4797L100.167 76.154C101.562 75.8007 103.024 75.8007 104.419 76.154ZM113.403 100.5C113.403 106.636 108.429 111.61 102.293 111.61C96.157 111.61 91.183 106.636 91.183 100.5C91.183 94.3642 96.157 89.3901 102.293 89.3901C108.429 89.3901 113.403 94.3642 113.403 100.5Z" fill="#669DF6"/><path fill-rule="evenodd" clip-rule="evenodd" d="M105.287 100.537C105.287 102.19 103.946 103.531 102.293 103.531C100.639 103.531 99.2989 102.19 99.2989 100.537C99.2989 98.8834 100.639 97.5429 102.293 97.5429C103.946 97.5429 105.287 98.8834 105.287 100.537ZM103.291 100.537C103.291 101.088 102.844 101.535 102.293 101.535C101.742 101.535 101.295 101.088 101.295 100.537C101.295 99.9857 101.742 99.5389 102.293 99.5389C102.844 99.5389 103.291 99.9857 103.291 100.537ZM102.293 106.525C106.617 106.525 109.611 104.529 111.275 100.537C109.279 96.5449 106.285 94.549 102.293 94.549C98.3009 94.549 95.3069 96.5449 93.3109 100.537C94.9742 104.529 97.9682 106.525 102.293 106.525ZM102.293 96.5449C105.224 96.5449 107.414 97.8364 109.043 100.606C107.66 103.278 105.494 104.529 102.293 104.529C99.0915 104.529 96.9261 103.278 95.5423 100.606C97.1716 97.8364 99.3614 96.5449 102.293 96.5449Z" fill="#669DF6"/>
      </g>

      <g id="nearby-onboarding-splash" width="201" height="200" viewBox="0 0 201 200" fill="none" fill-rule="evenodd">
        <path d="M82.2416 172.591C77.6105 172.855 75.2555 172.231 71.1615 173.316C71.1615 173.316 67.1422 174.346 63.1412 170.832L52.9482 180.75C52.9482 180.75 62.2832 186.902 66.7224 187.683C71.1615 188.463 81.5526 190.208 83.4351 189.749C85.3175 189.29 89.3122 187.086 89.3122 187.086L91.0273 184.147C91.4573 184.102 90.684 183.204 91.0273 182.971C91.3044 182.686 91.8834 182.971 91.9079 182C91.9338 180.977 89.5052 180.27 88.6829 180.134C85.1388 179.276 82.0028 178.554 78.418 177.96C80.3135 177.62 82.1723 177.12 83.9656 176.469C84.3587 176.328 86.2726 175.494 86.3524 175.171C86.4137 174.922 86.0455 173.316 86.0455 173.316C85.6512 172.725 83.0897 172.536 82.2416 172.591Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M77.1057 181.236C80.613 182.421 84.3634 183.095 88.201 183.229C89.0178 183.332 89.8587 183.301 90.678 183.139C91.1081 183.094 91.5197 182.946 91.863 182.714C92.1401 182.428 92.2824 182.071 92.261 181.714C92.2397 181.357 92.0563 181.027 91.748 180.791C91.1193 180.329 90.3522 180.015 89.5187 179.877C85.9745 179.019 82.8386 178.297 79.2538 177.703C81.1492 177.363 83.008 176.863 84.8013 176.211C85.3646 176.011 85.8793 175.718 86.3143 175.352C86.5213 175.161 86.6635 174.929 86.7248 174.68C87.02 173.483 86.172 172.841 85.3093 172.631C80.9328 172.409 76.1472 172.345 71.9973 173.059C71.9973 173.059 67.2835 173.946 63.2825 170.433" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M52.8409 181.025C57.4686 184.992 66.9244 188.308 72.1966 188.729C75.6516 188.954 82.8093 191.355 85.3963 188.729" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M90.6779 183.139C90.8798 183.18 91.063 183.264 91.2102 183.383C91.3573 183.503 91.4633 183.653 91.5181 183.821C91.5729 183.988 91.5746 184.167 91.5231 184.339C91.4716 184.512 91.3685 184.673 91.2239 184.807C90.758 185.243 90.1496 185.554 89.482 185.698C84.8371 186.417 80.53 185.666 75.9722 184.239" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M75.0054 186.767C77.2665 187.353 80.9811 188.317 82.933 188.365C84.8849 188.413 86.8953 188.324 88.646 187.496C89.085 187.248 89.4406 186.907 89.6745 186.511L89.7557 185.983" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path fill-rule="evenodd" clip-rule="evenodd" d="M103.988 160.782L97.9815 173.049C104.503 174.353 105.834 174.641 112.836 176.369C119.736 180.011 123.826 179.803 122.567 176.933C121.309 174.064 117.785 173.895 119.661 173.049H131.12C131.695 172.858 131.407 172.206 131.12 171.343C130.833 170.481 126.901 171.266 126.134 170.117C125.368 168.967 131.338 169.88 132.097 168.302C132.856 166.724 129.798 166.96 129.798 165.796C129.798 164.704 134.2 164.642 133.26 162.486C132.32 160.329 133.633 160.253 133.509 159.638C133.429 159.243 133.109 159.081 132.097 158.781C127.482 158.035 120.654 160.495 117.647 161.241C112.45 162.109 111.175 161.836 103.988 160.782Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M97.7311 173.976L103.787 160.327L96.9112 159.205C96.9112 159.205 94.3941 155.705 91.2659 148.614C89.3427 144.255 87.274 139.96 83.9541 137.646C75.5904 131.817 55.346 132.34 46.2219 139.563C37.0978 146.786 37.3513 158.191 39.1254 167.822C40.8995 177.453 48.8831 183.916 48.8831 183.916L64.1807 169.576" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path fill-rule="evenodd" clip-rule="evenodd" d="M64.1597 129.792H69.8135L71.2509 136.404C70.827 137.103 70.2172 137.671 69.4895 138.043C68.7619 138.415 67.9451 138.578 67.1303 138.513C65.118 138.513 63.3931 137.554 62.9139 136.309L64.1597 129.792Z" fill="var(--cros-sys-illo-color1-2)"/><path d="M69.8134 129.026H64.1596C63.819 129.044 63.5062 129.279 63.393 129.601L62.1473 136.117C62.1324 136.283 62.1656 136.449 62.2431 136.596C62.8181 138.225 64.8304 139.279 67.1303 139.279C69.4301 139.279 71.2508 138.225 71.9216 136.692C72.0126 136.55 72.0468 136.379 72.0174 136.213L70.58 129.601C70.4931 129.263 70.1616 129.015 69.8134 129.026ZM69.1426 130.559L70.3884 136.309C70.0077 136.8 69.5104 137.189 68.9415 137.44C67.8714 137.912 66.2537 137.879 65.19 137.396C64.6417 137.147 64.158 136.775 63.7763 136.309L64.8304 130.655L69.1426 130.559Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M70.5801 121.647C71.4802 122.406 72.1345 123.415 72.4599 124.547C72.7853 125.678 72.7672 126.881 72.4079 128.002C72.0486 129.123 71.3642 130.113 70.4417 130.844C69.5192 131.576 68.4002 132.017 67.2266 132.111C66.053 132.206 64.8778 131.949 63.8502 131.375C62.8226 130.8 61.9889 129.933 61.455 128.884C60.921 127.834 60.7109 126.65 60.8512 125.481C60.9915 124.312 61.476 123.211 62.2432 122.318C63.2638 121.13 64.7123 120.393 66.2736 120.267C67.8349 120.141 69.3826 120.637 70.5801 121.647V121.647Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M60.8057 123.564H71.4424C71.4424 123.564 70.6449 120.653 66.5572 120.406C62.4695 120.159 60.8057 123.564 60.8057 123.564Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M79.6141 177.465L81.9769 167.576C82.1425 166.806 82.852 166.246 83.6395 166.264H94.0531C95.2145 166.264 96.0009 167.365 95.7157 168.451L92.3029 180.703L79.6141 177.465Z" fill="var(--cros-sys-illo-color1)"/><path d="M84.9732 170.961C85.5024 170.961 85.9314 170.532 85.9314 170.003C85.9314 169.474 85.5024 169.045 84.9732 169.045C84.4439 169.045 84.0149 169.474 84.0149 170.003C84.0149 170.532 84.4439 170.961 84.9732 170.961Z" fill="var(--cros-sys-illo-base)"/><circle cx="66.4885" cy="126.103" r="6.027" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5"/><path fill-rule="evenodd" clip-rule="evenodd" d="M72.7414 123.564H65.8635C67.7955 121.631 69.2652 119.374 71.6288 117.899C73.1459 116.989 75.0677 116.787 75.8768 117.899C76.0423 118.255 76.1108 118.648 76.0752 119.039C75.9145 120.807 73.7522 122.226 72.7414 123.564Z" fill="var(--cros-sys-illo-color1-1)"/><path d="M150.595 38.0862H145.325C145.179 38.0939 145.038 38.143 144.92 38.2279C144.801 38.3128 144.709 38.4299 144.654 38.5653L142.929 42.2067C142.884 42.3332 142.869 42.4683 142.886 42.6015C142.902 42.7347 142.95 42.8622 143.024 42.9738C143.099 43.0855 143.198 43.1782 143.315 43.2447C143.431 43.3112 143.562 43.3495 143.696 43.3566H152.32C152.453 43.3827 152.59 43.3681 152.714 43.3149C152.838 43.2618 152.943 43.1724 153.015 43.0585C153.088 42.9447 153.124 42.8117 153.12 42.6768C153.116 42.5419 153.071 42.4115 152.991 42.3025L151.362 38.5653C151.291 38.4223 151.182 38.3018 151.046 38.2173C150.911 38.1327 150.755 38.0873 150.595 38.0862V38.0862ZM150.116 39.6194L151.17 41.8234H144.846L145.804 39.6194H150.116Z" fill="var(--cros-sys-illo-color1)"/><path d="M152.512 43.3566H143.6C131.238 42.7816 124.339 48.5312 115.714 64.5342C115.638 64.7044 115.501 64.8408 115.331 64.9176H115.235L96.4532 69.9006L102.107 82.4538H102.203C109.179 83.176 116.182 81.3741 121.943 77.375L122.326 77.0876C128.33 72.9344 132.487 66.6131 133.921 59.4554C133.96 59.2521 134.077 59.0723 134.248 58.9555C134.418 58.8387 134.628 58.7944 134.832 58.8326C135.035 58.8707 135.215 58.988 135.332 59.1587C135.449 59.3295 135.493 59.5396 135.455 59.7429C133.956 67.2807 129.593 73.9441 123.285 78.3333C117.002 82.8855 109.236 84.9041 101.532 83.987C101.415 83.9662 101.303 83.9215 101.204 83.8555C101.106 83.7895 101.021 83.7039 100.957 83.6038H100.861L94.6325 69.7089C94.5855 69.6223 94.5582 69.5264 94.5524 69.4281C94.5467 69.3297 94.5627 69.2313 94.5993 69.1398C94.6359 69.0483 94.6921 68.966 94.7641 68.8987C94.8361 68.8315 94.9221 68.7809 95.0158 68.7506H95.1116L114.469 63.6718L114.66 63.3843C123.189 47.5729 130.472 41.6317 142.929 41.8233H153.47L156.249 42.59C159.186 43.4907 161.99 44.7798 164.586 46.4231C172.06 51.2144 176.085 58.4013 174.935 68.1756C173.785 77.95 167.652 84.562 158.261 88.3951C155.005 89.7432 151.593 90.6768 148.104 91.174L144.846 91.6532H143.6C143.443 91.6426 143.29 91.5933 143.157 91.5097C143.023 91.4261 142.912 91.3108 142.833 91.174L137.467 72.392C137.438 72.2913 137.431 72.1858 137.445 72.082C137.458 71.9782 137.493 71.8783 137.547 71.7885C137.601 71.6987 137.673 71.621 137.758 71.5599C137.843 71.4989 137.94 71.456 138.042 71.4338C138.208 71.3923 138.383 71.4075 138.539 71.477C138.695 71.5465 138.824 71.6662 138.904 71.8171L144.175 90.0242H144.75L147.912 89.545C151.27 89.0671 154.555 88.1655 157.686 86.8618C166.598 83.2204 172.348 77.1834 173.402 67.8882C174.456 58.593 170.815 52.0768 163.724 47.6688C161.259 46.06 158.582 44.8022 155.77 43.9315C155.015 43.6948 154.247 43.5029 153.47 43.3566H153.087H152.512Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M152.522 25.2622C153.338 23.18 156.681 22.2024 158.842 23.4732C159.402 23.8027 159.889 24.2426 160.274 24.7663C159.647 22.5736 161.413 20.5127 163.434 19.9281C163.995 19.7661 164.581 19.7169 165.161 19.7833C165.603 19.8106 166.039 19.6666 166.378 19.3811C166.717 19.0956 166.933 18.6907 166.982 18.2501V17.8668C167.135 16.8398 167.638 15.8972 168.407 15.1987C169.175 14.5002 170.161 14.0887 171.198 14.0337C172.405 14.0337 174.402 14.3641 174.456 12.5963L174.744 9.33827C174.777 8.76132 174.959 8.20276 175.271 7.71678C175.584 7.23079 176.017 6.83385 176.528 6.56445C177.04 6.29504 177.612 6.16233 178.19 6.17916C178.767 6.19598 179.331 6.36178 179.825 6.66048C180.32 6.95918 180.729 7.38066 181.013 7.88402C181.297 8.38739 181.446 8.95556 181.446 9.53347C181.446 10.1114 181.296 10.6794 181.011 11.1824C180.727 11.6855 180.317 12.1066 179.822 12.4047L176.181 14.6087C175.514 14.9819 175.222 15.8178 175.51 16.5253C175.868 17.2354 176.001 18.0373 175.893 18.8251C175.846 19.4137 175.68 19.9867 175.407 20.5102C175.134 21.0336 174.758 21.4968 174.302 21.8722C173.846 22.2476 173.32 22.5276 172.753 22.6955C172.187 22.8634 171.593 22.9159 171.006 22.8498C169.95 22.7181 169.186 23.5758 169.186 24.5747C169.041 25.7437 168.454 26.8128 167.545 27.5616C166.635 28.3105 165.473 28.6819 164.298 28.5994C163.641 28.524 163.008 28.3045 162.445 27.9567C161.882 27.6089 161.402 27.1413 161.04 26.5871C161.04 27.5631 161 28.447 160.521 29.3329C160.237 29.8569 159.853 30.3195 159.389 30.6938C158.926 31.0681 158.393 31.3468 157.821 31.5136C157.249 31.6805 156.649 31.7322 156.057 31.6659C154.888 31.5215 153.819 30.9342 153.07 30.0249C152.322 29.1157 151.707 27.3445 152.522 25.2622Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M152.033 29.6536C152.665 30.1799 153.187 30.8262 153.568 31.5554C153.95 32.2846 154.183 33.0821 154.254 33.9018C154.325 34.7215 154.233 35.5472 153.984 36.3312C153.734 37.1152 153.331 37.842 152.799 38.4696C151.706 39.7391 150.153 40.5228 148.482 40.6486C146.811 40.7744 145.159 40.2319 143.887 39.1404C142.629 38.0602 141.852 36.5246 141.726 34.8713C141.6 33.2179 142.137 31.5823 143.217 30.3243C144.297 29.0663 145.832 28.2888 147.486 28.1631C149.139 28.0373 150.775 28.5734 152.033 29.6536" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M154.428 35.1157C155.195 33.5825 153.342 29.9508 150.499 28.7912C148.583 27.8329 144.175 28.6953 143.312 30.3244C145.774 32.9313 150.891 34.7227 154.428 35.1157Z" fill="var(--cros-sys-illo-color1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M67.9927 30.5162C67.4391 30.53 67.007 30.002 67.1303 29.4621C67.4375 27.2955 68.5396 25.3205 70.2221 23.9214C71.9047 22.5222 74.0475 21.7987 76.2338 21.8918C78.4629 22.0005 80.5765 22.9158 82.1808 24.4672C83.7851 26.0186 84.7707 28.1003 84.954 30.3245C85.0106 30.8302 84.6004 31.2859 84.0916 31.2828L67.9927 30.5162Z" fill="var(--cros-sys-illo-color5)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M42.0133 45.8812L34.5388 49.2351C33.5326 49.7164 33.3753 51.132 34.2513 51.8225L40.9592 56.4221C41.8839 57.066 43.2048 56.4847 43.3549 55.368L44.1215 47.3186C44.2579 46.1845 43.0192 45.34 42.0133 45.8812Z" fill="var(--cros-sys-illo-color1-2)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M40.778 48.6273C40.2996 48.0539 39.9417 47.3901 39.7255 46.6754C39.5094 45.9606 39.4394 45.2096 39.5199 44.4673C39.6004 43.7249 39.8297 43.0064 40.194 42.3546C40.5584 41.7028 41.0503 41.1311 41.6405 40.6737L52.2772 32.2409C53.469 31.2605 54.9955 30.7823 56.5336 30.9075C58.0717 31.0327 59.5008 31.7515 60.5183 32.9117C61.0047 33.4853 61.3674 34.1532 61.5837 34.8735C61.8 35.5938 61.8652 36.351 61.7752 37.0977C61.6853 37.8443 61.4421 38.5644 61.0609 39.2127C60.6797 39.861 60.1688 40.4236 59.56 40.8653L48.9233 49.2981C47.7471 50.2726 46.2362 50.7481 44.7139 50.6227C43.1916 50.4973 41.7789 49.7811 40.778 48.6273" fill="var(--cros-sys-illo-color3)"/><path d="M40.5713 48.3637L42.407 47.573L42.1536 49.7896C42.6552 50.095 43.2013 50.3239 43.7739 50.4673L44.1318 47.2855V46.8064C44.0813 46.599 43.9852 46.4055 43.8505 46.24C43.7159 46.0744 43.546 45.9408 43.3533 45.8491C43.1607 45.7573 42.95 45.7096 42.7365 45.7095C42.5231 45.7093 42.3123 45.7566 42.1195 45.8481L39.7842 46.858C39.9679 47.3975 40.2335 47.9053 40.5713 48.3637Z" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M38.7656 67.7925L35.1242 61.3721C34.9016 60.9865 34.5798 60.6675 34.1922 60.4484C33.8046 60.2294 33.3653 60.1182 32.9202 60.1264H25.4457C25.0128 60.1261 24.5862 60.2305 24.2025 60.4307C23.8187 60.631 23.489 60.9211 23.2417 61.2763L19.4086 67.6967C19.1693 68.0681 19.042 68.5006 19.042 68.9425C19.042 69.3843 19.1693 69.8168 19.4086 70.1882L23.05 76.6086C23.2823 76.9564 23.5954 77.2427 23.9626 77.4429C24.3298 77.6432 24.74 77.7515 25.1582 77.7585H32.7285C33.17 77.7482 33.6022 77.6292 33.9867 77.4119C34.3711 77.1946 34.696 76.8857 34.9325 76.5127L38.7656 70.0923C38.9966 69.7355 39.1195 69.3196 39.1195 68.8945C39.1195 68.4695 38.9966 68.0535 38.7656 67.6967" fill="var(--cros-sys-illo-color2)"/><path d="M37.8563 102.728C37.4952 102.177 37.0786 101.664 36.6131 101.198L35.3699 99.6676C34.8004 98.98 34.3721 98.1868 34.1096 97.3335C33.847 96.4802 33.7553 95.5835 33.8397 94.6947L34.1266 92.3995V91.4431C34.1422 91.1844 34.1097 90.925 34.031 90.6781C33.9147 89.9294 33.6513 89.2112 33.256 88.5649C32.8608 87.9186 32.3414 87.357 31.7279 86.9124C31.1144 86.4679 30.419 86.1493 29.6817 85.9749C28.9445 85.8005 28.18 85.7738 27.4323 85.8964C25.9143 86.1325 24.5506 86.9579 23.6374 88.1933C22.7243 89.4288 22.3353 90.9746 22.5551 92.4951C22.5551 92.6864 22.6507 92.9733 22.6507 93.1646L23.0332 94.1209L23.9896 96.2248C24.3574 97.0334 24.5556 97.9088 24.5721 98.797C24.5885 99.6852 24.4228 100.567 24.0852 101.389L23.3201 103.302C23.0256 103.857 22.7699 104.432 22.5551 105.023C22.219 106.373 22.219 107.785 22.5551 109.135C23.0669 111.021 24.2333 112.663 25.8455 113.767C27.4576 114.871 29.4101 115.365 31.3533 115.16C32.4747 115.066 33.5654 114.746 34.5594 114.218C35.5533 113.691 36.43 112.967 37.1362 112.091C37.8425 111.215 38.3637 110.204 38.6682 109.121C38.9728 108.038 39.0545 106.904 38.9083 105.788C38.7742 104.706 38.4159 103.664 37.8563 102.728V102.728Z" stroke="var(--cros-sys-illo-color1-2)" stroke-width="1.6" stroke-linecap="round" stroke-linejoin="round"/><path fill-rule="evenodd" clip-rule="evenodd" d="M36.1783 133.625C34.5416 133.565 32.9337 133.177 31.4494 132.485C29.965 131.793 28.6343 130.81 27.5358 129.595C26.4372 128.381 25.593 126.958 25.053 125.412C24.513 123.866 24.2881 122.227 24.3916 120.593V120.401C24.6375 117.096 26.1709 114.019 28.6618 111.833C31.1528 109.647 34.4023 108.525 37.7115 108.71C39.3481 108.771 40.956 109.159 42.4404 109.851C43.9247 110.543 45.2554 111.526 46.354 112.74C47.4526 113.955 48.2967 115.377 48.8367 116.923C49.3767 118.47 49.6016 120.108 49.4982 121.743V121.934C49.2522 125.24 47.7189 128.316 45.2279 130.503C42.737 132.689 39.4874 133.81 36.1783 133.625Z" fill="var(--cros-sys-illo-color4)"/><path d="M39.585 108.925C39.0441 108.821 38.4957 108.752 37.9435 108.721C37.0703 111.497 34.4578 113.72 31.0994 114.077C29.516 114.245 28.1458 114.059 27.0013 113.6C26.7044 113.983 26.4304 114.383 26.1804 114.797C27.7192 115.519 29.4829 115.857 31.291 115.706C34.7854 115.415 38.3903 112.524 39.585 108.925Z" fill="var(--cros-sys-illo-base)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M122.422 36.1698L97.6031 41.2486C97.2861 41.3057 96.9593 41.2378 96.6913 41.0591C96.4233 40.8804 96.2349 40.6049 96.1657 40.2903L91.1827 15.2796C91.1256 14.9626 91.1935 14.6358 91.3722 14.3678C91.5509 14.0998 91.8264 13.9114 92.141 13.8422L116.96 8.76338C117.277 8.70629 117.604 8.77421 117.872 8.95288C118.14 9.13154 118.328 9.40704 118.397 9.72161L123.38 34.7324C123.438 35.0494 123.37 35.3762 123.191 35.6442C123.012 35.9122 122.737 36.1006 122.422 36.1698" fill="var(--cros-sys-illo-color1)"/><path d="M97.8105 35.1156L102.224 26.377L121.29 33.8799" stroke="var(--cros-sys-illo-base)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M111.752 14.1154C111.307 14.3889 110.953 14.8494 110.569 15.2032C110.037 15.6946 109.306 15.9554 108.583 15.9127C107.402 15.9127 106.244 15.7921 105.515 16.9287C105.182 17.4476 105.07 18.0774 105.201 18.6795C105.333 19.2815 105.699 19.8067 106.217 20.1393C107.031 20.6609 107.812 20.5201 108.63 20.1693L109.482 19.7436C110.113 19.4016 110.879 19.3319 111.563 19.5544C112.637 19.8903 113.598 20.2495 114.731 19.9328C115.479 19.6768 116.114 19.1688 116.529 18.4957C117.451 16.9975 117.021 14.9934 115.58 14.0098C115.204 13.7532 114.78 13.5758 114.333 13.4883C113.415 13.3083 112.483 13.5291 111.752 14.1154Z" stroke="var(--cros-sys-illo-base)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><circle cx="97.8106" cy="19.5801" r="2.75364" stroke="var(--cros-sys-illo-base)" stroke-width="1.5"/><path d="M142.732 36.353C142.732 36.353 143.823 36.8443 144.569 36.8487C145.332 36.8531 146.45 36.353 146.45 36.353" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><circle cx="148.15" cy="34.2726" r="6.12759" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5"/><path d="M134.968 51.9084C134.968 51.9084 134.68 53.5988 134.968 58.2795C135.256 62.9602 136.343 64.2421 136.684 65.0838C136.845 65.4804 136.854 66.1224 136.819 66.6905C136.781 67.3106 137.254 67.8726 137.875 67.8726H157.997" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><line x1="159.28" y1="59.2826" x2="158.202" y2="67.695" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round"/><line x1="158.045" y1="68.0168" x2="138.272" y2="72.0241" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round"/><path d="M91.1629 89.1838L68.6902 95.2054L52.1218 75.5854" stroke="var(--cros-sys-illo-color1)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><path d="M143.953 90.7429C138.582 93.1174 138.504 93.5421 132.288 95.5999C131.387 95.9621 130.423 96.1439 129.451 96.1347C128.48 96.0934 127.537 95.8901 127.13 95.0125" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M136.315 91.2656C132.592 92.9685 129.732 94.6203 126.066 95.0914C125.291 95.2434 124.486 95.1076 123.805 94.7098C123.105 94.2792 122.678 93.1531 123.38 92.4589" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M135.515 88.5316C134.166 89.1703 132.871 89.9163 131.468 90.4477C129.758 91.1215 127.989 91.6362 126.183 91.9852C125.49 92.125 124.788 92.2124 124.081 92.2467C123.219 92.2441 122.25 92.027 121.767 91.2757C121.604 90.9698 121.538 90.6219 121.577 90.2778C121.617 89.9338 121.76 89.6097 121.989 89.3482C123.178 88.0128 125.981 87.4855 128.568 87.3326" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M132.464 81.881C130.74 81.8223 127.668 81.8668 125.89 81.8615C125.028 81.8589 124.059 81.6953 123.738 80.9445C123.59 80.4893 123.697 79.9682 124.011 79.6063C124.348 79.2622 124.753 78.9901 125.199 78.8065C129.555 77.2276 134.846 76.3763 139.43 76.7065" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M133.65 81.4025C130.642 82.7378 127.4 83.4742 124.107 83.5701C123.292 83.5614 122.484 83.7232 121.735 84.045C121.033 84.4179 120.438 85.2731 120.705 86.0237C120.781 86.2689 120.912 86.4935 121.089 86.6799C121.266 86.8663 121.484 87.0093 121.726 87.0979C122.197 87.2498 122.686 87.3412 123.18 87.3701C127.759 87.7586 130.561 87.3921 134.716 85.4763" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M89.8261 77.9328C89.3593 79.5933 88.0517 81.6189 86.2805 82.4635C85.5754 82.7995 84.8016 83.1285 84.3382 83.7525C84.1399 84.005 84.0424 84.3242 84.0646 84.6485C84.142 85.1131 84.608 85.4563 85.0734 85.5577C85.5507 85.6041 86.031 85.5547 86.4866 85.4124C90.1254 84.4638 94.6359 83.2875 97.2845 80.3411C97.809 79.7502 98.3361 79.0037 98.5628 78.2211" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M89.4111 78.487C87.4971 78.9462 84.2803 78.6327 83.2772 79.8998C83.2772 79.8998 82.488 80.7214 82.6911 83.1436C82.7252 83.3674 82.7426 83.6001 82.76 83.8329C82.8666 85.5146 83.0077 86.9795 82.4516 88.3139C82.1228 89.1075 81.4288 90.186 80.596 90.0846C79.7631 89.9831 79.6817 89.1904 79.6214 88.2763C79.561 87.3623 78.9086 81.66 78.6348 79.6282C78.5251 78.7654 78.746 77.898 79.2521 77.2041C80.8661 75.1455 83.5824 74.2098 85.9622 73.4114C89.0903 72.3415 92.6929 71.201 96.1045 70.9816" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M78.7289 78.2785C76.8666 80.9994 75.1275 83.5878 73.8006 85.778C73.6002 86.1281 73.3755 86.5134 73.4589 86.9087C73.5423 87.304 73.9856 87.7255 74.3656 87.8289C74.7504 87.8965 75.1448 87.8452 75.4967 87.6816C76.3299 87.3426 76.9624 86.6714 77.5264 85.9932C78.103 85.2765 78.6255 84.5166 79.0895 83.7199" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M63.9053 127.662C63.9053 127.662 63.9802 128.137 64.5298 128.662C65.0794 129.186 65.4042 129.186 65.4042 129.186" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round"/><path d="M55.7583 150.423L57.3571 163.719L64.1736 169.526" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M58.5609 164.731H79.6141" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M83.0749 154.799C83.0749 154.799 82.087 156.721 80.8732 159.647C79.6593 162.573 79.6141 164.731 79.6141 164.731" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M82.3029 156.948C82.3029 156.948 81.4244 162.607 85.6001 167.746C89.7758 172.885 97.5381 173.865 97.5381 173.865" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M98.5638 173.069C98.5638 173.069 106.599 174.902 110.661 176.255C114.723 177.609 119.217 178.609 120.029 178.728C120.842 178.847 123.19 178.885 122.433 176.679C121.676 174.472 116.041 174.465 116.214 170.55C116.387 166.635 121.698 164.741 124.802 163.436C127.906 162.13 131.151 161.717 132.388 161.098C133.624 160.48 134.442 158.939 132.388 158.58C130.334 158.22 126.404 158.751 123.739 159.324C121.074 159.897 115.963 161.559 111.842 161.787C107.721 162.014 103.771 161.325 103.771 161.325" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M122.522 167.95C122.522 167.95 132.171 164.617 132.93 163.964C133.689 163.311 133.621 162.007 132.93 161.653C132.56 161.527 132.147 161.398 131.695 161.398" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M126.481 166.609C126.481 166.609 131.347 165.767 132.246 166.609C133.146 167.45 132.719 168.425 132.246 168.692C131.773 168.959 122.543 170.461 122.543 170.461" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><path d="M122.955 170.566C122.955 170.566 129.324 170.278 130.632 171.052C131.941 171.826 131.338 172.918 130.876 173.136C130.413 173.354 126.418 172.899 123.977 173.136C121.535 173.372 118.833 173.999 118.833 173.999" stroke="var(--cros-sys-illo-color1)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template.content);
