// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_checkbox/cr_checkbox.js";import"chrome://resources/ash/common/cr_elements/cr_radio_button/cr_radio_button.js";import"chrome://resources/ash/common/cr_elements/cr_radio_group/cr_radio_group.js";import"chrome://resources/ash/common/cr_elements/cr_shared_style.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./network_logs_ui.html.js";import{NetworkUiBrowserProxyImpl}from"./network_ui_browser_proxy.js";const NetworkLogsUiElementBase=I18nMixin(PolymerElement);class NetworkLogsUiElement extends NetworkLogsUiElementBase{constructor(){super(...arguments);this.browserProxy_=NetworkUiBrowserProxyImpl.getInstance()}static get is(){return"network-logs-ui"}static get template(){return getTemplate()}static get properties(){return{systemLogs_:{type:Boolean,value:true},filterPII_:{type:Boolean,value:true},debugLogs_:{type:Boolean,value:false},chromeLogs_:{type:Boolean,value:false},policies_:{type:Boolean,value:false},shillDebugging_:{type:String,value:"unknown"}}}static get observers(){return["onShillDebuggingChanged_(shillDebugging_)"]}validOptions_(){return this.systemLogs_||this.policies_||this.debugLogs_}onShillDebuggingChanged_(){const shillDebugging=this.shillDebugging_;if(!shillDebugging||shillDebugging==="unknown"){return}this.browserProxy_.setShillDebugging(shillDebugging).then((([_,isError])=>{if(isError){console.error("setShillDebugging: "+shillDebugging+" failed.")}}))}onStore_(){const options={systemLogs:this.systemLogs_,filterPII:this.filterPII_,debugLogs:this.debugLogs_,chromeLogs:this.chromeLogs_,policies:this.policies_};const storeResult=this.shadowRoot.querySelector("#storeResult");assert(storeResult);storeResult.innerText=this.i18n("networkLogsStatus");storeResult.classList.toggle("error",false);this.browserProxy_.storeLogs(options).then((([result,isError])=>{storeResult.innerText=result;storeResult.classList.toggle("error",isError)}))}}customElements.define(NetworkLogsUiElement.is,NetworkLogsUiElement);