// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/network_health/network_diagnostics.js";import"chrome://resources/ash/common/network_health/network_health_summary.js";import"chrome://resources/ash/common/traffic_counters/traffic_counters.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_input/cr_input.js";import"chrome://resources/ash/common/cr_elements/cr_tabs/cr_tabs.js";import"chrome://resources/ash/common/cr_elements/cr_toggle/cr_toggle.js";import"chrome://resources/polymer/v3_0/iron-pages/iron-pages.js";import"chrome://resources/ash/common/network/network_select.js";import"/strings.m.js";import"./network_state_ui.js";import"./network_logs_ui.js";import"./network_metrics_ui.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{OncMojo}from"chrome://resources/ash/common/network/onc_mojo.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{CrosNetworkConfig,StartConnectResult}from"chrome://resources/mojo/chromeos/services/network_config/public/mojom/cros_network_config.mojom-webui.js";import{flush,PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./network_ui.html.js";import{NetworkUiBrowserProxyImpl}from"./network_ui_browser_proxy.js";function stringifyJson(result){return JSON.stringify(result,null,"\t")}const NetworkUiElementBase=I18nMixin(PolymerElement);class NetworkUiElement extends NetworkUiElementBase{constructor(){super(...arguments);this.onHashChange_=()=>{this.selectTabFromHash_()};this.networkConfig_=CrosNetworkConfig.getRemote();this.browserProxy_=NetworkUiBrowserProxyImpl.getInstance()}static get is(){return"network-ui"}static get template(){return getTemplate()}static get properties(){return{tabNames_:{type:Array,computed:"computeTabNames_()"},selectedTab_:{type:Number,value:0},hostname_:{type:String,value:""},tetheringConfigToSet_:{type:String,value:""},isGuestModeActive_:{type:Boolean,value(){return loadTimeData.valueExists("isGuestModeActive")&&loadTimeData.getBoolean("isGuestModeActive")}},invalidJSON_:{type:Boolean,value:false},showNetworkSelect_:{type:Boolean,value:false}}}connectedCallback(){super.connectedCallback();this.shadowRoot.querySelector("#import-onc").value="";this.requestGlobalPolicy_();this.getTetheringCapabilities_();this.getTetheringConfig_();this.getTetheringStatus_();this.getWifiDirectCapabilities_();this.getWifiDirectClientInfo_();this.getWifiDirectOwnerInfo_();this.getHostname_();this.selectTabFromHash_();window.addEventListener("hashchange",this.onHashChange_)}disconnectedCallback(){super.disconnectedCallback();window.removeEventListener("hashchange",this.onHashChange_)}computeTabNames_(){return[this.i18n("generalTab"),this.i18n("networkHealthTab"),this.i18n("networkLogsTab"),this.i18n("networkStateTab"),this.i18n("networkSelectTab"),this.i18n("TrafficCountersTrafficCounters"),this.i18n("networkMetricsTab"),this.i18n("networkHotspotTab"),this.i18n("networkWifiDirectTab")]}selectTabFromHash_(){const selectedTab=window.location.hash.substring(1);if(!selectedTab){return}const tabpanels=this.shadowRoot.querySelectorAll("iron-pages .tabpanel");for(let idx=0;idx<tabpanels.length;++idx){if(tabpanels[idx].id===selectedTab){this.selectedTab_=idx}}}async openCellularActivationUi_(){const response=await this.browserProxy_.openCellularActivationUi();this.shadowRoot.querySelector("#cellular-error-text").hidden=response[0]}onResetEsimCacheClick_(){this.browserProxy_.resetEsimCache()}onDisableActiveEsimProfileClick_(){this.browserProxy_.disableActiveEsimProfile()}onResetEuiccClick_(){this.browserProxy_.resetEuicc()}onResetApnMigratorClick_(){this.browserProxy_.resetApnMigrator()}showAddNewWifi_(){this.browserProxy_.showAddNewWifi()}onImportOncChange_(event){const target=event.target;const file=target.files&&target.files.length>0?target.files[0]:null;event.stopPropagation();if(!file){return}const reader=new FileReader;reader.onloadend=_=>{const content=reader.result;if(!content||typeof content!=="string"){console.error("File not read"+file);return}this.browserProxy_.importOnc(content).then((response=>{this.importOncResponse_(response)}))};reader.readAsText(file)}importOncResponse_(args){const resultDiv=this.shadowRoot.querySelector("#onc-import-result");assert(resultDiv);resultDiv.innerText=args[0];resultDiv.classList.toggle("error",args[1]);this.shadowRoot.querySelector("#import-onc").value=""}async requestGlobalPolicy_(){const result=await this.networkConfig_.getGlobalPolicy();this.shadowRoot.querySelector("#global-policy").textContent=stringifyJson(result.result)}async getTetheringCapabilities_(){const result=await this.browserProxy_.getTetheringCapabilities();const div=this.shadowRoot.querySelector("#tethering-capabilities-div");if(div){div.textContent=stringifyJson(result)}}async getTetheringStatus_(){const result=await this.browserProxy_.getTetheringStatus();const div=this.shadowRoot.querySelector("#tethering-status-div");if(div){div.textContent=stringifyJson(result)}}async getTetheringConfig_(){const result=await this.browserProxy_.getTetheringConfig();const div=this.shadowRoot.querySelector("#tethering-config-div");if(div){div.textContent=stringifyJson(result)}}async setTetheringConfig_(){const result=await this.browserProxy_.setTetheringConfig(this.tetheringConfigToSet_);const success=result==="success";const resultDiv=this.shadowRoot.querySelector("#set-tethering-config-result");assert(resultDiv);resultDiv.innerText=result;resultDiv.classList.toggle("error",!success);if(success){this.getTetheringConfig_()}}async checkTetheringReadiness_(){const result=await this.browserProxy_.checkTetheringReadiness();const resultDiv=this.shadowRoot.querySelector("#check-tethering-readiness-result");assert(resultDiv);resultDiv.innerText=result;resultDiv.classList.toggle("error",result!=="ready")}validateJson_(){if(this.tetheringConfigToSet_===""){this.invalidJSON_=false;return}try{const parsed=JSON.parse(this.tetheringConfigToSet_);if(parsed.constructor==={}.constructor){this.invalidJSON_=false;return}this.invalidJSON_=true}catch(e){this.invalidJSON_=true}}async getWifiDirectCapabilities_(){const result=await this.browserProxy_.getWifiDirectCapabilities();const div=this.shadowRoot.querySelector("#wifi-direct-capabilities-div");if(div){div.textContent=stringifyJson(result)}}async getWifiDirectOwnerInfo_(){const result=await this.browserProxy_.getWifiDirectOwnerInfo();const div=this.shadowRoot.querySelector("#wifi-direct-owner-info-div");if(div){div.textContent=stringifyJson(result)}}async getWifiDirectClientInfo_(){const result=await this.browserProxy_.getWifiDirectClientInfo();const div=this.shadowRoot.querySelector("#wifi-direct-client-info-div");if(div){div.textContent=stringifyJson(result)}}onHostnameChanged_(_){this.browserProxy_.setHostname(this.hostname_)}getHostname_(){this.browserProxy_.getHostname().then((result=>this.hostname_=result))}onNetworkItemSelected_(event){const networkState=event.detail;if(OncMojo.connectionStateIsConnected(networkState.connectionState)){this.browserProxy_.showNetworkDetails(networkState.guid);return}if(networkState.connectable===false||networkState.errorState){this.browserProxy_.showNetworkConfig(networkState.guid);return}this.networkConfig_.startConnect(networkState.guid).then((response=>{if(response.result===StartConnectResult.kSuccess){return}console.error("startConnect error for: "+networkState.guid+" Result: "+response.result.toString()+" Message: "+response.message);this.browserProxy_.showNetworkConfig(networkState.guid)}))}getNetworkDiagnosticsElement_(){return this.shadowRoot.querySelector("#network-diagnostics")}renderNetworkSelect_(){this.showNetworkSelect_=true;flush();const select=this.shadowRoot.querySelector("network-select");assert(select);select.customItems=[{customItemName:"addWiFiListItemName",polymerIcon:"cr:add",customData:"WiFi"}]}onSendFeedbackReportClick_(_){chrome.send("OpenFeedbackDialog")}onRunAllRoutinesClick_(_){this.getNetworkDiagnosticsElement_().runAllRoutines()}onCustomItemSelected_(event){this.browserProxy_.addNetwork(event.detail.customData)}}customElements.define(NetworkUiElement.is,NetworkUiElement);