import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">cr-button,cr-checkbox{margin:5px 0}cr-radio-group{--cr-radio-group-item-padding:6px}.error{color:red}.indented{margin-inline-start:10px}#storeResult{margin:10px 0;white-space:pre-wrap}</style>
<div>
  <h2>$i18n{networkLogsTab}</h2>
  <p>$i18n{networkLogsDescription}</p>
  <span>$i18nRaw{deviceLogLinkText}</span>
  <h3>Options</h3>
  <div class="indented">
    <cr-checkbox checked="{{systemLogs_}}">
      $i18n{networkLogsSystemLogs}
    </cr-checkbox>
    <div class="indented">
      <cr-checkbox class="indented" checked="{{filterPII_}}"
          disabled="[[!systemLogs_]]">
        $i18n{networkLogsFilterPii}
      </cr-checkbox>
    </div>
    <cr-checkbox checked="{{policies_}}">
      $i18n{networkLogsPolicies}
    </cr-checkbox>
    <cr-checkbox checked="{{debugLogs_}}">
      $i18n{networkLogsDebugLogs}
    </cr-checkbox>
    <div class="indented">
      <cr-checkbox checked="{{chromeLogs_}}" class="indented"
          disabled="[[!debugLogs_]]">
        $i18n{networkLogsChromeLogs}
      </cr-checkbox>
    </div>
  </div>
  <cr-button on-click="onStore_"
      disabled="[[!validOptions_(systemLogs_, policies_, debugLogs_)]]">
    $i18n{networkLogsStoreButton}
  </cr-button>
  <div id="storeResult"></div>

  <h2>$i18n{networkLogsDebuggingTitle}</h2>
  <p>$i18n{networkLogsDebuggingDescription}</p>
  <cr-radio-group selected="{{shillDebugging_}}">
    <cr-radio-button name="unknown" disabled>
      $i18n{networkLogsDebuggingUnknown}
    </cr-radio-button>
    <cr-radio-button name="none">
      $i18n{networkLogsDebuggingNone}
    </cr-radio-button>
    <cr-radio-button name="wifi">
      $i18n{OncTypeWiFi}
    </cr-radio-button>
    <cr-radio-button name="cellular">
      $i18n{OncTypeCellular}
    </cr-radio-button>
    <cr-radio-button name="ethernet">
      $i18n{OncTypeEthernet}
    </cr-radio-button>
  </cr-radio-group>
</div>
<!--_html_template_end_-->`;
}
