import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->
<style include="cr-shared-style">div{margin:10px 0}.state-table{border-collapse:collapse;min-width:800px}.state-table tr td{border:1px solid rgb(220,220,220);font-size:13px}.state-table-header{font-weight:bold}.state-table-expand-button-cell{text-align:center}.state-table-expand-button{background-color:transparent;border:none;height:20px;margin:0;outline:none;padding:0;width:20px}.state-table-expanded-cell{min-width:400px;white-space:pre-wrap}.state-table-icon-cell{height:32px;width:32px}</style>

<div>$i18n{autoRefreshText}</div>

<div>
  <cr-button class="action-button" id="refresh"
      on-click="requestNetworks_">
    $i18n{networkRefreshText}
  </cr-button>
</div>

<div>
  <h2>$i18n{networkListsLabel}</h2>
  <div>$i18n{clickToExpandText}</div>
  <div>
    <span>$i18n{propertyFormatText}</span>
    <select id="get-property-format" on-change="requestNetworks_">
      <option value="normal">$i18n{normalFormatOption}</option>
      <option value="managed">$i18n{managedFormatOption}</option>
      <option value="state">$i18n{stateFormatOption}</option>
      <option value="shill">$i18n{shillFormatOption}</option>
    </select>
  </div>

  <h3>$i18n{devicesLabel}</h3>
  <table id="device-state-table" class="state-table">
    <tr class="state-table-header">
      <td></td>
      <td></td>
      <td>Type</td>
      <td>State</td>
    </tr>
  </table>

  <h3>$i18n{visibleNetworksLabel}</h3>
  <table id="network-state-table" class="state-table">
    <tr class="state-table-header">
      <td></td>
      <td></td>
      <td>GUID</td>
      <td>Name</td>
      <td>Type</td>
      <td>State</td>
      <td>Connect?</td>
      <td>Error</td>
      <td>Security</td>
      <td>Tech</td>
      <td>Activation</td>
      <td>Roam</td>
      <td>Frequency</td>
      <td>Strength</td>
    </tr>
  </table>

  <h3>$i18n{ethernetEapNetworkLabel}</h3>
  <table id="ethernet-eap-state-table" class="state-table">
    <tr class="state-table-header">
      <td></td>
      <td></td>
      <td>GUID</td>
      <td>Name</td>
      <td>Type</td>
      <td>ONC Source</td>
    </tr>
  </table>

  <h3>$i18n{favoriteNetworksLabel}</h3>
  <table id="favorite-state-table" class="state-table">
    <tr class="state-table-header">
      <td></td>
      <td></td>
      <td>GUID</td>
      <td>Name</td>
      <td>Type</td>
      <td>ONC Source</td>
    </tr>
  </table>
</div>
<!--_html_template_end_-->`;
}
