import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>.button-group>cr-button{margin-inline-start:10px}.tabpanel>div{margin-bottom:10px}#global-policy,#tethering-capabilities-div,#tethering-status-div,#tethering-config-div,#wifi-direct-capabilities-div,#wifi-direct-owner-info-div,#wifi-direct-client-info-div{white-space:pre-wrap}#select-div{display:flex;height:400px;width:500px}#onc-import-result{margin:10px 0}#tethering-config-input{margin-bottom:0;margin-top:10px}iron-pages{flex:1;position:relative}network-select{flex:1}.error{color:red}</style>

<cr-tabs selected="{{selectedTab_}}" tab-names="[[tabNames_]]">
</cr-tabs>
<iron-pages selected="[[selectedTab_]]">
  <div class="tabpanel" id="general">
    <h2>$i18n{titleText}</h2>
    <div>
      <h2>$i18n{globalPolicyLabel}</h2>
      <div id="global-policy"></div>
    </div>

    <div>
      <h2>$i18n{dhcpHostnameLabel}</h2>
      <cr-input id="hostnameInput" value="{{hostname_}}"
          on-change="onHostnameChanged_">
      </cr-input>
    </div>

    <div>
      <h2>$i18n{cellularActivationLabel}</h2>
      <cr-button class="action-button" id="cellular-activation-button"
          on-click="openCellularActivationUi_">
        $i18n{cellularActivationButtonText}
      </cr-button>
      <div id="cellular-error-text" class="error" hidden>
        $i18n{noCellularErrorText}
      </div>
    </div>

    <div>
      <h2>$i18n{resetESimCacheLabel}</h2>
      <cr-button class="action-button" on-click="onResetEsimCacheClick_">
        $i18n{resetESimCacheButtonText}
      </cr-button>
    </div>

    <div>
      <h2>$i18n{disableESimProfilesLabel}</h2>
      <cr-button class="action-button"
          on-click="onDisableActiveEsimProfileClick_">
        $i18n{disableActiveESimProfileButtonText}
      </cr-button>
    </div>

    <template is="dom-if" if="[[!isGuestModeActive_]]">
      <div>
        <h2>$i18n{resetEuiccLabel}</h2>
        <cr-button class="action-button"
            on-click="onResetEuiccClick_">
          $i18n{resetEuiccLabel}
        </cr-button>
      </div>
    </template>

    <div>
      <h2>$i18n{resetApnMigratorLabel}</h2>
      <cr-button class="action-button"
          on-click="onResetApnMigratorClick_">
        $i18n{resetApnMigratorLabel}
      </cr-button>
    </div>

    <div>
      <h2>$i18n{addNewWifiLabel}</h2>
      <cr-button class="action-button" id="add-new-wifi-button"
          on-click="showAddNewWifi_">
        $i18n{addNewWifiButtonText}
      </cr-button>
    </div>

    <div>
      <h2>$i18n{importOncButtonText}</h2>
      <input type="file" id="import-onc" on-change="onImportOncChange_">
      <div id="onc-import-result"></div>
    </div>
  </div>

  <div class="tabpanel" id="health">
    <h2>$i18n{networkHealthLabel}</h2>
    <network-health-summary></network-health-summary>
    <h2>$i18n{networkDiagnosticsLabel}</h2>
    <div class="button-group">
      <cr-button on-click="onRunAllRoutinesClick_">
        [[i18n('NetworkDiagnosticsRunAll')]]
      </cr-button>
      <cr-button on-click="onSendFeedbackReportClick_">
        [[i18n('NetworkDiagnosticsSendFeedback')]]
      </cr-button>
    </div>
    <network-diagnostics id="network-diagnostics"
        on-open-feedback-dialog="onOpenFeedbackDialog_">
    </network-diagnostics>
  </div>

  <div class="tabpanel" id="logs">
    <network-logs-ui></network-logs-ui>
  </div>

  <div class="tabpanel" id="state">
    <network-state-ui></network-state-ui>
  </div>

  <div class="tabpanel" id="select">
    <div>$i18n{renderNetworkSelectButtonDescription}</div>
    <cr-button class="action-button" on-click="renderNetworkSelect_">
      $i18n{renderNetworkSelectButtonText}
    </cr-button>
    <template is="dom-if" if="[[showNetworkSelect_]]">
      <div id="select-div">
        <network-select
            on-network-item-selected="onNetworkItemSelected_"
            on-custom-item-selected="onCustomItemSelected_">
        </network-select>
      </div>
    </template>
  </div>

  <div class="tabpanel" id="counters">
    <traffic-counters id="traffic-counters"></traffic-counters>
  </div>

  <div class="tabpanel" id="metrics">
    <network-metrics-ui></network-metrics-ui>
  </div>

  <div class="tabpanel" id="hotspot">
    <h2>$i18n{tetheringCapabilitiesLabel}</h2>
    <div id="tethering-capabilities-div"></div>
    <cr-button class="action-button" on-click="getTetheringCapabilities_">
      $i18n{refreshTetheringCapabilitiesButtonText}
    </cr-button>

    <h2>$i18n{tetheringStatusLabel}</h2>
    <div id="tethering-status-div"></div>
    <cr-button class="action-button" on-click="getTetheringStatus_">
      $i18n{refreshTetheringStatusButtonText}
    </cr-button>

    <h2>$i18n{tetheringConfigLabel}</h2>
    <div id="tethering-config-div"></div>
    <cr-button class="action-button" on-click="getTetheringConfig_">
      $i18n{refreshTetheringConfigButtonText}
    </cr-button>
    <cr-input id="tethering-config-input" value="{{tetheringConfigToSet_}}"
        placeholder='Example: {"ssid": "test_ssid",
"passphrase": "test_password", "auto_disable": true, "security": "wpa2",
"band": "5GHz"}'
        type="text" on-input="validateJson_"
        error-message="Please enter valid JSON object"
        invalid="[[invalidJSON_]]">
    </cr-input>
    <cr-button class="action-button" on-click="setTetheringConfig_"
        disabled="[[invalidJSON_]]">
      $i18n{setTetheringConfigButtonText}
    </cr-button>
    <div id="set-tethering-config-result"></div>

    <h2>$i18n{tetheringReadinessLabel}</h2>
    <div id="check-tethering-readiness-result">Unknown</div>
    <cr-button class="action-button" on-click="checkTetheringReadiness_">
      $i18n{checkTetheringReadinessButtonText}
    </cr-button>
  </div>

  <div class="tabpanel" id="wifi-direct">
    <h2>$i18n{wifiDirectCapabilitiesLabel}</h2>
    <div id="wifi-direct-capabilities-div"></div>
    <cr-button class="action-button" on-click="getWifiDirectCapabilities_">
      $i18n{refreshWifiDirectCapabilitiesButtonText}
    </cr-button>

    <h2>$i18n{wifiDirectOwnerInfoLabel}</h2>
    <div id="wifi-direct-owner-info-div"></div>
    <cr-button class="action-button" on-click="getWifiDirectOwnerInfo_">
      $i18n{refreshWifiDirectOwnerInfoButtonText}
    </cr-button>

    <h2>$i18n{wifiDirectClientInfoLabel}</h2>
    <div id="wifi-direct-client-info-div"></div>
    <cr-button class="action-button" on-click="getWifiDirectClientInfo_">
      $i18n{refreshWifiDirectClientInfoButtonText}
    </cr-button>
  </div>

</iron-pages>
<!--_html_template_end_-->`;
}
