// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_shared_vars.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getParentAccessParams}from"../parent_access_ui_handler.js";import{getBase64EncodedSrcForPng}from"../utils.js";import{getTemplate}from"./local_web_approvals_after.html.js";const LocalWebApprovalsAfterBase=I18nMixin(PolymerElement);export class LocalWebApprovalsAfter extends LocalWebApprovalsAfterBase{static get is(){return"local-web-approvals-after"}static get template(){return getTemplate()}static get properties(){return{childName:{type:String},url:{type:String},favicon:{type:String}}}ready(){super.ready();this.configureWithParams()}async configureWithParams(){const response=await getParentAccessParams();const params=response.params.flowTypeParams.webApprovalsParams;if(params){this.renderDetails(params)}else{console.error("Failed to fetch web approvals params.")}}renderDetails(params){this.childName=params.childDisplayName;this.url=params.url.url;this.favicon=getBase64EncodedSrcForPng(params.faviconPngBytes)}}customElements.define(LocalWebApprovalsAfter.is,LocalWebApprovalsAfter);