// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./parent_access_template.js";import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{ParentAccessEvent}from"./parent_access_app.js";import{ParentAccessController}from"./parent_access_controller.js";import{getTemplate}from"./parent_access_ui.html.js";import{GetOauthTokenStatus,ParentAccessServerMessageType}from"./parent_access_ui.mojom-webui.js";import{getParentAccessUiHandler}from"./parent_access_ui_handler.js";import{WebviewManager}from"./webview_manager.js";const ALLOWED_HOSTS=["googleapis.com","gstatic.com","googleusercontent.com","google.com"];const LOCAL_DEV_SERVER_HOST="localhost:9879";export class ParentAccessUi extends PolymerElement{static get is(){return"parent-access-ui"}static get template(){return getTemplate()}static get properties(){return{webviewLoading:{type:Boolean,value:true}}}constructor(){super();this.parentAccessUiHandler=getParentAccessUiHandler()}ready(){super.ready();this.shadowRoot.querySelector("webview").addEventListener("contentload",(()=>{this.webviewLoading=false}));this.configureUi().then((()=>{}),(()=>{this.showErrorPage()}))}isAllowedRequest(url){const requestUrl=new URL(url);if(requestUrl.host===LOCAL_DEV_SERVER_HOST){return true}const requestIsHttps=requestUrl.protocol==="https:";const requestIsInAllowedHosts=ALLOWED_HOSTS.some((allowedHost=>requestUrl.host===allowedHost||requestUrl.host.endsWith(allowedHost)));return requestIsHttps&&requestIsInAllowedHosts}shouldReceiveAuthHeader(url){const requestUrl=new URL(url);const webviewUrl=new URL(this.webviewUrl);return requestUrl.host===webviewUrl.host}async configureUi(){this.webviewUrl=(await this.parentAccessUiHandler.getParentAccessUrl()).url;try{const parsedWebviewUrl=new URL(this.webviewUrl);const eventOriginFilter=parsedWebviewUrl.origin;const oauthFetchResult=await this.parentAccessUiHandler.getOauthToken();if(oauthFetchResult.status!==GetOauthTokenStatus.kSuccess){throw new Error("OAuth token was not successfully fetched.")}const webview=this.$.webview;const accessToken=oauthFetchResult.oauthToken;this.webviewManager=new WebviewManager(webview);this.webviewManager.setAccessToken(accessToken,(url=>this.shouldReceiveAuthHeader(url)));this.webviewManager.setAllowRequestFn((url=>this.isAllowedRequest(url)));const url=new URL(this.webviewUrl);webview.src=url.toString();webview.addEventListener("loadabort",(()=>{this.webviewLoading=false;this.showErrorPage()}));this.server=new ParentAccessController(webview,url.toString(),eventOriginFilter)}catch(e){this.showErrorPage();return}let lastServerMessageType=ParentAccessServerMessageType.kIgnore;while(lastServerMessageType===ParentAccessServerMessageType.kIgnore){const parentAccessCallback=await Promise.race([this.server.whenParentAccessCallbackReceived(),this.server.whenInitializationError()]);const parentAccessServerMessage=await this.parentAccessUiHandler.onParentAccessCallbackReceived(parentAccessCallback);if(!(parentAccessServerMessage instanceof Object)){console.error("Error initializing ParentAccessController");this.showErrorPage();break}lastServerMessageType=parentAccessServerMessage.message.type;switch(lastServerMessageType){case ParentAccessServerMessageType.kParentVerified:this.dispatchEvent(new CustomEvent(ParentAccessEvent.SHOW_AFTER,{bubbles:true,composed:true}));break;case ParentAccessServerMessageType.kIgnore:continue;case ParentAccessServerMessageType.kError:default:this.showErrorPage();break}}}showErrorPage(){this.dispatchEvent(new CustomEvent(ParentAccessEvent.SHOW_ERROR,{bubbles:true,composed:true}))}}customElements.define(ParentAccessUi.is,ParentAccessUi);