import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cros-color-overrides">#action-button,#action-button-jelly{margin-inline-start:8px}#disabled-screen{box-sizing:border-box;display:flex;flex-direction:column;height:100%;justify-content:flex-start;padding:26px 24px 20px}#disabled-screen-buttons,#disabled-screen-buttons-jelly{display:flex;flex-direction:row-reverse;margin-top:auto;width:100%}#illustration{height:96px;width:96px}:host-context(body.jelly-enabled) #disabled-screen-buttons{display:none}:host-context(body:not(.jelly-enabled)) #disabled-screen-buttons-jelly{display:none}</style>

<parent-access-template>
  <span slot="main">
    <div id="disabled-screen">
      <picture>
        <source srcset="images/request_approval_dark.svg"
            media="(prefers-color-scheme: dark)">
        <img src="images/request_approval.svg" id="illustration" alt="">
      </picture>
      <div id="disabled-screen-content"></div>
      <div id="disabled-screen-buttons">
        <cr-button class="action-button" id="action-button"
          on-click="onDisabledScreenClosed">
          $i18n{okButtonText}
        </cr-button>
      </div>
      <div id="disabled-screen-buttons-jelly">
        <cros-button
          button-style="primary"
          label="$i18n{okButtonText}"
          id="action-button-jelly"
          on-click="onDisabledScreenClosed">
        </cros-button>
      </div>
    </div>
  </span>
</parent-access-template>
<!--_html_template_end_-->`;
}
