import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style>
  ::part(dialog) {
    /* The HTML dialog should fill the entire system dialog. */
    height: 100%;
    width: 100%;
  }

  [slot='title'] {
    color: black;
    font-family: Roboto, sans-serif;
    font-size: 15px;
    padding: 24px 24px 16px;
  }

  [slot='body'] {
    color: var(--google-grey-900);
    font-family: Roboto, sans-serif;
    font-size: 13px;
    padding: 0 48px 0 24px;
  }

  [slot='button-container'] {
    bottom: 0;
    box-sizing: border-box;
    margin: 0;
    padding: 16px;
    position: fixed;
    width: 100%;
  }

  #prompt {
    margin-bottom: 20px;
  }

  cr-input[type='password'] {
    font-size: 20px;
  }

  paper-spinner-lite {
    height: 44px;
    left: 50%;
    margin: -22px;
    position: fixed;
    top: 50%;
    width: 44px;
  }
</style>

<paper-spinner-lite active></paper-spinner-lite>

<cr-dialog id="dialog" exportparts="dialog">
  <div slot="title">[[i18n('title')]]</div>

  <div slot="body" spellcheck="false">
    <div id="prompt">[[promptString_]]</div>

    <div hidden="[[!showOldPasswordPrompt_]]">
      <cr-input type="password" value="{{oldPassword_}}"
          label="[[i18n('oldPassword')]]"
          invalid="[[invalidOldPassword_(currentValidationError_)]]"
          error-message="[[errorString_]]">
      </cr-input>
    </div>

    <div hidden="[[!showNewPasswordPrompt_]]">
      <cr-input type="password" value="{{newPassword_}}"
          label="[[i18n('newPassword')]]"
          invalid="[[invalidNewPassword_(currentValidationError_)]]"
          error-message="[[errorString_]]">
      </cr-input>
      <cr-input type="password" value="{{confirmNewPassword_}}"
          label="[[i18n('confirmNewPassword')]]"
          invalid="[[invalidConfirmNewPassword_(currentValidationError_)]]"
          error-message="[[errorString_]]">
      </cr-input>
    </div>
  </div>

  <div slot="button-container">
    <cr-button class="action-button" on-click="onSaveTap_">
      [[i18n('save')]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}