import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->      <style>
        ::part(dialog) {
          /* The HTML dialog should fill the entire system dialog. */
          height: 100%;
          width: 100%;
        }

        [slot='title'] {
          color: var(--google-grey-900);
          font-family: Google Sans, sans-serif;
          font-size: 28px;
          padding: 64px 64px 8px;
        }

        #title-icon {
          --iron-icon-fill-color: var(--google-grey-900);
          height: 32px;
          padding-bottom: 24px;
          width: 32px;
        }

        [slot='body'] {
          color: var(--google-grey-900);
          font-family: Roboto, sans-serif;
          font-size: 13px;
          padding: 0 64px;
        }

        [slot='button-container'] {
          bottom: 0;
          box-sizing: border-box;
          margin: 0;
          padding: 32px;
          position: fixed;
          width: 100%;
        }
      </style>

      <cr-dialog id="dialog" exportparts="dialog">
        <div slot="title">
          <div><iron-icon id="title-icon" icon="cr:domain"></iron-icon></div>
          <div>[[title_]]</div>
        </div>

        <div slot="body">[[i18n('body')]]</div>

        <div slot="button-container">
          <cr-button class="action-button" on-click="onButtonTap_">
            [[i18n('button')]]
          </cr-button>
        </div>
      </cr-dialog>
<!--_html_template_end_-->`;
}