// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/ash/common/cr_elements/cr_page_host_style.css.js";import"chrome://resources/ash/common/cr_elements/md_select.css.js";import"chrome://resources/ash/common/cr_elements/cr_shared_style.css.js";import{WebUiListenerMixin}from"chrome://resources/ash/common/cr_elements/web_ui_listener_mixin.js";import{assert,assertInstanceof}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{SetTimeBrowserProxyImpl}from"./set_time_browser_proxy.js";import{getTemplate}from"./set_time_dialog.html.js";function getTimezoneItems(){const currentTimezoneId=loadTimeData.getString("currentTimezoneId");const timezoneList=loadTimeData.getValue("timezoneList");return timezoneList.map((tz=>({id:tz[0],name:tz[1],selected:tz[0]===currentTimezoneId})))}function dateToHtmlValues(date){const localDate=new Date(date);localDate.setMinutes(date.getMinutes()-date.getTimezoneOffset());return{date:localDate.toISOString().slice(0,10),time:localDate.toISOString().slice(11,16)}}function getMinDate(){let minDate=new Date(loadTimeData.getValue("buildTime"));minDate.setDate(minDate.getDate()-1);const now=new Date;if(now<minDate){minDate=now}return dateToHtmlValues(minDate).date}function getMaxDate(){let maxDate=new Date(loadTimeData.getValue("buildTime"));maxDate.setFullYear(maxDate.getFullYear()+20);const now=new Date;if(now>maxDate){maxDate=now}return dateToHtmlValues(maxDate).date}function getDateInTimezone(timezoneId){return new Date((new Date).toLocaleString("en-US",{timeZone:timezoneId}).replace(" "," "))}function getTimezoneDelta(firstTimezoneId,secondTimezoneId){return getDateInTimezone(firstTimezoneId).getTime()-getDateInTimezone(secondTimezoneId).getTime()}const SetTimeDialogBase=WebUiListenerMixin(PolymerElement);class SetTimeDialogElement extends SetTimeDialogBase{constructor(){super(...arguments);this.browserProxy_=SetTimeBrowserProxyImpl.getInstance();this.prevValues_={dateInput:"",timeInput:""};this.timeTimeoutId_=null}static get is(){return"set-time-dialog"}static get template(){return getTemplate()}static get properties(){return{timezoneItems_:{type:Array,readOnly:true,value:getTimezoneItems},isTimezoneVisible_:{type:Boolean,readOnly:true,value(){return loadTimeData.getBoolean("showTimezone")}},minDate_:{type:String,readOnly:true,value:getMinDate},maxDate_:{type:String,readOnly:true,value:getMaxDate},selectedTimezone_:{type:String,value(){return loadTimeData.getString("currentTimezoneId")}}}}connectedCallback(){super.connectedCallback();this.addWebUiListener("system-clock-updated",this.updateTime_.bind(this,new Date));this.addWebUiListener("system-timezone-changed",this.setTimezone_.bind(this));this.addWebUiListener("validation-complete",this.saveAndClose_.bind(this));this.browserProxy_.sendPageReady();this.$.dialog.showModal()}ready(){super.ready();this.updateTime_(new Date)}getInputTime_(){const date=this.$.dateInput.valueAsDate;assert(date);date.setMilliseconds(this.$.timeInput.valueAsNumber);date.setSeconds(date.getSeconds()+(new Date).getSeconds());date.setMinutes(date.getMinutes()+date.getTimezoneOffset());return date}getInputTimeSinceEpoch_(){const now=this.getInputTime_();if(this.isTimezoneVisible_){const timezoneDelta=getTimezoneDelta(loadTimeData.getString("currentTimezoneId"),this.selectedTimezone_);now.setMilliseconds(now.getMilliseconds()+timezoneDelta)}return Math.floor(now.getTime()/1e3)}setTimezone_(timezoneId){if(this.isTimezoneVisible_){const timezoneSelect=this.shadowRoot.querySelector("#timezoneSelect");assert(timezoneSelect);assert(timezoneSelect.childElementCount>0);timezoneSelect.value=timezoneId}const now=this.getInputTime_();const timezoneDelta=getTimezoneDelta(timezoneId,this.selectedTimezone_);now.setMilliseconds(now.getMilliseconds()+timezoneDelta);this.selectedTimezone_=timezoneId;this.updateTime_(now)}updateTime_(newTime){if(document.activeElement.id!=="dateInput"&&document.activeElement.id!=="timeInput"){const htmlValues=dateToHtmlValues(newTime);this.prevValues_.dateInput=this.$.dateInput.value=htmlValues.date;this.prevValues_.timeInput=this.$.timeInput.value=htmlValues.time}if(this.timeTimeoutId_){window.clearTimeout(this.timeTimeoutId_)}const secondsRemaining=60-newTime.getSeconds();const nextTime=new Date(newTime.setSeconds(newTime.getSeconds()+secondsRemaining));this.timeTimeoutId_=window.setTimeout(this.updateTime_.bind(this,nextTime),secondsRemaining*1e3)}applyTime_(){this.browserProxy_.setTimeInSeconds(this.getInputTimeSinceEpoch_())}onInputBlur_(e){const inputEl=e.target;assertInstanceof(inputEl,HTMLInputElement);const valueKey=inputEl.type==="date"?"dateInput":"timeInput";if(inputEl.value&&inputEl.validity.valid){this.prevValues_[valueKey]=inputEl.value}else{inputEl.value=this.prevValues_[valueKey]}this.updateTime_(this.getInputTime_())}onTimezoneChange_(e){const selectEl=e.currentTarget;assertInstanceof(selectEl,HTMLSelectElement);this.setTimezone_(selectEl.value)}onDoneClick_(){this.browserProxy_.doneClicked(this.getInputTimeSinceEpoch_())}saveAndClose_(){this.applyTime_();if(this.isTimezoneVisible_){this.browserProxy_.setTimezone(this.selectedTimezone_)}this.browserProxy_.dialogClose()}}customElements.define(SetTimeDialogElement.is,SetTimeDialogElement);