// chrome/browser/ui/webui/ash/skyvault/local_files_migration.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const CloudProviderSpec = { $: mojo.internal.Enum() };
export var CloudProvider;
(function (CloudProvider) {
    CloudProvider[CloudProvider["MIN_VALUE"] = 0] = "MIN_VALUE";
    CloudProvider[CloudProvider["MAX_VALUE"] = 2] = "MAX_VALUE";
    CloudProvider[CloudProvider["kGoogleDrive"] = 0] = "kGoogleDrive";
    CloudProvider[CloudProvider["kOneDrive"] = 1] = "kOneDrive";
    CloudProvider[CloudProvider["kDelete"] = 2] = "kDelete";
})(CloudProvider || (CloudProvider = {}));
export const TimeUnitSpec = { $: mojo.internal.Enum() };
export var TimeUnit;
(function (TimeUnit) {
    TimeUnit[TimeUnit["MIN_VALUE"] = 0] = "MIN_VALUE";
    TimeUnit[TimeUnit["MAX_VALUE"] = 1] = "MAX_VALUE";
    TimeUnit[TimeUnit["kMinutes"] = 0] = "kMinutes";
    TimeUnit[TimeUnit["kHours"] = 1] = "kHours";
})(TimeUnit || (TimeUnit = {}));
export class PageHandlerFactoryPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'policy.local_user_files.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "policy.local_user_files.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'policy.local_user_files.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getInitialDialogInfo() {
        return this.proxy.sendMessage(0, PageHandler_GetInitialDialogInfo_ParamsSpec.$, PageHandler_GetInitialDialogInfo_ResponseParamsSpec.$, [], false);
    }
    uploadOrDeleteNow() {
        this.proxy.sendMessage(1, PageHandler_UploadOrDeleteNow_ParamsSpec.$, null, [], false);
    }
    close() {
        this.proxy.sendMessage(2, PageHandler_Close_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_GetInitialDialogInfo_ParamsSpec.$, PageHandler_GetInitialDialogInfo_ResponseParamsSpec.$, impl.getInitialDialogInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_UploadOrDeleteNow_ParamsSpec.$, null, impl.uploadOrDeleteNow.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_Close_ParamsSpec.$, null, impl.close.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "policy.local_user_files.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getInitialDialogInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_GetInitialDialogInfo_ParamsSpec.$, PageHandler_GetInitialDialogInfo_ResponseParamsSpec.$, this.getInitialDialogInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.uploadOrDeleteNow =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_UploadOrDeleteNow_ParamsSpec.$, null, this.uploadOrDeleteNow.createReceiverHandler(false /* expectsResponse */), false);
        this.close =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_Close_ParamsSpec.$, null, this.close.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'policy.local_user_files.mojom.Page', scope);
    }
}
export class PageRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    updateRemainingTime(remainingTime) {
        this.proxy.sendMessage(0, Page_UpdateRemainingTime_ParamsSpec.$, null, [
            remainingTime
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_UpdateRemainingTime_ParamsSpec.$, null, impl.updateRemainingTime.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "policy.local_user_files.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.updateRemainingTime =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_UpdateRemainingTime_ParamsSpec.$, null, this.updateRemainingTime.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TimeUnitAndValueSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_GetInitialDialogInfo_ParamsSpec = { $: {} };
export const PageHandler_GetInitialDialogInfo_ResponseParamsSpec = { $: {} };
export const PageHandler_UploadOrDeleteNow_ParamsSpec = { $: {} };
export const PageHandler_Close_ParamsSpec = { $: {} };
export const Page_UpdateRemainingTime_ParamsSpec = { $: {} };
mojo.internal.Struct(TimeUnitAndValueSpec.$, 'TimeUnitAndValue', [
    mojo.internal.StructField('unit', 0, 0, TimeUnitSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('value', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetInitialDialogInfo_ParamsSpec.$, 'PageHandler_GetInitialDialogInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetInitialDialogInfo_ResponseParamsSpec.$, 'PageHandler_GetInitialDialogInfo_ResponseParams', [
    mojo.internal.StructField('cloudProvider', 0, 0, CloudProviderSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('remainingTime', 8, 0, TimeUnitAndValueSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('startDateAndTime', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandler_UploadOrDeleteNow_ParamsSpec.$, 'PageHandler_UploadOrDeleteNow_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_Close_ParamsSpec.$, 'PageHandler_Close_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_UpdateRemainingTime_ParamsSpec.$, 'Page_UpdateRemainingTime_Params', [
    mojo.internal.StructField('remainingTime', 0, 0, TimeUnitAndValueSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
