// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { html } from '//resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    // clang-format off
    return html `
<cr-toolbar id="toolbar" page-name="Color Pipeline" autofocus
    clear-label="Clear Search"
    search-prompt="Search Colors"
    @search-changed="${this.onSearchChanged_}"
    role="banner"
    @narrow-changed="${this.onNarrowChanged_}"
    narrow-threshold="780">
</cr-toolbar>
<div id="container">
  <div id="left" ?hidden="${this.narrow_}">
    <div role="navigation">
      <h2>Navigation</h2>
      <cr-menu-selector id="menu" selectable="a" attr-for-selected="href"
          @iron-activate="${this.onSelectorActivate_}"
          @click="${this.onLinkClick_}"
          selected-attribute="selected">
        ${this.sections_.map(section => html `
          <a role="menuitem" href="#${section.title}" class="cr-nav-menu-item">
            ${section.title}
          </a>
        `)}
      </cr-menu-selector>
    </div>
  </div>
  <div id="main">
    <div id="content">
      <h2>Color Pipeline Debug Page</h2>
      <p>
        This page displays the base colors generated by the color pipeline from
        the current theme, according to the "Foundations / Color" section of the
        core Chrome UX specification. Generally, you will not use these colors
        directly; instead, create color IDs or variables and mix them from these
        values.
      </p>
      <p>
        Mouse over a color to see RGBA values and usage information.
      </p>
      ${this.sections_.map(section => html `
        <div class="section" id="${section.title}">
          <a name="${section.title}"></a>
          <h2>${section.title}</h2>
          ${section.entries.map(entry => html `
            <div class="entry"
                ?hidden="${!this.entryFilter_(entry)}"
                style="${this.getEntryStyle_(entry)}"
                @mouseenter="${this.updateColorInfo_}"
                @mouseleave="${this.clearColorInfo_}">
                <p>${this.getEntryName_(entry)}</p>
            </div>
          `)}
        </div>
      `)}
    </div>
  </div>
  <div id="right" ?hidden="${this.narrow_}">
    <h2>Color Info</h2>
    <div id="colorInfo" ?hidden="${!this.currentColor_}"
    <p>R: ${this.red_}</p>
    <p>G: ${this.green_}</p>
    <p>B: ${this.blue_}</p>
    <p>A: ${this.alpha_}</p>
    <p>In //resources/cr_elements/cr_shared_vars.css.js:</p>
    <p class="varName">${this.cssName_}</p>
    <p>In //ui/color/color_id.h:</p>
    <p class="varName">${this.cppName_}</p>
  </div>
</div>`;
    // clang-format on
}
