// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js";import"chrome://resources/cr_elements/icons.html.js";import{assert}from"chrome://resources/js/assert.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./horizontal_carousel.css.js";import{getHtml}from"./horizontal_carousel.html.js";import{$$}from"./utils.js";export class HorizontalCarouselElement extends CrLitElement{static get is(){return"horizontal-carousel"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{canScroll_:{type:Boolean,reflect:true},showBackButton_:{type:Boolean},showForwardButton:{type:Boolean,reflect:true}}}#showForwardButton_accessor_storage=false;get showForwardButton(){return this.#showForwardButton_accessor_storage}set showForwardButton(value){this.#showForwardButton_accessor_storage=value}#canScroll__accessor_storage=false;get canScroll_(){return this.#canScroll__accessor_storage}set canScroll_(value){this.#canScroll__accessor_storage=value}#showBackButton__accessor_storage=false;get showBackButton_(){return this.#showBackButton__accessor_storage}set showBackButton_(value){this.#showBackButton__accessor_storage=value}intersectionObserver_=null;resizeObserver_=null;scrolledToEnd_=false;scrolledToStart_=false;connectedCallback(){super.connectedCallback();this.intersectionObserver_=this.createIntersectionObserver_();this.resizeObserver_=this.createResizeObserver_()}disconnectedCallback(){super.disconnectedCallback();if(this.intersectionObserver_){this.intersectionObserver_.disconnect();this.intersectionObserver_=null}if(this.resizeObserver_){this.resizeObserver_.disconnect();this.resizeObserver_=null}}onCarouselBackClick_(){this.$.carouselContainer.scrollBy({left:-1*this.columnOffsetWidth_})}onCarouselForwardClick_(){this.$.carouselContainer.scrollBy({left:this.columnOffsetWidth_})}createIntersectionObserver_(){const observer=new IntersectionObserver((entries=>{let tmpCanScroll=false;entries.forEach((entry=>{const{target:target,intersectionRatio:intersectionRatio}=entry;if(target===this.$.startProbe){tmpCanScroll=intersectionRatio===0||!this.scrolledToEnd_;this.scrolledToStart_=intersectionRatio!==0}else if(target===this.$.endProbe){tmpCanScroll=intersectionRatio===0||!this.scrolledToStart_;this.scrolledToEnd_=intersectionRatio!==0}}));this.canScroll_=tmpCanScroll;this.showBackButton_=tmpCanScroll&&!this.scrolledToStart_;this.showForwardButton=tmpCanScroll&&!this.scrolledToEnd_;this.dispatchEvent(new CustomEvent("intersection-observed",{bubbles:true,composed:true}))}),{root:this.$.carouselContainer});observer.observe(this.$.startProbe);observer.observe(this.$.endProbe);return observer}createResizeObserver_(){const observer=new ResizeObserver((()=>{const carouselHeight=this.$.carouselContainer.getBoundingClientRect().height;const carouselOffset=this.$.carouselContainer.getBoundingClientRect().top;if(carouselHeight>window.innerHeight-carouselOffset){this.$.backButtonContainer.attributeStyleMap.delete("top");this.$.forwardButtonContainer.attributeStyleMap.delete("top");return}const buttonTopPx=carouselOffset+carouselHeight*.44;this.$.backButtonContainer.style.top=`${buttonTopPx}px`;this.$.forwardButtonContainer.style.top=`${buttonTopPx}px`}));observer.observe(this.$.carouselContainer);return observer}get columnOffsetWidth_(){if(this.$.slottedTable.assignedElements().length===0){return 0}const tableElement=this.$.slottedTable.assignedElements()[0];assert(tableElement);const column=$$(tableElement,".col");return column?column.offsetWidth:0}}customElements.define(HorizontalCarouselElement.is,HorizontalCarouselElement);