// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { assert } from 'chrome://resources/js/assert.js';
export function getAbbreviatedUrl(urlString) {
    const url = new URL(urlString);
    // Chrome URLs should all have been filtered out.
    assert(url.protocol !== 'chrome:');
    let abbreviatedUrl = url.host;
    // We intentionally only check the start of the host for "www." as that string
    // can appear in other parts of the name.
    if (abbreviatedUrl.startsWith('www.')) {
        abbreviatedUrl = abbreviatedUrl.substring(4);
    }
    return abbreviatedUrl;
}
export function $$(element, selector) {
    return element.shadowRoot.querySelector(selector);
}
/**
 * @param uuid The UUID to validate.
 * @returns Whether the UUID is a valid lowercase UUID.
 */
export function isValidLowercaseUuid(uuid) {
    if (uuid.length !== 36) {
        return false;
    }
    for (let i = 0; i < uuid.length; i++) {
        const char = uuid.charAt(i);
        // Check for hyphens.
        if (i === 8 || i === 13 || i === 18 || i === 23) {
            if (char !== '-') {
                return false;
            }
            continue;
        }
        // Check that all other characters are lowercase hex digits.
        if ((char < '0' || char > '9') && (char < 'a' || char > 'f')) {
            return false;
        }
    }
    return true;
}
