// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_input/cr_input.js";import"chrome://resources/cr_elements/icons.html.js";import"chrome://resources/cr_elements/cr_icon/cr_icon.js";import{assert,assertNotReached}from"chrome://resources/js/assert.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./database_tab.css.js";import{getHtml}from"./database_tab.html.js";import{boolToString,durationToString,getOrCreateSiteDataProvider,secondsToString}from"./discards.js";import{SortedTableMixinLit}from"./sorted_table_mixin_lit.js";function compareRowsByOrigin(a,b){return a.origin.localeCompare(b.origin)}function compareRowsByIsDirty(a,b){return(a.isDirty?1:0)-(b.isDirty?1:0)}function compareRowsByLastLoaded(a,b){return a.value.lastLoaded-b.value.lastLoaded}function compareRowsByCpuUsage(a,b){const keyA=a.value.loadTimeEstimates?a.value.loadTimeEstimates.avgCpuUsageUs:0;const keyB=b.value.loadTimeEstimates?b.value.loadTimeEstimates.avgCpuUsageUs:0;return keyA-keyB}function compareRowsByMemoryUsage(a,b){const keyA=a.value.loadTimeEstimates?a.value.loadTimeEstimates.avgFootprintKb:0;const keyB=b.value.loadTimeEstimates?b.value.loadTimeEstimates.avgFootprintKb:0;return keyA-keyB}function compareRowsByLoadDuration(a,b){const keyA=a.value.loadTimeEstimates?a.value.loadTimeEstimates.avgLoadDurationUs:0;const keyB=b.value.loadTimeEstimates?b.value.loadTimeEstimates.avgLoadDurationUs:0;return keyA-keyB}function getSortFunctionForKey(sortKey){switch(sortKey){case"origin":return compareRowsByOrigin;case"dirty":return compareRowsByIsDirty;case"lastLoaded":return compareRowsByLastLoaded;case"cpuUsage":return compareRowsByCpuUsage;case"memoryUsage":return compareRowsByMemoryUsage;case"loadDuration":return compareRowsByLoadDuration;default:assertNotReached("Unknown sortKey: "+sortKey)}}function microsecondsToString(time){if(time<1e3){return time.toString()+" µs"}time/=1e3;if(time<1e3){return time.toFixed(2)+" ms"}time/=1e3;return time.toFixed(2)+" s"}function kilobytesToString(value){if(value<1e3){return value.toString()+" KB"}value/=1e3;if(value<1e3){return value.toFixed(1)+" MB"}value/=1e3;return value.toFixed(1)+" GB"}function formatLoadTimeEstimate(item,propertyName){if(!item.value||!item.value.loadTimeEstimates){return"N/A"}const value=item.value.loadTimeEstimates[propertyName];assert(value);if(propertyName.endsWith("Us")){return microsecondsToString(value)}else if(propertyName.endsWith("Kb")){return kilobytesToString(value)}return value.toString()}const DatabaseTabElementBase=SortedTableMixinLit(CrLitElement);export class DatabaseTabElement extends DatabaseTabElementBase{static get is(){return"database-tab"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{rows_:{type:Array},size_:{type:Object},newOrigin_:{type:String}}}#rows__accessor_storage=null;get rows_(){return this.#rows__accessor_storage}set rows_(value){this.#rows__accessor_storage=value}#size__accessor_storage={numRows:-1n,onDiskSizeKb:-1n};get size_(){return this.#size__accessor_storage}set size_(value){this.#size__accessor_storage=value}#newOrigin__accessor_storage="";get newOrigin_(){return this.#newOrigin__accessor_storage}set newOrigin_(value){this.#newOrigin__accessor_storage=value}updateTableTimer_=0;updateSizesTimer_=0;requestedOrigins_={};siteDataProvider_=null;sortKey="origin";connectedCallback(){super.connectedCallback();this.requestedOrigins_={};this.siteDataProvider_=getOrCreateSiteDataProvider();const UPDATE_INTERVAL_MS=1e3;this.updateDbRows_();this.updateDbSizes_();this.updateTableTimer_=setInterval(this.updateDbRows_.bind(this),UPDATE_INTERVAL_MS);this.updateSizesTimer_=setInterval(this.updateDbSizes_.bind(this),UPDATE_INTERVAL_MS*30)}disconnectedCallback(){super.disconnectedCallback();clearInterval(this.updateTableTimer_);this.updateTableTimer_=0;clearInterval(this.updateSizesTimer_);this.updateSizesTimer_=0}updateDbRows_(){this.siteDataProvider_.getSiteDataArray(Object.keys(this.requestedOrigins_)).then((response=>{if(!response.result){return}const dbRows=response.result.dbRows;for(const dbRow of dbRows){this.requestedOrigins_[dbRow.origin]=true}this.rows_=dbRows}))}addNewOrigin_(){this.requestedOrigins_[this.newOrigin_]=true;this.newOrigin_="";this.updateDbRows_()}async onAddOriginClick_(){this.addNewOrigin_();await this.updateComplete;this.$.addOriginInput.focus()}onOriginKeydown_(e){if(e.key==="Enter"&&this.isValidOrigin_(this.newOrigin_)){this.addNewOrigin_();e.stopPropagation()}}updateDbSizes_(){this.siteDataProvider_.getSiteDataDatabaseSize().then((response=>{if(!response.dbSize){return}this.size_=response.dbSize}))}computeSortFunction_(sortKey,sortReverse){const sortFunction=getSortFunctionForKey(sortKey);return(a,b)=>{const comp=sortFunction(a,b);return sortReverse?-comp:comp}}getSortedRows_(){if(!this.rows_){return[]}const sortFunction=this.computeSortFunction_(this.sortKey,this.sortReverse);return this.rows_.sort(sortFunction)}isValidOrigin_(origin){const re=/(https?|ftp):\/\/[a-z+.]/;return re.test(origin)}isEmptyOrValidOrigin_(origin){return!origin||this.isValidOrigin_(origin)}boolToString_(value){return boolToString(value)}lastUseToString_(time){const nowSecondsFromEpoch=Math.round(Date.now()/1e3);return durationToString(nowSecondsFromEpoch-time)}featureToString_(feature){if(!feature){return"N/A"}if(feature.useTimestamp){const nowSecondsFromEpoch=Math.round(Date.now()/1e3);return"Used "+durationToString(Number(BigInt(nowSecondsFromEpoch)-feature.useTimestamp))}if(feature.observationDuration){return"Observed without use for "+secondsToString(Number(feature.observationDuration))}return"N/A"}getLoadTimeEstimate_(item,propertyName){return formatLoadTimeEstimate(item,propertyName)}kilobytesToString_(value){return value===-1?"N/A":kilobytesToString(value)}optionalIntegerToString_(value){return value===-1?"N/A":value.toString()}onNewOriginChanged_(e){this.newOrigin_=e.detail.value}}customElements.define(DatabaseTabElement.is,DatabaseTabElement);