// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"/strings.m.js";import"./feedback_shared_styles.css.js";import"./js/jelly_colors.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{OpenWindowProxyImpl}from"chrome://resources/js/open_window_proxy.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./app.css.js";import{getHtml}from"./app.html.js";import{FeedbackBrowserProxyImpl}from"./js/feedback_browser_proxy.js";import{BT_DEVICE_REGEX,BT_REGEX,CANNOT_CONNECT_REGEX,CELLULAR_REGEX,DISPLAY_REGEX,FAST_PAIR_REGEX,NEARBY_SHARE_REGEX,SMART_LOCK_REGEX,TETHER_REGEX,THUNDERBOLT_REGEX,USB_REGEX,WIFI_REGEX}from"./js/feedback_regexes.js";import{FEEDBACK_LANDING_PAGE,FEEDBACK_LANDING_PAGE_TECHSTOP,FEEDBACK_LEGAL_HELP_URL,FEEDBACK_PRIVACY_POLICY_URL,FEEDBACK_TERM_OF_SERVICE_URL,openUrlInAppWindow}from"./js/feedback_util.js";import{domainQuestions,questionnaireBegin,questionnaireNotification}from"./js/questionnaire.js";import{takeScreenshot}from"./js/take_screenshot.js";const MAX_ATTACH_FILE_SIZE=3*1024*1024;const MAX_SCREENSHOT_WIDTH=100;export class AppElement extends CrLitElement{static get is(){return"feedback-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}formOpenTime=(new Date).getTime();attachedFileBlob=null;appendedQuestions={};feedbackInfo={attachedFile:undefined,attachedFileBlobUuid:undefined,autofillMetadata:"",categoryTag:undefined,description:"...",descriptionPlaceholder:undefined,email:undefined,flow:chrome.feedbackPrivate.FeedbackFlow.REGULAR,fromAutofill:false,includeBluetoothLogs:false,pageUrl:undefined,sendHistograms:undefined,systemInformation:[],useSystemWindowFrame:false,isOffensiveOrUnsafe:undefined,aiMetadata:undefined};async connectedCallback(){super.connectedCallback();const dialogArgs=FeedbackBrowserProxyImpl.getInstance().getDialogArguments();if(dialogArgs){this.feedbackInfo=JSON.parse(dialogArgs)}await this.applyData(this.feedbackInfo);this.getRequiredElement("#attach-file").addEventListener("change",(e=>this.onFileSelected(e)));this.getRequiredElement("#attach-file").addEventListener("click",this.onOpenFileDialog.bind(this));this.getRequiredElement("#send-report-button").onclick=this.sendReport.bind(this);this.getRequiredElement("#cancel-button").onclick=e=>this.cancel(e);this.getRequiredElement("#remove-attached-file").onclick=this.clearAttachedFile.bind(this);this.dispatchEvent(new CustomEvent("ready-for-testing"))}applyData(feedbackInfo){if(feedbackInfo.includeBluetoothLogs){assert(feedbackInfo.flow===chrome.feedbackPrivate.FeedbackFlow.GOOGLE_INTERNAL);this.getRequiredElement("#description-text").addEventListener("input",(e=>this.checkForSendBluetoothLogs(e)))}if(feedbackInfo.showQuestionnaire){assert(feedbackInfo.flow===chrome.feedbackPrivate.FeedbackFlow.GOOGLE_INTERNAL);this.getRequiredElement("#description-text").addEventListener("input",(e=>this.checkForShowQuestionnaire(e)))}if(this.shadowRoot.querySelector("#autofill-checkbox-container")!=null&&feedbackInfo.flow===chrome.feedbackPrivate.FeedbackFlow.GOOGLE_INTERNAL&&feedbackInfo.fromAutofill){this.getRequiredElement("#autofill-checkbox-container").hidden=false}this.getRequiredElement("#description-text").textContent=feedbackInfo.description;if(feedbackInfo.descriptionPlaceholder){this.getRequiredElement("#description-text").placeholder=feedbackInfo.descriptionPlaceholder}if(feedbackInfo.pageUrl){this.getRequiredElement("#page-url-text").value=feedbackInfo.pageUrl}const isAiFlow=feedbackInfo.flow===chrome.feedbackPrivate.FeedbackFlow.AI;if(isAiFlow){this.getRequiredElement("#free-form-text").textContent=loadTimeData.getString("freeFormTextAi");this.getRequiredElement("#offensive-container").hidden=false;this.getRequiredElement("#log-id-container").hidden=false}const isSeaPenFlow=isAiFlow&&feedbackInfo.aiMetadata?.includes("from_sea_pen");if(isSeaPenFlow){this.getRequiredElement("#log-id-container").hidden=true;this.getRequiredElement("#screenshot-container").hidden=true;this.getRequiredElement("#sys-info-container").hidden=true}const whenScreenshotUpdated=takeScreenshot().then((screenshotCanvas=>{window.requestAnimationFrame(this.resizeAppWindow.bind(this));FeedbackBrowserProxyImpl.getInstance().showDialog();if(!screenshotCanvas){const checkbox=this.getRequiredElement("#screenshot-checkbox");checkbox.disabled=true;checkbox.checked=false;return Promise.resolve()}return new Promise((resolve=>{screenshotCanvas.toBlob((blob=>{const image=this.getRequiredElement("#screenshot-image");image.src=URL.createObjectURL(blob);image.alt="screenshot";image.classList.toggle("wide-screen",image.width>MAX_SCREENSHOT_WIDTH);feedbackInfo.screenshot=blob;resolve()}))}))}));const whenEmailUpdated=isAiFlow?Promise.resolve():FeedbackBrowserProxyImpl.getInstance().getUserEmail().then((email=>{if(!email){return}const optionElement=document.createElement("option");optionElement.value=email;optionElement.text=email;optionElement.selected=true;this.getRequiredElement("#user-email-drop-down").insertBefore(optionElement,this.getRequiredElement("#anonymous-user-option"));this.getRequiredElement("#user-email").hidden=false;this.getRequiredElement("#consent-container").hidden=false}));if(feedbackInfo.attachedFile){this.getRequiredElement("#attached-filename-text").textContent=feedbackInfo.attachedFile.name;this.attachedFileBlob=feedbackInfo.attachedFile.data;this.getRequiredElement("#custom-file-container").hidden=false;this.getRequiredElement("#attach-file").hidden=true}if(feedbackInfo.flow===chrome.feedbackPrivate.FeedbackFlow.LOGIN){this.getRequiredElement("#page-url").hidden=true;this.getRequiredElement("#attach-file-container").hidden=true;this.getRequiredElement("#attach-file-note").hidden=true}const autofillMetadataUrlElement=this.shadowRoot.querySelector("#autofill-metadata-url");if(autofillMetadataUrlElement){autofillMetadataUrlElement.onclick=e=>{e.preventDefault();FeedbackBrowserProxyImpl.getInstance().showAutofillMetadataInfo(feedbackInfo.autofillMetadata)};autofillMetadataUrlElement.onauxclick=e=>{e.preventDefault()}}const sysInfoUrlElement=this.shadowRoot.querySelector("#sys-info-url");if(sysInfoUrlElement){sysInfoUrlElement.onclick=e=>{e.preventDefault();FeedbackBrowserProxyImpl.getInstance().showSystemInfo()};sysInfoUrlElement.onauxclick=e=>{e.preventDefault()}}const histogramUrlElement=this.shadowRoot.querySelector("#histograms-url");if(histogramUrlElement){histogramUrlElement.onclick=e=>{e.preventDefault();FeedbackBrowserProxyImpl.getInstance().showMetrics()};histogramUrlElement.onauxclick=e=>{e.preventDefault()}}if(feedbackInfo.flow!==chrome.feedbackPrivate.FeedbackFlow.LOGIN){const legalHelpPageUrlElement=this.shadowRoot.querySelector("#legal-help-page-url");if(legalHelpPageUrlElement){this.setupLinkHandlers(legalHelpPageUrlElement,FEEDBACK_LEGAL_HELP_URL,false)}const privacyPolicyUrlElement=this.shadowRoot.querySelector("#privacy-policy-url");if(privacyPolicyUrlElement){this.setupLinkHandlers(privacyPolicyUrlElement,FEEDBACK_PRIVACY_POLICY_URL,false)}const termsOfServiceUrlElement=this.shadowRoot.querySelector("#terms-of-service-url");if(termsOfServiceUrlElement){this.setupLinkHandlers(termsOfServiceUrlElement,FEEDBACK_TERM_OF_SERVICE_URL,false)}}this.getRequiredElement("#description-text").focus();return Promise.all([whenScreenshotUpdated,whenEmailUpdated]).then((()=>{}))}async sendFeedbackReport(useSystemInfo){const ID=Math.round(Date.now()/1e3);const FLOW=this.feedbackInfo.flow;const result=await FeedbackBrowserProxyImpl.getInstance().sendFeedback(this.feedbackInfo,useSystemInfo,this.formOpenTime);if(result.status===chrome.feedbackPrivate.Status.SUCCESS){if(FLOW!==chrome.feedbackPrivate.FeedbackFlow.LOGIN&&result.landingPageType!==chrome.feedbackPrivate.LandingPageType.NO_LANDING_PAGE){const landingPage=result.landingPageType===chrome.feedbackPrivate.LandingPageType.NORMAL?FEEDBACK_LANDING_PAGE:FEEDBACK_LANDING_PAGE_TECHSTOP;OpenWindowProxyImpl.getInstance().openUrl(landingPage)}}else{console.warn("Feedback: Report for request with ID "+ID+" will be sent later.")}this.scheduleWindowClose()}onFileSelected(fileSelectedEvent){FeedbackBrowserProxyImpl.getInstance().showDialog();const file=fileSelectedEvent.target.files[0];if(!file){this.attachedFileBlob=null;return}if(file.size>MAX_ATTACH_FILE_SIZE){this.getRequiredElement("#attach-error").hidden=false;this.getRequiredElement("#attach-file").value="";this.attachedFileBlob=null;return}this.attachedFileBlob=file.slice()}onOpenFileDialog(){this.getRequiredElement("#attach-error").hidden=true}clearAttachedFile(){this.getRequiredElement("#custom-file-container").hidden=true;this.attachedFileBlob=null;this.feedbackInfo.attachedFile=undefined;this.getRequiredElement("#attach-file").hidden=false}setupLinkHandlers(anchorElement,url,useAppWindow){anchorElement.onclick=e=>{e.preventDefault();if(useAppWindow){openUrlInAppWindow(url)}else{window.open(url,"_blank")}};anchorElement.onauxclick=e=>{e.preventDefault()}}checkForSendBluetoothLogs(inputEvent){const value=inputEvent.target.value;const isRelatedToBluetooth=BT_REGEX.test(value)||CANNOT_CONNECT_REGEX.test(value)||TETHER_REGEX.test(value)||SMART_LOCK_REGEX.test(value)||NEARBY_SHARE_REGEX.test(value)||FAST_PAIR_REGEX.test(value)||BT_DEVICE_REGEX.test(value);this.getRequiredElement("#bluetooth-checkbox-container").hidden=!isRelatedToBluetooth}checkForShowQuestionnaire(inputEvent){const toAppend=[];const value=inputEvent.target.value;const questionnaireBeginPos=value.indexOf(questionnaireBegin);const matchedText=questionnaireBeginPos>=0?value.substring(0,questionnaireBeginPos):value;if(BT_REGEX.test(matchedText)){toAppend.push(...domainQuestions["bluetooth"])}if(WIFI_REGEX.test(matchedText)){toAppend.push(...domainQuestions["wifi"])}if(CELLULAR_REGEX.test(matchedText)){toAppend.push(...domainQuestions["cellular"])}if(DISPLAY_REGEX.test(matchedText)){toAppend.push(...domainQuestions["display"])}if(THUNDERBOLT_REGEX.test(matchedText)){toAppend.push(...domainQuestions["thunderbolt"])}else if(USB_REGEX.test(matchedText)){toAppend.push(...domainQuestions["usb"])}if(toAppend.length===0){return}const textarea=this.getRequiredElement("#description-text");const savedCursor=textarea.selectionStart;if(Object.keys(this.appendedQuestions).length===0){textarea.value+="\n\n"+questionnaireBegin+"\n";this.getRequiredElement("#questionnaire-notification").textContent=questionnaireNotification}for(const question of toAppend){if(question in this.appendedQuestions){continue}textarea.value+="* "+question+" \n";this.appendedQuestions[question]=true}textarea.selectionEnd=savedCursor}updateDescription(wasValid){this.getRequiredElement("#description-empty-error").hidden=wasValid;const description=this.getRequiredElement("#description-text");description.setAttribute("aria-labelledby",(wasValid?"":"description-empty-error ")+"free-form-text");description.setAttribute("aria-invalid",String(!wasValid));if(!wasValid){description.focus()}this.resizeAppWindow()}sendReport(){const textarea=this.getRequiredElement("#description-text");if(textarea.value.length===0){this.updateDescription(false);return false}this.updateDescription(true);this.getRequiredElement("#send-report-button").disabled=true;if(!this.feedbackInfo.attachedFile&&this.attachedFileBlob){this.feedbackInfo.attachedFile={name:this.getRequiredElement("#attach-file").value,data:this.attachedFileBlob}}const consentCheckboxValue=this.getRequiredElement("#consent-checkbox").checked;this.feedbackInfo.systemInformation=[{key:"feedbackUserCtlConsent",value:String(consentCheckboxValue)}];const isAiFlow=this.feedbackInfo.flow===chrome.feedbackPrivate.FeedbackFlow.AI;const isSeaPenFlow=isAiFlow&&this.feedbackInfo.aiMetadata?.includes("from_sea_pen");if(isAiFlow){this.feedbackInfo.isOffensiveOrUnsafe=this.getRequiredElement("#offensive-checkbox").checked;if(isSeaPenFlow||!this.getRequiredElement("#log-id-checkbox").checked){this.feedbackInfo.aiMetadata=undefined}}this.feedbackInfo.description=textarea.value;this.feedbackInfo.pageUrl=this.getRequiredElement("#page-url-text").value;this.feedbackInfo.email=this.getRequiredElement("#user-email-drop-down").value;let useSystemInfo=false;let useHistograms=false;const checkbox=this.shadowRoot.querySelector("#sys-info-checkbox");if(checkbox!=null&&checkbox.checked&&!isSeaPenFlow){useHistograms=true;useSystemInfo=true}const autofillCheckbox=this.shadowRoot.querySelector("#autofill-metadata-checkbox");if(autofillCheckbox!=null&&autofillCheckbox.checked&&!this.getRequiredElement("#autofill-checkbox-container").hidden){this.feedbackInfo.sendAutofillMetadata=true}this.feedbackInfo.sendHistograms=useHistograms;if(this.getRequiredElement("#screenshot-checkbox").checked){this.feedbackInfo.sendTabTitles=true}else{this.feedbackInfo.screenshot=undefined}let productId=parseInt(""+this.feedbackInfo.productId,10);if(isNaN(productId)){productId=undefined}this.feedbackInfo.productId=productId;this.sendFeedbackReport(useSystemInfo);return true}cancel(e){e.preventDefault();this.scheduleWindowClose()}resizeAppWindow(){}scheduleWindowClose(){setTimeout((()=>FeedbackBrowserProxyImpl.getInstance().closeDialog()),100)}getRequiredElement(query){const el=this.shadowRoot.querySelector(query);assert(el);assert(el instanceof HTMLElement);return el}}customElements.define(AppElement.is,AppElement);