// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{skColorToHexColor,skColorToRgba}from"//resources/js/color_utils.js";import{loadTimeData}from"//resources/js/load_time_data.js";export function getFallbackTheme(){return{primary:{value:loadTimeData.getInteger("colorFallbackPrimary")},shaderLayer1:{value:loadTimeData.getInteger("colorFallbackShaderLayer1")},shaderLayer2:{value:loadTimeData.getInteger("colorFallbackShaderLayer2")},shaderLayer3:{value:loadTimeData.getInteger("colorFallbackShaderLayer3")},shaderLayer4:{value:loadTimeData.getInteger("colorFallbackShaderLayer4")},shaderLayer5:{value:loadTimeData.getInteger("colorFallbackShaderLayer5")},scrim:{value:loadTimeData.getInteger("colorFallbackScrim")},surfaceContainerHighestLight:{value:loadTimeData.getInteger("colorFallbackSurfaceContainerHighestLight")},surfaceContainerHighestDark:{value:loadTimeData.getInteger("colorFallbackSurfaceContainerHighestDark")},selectionElement:{value:loadTimeData.getInteger("colorFallbackSelectionElement")}}}export function skColorToRgbaWithCustomAlpha(skColor,alpha){const r=skColor.value>>16&255;const g=skColor.value>>8&255;const b=skColor.value&255;return`rgba(${r}, ${g}, ${b}, ${alpha.toFixed(2)})`}export function getShaderLayerColorHexes(theme){return[skColorToHexColor(theme.shaderLayer1),skColorToHexColor(theme.shaderLayer2),skColorToHexColor(theme.shaderLayer3),skColorToHexColor(theme.shaderLayer4),skColorToHexColor(theme.shaderLayer5)]}export function getShaderLayerColorRgbas(theme){return[skColorToRgba(theme.shaderLayer1),skColorToRgba(theme.shaderLayer2),skColorToRgba(theme.shaderLayer3),skColorToRgba(theme.shaderLayer4),skColorToRgba(theme.shaderLayer5)]}export const GLIF_HEX_COLORS={blue:"#3186ff",red:"#ff4641",yellow:"#ffd314",green:"#34a853"};export function modifyRgbaTransparency(rgba,alpha){const colorsString=rgba.substring(5,rgba.length-1);const[red,green,blue]=colorsString.split(",");return`rgba(${red}, ${green}, ${blue}, ${alpha})`}