// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const INITIAL_ANGULAR_POSITION_MULTIPLIER=1e3;const BASE_WAVE_AMPLITUDE_FACTOR=.53;const BASE_WAVE_FREQUENCY_FACTOR=1;const FIRST_OVERTONE_WAVE_AMPLITUDE_FACTOR=.25;const FIRST_OVERTONE_WAVE_FREQUENCY_FACTOR=2;const SECOND_OVERTONE_WAVE_AMPLITUDE_FACTOR=.12;const SECOND_OVERTONE_WAVE_FREQUENCY_FACTOR=3;function createWaveParam(amplitude,frequency){return{amplitude:amplitude,frequency:frequency}}function frequencyToAngularFrequency(frequency){return 2*Math.PI*frequency}export class Wiggle{waveParams=[createWaveParam(BASE_WAVE_AMPLITUDE_FACTOR*(.5+Math.random()),BASE_WAVE_FREQUENCY_FACTOR*(.5+Math.random())),createWaveParam(FIRST_OVERTONE_WAVE_AMPLITUDE_FACTOR*(.5+Math.random()),FIRST_OVERTONE_WAVE_FREQUENCY_FACTOR*(.5+Math.random())),createWaveParam(SECOND_OVERTONE_WAVE_AMPLITUDE_FACTOR*(.5+Math.random()),SECOND_OVERTONE_WAVE_FREQUENCY_FACTOR*(.5+Math.random()))];angularFrequency;angularPosition;previousTimeSeconds;previousWiggleValue;constructor(frequency){this.angularFrequency=frequencyToAngularFrequency(frequency);this.angularPosition=Math.random()*INITIAL_ANGULAR_POSITION_MULTIPLIER;this.previousWiggleValue=this.calculateNext(0)}getPreviousWiggleValue(){return this.previousWiggleValue}setFrequency(frequency){this.angularFrequency=frequencyToAngularFrequency(frequency)}calculateNext(timeSeconds){if(!this.previousTimeSeconds){this.previousTimeSeconds=timeSeconds}this.angularPosition+=(timeSeconds-this.previousTimeSeconds)*this.angularFrequency;this.previousTimeSeconds=timeSeconds;let wiggle=0;for(const{amplitude:amplitude,frequency:frequency}of this.waveParams){wiggle+=amplitude*Math.sin(frequency*this.angularPosition)}this.previousWiggleValue=wiggle;return wiggle}}