// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { getCss } from './action_chips.css.js';
import { getHtml } from './action_chips.html.js';
/**
 * The element for displaying Action Chips.
 */
export class ActionChipsElement extends CrLitElement {
    static get is() {
        return 'ntp-action-chips';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {};
    }
}
customElements.define(ActionChipsElement.is, ActionChipsElement);
