// services/on_device_model/public/mojom/on_device_model.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { FileSpec as mojoBase_mojom_FileSpec } from '//resources/mojo/mojo/public/mojom/base/file.mojom-webui.js';
import { FilePathSpec as mojoBase_mojom_FilePathSpec } from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import { BitmapWithArbitraryBppSpec as skia_mojom_BitmapWithArbitraryBppSpec } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
export const TokenSpec = { $: mojo.internal.Enum() };
export var Token;
(function (Token) {
    Token[Token["MIN_VALUE"] = 0] = "MIN_VALUE";
    Token[Token["MAX_VALUE"] = 3] = "MAX_VALUE";
    Token[Token["kSystem"] = 0] = "kSystem";
    Token[Token["kModel"] = 1] = "kModel";
    Token[Token["kUser"] = 2] = "kUser";
    Token[Token["kEnd"] = 3] = "kEnd";
})(Token || (Token = {}));
export const PrioritySpec = { $: mojo.internal.Enum() };
export var Priority;
(function (Priority) {
    Priority[Priority["MIN_VALUE"] = 0] = "MIN_VALUE";
    Priority[Priority["MAX_VALUE"] = 1] = "MAX_VALUE";
    Priority[Priority["kForeground"] = 0] = "kForeground";
    Priority[Priority["kBackground"] = 1] = "kBackground";
})(Priority || (Priority = {}));
export const PerformanceClassSpec = { $: mojo.internal.Enum() };
export var PerformanceClass;
(function (PerformanceClass) {
    PerformanceClass[PerformanceClass["MIN_VALUE"] = 0] = "MIN_VALUE";
    PerformanceClass[PerformanceClass["MAX_VALUE"] = 7] = "MAX_VALUE";
    PerformanceClass[PerformanceClass["kError"] = 0] = "kError";
    PerformanceClass[PerformanceClass["kGpuBlocked"] = 1] = "kGpuBlocked";
    PerformanceClass[PerformanceClass["kFailedToLoadLibrary"] = 2] = "kFailedToLoadLibrary";
    PerformanceClass[PerformanceClass["kVeryLow"] = 3] = "kVeryLow";
    PerformanceClass[PerformanceClass["kLow"] = 4] = "kLow";
    PerformanceClass[PerformanceClass["kMedium"] = 5] = "kMedium";
    PerformanceClass[PerformanceClass["kHigh"] = 6] = "kHigh";
    PerformanceClass[PerformanceClass["kVeryHigh"] = 7] = "kVeryHigh";
})(PerformanceClass || (PerformanceClass = {}));
export const LoadModelResultSpec = { $: mojo.internal.Enum() };
export var LoadModelResult;
(function (LoadModelResult) {
    LoadModelResult[LoadModelResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    LoadModelResult[LoadModelResult["MAX_VALUE"] = 3] = "MAX_VALUE";
    LoadModelResult[LoadModelResult["kSuccess"] = 0] = "kSuccess";
    LoadModelResult[LoadModelResult["kGpuBlocked"] = 1] = "kGpuBlocked";
    LoadModelResult[LoadModelResult["kFailedToLoadLibrary"] = 2] = "kFailedToLoadLibrary";
    LoadModelResult[LoadModelResult["kCrosNeedReboot"] = 3] = "kCrosNeedReboot";
})(LoadModelResult || (LoadModelResult = {}));
export class StreamingResponderPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.StreamingResponder', scope);
    }
}
export class StreamingResponderRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(StreamingResponderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onResponse(chunk) {
        this.proxy.sendMessage(0, StreamingResponder_OnResponse_ParamsSpec.$, null, [
            chunk
        ], false);
    }
    onComplete(summary) {
        this.proxy.sendMessage(1, StreamingResponder_OnComplete_ParamsSpec.$, null, [
            summary
        ], false);
    }
}
;
/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StreamingResponderReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StreamingResponderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, StreamingResponder_OnResponse_ParamsSpec.$, null, impl.onResponse.bind(impl), false);
        this.helper_internal_.registerHandler(1, StreamingResponder_OnComplete_ParamsSpec.$, null, impl.onComplete.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class StreamingResponder {
    static get $interfaceName() {
        return "on_device_model.mojom.StreamingResponder";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new StreamingResponderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the StreamingResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StreamingResponderCallbackRouter {
    helper_internal_;
    $;
    router_;
    onResponse;
    onComplete;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(StreamingResponderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onResponse =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, StreamingResponder_OnResponse_ParamsSpec.$, null, this.onResponse.createReceiverHandler(false /* expectsResponse */), false);
        this.onComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, StreamingResponder_OnComplete_ParamsSpec.$, null, this.onComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ContextClientPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.ContextClient', scope);
    }
}
export class ContextClientRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ContextClientPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onComplete(tokensProcessed) {
        this.proxy.sendMessage(0, ContextClient_OnComplete_ParamsSpec.$, null, [
            tokensProcessed
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ContextClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ContextClientReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ContextClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ContextClient_OnComplete_ParamsSpec.$, null, impl.onComplete.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ContextClient {
    static get $interfaceName() {
        return "on_device_model.mojom.ContextClient";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ContextClientRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ContextClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ContextClientCallbackRouter {
    helper_internal_;
    $;
    router_;
    onComplete;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ContextClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onComplete =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ContextClient_OnComplete_ParamsSpec.$, null, this.onComplete.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class SessionPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.Session', scope);
    }
}
export class SessionRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SessionPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    append(options, client) {
        this.proxy.sendMessage(6, Session_Append_ParamsSpec.$, null, [
            options,
            client
        ], false);
    }
    generate(options, responder) {
        this.proxy.sendMessage(7, Session_Generate_ParamsSpec.$, null, [
            options,
            responder
        ], false);
    }
    getSizeInTokens(input) {
        return this.proxy.sendMessage(5, Session_GetSizeInTokens_ParamsSpec.$, Session_GetSizeInTokens_ResponseParamsSpec.$, [
            input
        ], false);
    }
    score(text) {
        return this.proxy.sendMessage(3, Session_Score_ParamsSpec.$, Session_Score_ResponseParamsSpec.$, [
            text
        ], false);
    }
    clone(session) {
        this.proxy.sendMessage(4, Session_Clone_ParamsSpec.$, null, [
            session
        ], false);
    }
    getProbabilitiesBlocking(text) {
        return this.proxy.sendMessage(8, Session_GetProbabilitiesBlocking_ParamsSpec.$, Session_GetProbabilitiesBlocking_ResponseParamsSpec.$, [
            text
        ], false);
    }
    setPriority(priority) {
        this.proxy.sendMessage(9, Session_SetPriority_ParamsSpec.$, null, [
            priority
        ], false);
    }
    asrStream(options, stream, responder) {
        this.proxy.sendMessage(10, Session_AsrStream_ParamsSpec.$, null, [
            options,
            stream,
            responder
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Session
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SessionReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(6, Session_Append_ParamsSpec.$, null, impl.append.bind(impl), false);
        this.helper_internal_.registerHandler(7, Session_Generate_ParamsSpec.$, null, impl.generate.bind(impl), false);
        this.helper_internal_.registerHandler(5, Session_GetSizeInTokens_ParamsSpec.$, Session_GetSizeInTokens_ResponseParamsSpec.$, impl.getSizeInTokens.bind(impl), false);
        this.helper_internal_.registerHandler(3, Session_Score_ParamsSpec.$, Session_Score_ResponseParamsSpec.$, impl.score.bind(impl), false);
        this.helper_internal_.registerHandler(4, Session_Clone_ParamsSpec.$, null, impl.clone.bind(impl), false);
        this.helper_internal_.registerHandler(8, Session_GetProbabilitiesBlocking_ParamsSpec.$, Session_GetProbabilitiesBlocking_ResponseParamsSpec.$, impl.getProbabilitiesBlocking.bind(impl), false);
        this.helper_internal_.registerHandler(9, Session_SetPriority_ParamsSpec.$, null, impl.setPriority.bind(impl), false);
        this.helper_internal_.registerHandler(10, Session_AsrStream_ParamsSpec.$, null, impl.asrStream.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Session {
    static get $interfaceName() {
        return "on_device_model.mojom.Session";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SessionRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Session
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SessionCallbackRouter {
    helper_internal_;
    $;
    router_;
    append;
    generate;
    getSizeInTokens;
    score;
    clone;
    getProbabilitiesBlocking;
    setPriority;
    asrStream;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.append =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Session_Append_ParamsSpec.$, null, this.append.createReceiverHandler(false /* expectsResponse */), false);
        this.generate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Session_Generate_ParamsSpec.$, null, this.generate.createReceiverHandler(false /* expectsResponse */), false);
        this.getSizeInTokens =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Session_GetSizeInTokens_ParamsSpec.$, Session_GetSizeInTokens_ResponseParamsSpec.$, this.getSizeInTokens.createReceiverHandler(true /* expectsResponse */), false);
        this.score =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Session_Score_ParamsSpec.$, Session_Score_ResponseParamsSpec.$, this.score.createReceiverHandler(true /* expectsResponse */), false);
        this.clone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Session_Clone_ParamsSpec.$, null, this.clone.createReceiverHandler(false /* expectsResponse */), false);
        this.getProbabilitiesBlocking =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Session_GetProbabilitiesBlocking_ParamsSpec.$, Session_GetProbabilitiesBlocking_ResponseParamsSpec.$, this.getProbabilitiesBlocking.createReceiverHandler(true /* expectsResponse */), false);
        this.setPriority =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, Session_SetPriority_ParamsSpec.$, null, this.setPriority.createReceiverHandler(false /* expectsResponse */), false);
        this.asrStream =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, Session_AsrStream_ParamsSpec.$, null, this.asrStream.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class OnDeviceModelPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.OnDeviceModel', scope);
    }
}
export class OnDeviceModelRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(OnDeviceModelPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    startSession(session, params) {
        this.proxy.sendMessage(0, OnDeviceModel_StartSession_ParamsSpec.$, null, [
            session,
            params
        ], false);
    }
    classifyTextSafety(text) {
        return this.proxy.sendMessage(1, OnDeviceModel_ClassifyTextSafety_ParamsSpec.$, OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$, [
            text
        ], false);
    }
    detectLanguage(text) {
        return this.proxy.sendMessage(2, OnDeviceModel_DetectLanguage_ParamsSpec.$, OnDeviceModel_DetectLanguage_ResponseParamsSpec.$, [
            text
        ], false);
    }
    loadAdaptation(params, model) {
        return this.proxy.sendMessage(3, OnDeviceModel_LoadAdaptation_ParamsSpec.$, OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$, [
            params,
            model
        ], false);
    }
}
;
/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OnDeviceModelReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OnDeviceModelRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, OnDeviceModel_StartSession_ParamsSpec.$, null, impl.startSession.bind(impl), false);
        this.helper_internal_.registerHandler(1, OnDeviceModel_ClassifyTextSafety_ParamsSpec.$, OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$, impl.classifyTextSafety.bind(impl), false);
        this.helper_internal_.registerHandler(2, OnDeviceModel_DetectLanguage_ParamsSpec.$, OnDeviceModel_DetectLanguage_ResponseParamsSpec.$, impl.detectLanguage.bind(impl), false);
        this.helper_internal_.registerHandler(3, OnDeviceModel_LoadAdaptation_ParamsSpec.$, OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$, impl.loadAdaptation.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class OnDeviceModel {
    static get $interfaceName() {
        return "on_device_model.mojom.OnDeviceModel";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new OnDeviceModelRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the OnDeviceModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OnDeviceModelCallbackRouter {
    helper_internal_;
    $;
    router_;
    startSession;
    classifyTextSafety;
    detectLanguage;
    loadAdaptation;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OnDeviceModelRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.startSession =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, OnDeviceModel_StartSession_ParamsSpec.$, null, this.startSession.createReceiverHandler(false /* expectsResponse */), false);
        this.classifyTextSafety =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, OnDeviceModel_ClassifyTextSafety_ParamsSpec.$, OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$, this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */), false);
        this.detectLanguage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, OnDeviceModel_DetectLanguage_ParamsSpec.$, OnDeviceModel_DetectLanguage_ResponseParamsSpec.$, this.detectLanguage.createReceiverHandler(true /* expectsResponse */), false);
        this.loadAdaptation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, OnDeviceModel_LoadAdaptation_ParamsSpec.$, OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$, this.loadAdaptation.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class TextSafetySessionPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.TextSafetySession', scope);
    }
}
export class TextSafetySessionRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TextSafetySessionPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    classifyTextSafety(text) {
        return this.proxy.sendMessage(1, TextSafetySession_ClassifyTextSafety_ParamsSpec.$, TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$, [
            text
        ], false);
    }
    detectLanguage(text) {
        return this.proxy.sendMessage(2, TextSafetySession_DetectLanguage_ParamsSpec.$, TextSafetySession_DetectLanguage_ResponseParamsSpec.$, [
            text
        ], false);
    }
    clone(session) {
        this.proxy.sendMessage(3, TextSafetySession_Clone_ParamsSpec.$, null, [
            session
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSafetySessionReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TextSafetySessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(1, TextSafetySession_ClassifyTextSafety_ParamsSpec.$, TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$, impl.classifyTextSafety.bind(impl), false);
        this.helper_internal_.registerHandler(2, TextSafetySession_DetectLanguage_ParamsSpec.$, TextSafetySession_DetectLanguage_ResponseParamsSpec.$, impl.detectLanguage.bind(impl), false);
        this.helper_internal_.registerHandler(3, TextSafetySession_Clone_ParamsSpec.$, null, impl.clone.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TextSafetySession {
    static get $interfaceName() {
        return "on_device_model.mojom.TextSafetySession";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TextSafetySessionRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TextSafetySession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSafetySessionCallbackRouter {
    helper_internal_;
    $;
    router_;
    classifyTextSafety;
    detectLanguage;
    clone;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TextSafetySessionRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.classifyTextSafety =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, TextSafetySession_ClassifyTextSafety_ParamsSpec.$, TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$, this.classifyTextSafety.createReceiverHandler(true /* expectsResponse */), false);
        this.detectLanguage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, TextSafetySession_DetectLanguage_ParamsSpec.$, TextSafetySession_DetectLanguage_ResponseParamsSpec.$, this.detectLanguage.createReceiverHandler(true /* expectsResponse */), false);
        this.clone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, TextSafetySession_Clone_ParamsSpec.$, null, this.clone.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class TextSafetyModelPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.TextSafetyModel', scope);
    }
}
export class TextSafetyModelRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TextSafetyModelPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    startSession(session) {
        this.proxy.sendMessage(0, TextSafetyModel_StartSession_ParamsSpec.$, null, [
            session
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextSafetyModelReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TextSafetyModelRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TextSafetyModel_StartSession_ParamsSpec.$, null, impl.startSession.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TextSafetyModel {
    static get $interfaceName() {
        return "on_device_model.mojom.TextSafetyModel";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TextSafetyModelRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TextSafetyModel
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextSafetyModelCallbackRouter {
    helper_internal_;
    $;
    router_;
    startSession;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TextSafetyModelRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.startSession =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TextSafetyModel_StartSession_ParamsSpec.$, null, this.startSession.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AsrStreamResponderPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.AsrStreamResponder', scope);
    }
}
export class AsrStreamResponderRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AsrStreamResponderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onResponse(result) {
        this.proxy.sendMessage(0, AsrStreamResponder_OnResponse_ParamsSpec.$, null, [
            result
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AsrStreamResponderReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AsrStreamResponderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AsrStreamResponder_OnResponse_ParamsSpec.$, null, impl.onResponse.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AsrStreamResponder {
    static get $interfaceName() {
        return "on_device_model.mojom.AsrStreamResponder";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AsrStreamResponderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AsrStreamResponder
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AsrStreamResponderCallbackRouter {
    helper_internal_;
    $;
    router_;
    onResponse;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AsrStreamResponderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onResponse =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AsrStreamResponder_OnResponse_ParamsSpec.$, null, this.onResponse.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class AsrStreamInputPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_model.mojom.AsrStreamInput', scope);
    }
}
export class AsrStreamInputRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AsrStreamInputPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    addAudioChunk(data) {
        this.proxy.sendMessage(0, AsrStreamInput_AddAudioChunk_ParamsSpec.$, null, [
            data
        ], false);
    }
}
;
/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AsrStreamInputReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AsrStreamInputRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AsrStreamInput_AddAudioChunk_ParamsSpec.$, null, impl.addAudioChunk.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class AsrStreamInput {
    static get $interfaceName() {
        return "on_device_model.mojom.AsrStreamInput";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AsrStreamInputRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AsrStreamInput
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AsrStreamInputCallbackRouter {
    helper_internal_;
    $;
    router_;
    addAudioChunk;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AsrStreamInputRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.addAudioChunk =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AsrStreamInput_AddAudioChunk_ParamsSpec.$, null, this.addAudioChunk.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const AdaptationAssetsSpec = { $: {} };
export const LanguageDetectionResultSpec = { $: {} };
export const SafetyInfoSpec = { $: {} };
export const ResponseChunkSpec = { $: {} };
export const ResponseSummarySpec = { $: {} };
export const LoadAdaptationParamsSpec = { $: {} };
export const CapabilitiesSpec = { $: {} };
export const SessionParamsSpec = { $: {} };
export const InputSpec = { $: {} };
export const AppendOptionsSpec = { $: {} };
export const GenerateOptionsSpec = { $: {} };
export const AudioDataSpec = { $: {} };
export const SpeechRecognitionResultSpec = { $: {} };
export const AsrStreamOptionsSpec = { $: {} };
export const DevicePerformanceInfoSpec = { $: {} };
export const DeviceInfoSpec = { $: {} };
export const StreamingResponder_OnResponse_ParamsSpec = { $: {} };
export const StreamingResponder_OnComplete_ParamsSpec = { $: {} };
export const ContextClient_OnComplete_ParamsSpec = { $: {} };
export const Session_Append_ParamsSpec = { $: {} };
export const Session_Generate_ParamsSpec = { $: {} };
export const Session_GetSizeInTokens_ParamsSpec = { $: {} };
export const Session_GetSizeInTokens_ResponseParamsSpec = { $: {} };
export const Session_Score_ParamsSpec = { $: {} };
export const Session_Score_ResponseParamsSpec = { $: {} };
export const Session_Clone_ParamsSpec = { $: {} };
export const Session_GetProbabilitiesBlocking_ParamsSpec = { $: {} };
export const Session_GetProbabilitiesBlocking_ResponseParamsSpec = { $: {} };
export const Session_SetPriority_ParamsSpec = { $: {} };
export const Session_AsrStream_ParamsSpec = { $: {} };
export const OnDeviceModel_StartSession_ParamsSpec = { $: {} };
export const OnDeviceModel_ClassifyTextSafety_ParamsSpec = { $: {} };
export const OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec = { $: {} };
export const OnDeviceModel_DetectLanguage_ParamsSpec = { $: {} };
export const OnDeviceModel_DetectLanguage_ResponseParamsSpec = { $: {} };
export const OnDeviceModel_LoadAdaptation_ParamsSpec = { $: {} };
export const OnDeviceModel_LoadAdaptation_ResponseParamsSpec = { $: {} };
export const TextSafetySession_ClassifyTextSafety_ParamsSpec = { $: {} };
export const TextSafetySession_ClassifyTextSafety_ResponseParamsSpec = { $: {} };
export const TextSafetySession_DetectLanguage_ParamsSpec = { $: {} };
export const TextSafetySession_DetectLanguage_ResponseParamsSpec = { $: {} };
export const TextSafetySession_Clone_ParamsSpec = { $: {} };
export const TextSafetyModel_StartSession_ParamsSpec = { $: {} };
export const AsrStreamResponder_OnResponse_ParamsSpec = { $: {} };
export const AsrStreamInput_AddAudioChunk_ParamsSpec = { $: {} };
export const InputPieceSpec = { $: {} };
export const ResponseConstraintSpec = { $: {} };
mojo.internal.Struct(AdaptationAssetsSpec.$, 'AdaptationAssets', [
    mojo.internal.StructField('weights', 0, 0, mojoBase_mojom_FileSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('weightsPath', 8, 0, mojoBase_mojom_FilePathSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(LanguageDetectionResultSpec.$, 'LanguageDetectionResult', [
    mojo.internal.StructField('code', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('reliability', 8, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SafetyInfoSpec.$, 'SafetyInfo', [
    mojo.internal.StructField('classScores', 0, 0, mojo.internal.Array(mojo.internal.Float, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('language', 8, 0, LanguageDetectionResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ResponseChunkSpec.$, 'ResponseChunk', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('safetyInfo', 8, 0, SafetyInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ResponseSummarySpec.$, 'ResponseSummary', [
    mojo.internal.StructField('safetyInfo', 0, 0, SafetyInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('outputTokenCount', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(LoadAdaptationParamsSpec.$, 'LoadAdaptationParams', [
    mojo.internal.StructField('assets', 0, 0, AdaptationAssetsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CapabilitiesSpec.$, 'Capabilities', [
    mojo.internal.StructField('imageInput', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('audioInput', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SessionParamsSpec.$, 'SessionParams', [
    mojo.internal.StructField('maxTokens', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('capabilities', 8, 0, CapabilitiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topK', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 1, undefined, undefined),
    mojo.internal.StructField('temperature', 16, 0, mojo.internal.Float, 0, false /* nullable */, 1, undefined, undefined),
], [[0, 24], [1, 32],]);
mojo.internal.Struct(InputSpec.$, 'Input', [
    mojo.internal.StructField('pieces', 0, 0, mojo.internal.Array(InputPieceSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AppendOptionsSpec.$, 'AppendOptions', [
    mojo.internal.StructField('input', 0, 0, InputSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxTokens', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(GenerateOptionsSpec.$, 'GenerateOptions', [
    mojo.internal.StructField('maxOutputTokens', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('constraint', 8, 0, ResponseConstraintSpec.$, null, true /* nullable */, 2, undefined, undefined),
], [[0, 16], [2, 32],]);
mojo.internal.Struct(AudioDataSpec.$, 'AudioData', [
    mojo.internal.StructField('channelCount', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sampleRate', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('frameCount', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('data', 16, 0, mojo.internal.Array(mojo.internal.Float, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(SpeechRecognitionResultSpec.$, 'SpeechRecognitionResult', [
    mojo.internal.StructField('transcript', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isFinal', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AsrStreamOptionsSpec.$, 'AsrStreamOptions', [
    mojo.internal.StructField('sampleRateHz', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(DevicePerformanceInfoSpec.$, 'DevicePerformanceInfo', [
    mojo.internal.StructField('performanceClass', 0, 0, PerformanceClassSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('vramMb', 8, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DeviceInfoSpec.$, 'DeviceInfo', [
    mojo.internal.StructField('vendorId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('driverVersion', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('supportsFp16', 16, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(StreamingResponder_OnResponse_ParamsSpec.$, 'StreamingResponder_OnResponse_Params', [
    mojo.internal.StructField('chunk', 0, 0, ResponseChunkSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(StreamingResponder_OnComplete_ParamsSpec.$, 'StreamingResponder_OnComplete_Params', [
    mojo.internal.StructField('summary', 0, 0, ResponseSummarySpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ContextClient_OnComplete_ParamsSpec.$, 'ContextClient_OnComplete_Params', [
    mojo.internal.StructField('tokensProcessed', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_Append_ParamsSpec.$, 'Session_Append_Params', [
    mojo.internal.StructField('options', 0, 0, AppendOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('client', 8, 0, mojo.internal.InterfaceProxy(ContextClientRemote), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Session_Generate_ParamsSpec.$, 'Session_Generate_Params', [
    mojo.internal.StructField('options', 0, 0, GenerateOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('responder', 8, 0, mojo.internal.InterfaceProxy(StreamingResponderRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(Session_GetSizeInTokens_ParamsSpec.$, 'Session_GetSizeInTokens_Params', [
    mojo.internal.StructField('input', 0, 0, InputSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_GetSizeInTokens_ResponseParamsSpec.$, 'Session_GetSizeInTokens_ResponseParams', [
    mojo.internal.StructField('size', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_Score_ParamsSpec.$, 'Session_Score_Params', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_Score_ResponseParamsSpec.$, 'Session_Score_ResponseParams', [
    mojo.internal.StructField('probability', 0, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_Clone_ParamsSpec.$, 'Session_Clone_Params', [
    mojo.internal.StructField('session', 0, 0, mojo.internal.InterfaceRequest(SessionPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_GetProbabilitiesBlocking_ParamsSpec.$, 'Session_GetProbabilitiesBlocking_Params', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_GetProbabilitiesBlocking_ResponseParamsSpec.$, 'Session_GetProbabilitiesBlocking_ResponseParams', [
    mojo.internal.StructField('probabilities', 0, 0, mojo.internal.Array(mojo.internal.Float, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_SetPriority_ParamsSpec.$, 'Session_SetPriority_Params', [
    mojo.internal.StructField('priority', 0, 0, PrioritySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Session_AsrStream_ParamsSpec.$, 'Session_AsrStream_Params', [
    mojo.internal.StructField('options', 0, 0, AsrStreamOptionsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('stream', 8, 0, mojo.internal.InterfaceRequest(AsrStreamInputPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('responder', 12, 0, mojo.internal.InterfaceProxy(AsrStreamResponderRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(OnDeviceModel_StartSession_ParamsSpec.$, 'OnDeviceModel_StartSession_Params', [
    mojo.internal.StructField('session', 0, 0, mojo.internal.InterfaceRequest(SessionPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('params', 8, 0, SessionParamsSpec.$, null, true /* nullable */, 1, undefined, undefined),
], [[0, 16], [1, 24],]);
mojo.internal.Struct(OnDeviceModel_ClassifyTextSafety_ParamsSpec.$, 'OnDeviceModel_ClassifyTextSafety_Params', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OnDeviceModel_ClassifyTextSafety_ResponseParamsSpec.$, 'OnDeviceModel_ClassifyTextSafety_ResponseParams', [
    mojo.internal.StructField('safetyInfo', 0, 0, SafetyInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OnDeviceModel_DetectLanguage_ParamsSpec.$, 'OnDeviceModel_DetectLanguage_Params', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OnDeviceModel_DetectLanguage_ResponseParamsSpec.$, 'OnDeviceModel_DetectLanguage_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, LanguageDetectionResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OnDeviceModel_LoadAdaptation_ParamsSpec.$, 'OnDeviceModel_LoadAdaptation_Params', [
    mojo.internal.StructField('params', 0, 0, LoadAdaptationParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('model', 8, 0, mojo.internal.InterfaceRequest(OnDeviceModelPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(OnDeviceModel_LoadAdaptation_ResponseParamsSpec.$, 'OnDeviceModel_LoadAdaptation_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, LoadModelResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextSafetySession_ClassifyTextSafety_ParamsSpec.$, 'TextSafetySession_ClassifyTextSafety_Params', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextSafetySession_ClassifyTextSafety_ResponseParamsSpec.$, 'TextSafetySession_ClassifyTextSafety_ResponseParams', [
    mojo.internal.StructField('safetyInfo', 0, 0, SafetyInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextSafetySession_DetectLanguage_ParamsSpec.$, 'TextSafetySession_DetectLanguage_Params', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextSafetySession_DetectLanguage_ResponseParamsSpec.$, 'TextSafetySession_DetectLanguage_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, LanguageDetectionResultSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextSafetySession_Clone_ParamsSpec.$, 'TextSafetySession_Clone_Params', [
    mojo.internal.StructField('session', 0, 0, mojo.internal.InterfaceRequest(TextSafetySessionPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextSafetyModel_StartSession_ParamsSpec.$, 'TextSafetyModel_StartSession_Params', [
    mojo.internal.StructField('session', 0, 0, mojo.internal.InterfaceRequest(TextSafetySessionPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AsrStreamResponder_OnResponse_ParamsSpec.$, 'AsrStreamResponder_OnResponse_Params', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Array(SpeechRecognitionResultSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AsrStreamInput_AddAudioChunk_ParamsSpec.$, 'AsrStreamInput_AddAudioChunk_Params', [
    mojo.internal.StructField('data', 0, 0, AudioDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(InputPieceSpec.$, 'InputPiece', {
    'token': {
        'ordinal': 0,
        'type': TokenSpec.$,
    },
    'text': {
        'ordinal': 1,
        'type': mojo.internal.String,
    },
    'bitmap': {
        'ordinal': 2,
        'type': skia_mojom_BitmapWithArbitraryBppSpec.$,
    },
    'unknownType': {
        'ordinal': 3,
        'type': mojo.internal.Bool,
    },
    'audio': {
        'ordinal': 4,
        'type': AudioDataSpec.$,
    },
});
export var InputPieceFieldTags;
(function (InputPieceFieldTags) {
    InputPieceFieldTags[InputPieceFieldTags["TOKEN"] = 0] = "TOKEN";
    InputPieceFieldTags[InputPieceFieldTags["TEXT"] = 1] = "TEXT";
    InputPieceFieldTags[InputPieceFieldTags["BITMAP"] = 2] = "BITMAP";
    InputPieceFieldTags[InputPieceFieldTags["UNKNOWN_TYPE"] = 3] = "UNKNOWN_TYPE";
    InputPieceFieldTags[InputPieceFieldTags["AUDIO"] = 4] = "AUDIO";
})(InputPieceFieldTags || (InputPieceFieldTags = {}));
export function whichInputPiece(u) {
    if (u.token !== null && u.token !== undefined) {
        return InputPieceFieldTags.TOKEN;
    }
    if (u.text !== null && u.text !== undefined) {
        return InputPieceFieldTags.TEXT;
    }
    if (u.bitmap !== null && u.bitmap !== undefined) {
        return InputPieceFieldTags.BITMAP;
    }
    if (u.unknownType !== null && u.unknownType !== undefined) {
        return InputPieceFieldTags.UNKNOWN_TYPE;
    }
    if (u.audio !== null && u.audio !== undefined) {
        return InputPieceFieldTags.AUDIO;
    }
    return InputPieceFieldTags.UNKNOWN_TYPE;
}
mojo.internal.Union(ResponseConstraintSpec.$, 'ResponseConstraint', {
    'jsonSchema': {
        'ordinal': 0,
        'type': mojo.internal.String,
    },
    'regex': {
        'ordinal': 1,
        'type': mojo.internal.String,
    },
    'unknownType': {
        'ordinal': 2,
        'type': mojo.internal.Bool,
    },
});
export var ResponseConstraintFieldTags;
(function (ResponseConstraintFieldTags) {
    ResponseConstraintFieldTags[ResponseConstraintFieldTags["JSON_SCHEMA"] = 0] = "JSON_SCHEMA";
    ResponseConstraintFieldTags[ResponseConstraintFieldTags["REGEX"] = 1] = "REGEX";
    ResponseConstraintFieldTags[ResponseConstraintFieldTags["UNKNOWN_TYPE"] = 2] = "UNKNOWN_TYPE";
})(ResponseConstraintFieldTags || (ResponseConstraintFieldTags = {}));
export function whichResponseConstraint(u) {
    if (u.jsonSchema !== null && u.jsonSchema !== undefined) {
        return ResponseConstraintFieldTags.JSON_SCHEMA;
    }
    if (u.regex !== null && u.regex !== undefined) {
        return ResponseConstraintFieldTags.REGEX;
    }
    if (u.unknownType !== null && u.unknownType !== undefined) {
        return ResponseConstraintFieldTags.UNKNOWN_TYPE;
    }
    return ResponseConstraintFieldTags.UNKNOWN_TYPE;
}
