import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style md-select">cr-input:not(:first-of-type){margin-top:var(--cr-form-field-bottom-spacing)}cr-icon-button{--cr-icon-button-icon-size:16px;--cr-icon-button-size:32px;--cr-icon-button-margin-start:0;--cr-icon-button-margin-end:0}cr-input{--cr-input-error-display:none}cr-textarea{--settings-textarea-footer-display:flex}.md-select{--md-select-width:100%;margin-bottom:var(--cr-form-field-bottom-spacing);margin-top:2px}#websiteInput[show-error-message]{--cr-input-error-display:block}#usernameInput[invalid]{--cr-input-error-display:block}#viewExistingPasswordLink{color:var(--cr-link-color);display:block;font-size:var(--cr-form-field-label-font-size);line-height:1;width:fit-content}#footnote{margin-inline-start:2px;margin-top:16px}.divider{border-top:var(--cr-separator-line);margin:var(--cr-form-field-bottom-spacing) 0}cr-textarea{--cr-textarea-footer-display:flex;--cr-textarea-autogrow-max-height:20lh}</style>
<cr-dialog id="dialog" show-on-attach>
  <div slot="title" id="title" class="dialog-title">
    $i18n{addPasswordTitle}
  </div>
  <div slot="body">
    <select class="md-select" id="storePicker"
        aria-description="$i18n{addPasswordStorePickerA11yDescription}"
        hidden="[[!isAccountStoreUser]]">
      <option value="[[storeOptionAccountValue_]]">
        $i18n{addPasswordStoreOptionAccount}
      </option>
      <option value="[[storeOptionDeviceValue_]]">
        $i18n{addPasswordStoreOptionDevice}
      </option>
    </select>
    <cr-input id="websiteInput" label="$i18n{websiteLabel}" autofocus required
        placeholder="example.com"  value="{{website_}}"
        invalid="[[isWebsiteInputInvalid_(websiteErrorMessage_)]]"
        show-error-message$="[[showWebsiteError_(websiteErrorMessage_)]]"
        error-message="[[websiteErrorMessage_]]" spellcheck="false"
        on-input="validateWebsite_" on-blur="onWebsiteInputBlur_">
    </cr-input>
    <cr-input id="usernameInput" label="$i18n{usernameLabel}"
        value="{{username_}}" spellcheck="false"
        invalid="[[doesUsernameExistAlready_(usernameErrorMessage_)]]"
        error-message="[[usernameErrorMessage_]]">
    </cr-input>
    <a id="viewExistingPasswordLink" is="action-link" href="/"
        on-click="onViewExistingPasswordClick_"
        aria-description="[[getViewExistingPasswordAriaDescription_(
          urlCollection_, username_)]]"
        hidden="[[!doesUsernameExistAlready_(usernameErrorMessage_)]]">
      $i18n{viewExistingPassword}
    </a>
    <cr-input id="passwordInput" label="$i18n{passwordLabel}"
        type="[[getPasswordInputType(isPasswordVisible)]]"
        value="{{password_}}" invalid="[[isPasswordInvalid_]]"
        on-blur="onPasswordInput_" on-input="onPasswordInput_" required
        class="password-input" spellcheck="false">
      <cr-icon-button id="showPasswordButton" slot="inline-suffix"
          class$="[[getShowHideButtonIconClass(isPasswordVisible)]]"
          title="[[getShowHideButtonLabel(isPasswordVisible)]]"
          on-click="onShowHidePasswordButtonClick">
      </cr-icon-button>
    </cr-input>
    <div id="footnote">
      $i18n{addPasswordFooter}
    </div>
    <div class="divider"></div>
    <cr-textarea label="$i18n{noteLabel}" id="noteInput" value="{{note_}}"
        invalid="[[isNoteInputInvalid_(note_)]]" has-max-height autogrow
        first-footer="[[getFirstNoteFooter_(note_)]]"
        second-footer="[[getSecondNoteFooter_(note_)]]">
    </cr-textarea>
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="closeDialog_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="addButton" class="action-button"
        disabled="[[!canAddPassword_]]" on-click="onAddClick_">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
