import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style">a[href]{color:var(--cr-link-color)}</style>
<cr-dialog id="dialog" close-text="$i18n{close}"
    ignore-popstate ignore-enter-key>
  <div slot="title" class="dialog-title">
    $i18n{deletePasswordConfirmationTitle}
  </div>
  <div slot="body">
    <span id="link" hidden="[[!hasSecureChangePasswordUrl_(actionUrl)]]"
        inner-h-t-m-l="[[getDescriptionHtml_(origin,actionUrl)]]">
    </span>
    <span id="text" hidden="[[hasSecureChangePasswordUrl_(actionUrl)]]">
      [[getDescriptionText_(origin)]]
    </span>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick_" id="cancel"
        autofocus>
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onDeleteClick_" id="delete">
      $i18n{deletePassword}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
