import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style cr-spinner-style">#blockedSitesTitle,#actorLoginPermissionsTitle{margin-top:28px}.site-content{border-top:var(--cr-separator-line);flex:1;min-height:var(--section-min-height)}.site-content[first]{border-top:none}.favicon,#blockedSitesHeader,#actorLoginPermissionsHeader{margin-inline-end:20px;margin-inline-start:20px}.flex-spacer{flex:1}.site-username{margin-inline-start:8px}cr-icon-button{--cr-icon-button-icon-size:16px;--cr-icon-button-margin-start:0px;--cr-icon-button-margin-end:10px}@media all and (display-mode:standalone){#addShortcutBanner{display:none}}cr-link-row[hide-icon]::part(icon){display:none}</style>
<h2 class="page-title">$i18n{settings}</h2>
<div class="card">
  <pref-toggle-button id="passwordToggle" no-extension-indicator
      label="$i18n{savePasswordsLabel}"
      pref="{{prefs.credentials_enable_service}}">
  </pref-toggle-button>
  <template is="dom-if"
        if="[[prefs.credentials_enable_service.extensionId]]">
    <div class="cr-row continuation">
      <extension-controlled-indicator
          id="passwordsExtensionIndicator"
          extension-id="[[prefs.credentials_enable_service.extensionId]]"
          extension-name="[[
              prefs.credentials_enable_service.controlledByName]]"
          extension-can-be-disabled="[[
              prefs.credentials_enable_service.extensionCanBeDisabled]]">
      </extension-controlled-indicator>
    </div>
  </template>
  <template is="dom-if" if="[[isPasskeyUpgradeSettingsToggleVisible_]]">
    <pref-toggle-button id="passkeyUpgradeToggle"
        label="$i18n{passkeyUpgradeSettingsToggleLabel}"
        sub-label="$i18n{passkeyUpgradeSettingsToggleSubLabel}"
        pref="{{prefs.credentials_enable_automatic_passkey_upgrades}}"
        hidden="[[!prefs.credentials_enable_service.value]]">
    </pref-toggle-button>
  </template>
  <pref-toggle-button id="autosigninToggle" class="hr"
      label="$i18n{autosigninLabel}"
      sub-label="$i18n{autosigninDescription}"
      pref="{{prefs.credentials_enable_autosignin}}">
  </pref-toggle-button>
  
    <template is="dom-if"
        if="[[isBiometricAuthenticationForFillingToggleVisible_]]">
      <pref-toggle-button id="biometricAuthenticationToggle" class="hr"
          label="$i18n{biometricAuthenticationForFillingLabel}"
          sub-label="$i18n{biometricAuthenticationForFillingSubLabel}"
          pref="{{prefs.password_manager.biometric_authentication_filling}}"
          change-requires-validation
          on-validate-and-change-pref="switchBiometricAuthBeforeFillingState_">
      </pref-toggle-button>
    </template>
  
    <pref-toggle-button id="accountStorageToggle" class="hr"
        hidden="[[!shouldShowAccountStorageSettingToggle_]]"
        label="$i18n{accountStorageToggleLabel}"
        sub-label="[[getAccountStorageSubLabel_(accountEmail)]]"
        checked="[[isAccountStoreUser]]"
        change-requires-validation
        on-validate-and-change-pref="changeAccountStorageEnabled_">
    </pref-toggle-button>
  <template is="dom-if"
      if="[[shouldShowMovePasswordsEntry_(isAccountStoreUser,
            passwordsOnDevice_, localPasswordCount_)]]"
      restamp>
    <cr-link-row class="cr-row" non-clickable label="[[movePasswordsLabel_]]"
        sub-label="$i18n{movePasswordsInSettingsSubLabel}" hide-icon>
      <cr-button id="movePasswordsButton" on-click="onMovePasswordsClicked_"
          aria-label="[[getAriaLabelMovePasswordsButton_(movePasswordsLabel_)]]">
        $i18n{moveSinglePasswordButton}
      </cr-button>
    </cr-link-row>
  </template>
  <template is="dom-if" if="[[isAutomatedPasswordChangeVisible_]]">
    <cr-link-row id="automatedPasswordChange"
        class="cr-row settings-cr-link-row"
        label="$i18n{automatedPasswordChangeTitle}"
        sub-label="$i18n{automatedPasswordChangeDescription}"
        aria-label="[[getAriaLabelForAutomatedPasswordChange_()]]"
        on-click="onAutomatedPasswordChangeClick_">
    </cr-link-row>
  </template>
  <cr-link-row id="trustedVaultBanner" class="cr-row"
      label="[[getTrustedVaultBannerTitle_(trustedVaultBannerState_)]]"
      sub-label="[[getTrustedVaultBannerDescription_(trustedVaultBannerState_)]]"
      hidden$="[[shouldHideTrustedVaultBanner_(trustedVaultBannerState_)]]"
      button-aria-description="$i18n{opensInNewTab}"
      on-click="onTrustedVaultBannerClick_" external>
  </cr-link-row>
  <template is="dom-if" if="[[!passwordManagerDisabled_]]" restamp>
    <passwords-importer account-email="[[accountEmail]]"
        is-account-store-user="[[isAccountStoreUser]]"
        is-user-syncing-passwords="[[isSyncingPasswords]]">
    </passwords-importer>
  </template>
  <template is="dom-if" if="[[hasPasswordsToExport_]]" restamp>
    <passwords-exporter></passwords-exporter>
  </template>
  <template is="dom-if" if="[[canAddShortcut_]]"
      on-dom-change="onShortcutBannerDomChanged_" restamp>
    <cr-link-row id="addShortcutBanner" class="cr-row settings-cr-link-row"
        on-click="onAddShortcutClick_" label="$i18n{addShortcut}"
        sub-label="$i18n{addShortcutDescription}" role-description="button">
    </cr-link-row>
  </template>
  <template is="dom-if" if="[[isConnectedToCloudAuthenticator_]]" restamp>
    <cr-link-row id="disconnectCloudAuthenticatorRow"
        class="cr-row settings-cr-link-row"
        label="$i18n{disconnectCloudAuthenticatorTitle}"
        sub-label="$i18n{disconnectCloudAuthenticatorDescription}"
        hide-icon non-clickable>
      <template is="dom-if"
          if="[[!isDisconnectCloudAuthenticatorInProgress_]]" restamp>
        <cr-button id="disconnectCloudAuthenticatorButton"
            class="cr-row-action-button"
            aria-label="[[getAriaLabelForCloudAuthenticatorButton_()]]"
            on-click="onDisconnectCloudAuthenticatorClick_">
          $i18n{disconnectCloudAuthenticatorButton}
        </cr-button>
      </template>
      <div class="spinner"
          hidden$="[[!isDisconnectCloudAuthenticatorInProgress_]]"></div>
    </cr-link-row>
  </template>
  <template is="dom-if" if="[[isPasswordManagerPinAvailable_]]" restamp>
    <cr-link-row id="changePasswordManagerPinRow"
        class="cr-row settings-cr-link-row"
        label="$i18n{changePasswordManagerPin}"
        on-click="onChangePasswordManagerPinRowClick_">
    </cr-link-row>
  </template>
  
  <full-data-reset is-account-store-user="[[isAccountStoreUser]]"
      is-syncing-passwords="[[isSyncingPasswords]]">
  </full-data-reset>
</div>
<template is="dom-if" if="[[shouldShowActorLoginPermissions_]]" restamp>
  <h3 id="actorLoginPermissionsTitle"
      class="page-title">$i18n{actorLoginPermissionsTitle}</h3>
  <div class="card" id="actorLoginPermissions">
    <div class="flex-centered single-line-label">
      <div id="actorLoginPermissionsHeader" class="cr-secondary-text label">
        $i18n{actorLoginPermissionsDescription}
      </div>
    </div>
    <div id="actorLoginPermissionsList" class="hr">
      <template is="dom-repeat" items="[[actorLoginPermissions_]]">
        <div class="flex-centered">
          <site-favicon class="favicon" domain="[[item.url.link]]">
          </site-favicon>
          <div class="site-content flex-centered"
              first$="[[!index]]">
            <div class="label">[[item.url.humanReadableUrl]]</div>
            <div class="label site-username cr-secondary-text">
              [[item.username]]
            </div>
            <div class="flex-spacer"></div>
            <cr-icon-button class="icon-clear"
                id="removeActorLoginPermissionValueButton"
                on-click="onRemoveActorLoginPermissionClick_"
                title="$i18n{deletePassword}"
                aria-label="[[i18n('removeBlockedAriaDescription',
                    item.url.humanReadableUrl)]]">
            </cr-icon-button>
          </div>
        </div>
      </template>
    </div>
  </div>
</template>
<div hidden="[[!blockedSites_.length]]">
  <h3 id="blockedSitesTitle" class="page-title">$i18n{blockedSitesTitle}</h3>
  <div class="card" id="blockedSites">
    <div class="flex-centered single-line-label">
      <div id="blockedSitesHeader" class="cr-secondary-text label">
        $i18n{blockedSitesDescription}
      </div>
    </div>
    <div id="blockedSitesList" class="hr">
      <template is="dom-repeat" items="[[blockedSites_]]">
        <div class="flex-centered">
          <site-favicon class="favicon" domain="[[item.urls.link]]">
          </site-favicon>
          <div class="site-content flex-centered" first$="[[!index]]">
            <div class="label">[[item.urls.shown]]</div>
            <div class="flex-spacer"></div>
            <cr-icon-button class="icon-clear" id="removeBlockedValueButton"
                on-click="onRemoveBlockedSiteClick_"
                title="$i18n{deletePassword}"
                aria-label="[[getAriaLabelForBlockedSite_(item)]]">
            </cr-icon-button>
          </div>
        </div>
      </template>
    </div>
  </div>
</div>
<template is="dom-if" if="[[showDisconnectCloudAuthenticatorDialog_]]" restamp>
  <disconnect-cloud-authenticator-dialog id="disconnectCloudAuthenticatorDialog"
      on-close="onCloseDisconnectCloudAuthenticatorDialog_"
      on-disconnect-cloud-authenticator="onDisconnectCloudAuthenticator_">
  </disconnect-cloud-authenticator-dialog>
</template>
<template is="dom-if" if="[[removeActorLoginPermissionSite_]]" restamp>
  <remove-actor-login-permission-dialog
      id="removeActorLoginPermissionDialog"
      origin="[[removeActorLoginPermissionSite_.url.humanReadableUrl]]"
      on-close="onCloseRemoveActorLoginPermissionDialog_"
      on-remove-actor-login-permission-click="onRemoveActorLoginPermission_">
  </remove-actor-login-permission-dialog>
</template>
<cr-toast id="toast" duration="5000">
  <span id="toast-message">[[toastMessage_]]</span>
</cr-toast>
<!--_html_template_end_-->`;
}
