// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_checkbox/cr_checkbox.js';
import '//resources/cr_elements/cr_input/cr_input.js';
import '//resources/cr_elements/cr_toolbar/cr_toolbar.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './toolbar.css.js';
import { getHtml } from './toolbar.html.js';
export class PrivateStateTokensToolbarElement extends CrLitElement {
    static get is() {
        return 'private-state-tokens-toolbar';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            autoFocus_: { type: Boolean },
            alwaysShowLogo_: { type: Boolean },
            clearLabel_: { type: String },
            menuLabel_: { type: String },
            narrow: { type: Boolean },
            narrowThreshold: { type: Number },
            pageName: { type: String },
            searchPrompt_: { type: String },
            showSearch_: { type: Boolean },
        };
    }
    #autoFocus__accessor_storage = true;
    get autoFocus_() { return this.#autoFocus__accessor_storage; }
    set autoFocus_(value) { this.#autoFocus__accessor_storage = value; }
    #alwaysShowLogo__accessor_storage = true;
    get alwaysShowLogo_() { return this.#alwaysShowLogo__accessor_storage; }
    set alwaysShowLogo_(value) { this.#alwaysShowLogo__accessor_storage = value; }
    #clearLabel__accessor_storage = 'Clear search';
    get clearLabel_() { return this.#clearLabel__accessor_storage; }
    set clearLabel_(value) { this.#clearLabel__accessor_storage = value; }
    #menuLabel__accessor_storage = 'Menu';
    get menuLabel_() { return this.#menuLabel__accessor_storage; }
    set menuLabel_(value) { this.#menuLabel__accessor_storage = value; }
    #narrow_accessor_storage = false;
    get narrow() { return this.#narrow_accessor_storage; }
    set narrow(value) { this.#narrow_accessor_storage = value; }
    #narrowThreshold_accessor_storage = 0;
    get narrowThreshold() { return this.#narrowThreshold_accessor_storage; }
    set narrowThreshold(value) { this.#narrowThreshold_accessor_storage = value; }
    #pageName_accessor_storage = '';
    get pageName() { return this.#pageName_accessor_storage; }
    set pageName(value) { this.#pageName_accessor_storage = value; }
    #searchPrompt__accessor_storage = 'Search site';
    get searchPrompt_() { return this.#searchPrompt__accessor_storage; }
    set searchPrompt_(value) { this.#searchPrompt__accessor_storage = value; }
}
customElements.define(PrivateStateTokensToolbarElement.is, PrivateStateTokensToolbarElement);
