import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared cr-spinner-style">:host{--cr-dialog-button-container-padding-bottom:20px;--cr-dialog-button-container-padding-horizontal:20px;--cr-dialog-button-container-padding-top:20px;--cr-dialog-title-font-size:16px;--cr-dialog-title-slot-padding-bottom:14px;--cr-section-two-line-min-height:40px;--dbd-container-border-radius:12px;--dbd-container-color:var(--cr-fallback-color-surface3);--dbd-container-stacked-border-radius:4px;--dbd-dialog-body-max-height:400px;--dbd-dialog-max-height:600px;--settings-checkbox-margin-top:8px}#checkboxContainer{background-color:var(--dbd-container-color);border-radius:var(--dbd-container-border-radius);padding:8px var(--cr-section-padding) 12px var(--cr-section-padding)}#checkboxContainer:has(+#showMoreButton:not([hidden])){border-bottom-left-radius:var(--dbd-container-stacked-border-radius);border-bottom-right-radius:var(--dbd-container-stacked-border-radius);border-top-left-radius:var(--dbd-container-border-radius);border-top-right-radius:var(--dbd-container-border-radius);margin-bottom:2px}#deleteBrowsingDataDialog [slot=header]{padding-bottom:var(--cr-section-padding);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#deleteBrowsingDataDialog::part(body-container){max-height:var(--dbd-dialog-body-max-height)}#deleteBrowsingDataDialog::part(dialog){max-height:var(--dbd-dialog-max-height)}#deletingDataAlert{clip:rect(0,0,0,0);position:fixed}#manageOtherGoogleDataRow{border-radius:var(--dbd-container-border-radius);color:var(--cr-primary-text-color);background:var(--dbd-container-color);margin-top:12px;display:flex;align-items:center;font-weight:500}#showMoreButton{--cr-button-background-color:var(--dbd-container-color);--cr-button-height:auto;--cr-button-text-color:var(--cr-primary-text-color);border:none;border-bottom-left-radius:var(--dbd-container-border-radius);border-bottom-right-radius:var(--dbd-container-border-radius);border-top-left-radius:var(--dbd-container-stacked-border-radius);border-top-right-radius:var(--dbd-container-stacked-border-radius);padding:var(--cr-section-vertical-padding) 16px;width:100%}#spinner{margin-bottom:auto;margin-inline-end:16px;margin-top:auto}.checkbox-title{font-weight:500}.dialog-title{font-weight:500;line-height:24px}.row-aligned{align-items:center;display:flex}settings-clear-browsing-data-account-indicator{margin-inline-end:auto;overflow:hidden}</style>

<cr-dialog id="deleteBrowsingDataDialog" close-text="$i18n{close}"
    show-on-attach ignore-popstate ignore-enter-key
    hidden="[[showOtherGoogleDataDialog_]]">
  <div slot="title" class="dialog-title">$i18n{clearBrowsingData}</div>
  <div slot="header">
    <settings-clear-browsing-data-time-picker id="timePicker" prefs="{{prefs}}"
        on-selected-time-period-change="onTimePeriodChanged_">
    </settings-clear-browsing-data-time-picker>
  </div>
  <div slot="body">
    <div id="checkboxContainer">
      <template is="dom-repeat"
          items="[[expandedBrowsingDataTypeOptionsList_]]">
        <settings-checkbox pref="{{item.pref}}" no-set-pref
            sub-label-html="[[item.subLabel]]"
            disabled="[[isDeletionInProgress_]]"
            on-sub-label-link-clicked="onCheckboxSubLabelLinkClick_">
          <div class="checkbox-title">[[item.label]]</div>
        </settings-checkbox>
      </template>
      <div id="moreOptionsList">
        <template is="dom-if" if="[[dataTypesExpanded_]]">
          <template is="dom-repeat"
              items="[[moreBrowsingDataTypeOptionsList_]]">
            <settings-checkbox pref="{{item.pref}}" no-set-pref
                sub-label-html="[[item.subLabel]]"
                disabled="[[isDeletionInProgress_]]"
                on-sub-label-link-clicked="onCheckboxSubLabelLinkClick_">
              <div class="checkbox-title">[[item.label]]</div>
            </settings-checkbox>
          </template>
        </template>
      </div>
    </div>
    <cr-button id="showMoreButton" on-click="onShowMoreClick_"
        hidden="[[shouldHideShowMoreButton_(
            dataTypesExpanded_, moreBrowsingDataTypeOptionsList_)]]">
      $i18n{clearBrowsingDataShowMore}
      <cr-icon icon="cr:expand-more" aria-hidden="true" role="presentation">
      </cr-icon>
    </cr-button>
    <cr-link-row id="manageOtherGoogleDataRow"
        label="[[otherGoogleDataRowLabel_]]"
        sub-label="[[otherGoogleDataRowSubLabel_]]"
        on-click="onManageOtherGoogleDataRowClick_"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </div>
  <div slot="button-container" class="row-aligned">

    <div id="spinner" class="spinner" hidden="[[!isDeletionInProgress_]]"></div>
    <cr-button id="cancelButton" class="cancel-button" on-click="onCancelClick_"
        disabled="[[isDeletionInProgress_]]" autofocus>
      $i18n{cancel}
    </cr-button>
    <cr-button id="deleteButton" class="action-button"
        on-click="onDeleteBrowsingDataClick_"
        disabled="[[shouldDisableDeleteButton_(
            isDeletionInProgress_, isNoDatatypeSelected_)]]">
      [[deleteButtonLabel_]]
    </cr-button>
    <!-- The alert must be inside the dialog for it to be read while the
         dialog is open. -->
    <div id="deletingDataAlert" role="alert">
      [[deletingDataAlertString_]]
    </div>
  </div>
</cr-dialog>

<template is="dom-if" if="[[showHistoryDeletionDialog_]]" restamp>
  <settings-history-deletion-dialog id="historyNotice"
      on-close="onHistoryDeletionDialogClose_">
  </settings-history-deletion-dialog>
</template>

<template is="dom-if" if="[[showOtherGoogleDataDialog_]]" restamp>
  <settings-other-google-data-dialog on-cancel="onOtherGoogleDataDialogClose_">
  </settings-other-google-data-dialog>
</template><!--_html_template_end_-->`;
}
