import '//resources/cr_elements/cr_icon/cr_iconset.js';
import { getTrustedHTML } from '//resources/js/static_types.js';
const div = document.createElement('div');
div.innerHTML = getTrustedHTML `<!--
List icons here rather than importing large sets of (e.g. Polymer) icons.
Keep in alphabetical ordering.
NOTE: Chrome OS icons go in ./chromeos/os_icons.html.
-->
<cr-iconset name="settings20" size="20">
  <svg>
    <defs>
      <g id="account-box"><path d="M4.5 14.3958C5.27778 13.7569 6.13889 13.2847 7.08333 12.9792C8.02778 12.6597 9 12.5 10 12.5C11 12.5 11.9722 12.6528 12.9167 12.9583C13.8611 13.2639 14.7222 13.7431 15.5 14.3958V4.5H4.5V14.3958ZM10 11.5C10.8333 11.5 11.5417 11.2083 12.125 10.625C12.7083 10.0417 13 9.33333 13 8.5C13 7.66667 12.7083 6.95833 12.125 6.375C11.5417 5.79167 10.8333 5.5 10 5.5C9.16667 5.5 8.45833 5.79167 7.875 6.375C7.29167 6.95833 7 7.66667 7 8.5C7 9.33333 7.29167 10.0417 7.875 10.625C8.45833 11.2083 9.16667 11.5 10 11.5ZM4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM5.52083 15.5H14.4792C13.8403 15.0139 13.1389 14.6458 12.375 14.3958C11.6111 14.1319 10.8194 14 10 14C9.18056 14 8.38889 14.1319 7.625 14.3958C6.875 14.6458 6.17361 15.0139 5.52083 15.5ZM10 10C9.58333 10 9.22917 9.85417 8.9375 9.5625C8.64583 9.27083 8.5 8.91667 8.5 8.5C8.5 8.08333 8.64583 7.72917 8.9375 7.4375C9.22917 7.14583 9.58333 7 10 7C10.4167 7 10.7708 7.14583 11.0625 7.4375C11.3542 7.72917 11.5 8.08333 11.5 8.5C11.5 8.91667 11.3542 9.27083 11.0625 9.5625C10.7708 9.85417 10.4167 10 10 10Z"></path></g>
      <g id="account-circle"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 1.667A8.336 8.336 0 0 0 1.667 10c0 4.6 3.733 8.333 8.333 8.333S18.333 14.6 18.333 10 14.6 1.667 10 1.667zM5.89 15.233c.359-.75 2.542-1.483 4.109-1.483 1.566 0 3.758.733 4.108 1.483A6.578 6.578 0 0 1 10 16.667a6.577 6.577 0 0 1-4.109-1.434zM10 12.083c1.216 0 4.108.492 5.3 1.942A6.625 6.625 0 0 0 16.666 10 6.676 6.676 0 0 0 10 3.333 6.676 6.676 0 0 0 3.333 10c0 1.517.517 2.908 1.367 4.025 1.191-1.45 4.083-1.942 5.3-1.942zM10 5a2.91 2.91 0 0 0-2.917 2.917A2.91 2.91 0 0 0 10 10.833a2.91 2.91 0 0 0 2.916-2.916A2.91 2.91 0 0 0 10 5zM8.75 7.917c0 .691.558 1.25 1.25 1.25.691 0 1.25-.559 1.25-1.25 0-.692-.559-1.25-1.25-1.25-.692 0-1.25.558-1.25 1.25z"></path></g>
      <g id="account-circle-filled" viewBox="0 -960 960 960"><path d="M237-285q54-38 115.5-56.5T480-360q66 0 127.5 18.5T723-285q35-41 52-91t17-104q0-129.67-91.23-220.84-91.23-91.16-221-91.16Q350-792 259-700.84 168-609.67 168-480q0 54 17 104t52 91Zm243-123q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42Zm.28 312Q401-96 331-126t-122.5-82.5Q156-261 126-330.96t-30-149.5Q96-560 126-629.5q30-69.5 82.5-122T330.96-834q69.96-30 149.5-30t149.04 30q69.5 30 122 82.5T834-629.28q30 69.73 30 149Q864-401 834-331t-82.5 122.5Q699-156 629.28-126q-69.73 30-149 30Z"></path></g>
      <g id="archive"><path d="M4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V5.625C3 5.43055 3.03472 5.24306 3.10417 5.0625C3.1875 4.86805 3.29861 4.70139 3.4375 4.5625L4.5625 3.4375C4.70139 3.29861 4.86111 3.19444 5.04167 3.125C5.23611 3.04167 5.43056 3 5.625 3H14.375C14.5694 3 14.7569 3.04167 14.9375 3.125C15.1319 3.19444 15.2986 3.29861 15.4375 3.4375L16.5625 4.5625C16.7014 4.70139 16.8056 4.86805 16.875 5.0625C16.9583 5.24306 17 5.43055 17 5.625V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM4.625 5.5H15.375L14.375 4.5H5.625L4.625 5.5ZM4.5 7V15.5H15.5V7H4.5ZM10 14.25L13 11.25L11.9375 10.1875L10.75 11.375V8.25H9.25V11.375L8.0625 10.1875L7 11.25L10 14.25ZM4.5 15.5H15.5H4.5Z"></path></g>
      <g id="arrow-selector-tool" viewBox="0 -960 960 960"><path d="m320-410 79-110h170L320-716v306ZM551-80 406-392 240-160v-720l560 440H516l144 309-109 51ZM399-520Z"></path></g>
      <g id="auto-delete"><path d="M6.5 5.5v10ZM9.396 17H6.5q-.625 0-1.062-.438Q5 16.125 5 15.5v-10H4V4h4V3h4v1h4v1.5h-1v3.104q-.375-.062-.75-.094-.375-.031-.75.011V5.5h-7v10h2.208q.104.396.282.771.177.375.406.729ZM8 14h.5q0-1.458.5-2.312l.5-.855V7H8Zm2.5-4.25q.292-.229.677-.469.385-.239.823-.406V7h-1.5ZM14 18q-1.667 0-2.833-1.167Q10 15.667 10 14q0-1.667 1.167-2.833Q12.333 10 14 10q1.667 0 2.833 1.167Q18 12.333 18 14q0 1.667-1.167 2.833Q15.667 18 14 18Zm1.146-2.146.708-.708-1.354-1.354V12h-1v2.208Z"></path></g>
      <g id="auto-summarize"><path d="M5.83333 9.16665V7.49998H10.8333V9.16665H5.83333ZM5.83333 12.5V10.8333H17.5V12.5H5.83333ZM5.83333 15.8333V14.1666H17.5V15.8333H5.83333ZM3.33333 9.16665C3.09722 9.16665 2.89931 9.08679 2.73958 8.92706C2.57986 8.76734 2.5 8.56942 2.5 8.33331C2.5 8.0972 2.57986 7.89929 2.73958 7.73956C2.89931 7.57984 3.09722 7.49998 3.33333 7.49998C3.56944 7.49998 3.76736 7.57984 3.92708 7.73956C4.08681 7.89929 4.16667 8.0972 4.16667 8.33331C4.16667 8.56942 4.08681 8.76734 3.92708 8.92706C3.76736 9.08679 3.56944 9.16665 3.33333 9.16665ZM3.33333 12.5C3.09722 12.5 2.89931 12.4201 2.73958 12.2604C2.57986 12.1007 2.5 11.9028 2.5 11.6666C2.5 11.4305 2.57986 11.2326 2.73958 11.0729C2.89931 10.9132 3.09722 10.8333 3.33333 10.8333C3.56944 10.8333 3.76736 10.9132 3.92708 11.0729C4.08681 11.2326 4.16667 11.4305 4.16667 11.6666C4.16667 11.9028 4.08681 12.1007 3.92708 12.2604C3.76736 12.4201 3.56944 12.5 3.33333 12.5ZM3.33333 15.8333C3.09722 15.8333 2.89931 15.7535 2.73958 15.5937C2.57986 15.434 2.5 15.2361 2.5 15C2.5 14.7639 2.57986 14.566 2.73958 14.4062C2.89931 14.2465 3.09722 14.1666 3.33333 14.1666C3.56944 14.1666 3.76736 14.2465 3.92708 14.4062C4.08681 14.566 4.16667 14.7639 4.16667 15C4.16667 15.2361 4.08681 15.434 3.92708 15.5937C3.76736 15.7535 3.56944 15.8333 3.33333 15.8333ZM14.5833 9.99998C14.5833 8.7222 15.0278 7.63887 15.9167 6.74998C16.8056 5.86109 17.8889 5.41665 19.1667 5.41665C17.8889 5.41665 16.8056 4.9722 15.9167 4.08331C15.0278 3.19442 14.5833 2.11109 14.5833 0.833313C14.5833 2.11109 14.1389 3.19442 13.25 4.08331C12.3611 4.9722 11.2778 5.41665 10 5.41665C11.2778 5.41665 12.3611 5.86109 13.25 6.74998C14.1389 7.63887 14.5833 8.7222 14.5833 9.99998Z"></path></g>
      <g id="auto-tab-group"><path d="M6.5 3.5C6.5 3.81944 6.5 4.14583 6.5 4.47917C6.5 4.8125 6.5 5.15972 6.5 5.52083C6.5 7.03472 6.5 8.32639 6.5 9.39583C6.5 10.4653 6.5 11 6.5 11C6.5 11 6.5 10.9653 6.5 10.8958C6.5 10.8264 6.5 10.7292 6.5 10.6042V13.5V3.5ZM3.5 18C3.08333 18 2.72917 17.8542 2.4375 17.5625C2.14583 17.2708 2 16.9167 2 16.5V5H3.5V16.5H15V18H3.5ZM6.5 15C6.08333 15 5.72917 14.8542 5.4375 14.5625C5.14583 14.2708 5 13.9167 5 13.5V3.5C5 3.08333 5.14583 2.72917 5.4375 2.4375C5.72917 2.14583 6.08333 2 6.5 2H10.2708C10.0764 2.22222 9.90278 2.45833 9.75 2.70833C9.61111 2.95833 9.48611 3.22222 9.375 3.5H6.5V13.5H16.5V10.6042C16.7778 10.4931 17.0417 10.3681 17.2917 10.2292C17.5417 10.0764 17.7778 9.90278 18 9.70833V13.5C18 13.9167 17.8542 14.2708 17.5625 14.5625C17.2708 14.8542 16.9167 15 16.5 15H6.5ZM14.5 10C14.5 8.75 14.0625 7.6875 13.1875 6.8125C12.3125 5.9375 11.25 5.5 10 5.5C11.25 5.5 12.3125 5.0625 13.1875 4.1875C14.0625 3.3125 14.5 2.25 14.5 0.999999C14.5 2.25 14.9375 3.3125 15.8125 4.1875C16.6875 5.0625 17.75 5.5 19 5.5C17.75 5.5 16.6875 5.9375 15.8125 6.8125C14.9375 7.6875 14.5 8.75 14.5 10Z"></path></g>
      <g id="background-replace"><path d="M3 8.104V6.333L6.333 3h1.792Zm0-3.896V3h1.208Zm10.188 1.521Q13 5.5 12.76 5.281q-.239-.219-.51-.385L14.167 3h1.791Zm-8.73 6.938 2.063-2.042q.167.25.364.458.198.209.365.375l-.25.25q-.625.146-1.312.407-.688.26-1.23.552Zm9.667-3.979q0-.021.021-.136.021-.114.021-.156 0-.354-.052-.688-.053-.333-.157-.625L17 4.062v1.771Zm-5.354-4.23L10.271 3h1.771l-1.313 1.312q-.187-.041-.364-.052-.177-.01-.344-.01-.354 0-.667.052-.312.052-.583.156Zm-5.729 7.521v-1.771l3.062-3.041q-.104.291-.166.604-.063.312-.063.625 0 .166.01.333.011.167.053.354Zm13.729 1.833q-.167-.25-.365-.479-.198-.229-.489-.416L17 11.854v1.75ZM14.5 12.188q-.125-.042-.292-.105-.166-.062-.312-.104-.167-.062-.354-.114-.188-.053-.375-.094L17 7.938v1.791Zm-4.479-.688q-1.313 0-2.219-.917-.906-.916-.906-2.187 0-1.292.906-2.208.906-.917 2.219-.917 1.291 0 2.198.917.906.916.906 2.208 0 1.271-.906 2.187-.907.917-2.198.917Zm0-1.5q.667 0 1.135-.469.469-.469.469-1.135 0-.667-.469-1.146-.468-.479-1.135-.479t-1.146.479q-.479.479-.479 1.146 0 .666.479 1.135t1.146.469ZM4 17v-1.5q0-.604.323-1.125t.865-.813q1.124-.583 2.333-.895 1.208-.313 2.479-.313 1.25 0 2.458.313 1.209.312 2.334.895.541.292.875.813.333.521.333 1.125V17Zm1.5-1.5h9q0-.208-.125-.354t-.292-.25q-.937-.5-1.979-.771T10 13.854q-1.062 0-2.104.261-1.042.26-1.979.76-.188.104-.302.26-.115.157-.115.365Z"></path></g>
      <g id="bar-chart"><path fill-rule="evenodd" clip-rule="evenodd" d="M4 16V8h3v8Zm4.5 0V4h3v12Zm4.5 0v-6h3v6Z"></path></g>
      <g id="block"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.99984 1.66667C5.39984 1.66667 1.6665 5.40001 1.6665 10C1.6665 14.6 5.39984 18.3333 9.99984 18.3333C14.5998 18.3333 18.3332 14.6 18.3332 10C18.3332 5.40001 14.5998 1.66667 9.99984 1.66667ZM3.33317 10C3.33317 6.31667 6.3165 3.33334 9.99984 3.33334C11.5415 3.33334 12.9582 3.85834 14.0832 4.74167L4.7415 14.0833C3.85817 12.9583 3.33317 11.5417 3.33317 10ZM5.9165 15.2583C7.0415 16.1417 8.45817 16.6667 9.99984 16.6667C13.6832 16.6667 16.6665 13.6833 16.6665 10C16.6665 8.45834 16.1415 7.04167 15.2582 5.91667L5.9165 15.2583Z"></path></g>
      <g id="bolt"><path d="M9.16672 17.5H8.33339L9.16672 11.6667H6.25005C5.76672 11.6667 5.77505 11.4 5.93339 11.1167C6.09172 10.8333 5.97505 11.05 5.99172 11.0167C7.06672 9.11667 8.68339 6.28333 10.8334 2.5H11.6667L10.8334 8.33333H13.7501C14.1584 8.33333 14.2167 8.60833 14.1417 8.75833L14.0834 8.88333C10.8001 14.625 9.16672 17.5 9.16672 17.5Z"></path></g>
      <g id="broken"><path fill-rule="evenodd" clip-rule="evenodd" d="M15.8333 2.5H4.16667C3.25 2.5 2.5 3.25 2.5 4.16667V15.8333C2.5 16.75 3.25 17.5 4.16667 17.5H15.8333C16.75 17.5 17.5 16.75 17.5 15.8333V4.16667C17.5 3.25 16.75 2.5 15.8333 2.5ZM15.8333 4.16667V9.29167L14 7L11.3333 10.3333L8.66667 7L6 10.3333L4.16667 8.04167V4.16667H15.8333ZM4.16667 10.7083V15.8333H15.8417V11.9583L14.0083 9.66667L11.3333 13L8.66667 9.66667L6 13L4.16667 10.7083Z"></path></g>
      <g id="checklist"><path d="M4.833 15.5 2 12.667l1.062-1.063 1.75 1.771 3.542-3.542 1.084 1.063Zm0-6.5L2 6.167l1.062-1.063 1.771 1.771 3.521-3.542 1.084 1.063ZM11 14v-1.5h7V14Zm0-6.5V6h7v1.5Z"></path></g>
      <g id="chrome-filled"><path d="M6.875 10.0208C6.875 10.8958 7.17361 11.6389 7.77083 12.25C8.38194 12.8472 9.125 13.1458 10 13.1458C10.875 13.1458 11.6111 12.8472 12.2083 12.25C12.8194 11.6389 13.125 10.8958 13.125 10.0208C13.125 9.14583 12.8194 8.40972 12.2083 7.8125C11.6111 7.20139 10.875 6.89583 10 6.89583C9.125 6.89583 8.38194 7.20139 7.77083 7.8125C7.17361 8.40972 6.875 9.14583 6.875 10.0208ZM10 14.7083C10.1528 14.7083 10.3125 14.7083 10.4792 14.7083C10.6458 14.6944 10.8125 14.6667 10.9792 14.625L8.85417 18.25C6.78472 18.0139 5.06944 17.1111 3.70833 15.5417C2.36111 13.9722 1.6875 12.1319 1.6875 10.0208C1.6875 9.40972 1.75694 8.80556 1.89583 8.20833C2.03472 7.61111 2.24306 7.02083 2.52083 6.4375L5.97917 12.3542C6.38194 13.0903 6.94444 13.6667 7.66667 14.0833C8.38889 14.5 9.16667 14.7083 10 14.7083ZM10 5.33333C8.97222 5.33333 8.05556 5.63889 7.25 6.25C6.44444 6.84722 5.88889 7.625 5.58333 8.58333L3.45833 4.91667C4.22222 3.90278 5.17361 3.11805 6.3125 2.5625C7.46528 1.99305 8.69444 1.70833 10 1.70833C11.375 1.70833 12.6667 2.03472 13.875 2.6875C15.0833 3.32639 16.0694 4.20833 16.8333 5.33333H10ZM17.6875 6.89583C17.9097 7.40972 18.0694 7.93056 18.1667 8.45833C18.2639 8.97222 18.3125 9.49306 18.3125 10.0208C18.3125 12.2569 17.5903 14.1389 16.1458 15.6667C14.7014 17.1806 12.8681 18.0556 10.6458 18.2917L14.0208 12.3542C14.2292 11.9931 14.3889 11.6181 14.5 11.2292C14.625 10.8403 14.6875 10.4375 14.6875 10.0208C14.6875 9.4375 14.5764 8.88194 14.3542 8.35417C14.1458 7.8125 13.8542 7.32639 13.4792 6.89583H17.6875Z"></path></g>
      <g id="cloud-off"><path d="M16.4732571,13.3443682 C16.8002856,12.9882746 17,12.5134184 17,11.9922 C17,10.8882 16.104,9.9922 15,9.9922 L13.494,9.9922 L13.494,9.0002 C13.494,7.0672 11.927,5.5002 9.994,5.5002 C9.5847901,5.5002 9.1930204,5.57089988 8.82954884,5.70065995 L7.33083687,4.20194798 C8.11843435,3.75577808 9.02717677,3.5002 10,3.5002 C12.71,3.5002 14.957,5.4612 15.411,8.0412 C17.424,8.2502 19,9.9312 19,12.0002 C19,13.0718701 18.5784721,14.0451601 17.8921876,14.7632987 L16.4732571,13.3443682 Z M17.8711111,17 L16.8711111,18 L14.8713111,16.0002 L6,16.0002 C3.239,16.0002 1,13.7622 1,11.0002 C1,8.58475294 2.71868905,6.59044755 4.99627833,6.12516722 L2,3.12888889 L3,2.12888889 L17.8711111,17 Z M6.86331111,7.9922 L6,7.9922 C4.343,7.9922 3,9.3352 3,10.9922 C3,12.6492 4.343,13.9922 6,13.9922 L12.8633111,13.9922 L6.86331111,7.9922 Z"></path></g>
      <g id="credit-card"><path d="M16.4,4 L3.6,4 C2.716,4 2.008,4.7271875 2.008,5.625 L2,15.375 C2,16.2728125 2.716,17 3.6,17 L16.4,17 C17.284,17 18,16.2728125 18,15.375 L18,5.625 C18,4.7271875 17.284,4 16.4,4 Z M16.5,15 L3.5,15 L3.5,10 L16.5,10 L16.5,15 Z M16.5,7 L3.5,7 L3.5,5.5 L16.5,5.5 L16.5,7 Z"></path></g>
      <g id="dashboard"><path d="M3 10.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.74306 3.14583 4.09722 3 4.5 3H9.25V10.5H3ZM10.75 3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V8H10.75V3ZM10.75 17V9.5H17V15.5C17 15.9028 16.8542 16.2569 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H10.75ZM3 12H9.25V17H4.5C4.09722 17 3.74306 16.8542 3.4375 16.5625C3.14583 16.2569 3 15.9028 3 15.5V12ZM4.5 9H7.75V4.5H4.5V9ZM12.25 6.5H15.5V4.5H12.25V6.5ZM12.25 11V15.5H15.5V11H12.25ZM4.5 13.5V15.5H7.75V13.5H4.5Z"></path></g>
      <g id="data"><path d="M0 0h20v20H0z" fill="none" fill-rule="evenodd"></path><path d="M6.5 7v9H4V7h2.5zm5-3v12H9V4h2.5zm5 7v5H14v-5h2.5z"></path></g>
      <g id="data-connectors-system"><path d="M10 4.16667C10.0833 4.16667 10.2333 4.18333 10.3667 4.30833L13.025 6.96667L15.675 9.60833C15.8083 9.74167 15.825 9.9 15.825 10.0167V10.0417C15.825 10.125 15.8 10.2 15.7667 10.2667C15.7583 10.2833 15.75 10.3 15.7417 10.3083C15.725 10.3333 15.7 10.3667 15.675 10.3917L10.4 15.65L10.3583 15.6917C10.2333 15.8167 10.0833 15.8333 10 15.8333C9.91667 15.8333 9.75 15.8167 9.61667 15.675L4.325 10.3833C4.18333 10.2583 4.16667 10.1 4.16667 9.99167C4.16667 9.90833 4.18333 9.75 4.31667 9.60833L6.44167 7.48333L9.60833 4.325C9.75 4.18333 9.91667 4.16667 10 4.16667ZM10 2.5C9.43333 2.5 8.86667 2.71667 8.44167 3.14167L5.275 6.3L3.15 8.425C2.70833 8.85833 2.5 9.43333 2.5 10C2.5 10.5667 2.70833 11.1417 3.14167 11.575L5.26667 13.7L8.43333 16.8583C8.86667 17.2833 9.43333 17.5 10 17.5C10.5667 17.5 11.1333 17.2833 11.5583 16.8583L16.8583 11.575C16.9667 11.4667 17.0583 11.35 17.1417 11.2333C17.1833 11.175 17.2167 11.1083 17.25 11.05C17.4167 10.7333 17.5 10.375 17.5 10.025C17.5 10.0167 17.5 10.0167 17.5 10.0083C17.5083 9.44167 17.2917 8.86667 16.8583 8.43333L11.5583 3.15C11.1333 2.71667 10.5667 2.5 10 2.5Z"></path><path d="M10 11.6667L8.33333 10L10 8.33333L11.6667 10L10 11.6667Z"></path><path d="M10.5917 7.25833C10.9167 6.93333 10.9167 6.40833 10.5917 6.08333C10.2667 5.75833 9.74167 5.75833 9.41667 6.08333C9.09167 6.40833 9.09167 6.93333 9.41667 7.25833C9.73333 7.58333 10.2667 7.58333 10.5917 7.25833Z"></path><path d="M7.25833 10.5917C7.58333 10.2667 7.58333 9.74167 7.25833 9.41667C6.93333 9.09167 6.40833 9.09167 6.08333 9.41667C5.75833 9.74167 5.75833 10.2667 6.08333 10.5917C6.4 10.9167 6.93333 10.9167 7.25833 10.5917Z"></path><path d="M10.5917 13.925C10.9167 13.6 10.9167 13.075 10.5917 12.75C10.2667 12.425 9.74167 12.425 9.41667 12.75C9.09167 13.075 9.09167 13.6 9.41667 13.925C9.73333 14.25 10.2667 14.25 10.5917 13.925Z"></path><path d="M13.925 10.5917C14.25 10.2667 14.25 9.74167 13.925 9.41667C13.6 9.09167 13.075 9.09167 12.75 9.41667C12.425 9.74167 12.425 10.2667 12.75 10.5917C13.0667 10.9167 13.6 10.9167 13.925 10.5917Z"></g>
      <g id="delete"><path d="M6.5 17q-.625 0-1.062-.438Q5 16.125 5 15.5v-10H4V4h4V3h4v1h4v1.5h-1v10q0 .625-.438 1.062Q14.125 17 13.5 17Zm7-11.5h-7v10h7ZM8 14h1.5V7H8Zm2.5 0H12V7h-1.5Zm-4-8.5v10Z"></path></g>
      <g id="delete-forever"><path fill-rule="evenodd" clip-rule="evenodd" d="M12.4999 3.33333V2.5H7.49992V3.33333H3.33325V5H4.16659V15.8333C4.16659 16.75 4.91659 17.5 5.83325 17.5H14.1666C15.0833 17.5 15.8333 16.75 15.8333 15.8333V5H16.6666V3.33333H12.4999ZM14.1666 5V15.8333H5.83325V5H14.1666ZM9.99992 11.5917L7.84158 13.75L6.66658 12.575L8.82492 10.4167L6.66658 8.25833L7.84158 7.08333L9.99992 9.24167L12.1583 7.08333L13.3333 8.25833L11.1749 10.4167L13.3333 12.575L12.1583 13.75L9.99992 11.5917Z"></path></g>
      <g id="difference"><path d="M10.25 9.5H11.75V8H13.25V6.5H11.75V5H10.25V6.5H8.75V8H10.25V9.5ZM8.75 12.5H13.25V11H8.75V12.5ZM6.5 16C6.09722 16 5.74306 15.8542 5.4375 15.5625C5.14583 15.2569 5 14.9028 5 14.5V2.5C5 2.09722 5.14583 1.75 5.4375 1.45833C5.74306 1.15278 6.09722 0.999999 6.5 0.999999H13L17 5V14.5C17 14.9028 16.8472 15.2569 16.5417 15.5625C16.25 15.8542 15.9028 16 15.5 16H6.5ZM6.5 14.5H15.5V5.625L12.375 2.5H6.5V14.5ZM3.5 19C3.09722 19 2.74306 18.8542 2.4375 18.5625C2.14583 18.2569 2 17.9028 2 17.5V6H3.5V17.5H12.5V19H3.5ZM6.5 14.5V2.5V6.5625V14.5Z"></path></g>
      <g id="dns"><path fill-rule="evenodd" clip-rule="evenodd" d="M16.6667 2.5H3.33333C2.875 2.5 2.5 2.875 2.5 3.33333V9.16667C2.5 9.625 2.875 10 3.33333 10H16.6667C17.125 10 17.5 9.625 17.5 9.16667V3.33333C17.5 2.875 17.125 2.5 16.6667 2.5ZM7.5 6.25C7.5 6.94036 6.94036 7.5 6.25 7.5C5.55964 7.5 5 6.94036 5 6.25C5 5.55964 5.55964 5 6.25 5C6.94036 5 7.5 5.55964 7.5 6.25ZM7.5 14.5833C7.5 15.2737 6.94036 15.8333 6.25 15.8333C5.55964 15.8333 5 15.2737 5 14.5833C5 13.893 5.55964 13.3333 6.25 13.3333C6.94036 13.3333 7.5 13.893 7.5 14.5833ZM4.16667 8.33333H15.8333V4.16667H4.16667V8.33333ZM16.6667 10.8333H3.33333C2.875 10.8333 2.5 11.2083 2.5 11.6667V17.5C2.5 17.9583 2.875 18.3333 3.33333 18.3333H16.6667C17.125 18.3333 17.5 17.9583 17.5 17.5V11.6667C17.5 11.2083 17.125 10.8333 16.6667 10.8333ZM4.16667 16.6667H15.8333V12.5H4.16667V16.6667Z"></path></g>
      <g id="download"><path d="M 10 13.292969 L 5.230469 8.519531 L 6.644531 7.144531 L 9.019531 9.519531 L 9.019531 2.792969 L 10.980469 2.792969 L 10.980469 9.519531 L 13.355469 7.144531 L 14.769531 8.519531 Z M 4.769531 17.1875 C 4.226562 17.1875 3.765625 16.996094 3.386719 16.613281 C 3.003906 16.234375 2.8125 15.773438 2.8125 15.230469 L 2.8125 12.25 L 4.769531 12.25 L 4.769531 15.230469 L 15.230469 15.230469 L 15.230469 12.25 L 17.207031 12.25 L 17.207031 15.230469 C 17.207031 15.769531 17.015625 16.234375 16.628906 16.613281 C 16.246094 16.996094 15.777344 17.1875 15.230469 17.1875 Z M 4.769531 17.1875"></path></g>
      <g id="edit-square"><path d="M 4.167969 17.5 C 3.707031 17.5 3.316406 17.335938 2.988281 17.011719 C 2.664062 16.683594 2.5 16.292969 2.5 15.832031 L 2.5 4.167969 C 2.5 3.707031 2.664062 3.316406 2.988281 2.988281 C 3.316406 2.664062 3.707031 2.5 4.167969 2.5 L 11.605469 2.5 L 9.9375 4.167969 L 4.167969 4.167969 L 4.167969 15.832031 L 15.832031 15.832031 L 15.832031 10.042969 L 17.5 8.375 L 17.5 15.832031 C 17.5 16.292969 17.335938 16.683594 17.011719 17.011719 C 16.683594 17.335938 16.292969 17.5 15.832031 17.5 Z M 10 10 Z M 7.5 12.5 L 7.5 8.957031 L 15.144531 1.3125 C 15.3125 1.144531 15.5 1.019531 15.707031 0.9375 C 15.917969 0.855469 16.125 0.8125 16.332031 0.8125 C 16.554688 0.8125 16.765625 0.855469 16.96875 0.9375 C 17.171875 1.019531 17.355469 1.144531 17.519531 1.3125 L 18.6875 2.5 C 18.839844 2.667969 18.957031 2.851562 19.042969 3.050781 C 19.125 3.253906 19.167969 3.457031 19.167969 3.667969 C 19.167969 3.875 19.128906 4.078125 19.050781 4.28125 C 18.976562 4.484375 18.855469 4.667969 18.6875 4.832031 L 11.042969 12.5 Z M 17.519531 3.667969 L 16.355469 2.5 Z M 9.167969 10.832031 L 10.332031 10.832031 L 15.167969 6 L 14.582031 5.417969 L 13.980469 4.832031 L 9.167969 9.644531 Z M 14.582031 5.417969 L 13.980469 4.832031 L 14.582031 5.417969 L 15.167969 6 Z M 14.582031 5.417969 "></path></g>
      <g id="experiment"><path d="M17.2667 14.7583L12.5 8.18332V4.23332H14.1667V2.56665H5.83332V4.23332H7.49998V8.17498L2.61665 14.9166C2.24998 15.425 2.19998 16.0917 2.48332 16.65C2.76665 17.2083 3.34165 17.5583 3.96665 17.5583H16.05C16.9667 17.5583 17.7167 16.8083 17.7167 15.8917C17.7167 15.4583 17.5416 15.0583 17.2667 14.7583Z" fill="#5F6368"></path></g>
      <g id="my_extensions" viewBox="0 -960 960 960"><path d="M216-135.869q-33.287 0-56.709-23.422-23.422-23.422-23.422-56.709v-172.304q37.609-2 63.218-28.424 25.608-26.424 25.608-63.272t-25.608-63.272q-25.609-26.424-63.218-28.424V-744q0-33.287 23.422-56.709 23.422-23.422 56.709-23.422h161.065q2.631-40.956 31.96-69.315 29.329-28.359 70.75-28.359t70.975 28.199q29.554 28.199 32.185 69.475H744q33.287 0 56.709 23.422 23.422 23.422 23.422 56.709v161.065q40.956 2.631 69.315 31.96 28.359 29.329 28.359 70.75t-28.199 70.975q-28.199 29.554-69.475 32.185V-216q0 33.287-23.422 56.709-23.422 23.422-56.709 23.422H216Zm2.87-83.001h522.26v-522.26H218.87v108.652q42.13 22.63 65.597 63.772 23.468 41.141 23.468 88.706 0 49.01-23.468 90.168Q261-348.674 218.87-327.283v108.413ZM480-480Z"></path></g>
      <g id="fact-check" viewBox="0 -960 960 960"><path d="M168-144q-29.7 0-50.85-21.15Q96-186.3 96-216v-528q0-29.7 21.15-50.85Q138.3-816 168-816h624q29.7 0 50.85 21.15Q864-773.7 864-744v528q0 29.7-21.15 50.85Q821.7-144 792-144H168Zm0-72h624v-528H168v528Zm43-71h192v-72H211v72Zm371-73 170-170-51-51-119 119-51-51-51 51 102 102Zm-371-84h192v-72H211v72Zm0-156h192v-72H211v72Zm-43 384v-528 528Z"></path></g>
      <g id="file-save"><path d="M15.25 17.5L18.25 14.5L17.1875 13.4375L16 14.625V11.5H14.5V14.625L13.3125 13.4375L12.25 14.5L15.25 17.5ZM12.25 20V18.5H18.25V20H12.25ZM5.5 17C5.09722 17 4.74306 16.8542 4.4375 16.5625C4.14583 16.2569 4 15.9028 4 15.5V3.5C4 3.09722 4.14583 2.75 4.4375 2.45833C4.74306 2.15278 5.09722 2 5.5 2H12L16 6V10H14.5V7H11V3.5H5.5V15.5H11V17H5.5ZM5.5 15.5V9.41667V7.45833V3.5V15.5Z"></path></g>
      <g id="filter-list"><path d="M8 14.5V13h4v1.5Zm-3-3.75v-1.5h10v1.5ZM3 7V5.5h14V7Z"></path></g>
      <g id="flash-on"><path d="M5.83337 1.66666V10.8333H8.33337V18.3333L14.1667 8.33332H10.8334L13.3334 1.66666H5.83337Z"></path></g>
      <g id="gavel" viewBox="0 -960 960 960"><path d="M160-120v-80h480v80H160Zm226-194L160-540l84-86 228 226-86 86Zm254-254L414-796l86-84 226 226-86 86Zm184 408L302-682l56-56 522 522-56 56Z"></path></g>
      <g id="googleg"><path d="M16.58 8H9v2.75h4.47c-.24 1.2-1.42 3.27-4.47 3.27-2.72 0-4.93-2.25-4.93-5.02S6.28 3.98 9 3.98c1.54 0 2.57.66 3.17 1.22l2.19-2.12C12.97 1.79 11.16 1 9 1 4.58 1 1 4.58 1 9s3.58 8 8 8c4.62 0 7.68-3.25 7.68-7.82 0-.46-.04-.83-.1-1.18z"></path></g>
      <g id="google-lens-2"><path d="M15.5 11V7.5C15.5 7.08333 15.3542 6.72917 15.0625 6.4375C14.7708 6.14583 14.4167 6 14 6H6C5.58333 6 5.22917 6.14583 4.9375 6.4375C4.64583 6.72917 4.5 7.08333 4.5 7.5V10H3V7.5C3 6.66667 3.29167 5.95833 3.875 5.375C4.45833 4.79167 5.16667 4.5 6 4.5H7.75L8.5 3H11.5L12.25 4.5H14C14.8333 4.5 15.5417 4.79167 16.125 5.375C16.7083 5.95833 17 6.66667 17 7.5V11H15.5ZM6 17C5.16667 17 4.45833 16.7083 3.875 16.125C3.29167 15.5417 3 14.8333 3 14V12.5H4.5V14C4.5 14.4167 4.64583 14.7708 4.9375 15.0625C5.22917 15.3542 5.58333 15.5 6 15.5H10V17H6ZM15 16.5C14.5833 16.5 14.2292 16.3542 13.9375 16.0625C13.6458 15.7708 13.5 15.4167 13.5 15C13.5 14.5833 13.6458 14.2292 13.9375 13.9375C14.2292 13.6458 14.5833 13.5 15 13.5C15.4167 13.5 15.7708 13.6458 16.0625 13.9375C16.3542 14.2292 16.5 14.5833 16.5 15C16.5 15.4167 16.3542 15.7708 16.0625 16.0625C15.7708 16.3542 15.4167 16.5 15 16.5ZM10 13.5C9.30556 13.5 8.71528 13.2569 8.22917 12.7708C7.74306 12.2847 7.5 11.6944 7.5 11C7.5 10.3056 7.74306 9.71528 8.22917 9.22917C8.71528 8.74305 9.30556 8.5 10 8.5C10.6944 8.5 11.2847 8.74305 11.7708 9.22917C12.2569 9.71528 12.5 10.3056 12.5 11C12.5 11.6944 12.2569 12.2847 11.7708 12.7708C11.2847 13.2569 10.6944 13.5 10 13.5Z"></path></g>
      <g id="gshield"><path d="M 10.089844 13.9375 C 11.410156 13.9375 12.46875 13.519531 13.265625 12.6875 C 14.058594 11.855469 14.457031 10.785156 14.457031 9.46875 C 14.457031 9.296875 14.449219 9.136719 14.425781 8.988281 C 14.40625 8.84375 14.378906 8.703125 14.351562 8.5625 L 10.082031 8.5625 L 10.082031 10.105469 L 12.75 10.105469 C 12.707031 10.546875 12.484375 11.027344 12.074219 11.542969 C 11.664062 12.054688 11 12.3125 10.085938 12.3125 C 9.277344 12.3125 8.601562 12.023438 8.050781 11.445312 C 7.503906 10.871094 7.230469 10.179688 7.230469 9.375 C 7.230469 8.570312 7.503906 7.882812 8.054688 7.3125 C 8.601562 6.742188 9.277344 6.457031 10.074219 6.457031 C 10.523438 6.457031 10.90625 6.535156 11.21875 6.6875 C 11.53125 6.839844 11.773438 7 11.945312 7.167969 L 13.144531 6.003906 C 12.738281 5.644531 12.28125 5.359375 11.777344 5.148438 C 11.273438 4.9375 10.707031 4.832031 10.082031 4.832031 C 8.8125 4.832031 7.738281 5.273438 6.859375 6.15625 C 5.980469 7.039062 5.542969 8.109375 5.542969 9.375 C 5.542969 10.640625 5.984375 11.714844 6.863281 12.605469 C 7.746094 13.492188 8.820312 13.9375 10.089844 13.9375 Z M 10 18.75 C 9.882812 18.75 9.773438 18.738281 9.667969 18.71875 C 9.5625 18.699219 9.464844 18.667969 9.375 18.625 C 7.375 17.972656 5.78125 16.738281 4.59375 14.925781 C 3.40625 13.109375 2.8125 11.171875 2.8125 9.101562 L 2.8125 5.167969 C 2.8125 4.746094 2.925781 4.363281 3.152344 4.015625 C 3.382812 3.671875 3.691406 3.429688 4.082031 3.292969 L 9.3125 1.332031 C 9.535156 1.25 9.765625 1.207031 10 1.207031 C 10.234375 1.207031 10.464844 1.25 10.6875 1.332031 L 15.917969 3.292969 C 16.308594 3.429688 16.621094 3.671875 16.855469 4.015625 C 17.089844 4.363281 17.207031 4.746094 17.207031 5.167969 L 17.207031 9.101562 C 17.207031 11.171875 16.609375 13.109375 15.417969 14.925781 C 14.222656 16.738281 12.625 17.972656 10.625 18.625 C 10.535156 18.667969 10.4375 18.699219 10.332031 18.71875 C 10.226562 18.738281 10.117188 18.75 10 18.75 Z M 10 16.855469 C 11.527344 16.257812 12.78125 15.257812 13.761719 13.855469 C 14.738281 12.453125 15.230469 10.871094 15.230469 9.109375 L 15.230469 5.167969 L 10 3.1875 L 4.769531 5.175781 L 4.769531 9.101562 C 4.769531 10.867188 5.261719 12.453125 6.238281 13.855469 C 7.21875 15.257812 8.472656 16.257812 10 16.855469 Z M 10 10.019531 Z M 10 10.019531"></path></g>
      <g id="history"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.33341 5.00832V3.33332H1.66675V8.33332H6.66675V6.66666H4.24175C5.39175 4.67499 7.53341 3.33332 10.0001 3.33332C13.6834 3.33332 16.6667 6.31666 16.6667 9.99999C16.6667 13.6833 13.6834 16.6667 10.0001 16.6667C6.31675 16.6667 3.33341 13.6833 3.33341 9.99999H1.66675C1.66675 14.6 5.40008 18.3333 10.0084 18.3333C14.6084 18.3333 18.3334 14.6 18.3334 9.99999C18.3334 5.39999 14.6084 1.66666 10.0084 1.66666C7.27508 1.66666 4.85841 2.98332 3.33341 5.00832ZM10.8334 4.99999V9.99999L14.3584 12.45L13.3084 13.7417L9.16675 10.8333V4.99999H10.8334Z"></path></g>
      <g id="home" viewBox="0 -960 960 960"><path d="M264-216h96v-240h240v240h96v-348L480-726 264-564v348Zm-72 72v-456l288-216 288 216v456H528v-240h-96v240H192Zm288-327Z"></path></g>
      <g id="hourglass" viewBox="0 -960 960 960"><path d="M324-168h312v-120q0-65-45.5-110.5T480-444q-65 0-110.5 45.5T324-288v120Zm156-348q65 0 110.5-45.5T636-672v-120H324v120q0 65 45.5 110.5T480-516ZM192-96v-72h60v-120q0-59 28-109.5t78-82.5q-49-32-77.5-82.5T252-672v-120h-60v-72h576v72h-60v120q0 59-28.5 109.5T602-480q50 32 78 82.5T708-288v120h60v72H192Zm288-72Zm0-624Z"></path></g>
      <g id="id-card" viewBox="0 -960 960 960"><path d="M560-440h200v-80H560v80Zm0-120h200v-80H560v80ZM200-320h320v-22q0-45-44-71.5T360-440q-72 0-116 26.5T200-342v22Zm160-160q33 0 56.5-23.5T440-560q0-33-23.5-56.5T360-640q-33 0-56.5 23.5T280-560q0 33 23.5 56.5T360-480ZM160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h640q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160H160Zm0-80h640v-480H160v480Zm0 0v-480 480Z"></path></g>
      <g id="iban" viewBox="0 0 20 20"><path d="M1.20431 14.4502V15.9036H9.66906C9.44858 15.177 9.38637 14.4502 9.38637 14.4502H1.20431ZM4.83221 7.80922H2.84798V13.0141H4.83221V7.80922ZM13.199 7.80922H11.1811V10.2349C11.7574 9.7334 12.4427 9.35439 13.199 9.13836V7.80922ZM7.96842 1.66675L7.99158 1.67876L8.01499 1.66675H7.96842ZM14.8257 5.21445L7.99158 1.67876L1.15771 5.21445V6.66598H14.8257V5.21445ZM4.45224 5.12221L7.9684 3.44066H8.01497L11.3167 5.12221H4.45224ZM9.0358 7.80922H7.04038V13.0141H9.0358V7.80922ZM14.662 10.032C12.3572 10.032 10.4819 11.894 10.4819 14.1828C10.4819 16.4715 12.3569 18.3334 14.662 18.3334C16.9671 18.3334 18.8422 16.4715 18.8422 14.1828C18.8422 11.894 16.9668 10.032 14.662 10.032ZM14.5938 14.638C14.2882 14.3344 13.9205 14.1828 13.4914 14.1828H11.6914C11.6914 12.5561 13.0241 11.2325 14.662 11.2325C14.8868 11.2325 15.105 11.2596 15.3156 11.307C15.2638 11.3542 15.2165 11.4066 15.1742 11.4654C15.0929 11.5782 15.0523 11.7091 15.0523 11.8577H14.662C14.4474 11.8577 14.2637 11.9337 14.1106 12.0855C13.9578 12.2371 13.8813 12.4196 13.8813 12.6329V13.4081H15.4424V13.7956C15.4424 14.0087 15.5187 14.1912 15.6715 14.343C15.8245 14.4946 16.0082 14.5706 16.2229 14.5706H17.0036C17.1986 14.5706 17.3679 14.5092 17.511 14.3863C17.5568 14.347 17.5946 14.3033 17.6291 14.2576C17.5886 15.8496 16.2747 17.1329 14.662 17.1329C14.3917 17.1329 14.1307 17.0937 13.8813 17.026V16.1203H15.0521V15.7328C15.0521 15.3063 14.8995 14.9416 14.5938 14.638Z"></path></g>
      <g id="incognito" fill="#5F6368"><circle cx="6.8" cy="12.964" r="1.764"/><path d="M10 0C4.473 0 0 4.473 0 10s4.473 10 10 10 10-4.473 10-10S15.527 0 10 0zM7.619 4.1a.696.696 0 0 1 .881-.419l1.473.492 1.463-.492a.716.716 0 0 1 .883.419l1.608 4.291H6.02l1.6-4.291zm5.517 11.328a2.463 2.463 0 0 1-2.445-2.256c-.682-.436-1.237-.162-1.455-.017a2.45 2.45 0 0 1-2.445 2.263 2.471 2.471 0 0 1-2.464-2.463 2.47 2.47 0 0 1 2.463-2.464c1.165 0 2.138.809 2.391 1.9a1.934 1.934 0 0 1 1.546.009 2.462 2.462 0 0 1 2.392-1.909 2.47 2.47 0 0 1 2.462 2.463 2.435 2.435 0 0 1-2.445 2.474zM16.31 9.8H3.637v-.709H16.31V9.8h-.001z"/><circle cx="13.136" cy="12.964" r="1.764"/></g>
      <g id="incognito-unfilled"><path d="M17.5 9.16667H2.5V10H17.5V9.16667Z"></path><path d="M14.6833 8.33334L12.775 3.25001C12.6167 2.83334 12.1583 2.60834 11.7333 2.75L10 3.33334L8.25833 2.75C7.83333 2.60834 7.375 2.83334 7.21667 3.25001L5.31667 8.33334H14.6833Z"></path><path d="M13.75 10.8333C12.3667 10.8333 11.2167 11.8 10.9167 13.0917C10.2167 12.7917 9.56667 12.875 9.08333 13.0833C8.775 11.7917 7.625 10.8333 6.25 10.8333C4.64167 10.8333 3.33333 12.1417 3.33333 13.75C3.33333 15.3583 4.64167 16.6667 6.25 16.6667C7.78333 16.6667 9.025 15.4833 9.14167 13.9833C9.39167 13.8083 10.05 13.4833 10.8583 14C10.9917 15.4917 12.225 16.6667 13.75 16.6667C15.3583 16.6667 16.6667 15.3583 16.6667 13.75C16.6667 12.1417 15.3583 10.8333 13.75 10.8333ZM6.25 15.8333C5.1 15.8333 4.16667 14.9 4.16667 13.75C4.16667 12.6 5.1 11.6667 6.25 11.6667C7.4 11.6667 8.33333 12.6 8.33333 13.75C8.33333 14.9 7.4 15.8333 6.25 15.8333ZM13.75 15.8333C12.6 15.8333 11.6667 14.9 11.6667 13.75C11.6667 12.6 12.6 11.6667 13.75 11.6667C14.9 11.6667 15.8333 12.6 15.8333 13.75C15.8333 14.9 14.9 15.8333 13.75 15.8333Z"></path></g>
      <g id="interests"><path d="m2 9 4-7 4 7Zm4 8q-1.25 0-2.125-.875T3 14q0-1.25.875-2.125T6 11q1.25 0 2.125.875T9 14q0 1.25-.875 2.125T6 17Zm0-1.5q.625 0 1.062-.438Q7.5 14.625 7.5 14t-.438-1.062Q6.625 12.5 6 12.5t-1.062.438Q4.5 13.375 4.5 14t.438 1.062Q5.375 15.5 6 15.5Zm-1.396-8h2.792L6 5.021ZM11 17v-6h6v6Zm1.5-1.5h3v-3h-3ZM14 9q-1.125-.938-1.854-1.552-.729-.615-1.167-1.083-.437-.469-.614-.865t-.177-.896q0-.875.583-1.489.583-.615 1.5-.615.541 0 .969.219.427.219.76.677.333-.458.771-.677.437-.219.958-.219.917 0 1.5.615.583.614.583 1.489 0 .5-.166.896-.167.396-.604.854-.438.458-1.177 1.073Q15.125 8.042 14 9Zm0-2q1.417-1.188 1.865-1.635.447-.448.447-.782 0-.229-.166-.406Q15.979 4 15.75 4q-.167 0-.312.083-.146.084-.25.209L14 5.396l-1.167-1.104q-.125-.125-.271-.209Q12.417 4 12.25 4q-.229 0-.396.177-.166.177-.166.406 0 .355.468.813Q12.625 5.854 14 7Zm0-1.604Zm-7.979 1Zm0 7.542Zm7.958 0Z"></path></g>
      <g id="keyboard-lock"><path d="M3.332 14.168V5.832Zm.836-3.336h1.664V9.168H4.168Zm2.5 0h1.664V9.168H6.668Zm2.5 0h1.664V9.168H9.168Zm2.5 0h1.664V9.168h-1.664Zm-7.5-2.5h1.664V6.668H4.168Zm2.5 0h1.664V6.668H6.668Zm2.5 0h1.664V6.668H9.168Zm2.5 0h1.664V6.668h-1.664Zm2.5 0h1.664V6.668h-1.664Zm0 2.023c.25-.113.516-.199.8-.261a4.03 4.03 0 0 1 .864-.094v-.832h-1.664Zm-7.5 2.977h5.082c.07-.316.168-.617.293-.895.125-.277.277-.535.457-.769H6.668Zm-3.336 2.5c-.457 0-.848-.16-1.176-.488a1.599 1.599 0 0 1-.488-1.176V5.832c0-.457.16-.848.488-1.176a1.599 1.599 0 0 1 1.176-.488h13.336c.457 0 .848.16 1.176.488.328.328.488.719.488 1.176v5a3.885 3.885 0 0 0-.77-.457 4.616 4.616 0 0 0-.894-.293v-4.25H3.332v8.336h8.336v1.664Zm10.711 2.5a.67.67 0 0 1-.5-.207.68.68 0 0 1-.211-.5v-2.75c0-.195.07-.36.211-.5a.67.67 0 0 1 .5-.207h.125v-.836c0-.457.16-.848.488-1.176a1.599 1.599 0 0 1 1.176-.488c.461 0 .852.16 1.18.488.324.328.488.719.488 1.176v.836h.125c.195 0 .36.066.5.207.14.14.207.305.207.5v2.75c0 .195-.066.36-.207.5a.675.675 0 0 1-.5.207ZM15 14.168h1.668v-.836a.81.81 0 0 0-.242-.594.8.8 0 0 0-.594-.238.807.807 0 0 0-.594.238.807.807 0 0 0-.238.594Zm0 0"></path></g>
      <g id="keyboard-lock-off"><path d="M7.5 10Zm3.48 3.332H6.668v-1.664h4.312Zm-6.812-2.5V9.168h1.664v1.664Zm2.5 0V9.168h1.664v1.664Zm-2.5-2.5V6.668h1.664v1.664Zm7.5 0h1.664V6.668h-1.664Zm2.5 0h1.664V6.668h-1.664Zm0 2.023c.25-.113.516-.199.8-.261a4.03 4.03 0 0 1 .864-.094v-.832h-1.664Zm-.836.477V9.168h-1.664v.125l1.539 1.539Zm-2.5-2.5V6.668H9.168v.125l1.539 1.539Zm6.23 11.086L.582 2.918 1.75 1.75l16.5 16.5ZM10.75 8.355Zm7.582 2.477a3.885 3.885 0 0 0-.77-.457 4.616 4.616 0 0 0-.894-.293v-4.25H8.207L6.543 4.168h10.125c.457 0 .848.16 1.176.488.328.328.488.719.488 1.176Zm-15 5c-.457 0-.848-.16-1.176-.488a1.599 1.599 0 0 1-.488-1.176V5.832c0-.457.16-.848.488-1.176a1.599 1.599 0 0 1 1.176-.488h.836l1.664 1.664h-2.5v8.336h8.336v1.664Zm10.711 2.5a.67.67 0 0 1-.5-.207.68.68 0 0 1-.211-.5v-2.75c0-.195.07-.36.211-.5a.67.67 0 0 1 .5-.207h.125L17.5 17.5v.832Zm4.289-2.375-1.664-1.664v-.961a.81.81 0 0 0-.242-.594.8.8 0 0 0-.594-.238.85.85 0 0 0-.363.082.746.746 0 0 0-.281.23l-.583-.605a1.71 1.71 0 0 1 .551-.395c.215-.097.442-.144.676-.144.461 0 .852.16 1.18.488.324.328.488.719.488 1.176v.836h.125c.195 0 .36.066.5.207.14.14.207.305.207.5Zm0 0"></path></g>
      <g id="lightbulb"><path d="M7.49996 17.5C7.49996 17.9583 7.87496 18.3333 8.33329 18.3333H11.6666C12.125 18.3333 12.5 17.9583 12.5 17.5V16.6667H7.49996V17.5ZM9.99996 1.66667C6.78329 1.66667 4.16663 4.28334 4.16663 7.50001C4.16663 9.48334 5.15829 11.225 6.66663 12.2833V14.1667C6.66663 14.625 7.04163 15 7.49996 15H12.5C12.9583 15 13.3333 14.625 13.3333 14.1667V12.2833C14.8416 11.225 15.8333 9.48334 15.8333 7.50001C15.8333 4.28334 13.2166 1.66667 9.99996 1.66667ZM12.375 10.9167L11.6666 11.4167V13.3333H8.33329V11.4167L7.62496 10.9167C6.49996 10.1333 5.83329 8.85834 5.83329 7.50001C5.83329 5.20001 7.69996 3.33334 9.99996 3.33334C12.3 3.33334 14.1666 5.20001 14.1666 7.50001C14.1666 8.85834 13.5 10.1333 12.375 10.9167Z"></path></g>
      <g id="link"><path fill-rule="evenodd" clip-rule="evenodd" d="M9.16663 12.5H5.83329C4.45829 12.5 3.33329 11.375 3.33329 10C3.33329 8.62501 4.45829 7.50001 5.83329 7.50001H9.16663V5.83334H5.83329C3.53329 5.83334 1.66663 7.70001 1.66663 10C1.66663 12.3 3.53329 14.1667 5.83329 14.1667H9.16663V12.5ZM14.1666 5.83334H10.8333V7.50001H14.1666C15.5416 7.50001 16.6666 8.62501 16.6666 10C16.6666 11.375 15.5416 12.5 14.1666 12.5H10.8333V14.1667H14.1666C16.4666 14.1667 18.3333 12.3 18.3333 10C18.3333 7.70001 16.4666 5.83334 14.1666 5.83334ZM13.3333 9.16668H6.66663V10.8333H13.3333V9.16668Z"></path></g>
      <g id="location-on" viewBox="0 -960 960 960"><path d="M480.21-480Q510-480 531-501.21t21-51Q552-582 530.79-603t-51-21Q450-624 429-602.79t-21 51Q408-522 429.21-501t51 21ZM480-191q119-107 179.5-197T720-549q0-105-68.5-174T480-792q-103 0-171.5 69T240-549q0 71 60.5 161T480-191Zm0 95Q323.03-227.11 245.51-339.55 168-452 168-549q0-134 89-224.5T479.5-864q133.5 0 223 90.5T792-549q0 97-77 209T480-96Zm0-456Z"></path></g>
      <g id="logout"><path d="M14.1665 5.83333L12.9915 7.00833L15.1415 9.16667H6.6665V10.8333H15.1415L12.9915 12.9833L14.1665 14.1667L18.3332 10L14.1665 5.83333ZM3.33317 4.16667H9.99984V2.5H3.33317C2.4165 2.5 1.6665 3.25 1.6665 4.16667V15.8333C1.6665 16.75 2.4165 17.5 3.33317 17.5H9.99984V15.8333H3.33317V4.16667Z"></path></g>
      <g id="loyalty-programs" viewBox="0 -960 960 960"><path d="M116.73-511.27Q106-522 101-534.89T96-562v-205q0-29.7 21.15-50.85Q138.3-839 168-839h205q14.22 0 27.11 5Q413-829 424-818l362 362-255 257q-21 21-51 21t-51-21L116.73-511.27ZM168-562l312 312 205-205-312-312H168v205Zm83.79-85q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM735-405q-12.63-12.98-24.82-25.49Q698-443 685-455l66-66q42-42 41.5-101.5T749-725q-42-42-100-41.5T548-725l-68 65-51-51 68-65q65-62 153-62.5t151 63Q864-712 864-623t-63 152l-66 66ZM427-509Zm251-142Z"></path></g>
      <g id="magic"><path d="m11 17-2-2 2-2 2 2-2 2Zm-6-2-5-5 5-5 5 5-5 5Zm7.5-6c0-1.25-.438-2.313-1.313-3.188C10.313 4.938 9.25 4.5 8 4.5c1.25 0 2.313-.438 3.188-1.313C12.062 2.313 12.5 1.25 12.5 0c0 1.25.438 2.313 1.313 3.188C14.687 4.061 15.75 4.5 17 4.5c-1.25 0-2.313.438-3.188 1.313C12.938 6.688 12.5 7.75 12.5 9Z"></path></g>
      <g id="manage-search"><path d="M8 9H2V7h6v2zm0 3H2v2h6v-2zm12.59 7l-3.83-3.83c-.8.52-1.74.83-2.76.83-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5c0 1.02-.31 1.96-.83 2.75L22 17.59 20.59 19zM17 11c0-1.65-1.35-3-3-3s-3 1.35-3 3 1.35 3 3 3 3-1.35 3-3zM2 19h13v-2H2v2z"></path></g>
      <g id="network-ping" viewBox="0 -960 960 960"><path d="M192-237v-72h240L96-645l51-51 333 333 199-199q-3-8-5-17t-2-18q0-40 28-68t68-28q40 0 68 28t28 68q0 40-28 68t-68 28q-11 0-20.5-2t-18.5-7L528-309h240v72H192Z"></path></g>
      <g id="notification-add"><path d="M20,7.69h-2.25V10h-1.5V7.69H14V6.31h2.25V4h1.5v2.31H20V7.69z M13.5,11v3h-7V9c0-1.93,1.57-3.5,3.5-3.5 c0.58,0,1.13,0.14,1.61,0.39l1.1-1.1C12.19,4.47,11.62,4.23,11,4.1V3c0-0.55-0.45-1-1-1S9,2.45,9,3v1.1C6.72,4.56,5,6.58,5,9v5H4 v1.5h12V14h-1v-3H13.5z M10,18c0.83,0,1.5-0.67,1.5-1.5h-3C8.5,17.33,9.17,18,10,18z"></path></g>
      <g id="passkey" viewBox="0 -960 960 960"><path d="M144-192v-96q0-23 12.5-43.5T191-366q55-32 116.36-49T432-432q24 0 48 2.5t48 7.5q-1 46 19 87.5t55 71v71.5H144ZM750-72l-54-54.15V-294q-42-11-69-46t-27-80.19q0-54.61 38.72-93.21 38.72-38.6 93.5-38.6t93.28 38.66Q864-474.69 864-420q0 42.58-24.65 75.69Q814.7-311.19 777-297l45 45-54 54 54 54-72 72ZM432-480q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42Zm299.79 72q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5Z"></path></g>
      <g id="passport" viewBox="0 -960 960 960"><path d="M360-240h240v-48H360v48Zm120.21-120q74.79 0 127.29-52.71t52.5-127.5q0-74.79-52.71-127.29T479.79-720Q405-720 352.5-667.29T300-539.79q0 74.79 52.71 127.29t127.5 52.5Zm-.21-50q-8-8-18.5-34.5T448-516h64q-3 45-13.5 71.5T480-410Zm-61-14q-26-14-45-38t-24-54h50.3q2.14 26.07 6.42 49.54Q411-443 419-424Zm122 0q8-19 12.28-42.46 4.28-23.47 6.42-49.54H610q-5 30-24 54t-45 38ZM350-564q5-30 24-54t45-38q-8 19-12.28 42.46-4.28 23.47-6.42 49.54H350Zm98 0q3-45 13.5-71.5T480-670q8 8 18.5 34.5T512-564h-64Zm111.7 0q-2.14-26.07-6.42-49.54Q549-637 541-656q26 14 45 38t24 54h-50.3ZM192-96v-768h504.28Q726-864 747-842.85T768-792v624q0 29.7-21.15 50.85Q725.7-96 696-96H192Zm72-72h432v-624H264v624Zm0 0v-624 624Z"></path></g>
      <g id="pen-spark"><path d="M5.5 15.5H6.5625L14.375 7.6875L13.3125 6.625L5.5 14.4375V15.5ZM4 17V13.8125L14.375 3.4375C14.5278 3.28472 14.6944 3.17361 14.875 3.10417C15.0556 3.03472 15.2431 3 15.4375 3C15.6319 3 15.8194 3.03472 16 3.10417C16.1806 3.17361 16.3472 3.28472 16.5 3.4375L17.5625 4.5C17.7153 4.65278 17.8264 4.81944 17.8958 5C17.9653 5.18055 18 5.36806 18 5.5625C18 5.75694 17.9653 5.94444 17.8958 6.125C17.8264 6.30555 17.7153 6.47222 17.5625 6.625L7.1875 17H4ZM16.5 5.5625L15.4375 4.5L16.5 5.5625ZM13.8333 7.16667L13.3125 6.625L14.375 7.6875L13.8333 7.16667ZM5.5 10C5.5 8.75 5.0625 7.6875 4.1875 6.8125C3.3125 5.9375 2.25 5.5 1 5.5C2.25 5.5 3.3125 5.0625 4.1875 4.1875C5.0625 3.3125 5.5 2.25 5.5 0.999999C5.5 2.25 5.9375 3.3125 6.8125 4.1875C7.6875 5.0625 8.75 5.5 10 5.5C8.75 5.5 7.6875 5.9375 6.8125 6.8125C5.9375 7.6875 5.5 8.75 5.5 10Z"></path></g>
      <g id="performance-max"><path d="m4.625 14-1.083-1.062L8 8.5l3.25 3.25 4.146-4.021 1.062 1.063-5.208 5.104L8 10.625Zm6.625-5-.771-1.729L8.75 6.5l1.729-.771L11.25 4l.771 1.729 1.729.771-1.729.771Z"></path></g>
      <g id="pointer-lock"><path d="M10 9.168Zm0 9.164c-1.61 0-2.984-.566-4.125-1.707-1.14-1.14-1.707-2.516-1.707-4.125v-5c0-1.61.566-2.984 1.707-4.125C7.015 2.235 8.391 1.668 10 1.668c1.61 0 2.984.566 4.125 1.707 1.14 1.14 1.707 2.516 1.707 4.125v2.582a4.291 4.291 0 0 0-1.664 0v-.914H5.832V12.5c0 1.152.406 2.137 1.219 2.95.812.812 1.797 1.218 2.949 1.218.152 0 .297-.008.426-.023.133-.012.27-.036.406-.063v1.688a2.977 2.977 0 0 1-.406.054 13.92 13.92 0 0 1-.426.008ZM5.832 7.5h3.336V3.418c-.961.191-1.754.672-2.387 1.437A4.019 4.019 0 0 0 5.832 7.5Zm5 0h3.336c0-1-.316-1.883-.95-2.645-.632-.765-1.425-1.246-2.386-1.437Zm2.375 10.832a.682.682 0 0 1-.5-.207.69.69 0 0 1-.207-.5v-2.75c0-.195.07-.36.207-.5a.682.682 0 0 1 .5-.207h.125v-.836c0-.457.164-.848.492-1.176A1.593 1.593 0 0 1 15 11.668c.457 0 .852.16 1.176.488.328.328.492.719.492 1.176v.836h.125c.191 0 .36.066.5.207a.69.69 0 0 1 .207.5v2.75a.69.69 0 0 1-.207.5.682.682 0 0 1-.5.207Zm.961-4.164h1.664v-.836a.807.807 0 0 0-.238-.594A.807.807 0 0 0 15 12.5a.807.807 0 0 0-.594.238.807.807 0 0 0-.238.594Zm-4.168-5Zm.832-1.668Zm-1.664 0Zm0 0"></path></g>
      <g id="pointer-lock-off"><path d="M9.168 6.832Zm2.312 2.336Zm-2.73 1.937Zm.418-1.937Zm0 0ZM10.832 7.5ZM10 1.668c1.61 0 2.984.566 4.125 1.707 1.14 1.14 1.707 2.516 1.707 4.125v2.582a4.291 4.291 0 0 0-1.664 0v-.914H11.48L9.168 6.832V3.418a3.802 3.802 0 0 0-1.2.437c-.366.208-.698.465-.988.77L5.812 3.437a5.932 5.932 0 0 1 1.875-1.292A5.7 5.7 0 0 1 10 1.668ZM4.812 4.832l4.356 4.336H5.832V12.5c0 1.152.406 2.137 1.219 2.95.812.812 1.797 1.218 2.949 1.218.152 0 .297-.008.426-.023.133-.012.27-.036.406-.063v1.688a2.977 2.977 0 0 1-.406.054 13.92 13.92 0 0 1-.426.008c-1.61 0-2.984-.566-4.125-1.707-1.14-1.14-1.707-2.516-1.707-4.125v-5c0-.484.055-.953.164-1.395.113-.445.273-.87.48-1.273Zm6.02 2.668h3.336c0-1-.316-1.883-.95-2.645-.632-.765-1.425-1.246-2.386-1.437Zm6.23 11.918L.582 2.918 1.75 1.75l16.5 16.5Zm-3.855-1.086a.682.682 0 0 1-.5-.207.69.69 0 0 1-.207-.5V15c0-.234.078-.434.238-.594.16-.16.36-.238.594-.238h.836L17.5 17.5v.125a.69.69 0 0 1-.207.5.682.682 0 0 1-.5.207Zm3.461-3.914-.836-.836v-.25a.807.807 0 0 0-.238-.594A.807.807 0 0 0 15 12.5h-.105a.261.261 0 0 0-.102.02l-.625-.625c.125-.067.254-.125.395-.165.14-.043.285-.062.437-.062.457 0 .852.16 1.176.488.328.328.492.719.492 1.176Zm0 0"></path></g>
      <g id="preview" viewBox="0 -960 960 960"><path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-456H216v456Zm263.88-84Q406-300 348-340.5T264-444q26-63 84.12-103.5 58.11-40.5 132-40.5Q554-588 612-547.5T696-444q-26 63-84.12 103.5-58.11 40.5-132 40.5Zm.12-48q53 0 95.88-25.44Q618.76-398.88 643-444q-24.24-45.12-67.12-70.56Q533-540 480-540q-53 0-95.88 25.44Q341.24-489.12 317-444q24.24 45.12 67.12 70.56Q427-348 480-348Zm0-96Zm0 60q25 0 42.5-17.5T540-444q0-25-17.5-42.5T480-504q-25 0-42.5 17.5T420-444q0 25 17.5 42.5T480-384Z"></path></g>
      <!-- The polygon ("+" shape) within this icon will always be filled with
           the color #4285F4. Any color fills specified programmatically will
           only be applied to the outer layer. -->
      <g id="printer-add"><path d="M17.8734304,8.29826826 C17.2839707,8.10470383 16.6542128,8 16,8 C13.3875623,8 11.1650842,9.66961525 10.3414114,12 L7,12 L7,15 L10.0829584,15 C10.2034032,15.7179235 10.4513404,16.3926158 10.8026932,17 L5,17 L5,14 L2,14 L2,9 C2,7.8954305 2.8954305,7 4,7 L5,7 L5,3 L15,3 L15,7 L16,7 C16.8576527,7 17.5892179,7.53984453 17.8734304,8.29826826 Z M7,5 L7,7 L13,7 L13,5 L7,5 Z"></path><polygon fill="#4285F4" points="17 13 19 13 19 15 17 15 17 17 15 17 15 15 13 15 13 13 15 13 15 11 17 11"></polygon></g>
      <g id="privacy-screen" viewBox="0 -960 960 960"><path d="m168-555 141-141H168v141Zm0 240 381-381H411L168-453v138Zm51 51h573v-432H651L219-264Zm-51 72q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Z"></path></g>
      <g id="psychiatry"><path d="M9.25 17V10.8125H9.0625C8.27083 10.8125 7.50694 10.6667 6.77083 10.375C6.04861 10.0694 5.40278 9.63889 4.83333 9.08333C4.23611 8.51389 3.77778 7.85417 3.45833 7.10417C3.15278 6.35417 3 5.56944 3 4.75V3H4.75C5.54167 3 6.29861 3.15278 7.02083 3.45833C7.74306 3.75 8.38889 4.17361 8.95833 4.72917C9.36111 5.11805 9.69445 5.55555 9.95833 6.04167C10.2361 6.51389 10.4444 7.01389 10.5833 7.54167C11.1111 6.80556 11.7917 6.24305 12.625 5.85417C13.4583 5.45139 14.3333 5.25 15.25 5.25H17V7C17 7.81944 16.8403 8.60417 16.5208 9.35417C16.2153 10.1042 15.7639 10.7639 15.1667 11.3333C14.6111 11.8194 13.9931 12.1944 13.3125 12.4583C12.6319 12.7222 11.9236 12.8542 11.1875 12.8542H10.75V17H9.25ZM9.25 9.25C9.25 8.61111 9.13889 7.99306 8.91667 7.39583C8.70833 6.78472 8.38194 6.25694 7.9375 5.8125C7.49306 5.36805 6.96528 5.04167 6.35417 4.83333C5.75694 4.61111 5.13889 4.5 4.5 4.5C4.5 5.13889 4.60417 5.76389 4.8125 6.375C5.03472 6.97222 5.36806 7.49306 5.8125 7.9375C6.25694 8.38194 6.77778 8.71528 7.375 8.9375C7.98611 9.14583 8.61111 9.25 9.25 9.25ZM10.75 11.5C11.3889 11.5 12.0069 11.3958 12.6042 11.1875C13.2153 10.9653 13.7431 10.6319 14.1875 10.1875C14.6319 9.74305 14.9583 9.22222 15.1667 8.625C15.3889 8.01389 15.5 7.38889 15.5 6.75C14.8611 6.75 14.2361 6.86111 13.625 7.08333C13.0278 7.29167 12.5069 7.61805 12.0625 8.0625C11.6181 8.50694 11.2847 9.03472 11.0625 9.64583C10.8542 10.2431 10.75 10.8611 10.75 11.5Z"></path></g>
      <g id="public"><path fill-rule="evenodd" clip-rule="evenodd" d="M10 1.667A8.336 8.336 0 0 0 1.667 10c0 4.6 3.733 8.333 8.333 8.333S18.333 14.6 18.333 10 14.6 1.667 10 1.667zM3.333 10c0-.508.067-1.008.175-1.483L7.492 12.5v.833c0 .917.75 1.667 1.666 1.667v1.608C5.883 16.192 3.333 13.392 3.333 10zm9.992 3.333c.75 0 1.367.492 1.583 1.167a6.66 6.66 0 0 0 1.758-4.5 6.67 6.67 0 0 0-4.175-6.175v.342c0 .916-.75 1.666-1.666 1.666H9.158V7.5a.836.836 0 0 1-.833.833H6.658V10h5c.459 0 .834.375.834.833v2.5h.833z"></path></g>
      <g id="quick-reference-all"><path d="M4.5 3.5V7V9.02083C4.5 9.14583 4.5 9.68055 4.5 10.625C4.5 11.5694 4.5 12.6944 4.5 14C4.5 14.4583 4.5 14.9028 4.5 15.3333C4.5 15.75 4.5 16.1389 4.5 16.5V3.5V7V3.5ZM6 12H9.41667C9.54167 11.7222 9.6875 11.4583 9.85417 11.2083C10.0347 10.9583 10.2292 10.7222 10.4375 10.5H6V12ZM6 15H9.10417C9.04861 14.75 9.01389 14.5 9 14.25C8.98611 14 8.99306 13.75 9.02083 13.5H6V15ZM4.5 18C4.08333 18 3.72917 17.8542 3.4375 17.5625C3.14583 17.2708 3 16.9167 3 16.5V3.5C3 3.08333 3.14583 2.72917 3.4375 2.4375C3.72917 2.14583 4.08333 2 4.5 2H11L15 6V9.10417C14.75 9.04861 14.5 9.01389 14.25 9C14 8.98611 13.75 8.99305 13.5 9.02083V7H10V3.5H4.5V16.5H9.66667C9.83333 16.7917 10.0278 17.0694 10.25 17.3333C10.4722 17.5833 10.7222 17.8056 11 18H4.5ZM14 16C14.5556 16 15.0278 15.8056 15.4167 15.4167C15.8056 15.0278 16 14.5556 16 14C16 13.4444 15.8056 12.9722 15.4167 12.5833C15.0278 12.1944 14.5556 12 14 12C13.5556 12 13.1111 12.1667 12.6667 12.5C12.2222 12.8333 12 13.3333 12 14C12 14.5556 12.1944 15.0278 12.5833 15.4167C12.9722 15.8056 13.4444 16 14 16ZM17.9375 19L15.8958 16.9375C15.6181 17.1181 15.3194 17.2569 15 17.3542C14.6806 17.4514 14.3542 17.5 14.0208 17.5C13.0347 17.5 12.2014 17.1597 11.5208 16.4792C10.8403 15.7986 10.5 14.9722 10.5 14C10.5 13.0278 10.8403 12.2014 11.5208 11.5208C12.2014 10.8403 13.0278 10.5 14 10.5C14.9722 10.5 15.7986 10.8403 16.4792 11.5208C17.1597 12.2014 17.5 13.0278 17.5 14C17.5 14.3472 17.4514 14.6806 17.3542 15C17.2569 15.3194 17.1181 15.6181 16.9375 15.8958L19 17.9375L17.9375 19Z"></path></g>
      <g id="reviews"><path d="M7.6875 11.75L10 10.375L12.3125 11.75L11.6875 9.16667L13.7292 7.41667L11.0417 7.1875L10 4.75L8.95833 7.1875L6.27083 7.41667L8.3125 9.16667L7.6875 11.75ZM2 18V3.5C2 3.08333 2.14583 2.72917 2.4375 2.4375C2.72917 2.14583 3.08333 2 3.5 2H16.5C16.9167 2 17.2708 2.14583 17.5625 2.4375C17.8542 2.72917 18 3.08333 18 3.5V13.5C18 13.9167 17.8542 14.2708 17.5625 14.5625C17.2708 14.8542 16.9167 15 16.5 15H5L2 18ZM4.375 13.5H16.5V3.5H3.5V14.375L4.375 13.5ZM3.5 13.5V3.5V13.5Z"></path></g>
      <g id="router"><path d="M4.5 17c-.414 0-.766-.148-1.059-.441A1.449 1.449 0 0 1 3 15.5v-3.004c0-.414.148-.766.441-1.059A1.439 1.439 0 0 1 4.5 11h8V8H14v3h1.5c.426 0 .785.145 1.09.438.3.292.437.644.41 1.062v3a1.637 1.637 0 0 1-.469 1.05c-.285.302-.629.45-1.031.45Zm0-1.5h11v-3h-11Zm1.746-.75c.211 0 .39-.07.535-.215A.716.716 0 0 0 7 14.004c0-.211-.07-.39-.215-.535a.716.716 0 0 0-.531-.219c-.211 0-.39.07-.535.215a.716.716 0 0 0-.219.531c0 .211.07.39.215.535.14.145.32.219.531.219Zm2.75 0c.211 0 .39-.07.535-.215a.716.716 0 0 0 .219-.531c0-.211-.07-.39-.215-.535a.716.716 0 0 0-.531-.219c-.211 0-.39.07-.535.215a.716.716 0 0 0-.219.531c0 .211.07.39.215.535.14.145.32.219.531.219Zm2.75 0c.211 0 .39-.07.535-.215a.716.716 0 0 0 .219-.531c0-.211-.07-.39-.215-.535a.716.716 0 0 0-.531-.219c-.211 0-.39.07-.535.215a.716.716 0 0 0-.219.531c0 .211.07.39.215.535.14.145.32.219.531.219Zm.36-7.895-1.063-1.062c.289-.277.629-.48 1.02-.606a3.868 3.868 0 0 1 2.374 0c.391.125.731.329 1.02.606l-1.062 1.062a1.042 1.042 0 0 0-.532-.293 2.917 2.917 0 0 0-.613-.062c-.207 0-.414.02-.613.063-.203.042-.38.14-.532.292ZM10 4.75 8.918 3.668a5.052 5.052 0 0 1 1.988-1.273A7.132 7.132 0 0 1 13.25 2c.805 0 1.586.133 2.344.395a5.052 5.052 0 0 1 1.988 1.273L16.5 4.75a4.007 4.007 0 0 0-1.488-.95 5.25 5.25 0 0 0-1.762-.3c-.61 0-1.2.102-1.762.3A4.007 4.007 0 0 0 10 4.75ZM4.5 15.5v-3Zm0 0"></path></g>
      <g id="router-off"><path d="m12.105 6.855-1.062-1.062c.289-.277.629-.48 1.02-.606a3.868 3.868 0 0 1 2.374 0c.391.125.731.329 1.02.606l-1.062 1.062a1.042 1.042 0 0 0-.532-.293 2.917 2.917 0 0 0-.613-.062c-.207 0-.414.02-.613.063-.203.042-.38.14-.532.292ZM10 4.75 8.918 3.668a5.052 5.052 0 0 1 1.988-1.273A7.132 7.132 0 0 1 13.25 2c.805 0 1.586.133 2.344.395a5.052 5.052 0 0 1 1.988 1.273L16.5 4.75a4.007 4.007 0 0 0-1.488-.95 5.25 5.25 0 0 0-1.762-.3c-.61 0-1.2.102-1.762.3A4.007 4.007 0 0 0 10 4.75Zm7 10.125-4.5-4.508V8H14v3h1.5c.426 0 .785.145 1.09.438.3.292.437.644.41 1.062ZM4.5 15.5h8.875l-3-3H4.5ZM16 18.125 14.875 17H4.5c-.414 0-.766-.148-1.059-.441A1.449 1.449 0 0 1 3 15.5v-3.004c0-.414.148-.766.441-1.059A1.439 1.439 0 0 1 4.5 11h4.375l-7-7 1.063-1.063 14.124 14.126ZM6.254 14.75c-.211 0-.39-.07-.535-.215a.716.716 0 0 1-.219-.531c0-.211.07-.39.215-.535a.716.716 0 0 1 .531-.219c.211 0 .39.07.535.215.145.14.219.32.219.531 0 .211-.07.39-.215.535a.716.716 0 0 1-.531.219Zm2.75 0c-.211 0-.39-.07-.535-.215a.716.716 0 0 1-.219-.531c0-.211.07-.39.215-.535a.716.716 0 0 1 .531-.219c.211 0 .39.07.535.215.145.14.219.32.219.531 0 .211-.07.39-.215.535a.716.716 0 0 1-.531.219Zm2.75 0c-.211 0-.39-.07-.535-.215a.716.716 0 0 1-.219-.531c0-.211.07-.39.215-.535a.716.716 0 0 1 .531-.219c.211 0 .39.07.535.215.145.14.219.32.219.531 0 .211-.07.39-.215.535a.716.716 0 0 1-.531.219ZM4.5 15.5v-3Zm0 0"></path></g>
      <g id="rule-folder" viewBox="0 -960 960 960"><path d="m313-305 198-198-57-57-141 142-57-57-56 57 113 113Zm263 0 64-64 64 64 56-56-64-64 64-64-56-56-64 64-64-64-56 56 64 64-64 64 56 56ZM160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h240l80 80h320q33 0 56.5 23.5T880-640v400q0 33-23.5 56.5T800-160H160Zm0-80h640v-400H447l-80-80H160v480Zm0 0v-480 480Z"></path></g>
      <g id="saved-info"><path d="M7 13C7.93333 13 8.81706 13.1163 9.65039 13.3496C10.5002 13.5662 11.3 13.8998 12.0498 14.3496C12.3497 14.5329 12.5833 14.7831 12.75 15.0996C12.9166 15.4162 12.9999 15.7498 13 16.0996V18H1V16.0996C1.00006 15.7498 1.0834 15.4162 1.25 15.0996C1.41666 14.7831 1.65029 14.5329 1.9502 14.3496C2.7001 13.8997 3.49198 13.5662 4.3252 13.3496C5.17511 13.1163 6.06677 13 7 13ZM7 15C6.31667 15 5.65 15.0833 5 15.25C4.35011 15.4166 3.73364 15.6668 3.15039 16H10.8496C10.2664 15.6668 9.64989 15.4166 9 15.25C8.35 15.0833 7.68333 15 7 15ZM23 18H16V16H23V18ZM23 13H14V11H23V13ZM7 6C7.83333 6 8.54167 6.29167 9.125 6.875C9.70833 7.45833 10 8.16667 10 9C10 9.83333 9.70833 10.5417 9.125 11.125C8.54167 11.7083 7.83333 12 7 12C6.16667 12 5.45833 11.7083 4.875 11.125C4.29167 10.5417 4 9.83333 4 9C4 8.16667 4.29167 7.45833 4.875 6.875C5.45833 6.29167 6.16667 6 7 6ZM7 8C6.71681 8 6.47533 8.1 6.27539 8.2998C6.09206 8.48314 6 8.71667 6 9C6 9.28332 6.09207 9.52461 6.27539 9.72461C6.47539 9.90793 6.71668 10 7 10C7.28333 10 7.51686 9.90794 7.7002 9.72461C7.9 9.52467 8 9.28319 8 9C8 8.71667 7.90019 8.48314 7.7002 8.2998C7.51686 8.09981 7.28333 8 7 8ZM23 8H12V6H23V8Z"></path></g>
      <g id="search-spark"><path d="M15.9375 17L10.9583 12.0208C10.5417 12.3264 10.0833 12.5694 9.58333 12.75C9.08333 12.9167 8.55556 13 8 13C6.61111 13 5.43056 12.5139 4.45833 11.5417C3.48611 10.5694 3 9.38889 3 8C3 6.61111 3.48611 5.43055 4.45833 4.45833C5.43056 3.48611 6.61111 3 8 3C8.36111 3 8.70139 3.03472 9.02083 3.10417C9.35417 3.17361 9.67361 3.27778 9.97917 3.41667L8.79167 4.58333C8.66667 4.55555 8.53472 4.53472 8.39583 4.52083C8.27083 4.50694 8.13889 4.5 8 4.5C7.02778 4.5 6.20139 4.84028 5.52083 5.52083C4.84028 6.20139 4.5 7.02778 4.5 8C4.5 8.97222 4.84028 9.79861 5.52083 10.4792C6.20139 11.1597 7.02778 11.5 8 11.5C8.80556 11.5 9.51389 11.2708 10.125 10.8125C10.7361 10.3403 11.1458 9.73611 11.3542 9H12.8958C12.8264 9.36111 12.7153 9.70833 12.5625 10.0417C12.4097 10.3611 12.2292 10.6667 12.0208 10.9583L17 15.9375L15.9375 17ZM14.5 10C14.5 8.75 14.0625 7.6875 13.1875 6.8125C12.3125 5.9375 11.25 5.5 10 5.5C11.25 5.5 12.3125 5.0625 13.1875 4.1875C14.0625 3.3125 14.5 2.25 14.5 0.999999C14.5 2.25 14.9375 3.3125 15.8125 4.1875C16.6875 5.0625 17.75 5.5 19 5.5C17.75 5.5 16.6875 5.9375 15.8125 6.8125C14.9375 7.6875 14.5 8.75 14.5 10Z"></path></g>
      <g id="security"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.183 4.7L10 1.667 16.816 4.7v4.542c0 4.208-2.908 8.133-6.816 9.091-3.909-.958-6.817-4.883-6.817-9.091V4.7zM15.3 9.992H10V3.325L4.7 5.683V10l5.3-.008v6.775c2.816-.875 4.9-3.65 5.3-6.775z"></path></g>
      <g id="select-window"><path d="M17.5 0.833344H6.66671C5.75004 0.833344 5.00004 1.58334 5.00004 2.50001V7.50001H2.50004C1.58337 7.50001 0.833374 8.25001 0.833374 9.16668V17.5C0.833374 18.4167 1.58337 19.1667 2.50004 19.1667H13.3334C14.25 19.1667 15 18.4167 15 17.5V12.5H17.5C18.4167 12.5 19.1667 11.75 19.1667 10.8333V2.50001C19.1667 1.58334 18.4167 0.833344 17.5 0.833344ZM13.3334 17.5H2.50004V10.8333H13.3334V17.5ZM17.5 10.8333H15V9.16668C15 8.25001 14.25 7.50001 13.3334 7.50001H6.66671V4.16668H17.5V10.8333Z"></path></g>
      <g id="shield" viewBox="0 -960 960 960"><path d="M480-80q-139-35-229.5-159.5T160-516v-244l320-120 320 120v244q0 152-90.5 276.5T480-80Zm0-84q104-33 172-132t68-220v-189l-240-90-240 90v189q0 121 68 220t172 132Zm0-316Z"></path></g>
      <g id="spam"><path d="M15.0714 6.66667V3.5H16.5V7.38889H15.0714V6.66667ZM15.0714 9.83333H16.5V8.38889H15.0714V9.83333ZM9.71429 10.9444C11.6214 10.9444 15.4286 11.9122 15.4286 13.8333V16H4V13.8333C4 11.9122 7.80714 10.9444 9.71429 10.9444ZM9.71429 4.44444C10.472 4.44444 11.1988 4.74881 11.7346 5.29058C12.2704 5.83235 12.5714 6.56715 12.5714 7.33333C12.5714 8.09951 12.2704 8.83431 11.7346 9.37609C11.1988 9.91786 10.472 10.2222 9.71429 10.2222C8.95652 10.2222 8.2298 9.91786 7.69398 9.37609C7.15816 8.83431 6.85714 8.09951 6.85714 7.33333C6.85714 6.56715 7.15816 5.83235 7.69398 5.29058C8.2298 4.74881 8.95652 4.44444 9.71429 4.44444ZM9.71429 12.3167C7.59286 12.3167 5.35714 13.3711 5.35714 13.8333V14.6278H14.0714V13.8333C14.0714 13.3711 11.8357 12.3167 9.71429 12.3167ZM9.71429 5.81667C9.31646 5.81667 8.93493 5.97646 8.65363 6.26089C8.37232 6.54532 8.21429 6.93109 8.21429 7.33333C8.21429 7.73558 8.37232 8.12135 8.65363 8.40578C8.93493 8.69021 9.31646 8.85 9.71429 8.85C10.1121 8.85 10.4936 8.69021 10.7749 8.40578C11.0563 8.12135 11.2143 7.73558 11.2143 7.33333C11.2143 6.93109 11.0563 6.54532 10.7749 6.26089C10.4936 5.97646 10.1121 5.81667 9.71429 5.81667Z"></path></g>
      <g id="sync-saved-locally"><path d="M 9.105469 11.707031 L 13.832031 7 L 12.644531 5.8125 L 9.105469 9.355469 L 7.332031 7.582031 L 6.167969 8.75 Z M 0.832031 17.5 L 0.832031 15.832031 L 19.167969 15.832031 L 19.167969 17.5 Z M 3.332031 15 C 2.875 15 2.484375 14.835938 2.15625 14.511719 C 1.828125 14.183594 1.667969 13.792969 1.667969 13.332031 L 1.667969 4.167969 C 1.667969 3.707031 1.828125 3.316406 2.15625 2.988281 C 2.484375 2.664062 2.875 2.5 3.332031 2.5 L 16.667969 2.5 C 17.125 2.5 17.515625 2.664062 17.84375 2.988281 C 18.171875 3.316406 18.332031 3.707031 18.332031 4.167969 L 18.332031 13.332031 C 18.332031 13.792969 18.171875 14.183594 17.84375 14.511719 C 17.515625 14.835938 17.125 15 16.667969 15 Z M 3.332031 13.332031 L 16.667969 13.332031 L 16.667969 4.167969 L 3.332031 4.167969 Z M 3.332031 13.332031 L 3.332031 4.167969 Z M 3.332031 13.332031 "></path></g>
      <g id="summarize"><path d="M6.75 7.5C6.95833 7.5 7.13194 7.43055 7.27083 7.29167C7.42361 7.13889 7.5 6.95833 7.5 6.75C7.5 6.54167 7.42361 6.36805 7.27083 6.22917C7.13194 6.07639 6.95833 6 6.75 6C6.54167 6 6.36111 6.07639 6.20833 6.22917C6.06944 6.36805 6 6.54167 6 6.75C6 6.95833 6.06944 7.13889 6.20833 7.29167C6.36111 7.43055 6.54167 7.5 6.75 7.5ZM6.75 10.75C6.95833 10.75 7.13194 10.6806 7.27083 10.5417C7.42361 10.3889 7.5 10.2083 7.5 10C7.5 9.79167 7.42361 9.61806 7.27083 9.47917C7.13194 9.32639 6.95833 9.25 6.75 9.25C6.54167 9.25 6.36111 9.32639 6.20833 9.47917C6.06944 9.61806 6 9.79167 6 10C6 10.2083 6.06944 10.3889 6.20833 10.5417C6.36111 10.6806 6.54167 10.75 6.75 10.75ZM6.75 14C6.95833 14 7.13194 13.9306 7.27083 13.7917C7.42361 13.6389 7.5 13.4583 7.5 13.25C7.5 13.0417 7.42361 12.8681 7.27083 12.7292C7.13194 12.5764 6.95833 12.5 6.75 12.5C6.54167 12.5 6.36111 12.5764 6.20833 12.7292C6.06944 12.8681 6 13.0417 6 13.25C6 13.4583 6.06944 13.6389 6.20833 13.7917C6.36111 13.9306 6.54167 14 6.75 14ZM4.5 17C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H13L17 7V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H4.5ZM4.5 15.5H15.5V8H12V4.5H4.5V15.5ZM4.5 4.5V7.75V4.5V7.75V15.5V4.5Z"></path></g>
      <g id="tab"><path d="M3.5 14.5H16.5V9H11V5.5H3.5V14.5ZM3.5 16C3.08333 16 2.72917 15.8542 2.4375 15.5625C2.14583 15.2708 2 14.9167 2 14.5V5.5C2 5.08333 2.14583 4.72917 2.4375 4.4375C2.72917 4.14583 3.08333 4 3.5 4H16.5C16.9167 4 17.2708 4.14583 17.5625 4.4375C17.8542 4.72917 18 5.08333 18 5.5V14.5C18 14.9167 17.8542 15.2708 17.5625 15.5625C17.2708 15.8542 16.9167 16 16.5 16H3.5ZM3.5 14.5V5.5V14.5Z"></path></g>
      <g id="table-chart-organize"><path d="M4.5 17C4.09722 17 3.74306 16.8542 3.4375 16.5625C3.14583 16.2569 3 15.9028 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.74306 3.14583 4.09722 3 4.5 3H9.58333C9.47222 3.23611 9.36806 3.47917 9.27083 3.72917C9.1875 3.97917 9.125 4.23611 9.08333 4.5H4.5V6.75H9.14583C9.21528 7.02778 9.29861 7.29167 9.39583 7.54167C9.49306 7.77778 9.61111 8.01389 9.75 8.25H8V15.5H12V10.375C12.2361 10.5 12.4792 10.6042 12.7292 10.6875C12.9792 10.7708 13.2361 10.8403 13.5 10.8958V15.5H15.5V10.9167C15.7639 10.875 16.0208 10.8125 16.2708 10.7292C16.5208 10.6319 16.7639 10.5278 17 10.4167V15.5C17 15.9028 16.8472 16.2569 16.5417 16.5625C16.25 16.8542 15.9028 17 15.5 17H4.5ZM4.5 15.5H6.5V8.25H4.5V15.5ZM4.5 17H6.5H3C3 17 3.14583 17 3.4375 17C3.72917 17 4.08333 17 4.5 17ZM3 6.75C3 6.54167 3 6.33333 3 6.125C3 5.90278 3 5.68056 3 5.45833C3 5.01389 3 4.59028 3 4.1875C3 3.77083 3 3.375 3 3C3 3 3 3.14583 3 3.4375C3 3.72917 3 4.08333 3 4.5V6.75ZM8 17H12C11.5278 17 11.0972 17 10.7083 17C10.3333 17 10.0139 17 9.75 17H8ZM13.5 17H15.5C15.9167 17 16.2708 17 16.5625 17C16.8542 17 17 17 17 17C16.625 17 16.2292 17 15.8125 17C15.4097 17 14.9861 17 14.5417 17C14.3611 17 14.1806 17 14 17C13.8333 17 13.6667 17 13.5 17ZM14.5 10C14.5 8.75 14.0625 7.6875 13.1875 6.8125C12.3125 5.9375 11.25 5.5 10 5.5C11.25 5.5 12.3125 5.0625 13.1875 4.1875C14.0625 3.3125 14.5 2.25 14.5 0.999999C14.5 2.25 14.9375 3.3125 15.8125 4.1875C16.6875 5.0625 17.75 5.5 19 5.5C17.75 5.5 16.6875 5.9375 15.8125 6.8125C14.9375 7.6875 14.5 8.75 14.5 10Z"></path></g>
      <g id="text-analysis"><path d="M 2.5 17.5 L 2.5 15.832031 L 12.5 15.832031 L 12.5 17.5 Z M 2.5 13.332031 L 2.5 11.667969 L 17.5 11.667969 L 17.5 13.332031 Z M 2.5 9.167969 L 2.5 7.5 L 11.667969 7.5 L 11.667969 9.167969 Z M 14.582031 10 C 14.582031 8.722656 14.140625 7.640625 13.25 6.75 C 12.359375 5.859375 11.277344 5.417969 10 5.417969 C 11.277344 5.417969 12.359375 4.972656 13.25 4.082031 C 14.140625 3.195312 14.582031 2.109375 14.582031 0.832031 C 14.582031 2.109375 15.027344 3.195312 15.917969 4.082031 C 16.804688 4.972656 17.890625 5.417969 19.167969 5.417969 C 17.890625 5.417969 16.804688 5.859375 15.917969 6.75 C 15.027344 7.640625 14.582031 8.722656 14.582031 10 Z M 14.582031 10 "></path></g>
      <g id="text-compare"><path d="M8.5 19V17H4.5C4.08333 17 3.72917 16.8542 3.4375 16.5625C3.14583 16.2708 3 15.9167 3 15.5V4.5C3 4.08333 3.14583 3.72917 3.4375 3.4375C3.72917 3.14583 4.08333 3 4.5 3H8.5V0.999999H10V19H8.5ZM4.5 15.5H8.5V14H6V12.5H8.5V11H6V9.5H8.5V8H6V6.5H8.5V4.5H4.5V15.5ZM11.5 4.5V3H15.5C15.9167 3 16.2708 3.14583 16.5625 3.4375C16.8542 3.72917 17 4.08333 17 4.5V15.5C17 15.9167 16.8542 16.2708 16.5625 16.5625C16.2708 16.8542 15.9167 17 15.5 17H11.5V15.5H15.5V4.5H11.5ZM11.5 11V9.5H14V11H11.5ZM11.5 8V6.5H14V8H11.5Z"></path></g>
      <g id="timer"><path d="M7.5 3V1.5H12.5V3H7.5ZM9.25 12H10.75V7H9.25V12ZM10 18C9.02778 18 8.11806 17.8194 7.27083 17.4583C6.42361 17.0833 5.68056 16.5833 5.04167 15.9583C4.41667 15.3194 3.91667 14.5764 3.54167 13.7292C3.18056 12.8819 3 11.9722 3 11C3 10.0278 3.18056 9.11806 3.54167 8.27083C3.91667 7.42361 4.41667 6.6875 5.04167 6.0625C5.68056 5.42361 6.42361 4.92361 7.27083 4.5625C8.11806 4.1875 9.02778 4 10 4C10.8056 4 11.5764 4.13889 12.3125 4.41667C13.0625 4.68055 13.7569 5.05555 14.3958 5.54167L15.4792 4.47917L16.5208 5.52083L15.4583 6.60417C15.9444 7.22917 16.3194 7.91667 16.5833 8.66667C16.8611 9.41667 17 10.1944 17 11C17 11.9722 16.8125 12.8819 16.4375 13.7292C16.0764 14.5764 15.5764 15.3194 14.9375 15.9583C14.3125 16.5833 13.5764 17.0833 12.7292 17.4583C11.8819 17.8194 10.9722 18 10 18ZM10 16.5C11.5278 16.5 12.8264 15.9653 13.8958 14.8958C14.9653 13.8264 15.5 12.5278 15.5 11C15.5 9.47222 14.9653 8.17361 13.8958 7.10417C12.8264 6.03472 11.5278 5.5 10 5.5C8.47222 5.5 7.17361 6.03472 6.10417 7.10417C5.03472 8.17361 4.5 9.47222 4.5 11C4.5 12.5278 5.03472 13.8264 6.10417 14.8958C7.17361 15.9653 8.47222 16.5 10 16.5Z"></path></g>
      <g id="undo"><path d="M11.8335 15.8333H5.8335V14.5833H11.8543C12.8266 14.5833 13.6634 14.2604 14.3647 13.6146C15.0661 12.9687 15.4168 12.1666 15.4168 11.2083C15.4168 10.25 15.0661 9.4479 14.3647 8.80206C13.6634 8.15623 12.8266 7.83331 11.8543 7.83331H5.7085L8.0835 10.2083L7.2085 11.0833L3.3335 7.20831L7.2085 3.33331L8.0835 4.20831L5.7085 6.58331H11.8335C13.1529 6.58331 14.2884 7.02776 15.2397 7.91665C16.1911 8.80554 16.6668 9.90276 16.6668 11.2083C16.6668 12.5139 16.1911 13.6111 15.2397 14.5C14.2884 15.3889 13.1529 15.8333 11.8335 15.8333Z"></path></g>
      <g id="user-attributes-filled" viewBox="0 -960 960 960"><path d="M576-696v-72h288v72H576Zm0 156v-72h288v72H576Zm0 156v-72h288v72H576Zm-240-48q-50 0-85-35t-35-85q0-50 35-85t85-35q50 0 85 35t35 85q0 50-35 85t-85 35ZM96-192v-63q0-28 14.5-51t38.5-35q43-21 90-32t97-11q50 0 97 11t90 32q24 12 38.5 35t14.5 51v63H96Z"></path></g>
      <g id="volume-down"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13ZM10 6.5V13.5C11.776 12.8652 12.5 11.0043 12.5 10C12.5 8.99565 11.776 7.14348 10 6.5Z"></path></g>
      <g id="volume-zero"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13Z"></g>
      <g id="vpn-key"><path d="M10.4727273,8 C9.87272727,6.2525 8.26181818,5 6.36363636,5 C3.95272727,5 2,7.01375 2,9.5 C2,11.98625 3.95272727,14 6.36363636,14 C8.26181818,14 9.87272727,12.7475 10.4727273,11 L13.6363636,11 L13.6363636,14 L16.5454545,14 L16.5454545,11 L18,11 L18,8 L10.4727273,8 Z M6.36363636,11 C5.56,11 4.90909091,10.32875 4.90909091,9.5 C4.90909091,8.67125 5.56,8 6.36363636,8 C7.16727273,8 7.81818182,8.67125 7.81818182,9.5 C7.81818182,10.32875 7.16727273,11 6.36363636,11 Z"></path></g>
      <g id="vpn-key-new"><path d="M 5.832031 15.480469 C 4.324219 15.480469 3.035156 14.941406 1.960938 13.871094 C 0.890625 12.796875 0.355469 11.503906 0.355469 9.996094 C 0.355469 8.484375 0.890625 7.195312 1.960938 6.125 C 3.035156 5.054688 4.324219 4.519531 5.832031 4.519531 C 7.070312 4.519531 8.097656 4.828125 8.917969 5.4375 C 9.734375 6.046875 10.3125 6.777344 10.644531 7.625 L 19.644531 7.625 L 19.644531 12.375 L 17.4375 12.375 L 17.4375 15.230469 L 13.082031 15.230469 L 13.082031 12.375 L 10.640625 12.375 C 10.3125 13.222656 9.734375 13.953125 8.917969 14.5625 C 8.097656 15.171875 7.070312 15.480469 5.832031 15.480469 Z M 5.832031 13.75 C 6.890625 13.75 7.734375 13.390625 8.375 12.667969 C 9.015625 11.945312 9.359375 11.277344 9.410156 10.667969 L 14.894531 10.667969 L 14.894531 13.519531 L 15.707031 13.519531 L 15.707031 10.667969 L 17.917969 10.667969 L 17.917969 9.332031 L 9.417969 9.332031 C 9.359375 8.722656 9.015625 8.054688 8.375 7.332031 C 7.734375 6.609375 6.890625 6.25 5.832031 6.25 C 4.792969 6.25 3.90625 6.613281 3.175781 7.34375 C 2.449219 8.074219 2.082031 8.957031 2.082031 10 C 2.082031 11.042969 2.449219 11.925781 3.175781 12.65625 C 3.90625 13.386719 4.792969 13.75 5.832031 13.75 Z M 5.828125 11.644531 C 6.304688 11.644531 6.699219 11.488281 7.011719 11.171875 C 7.324219 10.855469 7.480469 10.46875 7.480469 10.003906 C 7.480469 9.53125 7.324219 9.136719 7.015625 8.824219 C 6.707031 8.511719 6.3125 8.355469 5.839844 8.355469 C 5.375 8.355469 4.984375 8.507812 4.667969 8.816406 C 4.347656 9.125 4.1875 9.519531 4.1875 9.996094 C 4.1875 10.457031 4.34375 10.847656 4.660156 11.167969 C 4.976562 11.484375 5.367188 11.644531 5.828125 11.644531 Z M 5.832031 10 Z M 5.832031 10"></path></g>
      <g id="wallet" viewBox="0 -960 960 960"><path d="M240-192q-60 0-102-42T96-336v-288q0-60 42-102t102-42h480q60 0 102 42t42 102v288q0 60-42 102t-102 42H240Zm0-432h480q19 0 37 5.5t35 14.5v-20q0-30-21-51t-51-21H240q-30 0-51 21t-21 51v20q17-10 35-15t37-5Zm-63 110 430 105q8 2 16 0t15-7l135-112q-11-11-24.5-17.5T720-552H240q-20 0-38 11t-25 27Z"></path></g>
      <g id="web" viewBox="0 -960 960 960"><path d="M168-192q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Zm0-72h408v-120H168v120Zm480 0h144v-312H648v312ZM168-456h408v-120H168v120Z"></path></g>
      <g id="web-asset"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.333 3.333h13.334c.924 0 1.666.75 1.666 1.667v10c0 .917-.75 1.667-1.666 1.667H3.332c-.925 0-1.667-.75-1.667-1.667V5c0-.917.742-1.667 1.667-1.667zm0 11.667h13.334V6.667H3.332V15z"></path></g>
      <g id="work" viewBox="0 -960 960 960"><path d="M168-144q-29.7 0-50.85-21.15Q96-186.3 96-216v-432q0-29.7 21.15-50.85Q138.3-720 168-720h168v-72.21Q336-822 357.18-843q21.17-21 50.91-21h144.17Q582-864 603-842.85q21 21.15 21 50.85v72h168q29.7 0 50.85 21.15Q864-677.7 864-648v432q0 29.7-21.15 50.85Q821.7-144 792-144H168Zm0-72h624v-432H168v432Zm240-504h144v-72H408v72ZM168-216v-432 432Z"></path></g>
      <g id="youtube-searched-for"><path d="M16.27 13.27c.77-1.07 1.24-2.36 1.24-3.77 0-3.59-2.91-6.5-6.5-6.5-3.46 0-6.28 2.7-6.48 6.11L3.22 7.79 1.8 9.21l3.71 3.71 3.71-3.71L7.8 7.79 6.56 9.04C6.79 6.77 8.68 5 11.01 5c2.49 0 4.5 2.01 4.5 4.5S13.5 14 11.01 14c-.86 0-1.65-.25-2.33-.67l-1.45 1.45C8.3 15.55 9.6 16 11.01 16c1.41 0 2.7-.47 3.77-1.24l5.73 5.73L22 19l-5.73-5.73z"></path></g>
    </defs>
  </svg>
</cr-iconset>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<cr-iconset name="settings" size="24">
  <svg>
    <defs>
      <!-- Location disabled GM3 icon -->
      <g id="location-disabled" viewBox="0 -960 960 960">
        <path d="m784-286-58-58q17-30 25.5-64t8.5-70q0-116-82-198t-198-82q-36 0-70 8.5T346-724l-58-58q35-21 72.5-35t79.5-19v-80h80v80q125 14 214.5 103.5T838-518h80v80h-80q-5 42-19 79.5T784-286ZM440-40v-80q-125-14-214.5-103.5T122-438H42v-80h80q5-42 19-79.5t35-72.5L56-790l56-56 736 736-58 56-118-120q-35 21-72.5 35T520-120v80h-80Zm40-158q36 0 70-8.5t64-25.5L234-612q-17 30-25.5 64t-8.5 70q0 116 82 198t198 82Z"></path>
      </g>

      <!-- Fingerprint off GM3 icon -->
      <g id="fingerprint-off" viewBox="0 -960 960 960">
        <path d="M833-41 435-440q-19 11-29 28.5T396-374q0 92 55.5 161T601-120q8 2 12 9.5t2 15.5q-2 8-9 12t-15 2q-108-28-171.5-107.5T356-374q0-28 13-52.5t37-41.5l-42-42q-34 26-52 61t-18 75q0 75 25.5 132T405-123q6 6 6 14.5T405-94q-6 6-14.5 6T376-94q-66-67-94-130.5T254-374q0-48 22-91.5t60-73.5l-44-43q-58 54-80 99t-22 109q0 36 6.5 73t20.5 72q3 8 0 15t-11 10q-8 3-15.5 0T180-215q-15-42-22-81t-7-78q0-73 25.5-127.5T264-611l-41-41q-20 17-36.5 34.5T156-580q-4 7-12 8.5t-16-3.5q-7-5-8-13t4-15q14-21 32-40t39-37L42-834l42-42L876-84l-43 43ZM688-354q-8 0-14-5.5t-6-14.5q0-72-51-121t-121-54l-40-40q6-1 12.5-1H481q93 0 160 62.5T708-374q0 9-5.5 14.5T688-354ZM481-879q64 0 125 15.5T724-819q9 5 10.5 12t-1.5 14q-3 7-10 11t-17-1q-53-27-109.5-41.5T481-839q-58 0-113.5 13T261-784l-29-29q57-32 120-49t129-17Zm0 98q106 0 200 45.5T838-604q7 9 4.5 16t-8.5 12q-6 5-14 4.5t-14-8.5q-55-78-141.5-119.5T481-741q-39 0-76.5 7T332-713l-30-30q42-19 86.5-28.5T481-781Zm0 94q135 0 232 90t97 223q0 29-13 52.5T763-282l-28-28q16-11 25.5-27.5T770-374q0-116-85-195t-203-79q-20 0-38.5 2.5T407-638l-32-32q25-8 51.5-12.5T481-687Zm193 525q-89 0-152.5-61T458-373q0-8 5.5-14t14.5-6q9 0 14.5 6t5.5 14q0 72 52 121t124 49q6 0 17-.5t23-2.5q9-2 15.5 2.5T738-190q2 8-3 14t-13 8q-18 5-31.5 5.5t-16.5.5Z"></path>
      </g>

      <!-- Visibility off GM3 icon -->
      <g id="visibility-off" viewBox="0 -960 960 960">
        <path d="m644-428-58-58q9-47-27-88t-93-32l-58-58q17-8 34.5-12t37.5-4q75 0 127.5 52.5T660-500q0 20-4 37.5T644-428Zm128 126-58-56q38-29 67.5-63.5T832-500q-50-101-143.5-160.5T480-720q-29 0-57 4t-55 12l-62-62q41-17 84-25.5t90-8.5q151 0 269 83.5T920-500q-23 59-60.5 109.5T772-302Zm20 246L624-222q-35 11-70.5 16.5T480-200q-151 0-269-83.5T40-500q21-53 53-98.5t73-81.5L56-792l56-56 736 736-56 56ZM222-624q-29 26-53 57t-41 67q50 101 143.5 160.5T480-280q20 0 39-2.5t39-5.5l-36-38q-11 3-21 4.5t-21 1.5q-75 0-127.5-52.5T300-500q0-11 1.5-21t4.5-21l-84-82Zm319 93Zm-151 75Z"></path>
      </g>

      <!-- Domain verification GM3 icon -->
      <g id="domain-verification" viewBox="0 -960 960 960">
        <path d="M160-160q-33 0-56.5-23.5T80-240v-480q0-33 23.5-56.5T160-800h640q33 0 56.5 23.5T880-720v480q0 33-23.5 56.5T800-160H160Zm0-80h640v-400H160v400Zm278-58L296-440l58-58 84 84 168-168 58 58-226 226Zm-278 58v-480 480Z"></path>
      </g>

      <!-- Forward GM3 icon -->
      <g id="forward" viewBox="0 -960 960 960">
        <path d="m640-280-57-56 184-184-184-184 57-56 240 240-240 240ZM80-200v-160q0-83 58.5-141.5T280-560h247L383-704l57-56 240 240-240 240-57-56 144-144H280q-50 0-85 35t-35 85v160H80Z"></path>
      </g>

      <!-- Navigation: Accessibility disabled GM3 icon -->
      <g id="accessibility" viewBox="0 -960 960 960">
        <path d="M479.75-696q-34.75 0-59.25-24.75t-24.5-59.5q0-34.75 24.75-59.25t59.5-24.5q34.75 0 59.25 24.75t24.5 59.5q0 34.75-24.75 59.25t-59.5 24.5ZM360-108v-456H144v-72h672v72H600v456h-72l-9-220h-77l-10 220h-72Z"></path>
      </g>

      <!-- Navigation: Assignment disabled GM3 icon -->
      <g id="assignment" viewBox="0 -960 960 960">
        <path d="M288-384q39.6 0 67.8-28.2Q384-440.4 384-480q0-39.6-28.2-67.8Q327.6-576 288-576q-39.6 0-67.8 28.2Q192-519.6 192-480q0 39.6 28.2 67.8Q248.4-384 288-384Zm0 144q-100 0-170-70T48-480q0-100 70-170t170-70q72 0 131 39t89 105h332q29.7 0 50.85 21.15Q912-533.7 912-504v192q0 29.7-21.15 50.85Q869.7-240 840-240H696q-29.7 0-50.85-21.15Q624-282.3 624-312v-72H508q-30 66-89 105t-131 39Zm166-216h242v144h48v-72q0-10.4 6.8-17.2 6.8-6.8 17.2-6.8 10.4 0 17.2 6.8 6.8 6.8 6.8 17.2v72h48v-192H454q-8-63-55.62-103.5Q350.77-648 288-648q-70 0-119 49t-49 119q0 70 49 119t119 49q62.77 0 110.38-40.5Q446-393 454-456Z"></path>
      </g>

      <!-- Navigation: Download GM3 icon -->
      <g id="download" viewBox="0 -960 960 960">
        <path d="M480-336 288-528l51-51 105 105v-342h72v342l105-105 51 51-192 192ZM263.72-192Q234-192 213-213.15T192-264v-72h72v72h432v-72h72v72q0 29.7-21.16 50.85Q725.68-192 695.96-192H263.72Z"></path>
      </g>

      <!-- Navigation: Extension GM3 icon -->
      <g id="extension" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-168q40-2 68-29.5t28-66.5q0-39-28-66.5T144-576v-168q0-29.7 21.15-50.85Q186.3-816 216-816h168q0-40 27.77-68 27.78-28 68-28Q520-912 548-884.16q28 27.84 28 68.16h168q29.7 0 50.85 21.15Q816-773.7 816-744v168q40 0 68 27.77 28 27.78 28 68Q912-440 884.16-412q-27.84 28-68.16 28v168q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528H216v112q45 20 70.5 61.5T312-480q0 50.21-25.5 91.6Q261-347 216-328v112Zm264-264Z"></path>
      </g>

      <!-- Navigation: Palette GM3 icon -->
      <g id="palette" viewBox="0 -960 960 960">
        <path d="M480-96q-79 0-149-30t-122.5-82.5Q156-261 126-331T96-480q0-80 30.5-149.5t84-122Q264-804 335.5-834T488-864q78 0 146.5 27T754-763q51 47 80.5 110T864-518q0 96-67 163t-163 67h-68q-8 0-14 5t-6 13q0 15 15 25t15 53q0 37-27 66.5T480-96Zm0-384Zm-216 36q25 0 42.5-17.5T324-504q0-25-17.5-42.5T264-564q-25 0-42.5 17.5T204-504q0 25 17.5 42.5T264-444Zm120-144q25 0 42.5-17.5T444-648q0-25-17.5-42.5T384-708q-25 0-42.5 17.5T324-648q0 25 17.5 42.5T384-588Zm192 0q25 0 42.5-17.5T636-648q0-25-17.5-42.5T576-708q-25 0-42.5 17.5T516-648q0 25 17.5 42.5T576-588Zm120 144q25 0 42.5-17.5T756-504q0-25-17.5-42.5T696-564q-25 0-42.5 17.5T636-504q0 25 17.5 42.5T696-444ZM480-168q11 0 17.5-8.5T504-192q0-16-15-28t-15-50q0-38 26.5-64t64.5-26h69q66 0 112-46t46-112q0-115-88.5-194.5T488-792q-134 0-227 91t-93 221q0 130 91 221t221 91Z"></path>
      </g>

      <!-- Navigation: Language GM3 icon -->
      <g id="navigation-language" viewBox="0 -960 960 960">
        <path d="m488-96 171-456h82L912-96h-79l-41-117H608L567-96h-79ZM169-216l-50-51 192-190q-36-38-67-79t-54-89h82q18 32 36 54.5t52 60.5q38-42 70-87.5t52-98.5H48v-72h276v-96h72v96h276v72H558q-21 69-61 127.5T409-457l91 90-28 74-112-112-191 189Zm463-63h136l-66-189-70 189Z"></path>
      </g>

      <!-- Navigation: Performance GM3 icon -->
      <g id="navigation-performance" viewBox="0 -960 960 960">
        <path d="M429-358q23 22 57 20.5t50-25.5l208-309-309.16 208.26Q410-447 408-413.5t21 55.5Zm52-410q60 0 108 15.5t87 38.5l-69 45q-28-13-58.5-20t-67.5-7q-130.09 0-221.55 93.5Q168-509 168-384q0 38 5.5 62.5T191-264h577q13-33 18.5-60.5T792-384q0-42-11.5-84T747-545l43-65q35 48 54.5 106T864-386q0 51-8.5 89T828-227q-10 17-25.5 26t-34.5 9H192q-19 0-34.5-9T132-227q-19-32-27.5-70T96-386q0-79.72 30.5-149.36Q157-605 209-656.5T331.44-738q70.44-30 149.56-30Zm-1 279Z"></path>
      </g>

      <!-- Navigation: Person GM3 icon -->
      <g id="person" viewBox="0 -960 960 960">
        <path d="M480-480q-66 0-113-47t-47-113q0-66 47-113t113-47q66 0 113 47t47 113q0 66-47 113t-113 47ZM160-160v-112q0-34 17.5-62.5T224-378q62-31 126-46.5T480-440q66 0 130 15.5T736-378q29 15 46.5 43.5T800-272v112H160Zm80-80h480v-32q0-11-5.5-20T700-306q-54-27-109-40.5T480-360q-56 0-111 13.5T260-306q-9 5-14.5 14t-5.5 20v32Zm240-320q33 0 56.5-23.5T560-640q0-33-23.5-56.5T480-720q-33 0-56.5 23.5T400-640q0 33 23.5 56.5T480-560Zm0-80Zm0 400Z"></path>
      </g>

      <!-- Navigation: Power settings GM3 icon -->
      <g id="power-settings" viewBox="0 -960 960 960">
        <path d="M444-432v-384h72v384h-72Zm36 288q-70 0-130.92-26.51-60.92-26.5-106.49-72.08-45.58-45.57-72.08-106.49Q144-410 144-480.16 144-556 176.5-624T268-740l51 51q-49 38-76 92.5T216-480q0 110 77.25 187t186.53 77Q590-216 667-293t77-187q0-61.84-26.5-116.92T641-689l51-51q60 48 92 115.8T816-480q0 70-26.6 130.92-26.6 60.92-71.87 106.49-45.26 45.58-106.4 72.08Q550-144 480-144Z"></path>
      </g>

      <!-- Navigation: Restore GM3 icon -->
      <g id="restore" viewBox="0 -960 960 960">
        <path d="M444-144q-107-14-179.5-94.5T192-430q0-61 23-113.5t63-91.5l51 51q-30 29-47.5 69T264-430q0 81 51.5 140T444-217v73Zm72 0v-73q77-13 128.5-72.5T696-430q0-90-63-153t-153-63h-7l46 46-51 50-132-132 132-132 51 51-45 45h6q120 0 204 84t84 204q0 111-72.5 192T516-144Z"></path>
      </g>

      <!-- Navigation: Search GM3 icon -->
      <g id="search" viewBox="0 -960 960 960">
        <path d="M765-144 526-383q-30 22-65.79 34.5-35.79 12.5-76.18 12.5Q284-336 214-406t-70-170q0-100 70-170t170-70q100 0 170 70t70 170.03q0 40.39-12.5 76.18Q599-464 577-434l239 239-51 51ZM384-408q70 0 119-49t49-119q0-70-49-119t-119-49q-70 0-119 49t-49 119q0 70 49 119t119 49Z"></path>
      </g>

      <!-- Navigation: Security GM3 icon -->
      <g id="security" viewBox="0 -960 960 960">
        <path d="M480-96q-135-33-223.5-153T168-515v-229l312-120 312 120v229q0 146-88.5 266T480-96Zm0-75q97-30 161.5-115.5T717-480H480v-307l-240 92v180q0 9 1 17.5t2 17.5h237v309Z"></path>
      </g>



      <!-- Google Symbols: Print -->
      <g id="printer" viewBox="0 -960 960 960">
        <path d="M648-624v-120H312v120h-72v-192h480v192h-72Zm-480 72h625-625Zm539.789 96Q723-456 733.5-466.289q10.5-10.29 10.5-25.5Q744-507 733.711-517.5q-10.29-10.5-25.5-10.5Q693-528 682.5-517.711q-10.5 10.29-10.5 25.5Q672-477 682.289-466.5q10.29 10.5 25.5 10.5ZM648-216v-144H312v144h336Zm72 72H240v-144H96v-240q0-40 28-68t68-28h576q40 0 68 28t28 68v240H720v144Zm73-216v-153.672Q793-530 781-541t-28-11H206q-16.15 0-27.075 11.04T168-513.6V-360h72v-72h480v72h73Z"/>
      </g>

      <!-- Google Symbols: Print Disabled -->
      <g id="printer-off" viewBox="0 -960 960 960">
        <path d="m768-90-54-54H240v-144H96v-240q0-40 28-68t68-28h42L90-768l51-51 678 678-51 51ZM312-216h330L498-360H312v144Zm462-72-72-72h90v-153.672Q792-530 781.075-541T754-552H510l-72-72h330q40 0 68 28t28 68v240h-90Zm-606-72h72v-72h186L306-552h-99q-16 0-27.5 11.04T168-513.6V-360Zm480-264v-120H318l-72-72h474v192h-72Zm59.789 168Q723-456 733.5-466.289q10.5-10.29 10.5-25.5Q744-507 733.711-517.5q-10.29-10.5-25.5-10.5Q693-528 682.5-517.711q-10.5 10.29-10.5 25.5Q672-477 682.289-466.5q10.29 10.5 25.5 10.5ZM207-552h99-138 39Zm547 0h39-283 244Z"/>
      </g>

      <!-- Cookies Settings SVG -->
      <g id="block"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z"></path></g>

      <!-- The Google "G" icon in the Clear Browsing Data dialog. -->
      <g id="googleg">
        <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"></path>
        <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"></path>
        <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"></path>
        <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"></path>
        <path fill="none" d="M1 1h22v22H1z"></path>
      </g>

      <!-- Safebrowsing SVG -->
      <g id="public"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.95-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"></path></g>

      <!-- Picture-in-picture SVG -->
      <g id="picture-in-picture"><path d="M4 20c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4h16c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414v12c0 .55-.195 1.02-.586 1.414-.394.39-.863.586-1.414.586Zm0-2h16V6H4Zm0 0V6Zm7-5h8V7h-8Zm2-2V9h4v2Zm0 0"></path></g>
      <g id="picture-in-picture-off"><path d="M15.852 13H19V7h-8v1.148l2 2V9h4v2h-3.148Zm5.921 5.926L20 17.148V6H8.852l-2-2H20c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414v12c0 .168-.016.328-.05.488-.032.157-.09.305-.177.438Zm-12.199-6.5Zm4.852-.852Zm6.023 11.727L17.15 20H4c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4l2 2H4v12h11.148L.648 3.5l1.426-1.426 19.801 19.801Zm0 0"></path></g>

      <!-- Touchpad-Mouse SVG -->
      <g id="touchpad-mouse"><path d="M16.5 20c.965 0 1.793-.34 2.477-1.023A3.377 3.377 0 0 0 20 16.5V15h-7v1.5c0 .965.34 1.793 1.023 2.477A3.377 3.377 0 0 0 16.5 20Zm-3.477-7H15.5v-2.852a3.438 3.438 0 0 0-1.637 1.051 3.392 3.392 0 0 0-.84 1.801Zm4.477 0h2.477a3.392 3.392 0 0 0-.84-1.8 3.438 3.438 0 0 0-1.637-1.052Zm-1 9c-1.535 0-2.832-.535-3.898-1.602C11.535 19.332 11 18.035 11 16.5v-3c0-1.535.535-2.832 1.602-3.898C13.668 8.535 14.965 8 16.5 8c1.535 0 2.832.535 3.898 1.602C21.465 10.668 22 11.965 22 13.5v3c0 1.535-.535 2.832-1.602 3.898C19.332 21.465 18.035 22 16.5 22ZM4 18V6Zm0 2c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4h16c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414v2.398a6.878 6.878 0 0 0-.926-.859A6.791 6.791 0 0 0 20 6.852V6H4v12h5.148c.086.352.18.691.29 1.023.109.336.246.66.414.977Zm0 0"></path></g>
      <g id="touchpad-mouse-off"><path d="M16.5 15.023Zm0 0Zm3.977 8.278L.676 3.5l1.426-1.426 19.796 19.801ZM16.5 15.023Zm0 0Zm0 6.977c-1.535 0-2.832-.535-3.898-1.602C11.535 19.332 11 18.035 11 16.5v-3c0-.383.04-.746.113-1.086.075-.344.18-.68.313-1.016L15.023 15H13v1.5c0 .965.34 1.793 1.023 2.477A3.377 3.377 0 0 0 16.5 20a3.4 3.4 0 0 0 1.363-.273 3.312 3.312 0 0 0 1.114-.778l1.421 1.426c-.5.5-1.082.895-1.75 1.188A5.27 5.27 0 0 1 16.5 22Zm5.05-3.324-1.6-1.602c.015-.097.03-.195.038-.285.008-.094.012-.187.012-.289V15h-2.125L15.5 12.625v-2.477a3.518 3.518 0 0 0-.813.364 3.38 3.38 0 0 0-.71.59L12.55 9.676a5.602 5.602 0 0 1 1.761-1.227C14.989 8.15 15.716 8 16.5 8c1.535 0 2.832.535 3.898 1.602C21.465 10.668 22 11.965 22 13.5v3c0 .383-.043.758-.125 1.125a6.991 6.991 0 0 1-.324 1.05ZM17.5 13h2.477a3.392 3.392 0 0 0-.84-1.8 3.438 3.438 0 0 0-1.637-1.052ZM9.926 9.898ZM4 20c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4h.023l2 2H4v12h5.148c.086.352.18.691.29 1.023.109.336.246.66.414.977ZM8.875 6l-2-2H20c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414Zm2.398 2.398Zm0 0"></path></g>

      <!-- Install-Desktop SVG for Web Install API -->
      <g id="install-desktop"><path d="M8 21v-2H4c-.55 0-1.02-.2-1.41-.59S2 17.55 2 17V5c0-.55.2-1.02.59-1.41S3.45 3 4 3h8v2H4v12h16v-3h2v3c0 .55-.2 1.02-.59 1.41S20.55 19 20 19h-4v2H8Zm9-7-5-5 1.4-1.4 2.6 2.58V3h2v7.18l2.6-2.58L22 9l-5 5Z"></path></g>
      <g id="install-desktop-off"><path d="m20 16.72 1.54 1.54c.3-.36.46-.78.46-1.26v-3h-2v2.72ZM8.28 5H12V3H6.28l2 2zM2.52 2.09 1.1 3.51l.97.97C2.03 4.64 2 4.81 2 5v12c0 .55.2 1.02.59 1.41S3.45 19 4 19h4v2h8v-2h.59l.29.29 2.62 2.62 1.43-1.42L2.52 2.09ZM4 17V6.41l3.3 3.3 5 5L14.59 17H4ZM17 14l-5-5 1.4-1.4 2.6 2.58V3h2v7.18l2.6-2.58L22 9l-5 5Z"></path></g>

      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      See http://goo.gl/Y1OdAq for instructions on adding additional icons.
      -->
      <g id="apps"><path d="M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z"></path></g>
      <g id="bluetooth"><path d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z"></path></g>
      <g id="bluetooth-off"><path d="M13 5.83l1.88 1.88-1.6 1.6 1.41 1.41 3.02-3.02L12 2h-1v5.03l2 2v-3.2zM5.41 4L4 5.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l4.29-4.29 2.3 2.29L20 18.59 5.41 4zM13 18.17v-3.76l1.88 1.88L13 18.17z"></path></g>
      <g id="bluetooth-scanning"><path d="M14.24 12.01l2.32 2.32c.28-.72.44-1.51.44-2.33 0-.82-.16-1.59-.43-2.31l-2.33 2.32zm5.29-5.3l-1.26 1.26c.63 1.21.98 2.57.98 4.02s-.36 2.82-.98 4.02l1.2 1.2a9.936 9.936 0 0 0 1.54-5.31c-.01-1.89-.55-3.67-1.48-5.19zm-3.82 1L10 2H9v7.59L4.41 5 3 6.41 8.59 12 3 17.59 4.41 19 9 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM11 5.83l1.88 1.88L11 9.59V5.83zm1.88 10.46L11 18.17v-3.76l1.88 1.88z"></path></g>
      <g id="cloud"><path d="M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96z"></path></g>
      <g id="compose"><path d="M5.39583 9.97917C5.39583 8.70139 4.95139 7.61806 4.0625 6.72917C3.17361 5.84028 2.09028 5.39583 0.8125 5.39583C2.09028 5.39583 3.17361 4.95139 4.0625 4.0625C4.95139 3.17361 5.39583 2.08333 5.39583 0.791665C5.39583 2.08333 5.84028 3.17361 6.72917 4.0625C7.61806 4.95139 8.70139 5.39583 9.97917 5.39583C8.70139 5.39583 7.61806 5.84028 6.72917 6.72917C5.84028 7.61806 5.39583 8.70139 5.39583 9.97917ZM5.39583 15.6042H6.39583L14.125 7.85417L13.625 7.33333L13.1458 6.875L5.39583 14.625V15.6042ZM3.83333 17.1667V13.9583L14.25 3.52083C14.5694 3.21528 14.9444 3.0625 15.375 3.0625C15.8056 3.0625 16.1736 3.21528 16.4792 3.52083L17.4792 4.52083C17.7847 4.82639 17.9375 5.20139 17.9375 5.64583C17.9375 6.07639 17.7847 6.44444 17.4792 6.75L7.04167 17.1667H3.83333ZM16.3333 5.58333L15.3542 4.64583L16.3333 5.58333ZM14.125 7.85417L13.625 7.33333L13.1458 6.875L14.125 7.85417Z"></path></g>
      <g id="content-copy"><path d="M16 1H4c-1.1 0-2 .9-2 2v14h2V3h12V1zm3 4H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h11c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 16H8V7h11v14z"></path></g>
      <g id="devices" viewBox="0 -960 960 960"><path d="M96-192v-96h96v-408q0-29.7 21.15-50.85Q234.3-768 264-768h552v72H264v408h216v96H96Zm516.28 0q-15.28 0-25.78-10.34-10.5-10.34-10.5-25.63v-359.74q0-15.29 10.34-25.79t25.62-10.5h215.76q15.28 0 25.78 10.34 10.5 10.34 10.5 25.63v359.74q0 15.29-10.34 25.79T828.04-192H612.28ZM648-288h144v-264H648v264Zm0 0h144-144Z"></path></g>
      <g id="email"><path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"></path></g>
      <g id="exit-to-app"><path d="M10.09 15.59L11.5 17l5-5-5-5-1.41 1.41L12.67 11H3v2h9.67l-2.58 2.59zM19 3H5c-1.11 0-2 .9-2 2v4h2V5h14v14H5v-4H3v4c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z"></path></g>
      <g id="feedback" viewBox="0 0 24 24"><path d="M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H5.17l-.59.59-.58.58V4h16v12zm-9-4h2v2h-2zm0-6h2v4h-2z"></path></g>
      <g id="file-handling"><path d="M8 16h8v2H8v-2zm0-4h8v2H8v-2zm6-10H6c-1.1 0-2 .9-2 2v16c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zm4 18H6V4h7v5h5v11z" fill="#5F6368"></path></g>
      <g id="file-handling-off"><path d="M13.002 4.001H7.106L5.252 2.148c.232-.094.485-.147.75-.147h8l6 6v8.896l-2-2V9.001h-5v-5z" fill="#5F6368"></path><path d="M16.002 12.001h-.896l.896.896v-.896zM.6 3.45l1.414-1.414 19.94 19.94-1.414 1.414L.6 3.45zM3.986 20.01V6.84l2 2V20.01h11.172l1.765 1.766c-.28.15-.599.234-.937.234H5.976c-1.1 0-1.99-.9-1.99-2z" fill="#5F6368"></path><path d="M9.158 12.01H7.986v2h3.172l-2-2zM13.158 16.01H7.986v2h7.172l-2-2z" fill="#5F6368"></path></g>
      <g id="hid-device"><path d="M20 6H4C2.9 6 2 6.9 2 8V16C2 17.1 2.9 18 4 18H20C21.1 18 22 17.1 22 16V8C22 6.9 21.1 6 20 6ZM11 13H9V15H7V13H5V11H7V9H9V11H11V13ZM14.5 15C13.67 15 13 14.33 13 13.5C13 12.67 13.67 12 14.5 12C15.33 12 16 12.67 16 13.5C16 14.33 15.33 15 14.5 15ZM17.5 12C16.67 12 16 11.33 16 10.5C16 9.67 16.67 9 17.5 9C18.33 9 19 9.67 19 10.5C19 11.33 18.33 12 17.5 12Z"></path></g>
      <g id="hid-device-off"><path d="M20.424 17.88C21.108 17.616 21.6 16.932 21.6 16.128V7.872C21.6 6.84 20.796 6 19.8 6H8.54399L20.424 17.88ZM17.4 9.3C18.228 9.3 18.9 9.972 18.9 10.8C18.9 11.628 18.228 12.3 17.4 12.3C16.572 12.3 15.9 11.628 15.9 10.8C15.9 9.972 16.572 9.3 17.4 9.3ZM20.484 20.484L3.51599 3.516L2.24399 4.788L3.57599 6.12C2.89199 6.384 2.39999 7.068 2.39999 7.872V16.128C2.39999 17.16 3.20399 18 4.19999 18H15.456L19.212 21.756L20.484 20.484ZM9.05999 12.9V15H7.25999V12.9H5.15999V11.1H7.25999V9.804L10.356 12.9H9.05999Z"></path></g>
      <g id="language"><path d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zm6.93 6h-2.95c-.32-1.25-.78-2.45-1.38-3.56 1.84.63 3.37 1.91 4.33 3.56zM12 4.04c.83 1.2 1.48 2.53 1.91 3.96h-3.82c.43-1.43 1.08-2.76 1.91-3.96zM4.26 14C4.1 13.36 4 12.69 4 12s.1-1.36.26-2h3.38c-.08.66-.14 1.32-.14 2 0 .68.06 1.34.14 2H4.26zm.82 2h2.95c.32 1.25.78 2.45 1.38 3.56-1.84-.63-3.37-1.9-4.33-3.56zm2.95-8H5.08c.96-1.66 2.49-2.93 4.33-3.56C8.81 5.55 8.35 6.75 8.03 8zM12 19.96c-.83-1.2-1.48-2.53-1.91-3.96h3.82c-.43 1.43-1.08 2.76-1.91 3.96zM14.34 14H9.66c-.09-.66-.16-1.32-.16-2 0-.68.07-1.35.16-2h4.68c.09.65.16 1.32.16 2 0 .68-.07 1.34-.16 2zm.25 5.56c.6-1.11 1.06-2.31 1.38-3.56h2.95c-.96 1.65-2.49 2.93-4.33 3.56zM16.36 14c.08-.66.14-1.32.14-2 0-.68-.06-1.34-.14-2h3.38c.16.64.26 1.31.26 2s-.1 1.36-.26 2h-3.38z"></path></g>
      <g id="location-on" viewBox="0 -960 960 960">
        <path d="M480.28-96q-13.71 0-23.49-7.5Q447-111 443-123q-19-53-45.5-100.5T321-335q-49-63-79.5-121T211-595.21Q211-707 289.3-785.5 367.6-864 480-864q112.4 0 190.7 78.42Q749-707.15 749-594.57q0 87.57-33.5 145.07T639-335q-52 68-78.5 114.5T517-123q-5 12-14.5 19.5T480.28-96ZM480-223q17-34 38.5-67.27Q540-323.55 582-379q42-54 68.5-100.36Q677-525.71 677-595q0-81-58-139t-139.5-58q-81.5 0-139 58T283-595q0 69.29 27 115.64Q337-433 378-379q42 55.45 63.5 88.73Q463-257 480-223Zm0-275q40 0 68.5-28.5T577-595q0-40-28.5-68.5T480-692q-40 0-68.5 28.5T383-595q0 40 28.5 68.5T480-498Zm0-97Z"></path>
      </g>
      <g id="mic-off"><path d="M19,11h-2c0,0.91-0.25,1.76-0.68,2.49l1.45,1.45C18.54,13.82,19,12.47,19,11z M2.81,2.81L1.39,4.22l11.66,11.66 C12.71,15.96,12.36,16,12,16c-2.76,0-5-2.24-5-5H5c0,3.53,2.61,6.43,6,6.92V21h2v-3.08c0.57-0.08,1.12-0.24,1.64-0.45l5.14,5.14 l1.41-1.41L2.81,2.81z M15,11V5c0-1.66-1.34-3-3-3S9,3.34,9,5v1.17l5.81,5.81C14.92,11.67,15,11.35,15,11z"></path></g>
      <g id="music-note"><path d="M12 3v10.55c-.59-.34-1.27-.55-2-.55-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4V7h4V3h-6z"></path></g>
      <g id="performance"><path d="M0 0h24v24H0z" fill="none"></path><path d="m20.38 8.57-1.23 1.85a8 8 0 0 1-.22 7.58H5.07A8 8 0 0 1 15.58 6.85l1.85-1.23A10 10 0 0 0 3.35 19a2 2 0 0 0 1.72 1h13.85a2 2 0 0 0 1.74-1 10 10 0 0 0-.27-10.44zm-9.79 6.84a2 2 0 0 0 2.83 0l5.66-8.49-8.49 5.66a2 2 0 0 0 0 2.83z"></path></g>
      <g id="refresh"><path d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z"></path></g>
      <g id="rotate-right"><path d="M15.55 5.55L11 1v3.07C7.06 4.56 4 7.92 4 12s3.05 7.44 7 7.93v-2.02c-2.84-.48-5-2.94-5-5.91s2.16-5.43 5-5.91V10l4.55-4.45zM19.93 11c-.17-1.39-.72-2.73-1.62-3.89l-1.42 1.42c.54.75.88 1.6 1.02 2.47h2.02zM13 17.9v2.02c1.39-.17 2.74-.71 3.9-1.61l-1.44-1.44c-.75.54-1.59.89-2.46 1.03zm3.89-2.42l1.42 1.41c.9-1.16 1.45-2.5 1.62-3.89h-2.02c-.14.87-.48 1.72-1.02 2.48z"></path></g>
      <g id="sync-disabled"><path d="M10 6.35V4.26c-.8.21-1.55.54-2.23.96l1.46 1.46c.25-.12.5-.24.77-.33zm-7.14-.94l2.36 2.36C4.45 8.99 4 10.44 4 12c0 2.21.91 4.2 2.36 5.64L4 20h6v-6l-2.24 2.24C6.68 15.15 6 13.66 6 12c0-1 .25-1.94.68-2.77l8.08 8.08c-.25.13-.5.25-.77.34v2.09c.8-.21 1.55-.54 2.23-.96l2.36 2.36 1.27-1.27L4.14 4.14 2.86 5.41zM20 4h-6v6l2.24-2.24C17.32 8.85 18 10.34 18 12c0 1-.25 1.94-.68 2.77l1.46 1.46C19.55 15.01 20 13.56 20 12c0-2.21-.91-4.2-2.36-5.64L20 4z"></path></g>
      <g id="sync-problem"><path d="M3 12c0 2.21.91 4.2 2.36 5.64L3 20h6v-6l-2.24 2.24C5.68 15.15 5 13.66 5 12c0-2.61 1.67-4.83 4-5.65V4.26C5.55 5.15 3 8.27 3 12zm8 5h2v-2h-2v2zM21 4h-6v6l2.24-2.24C18.32 8.85 19 10.34 19 12c0 2.61-1.67 4.83-4 5.65v2.09c3.45-.89 6-4.01 6-7.74 0-2.21-.91-4.2-2.36-5.64L21 4zm-10 9h2V7h-2v6z"></path></g>
      <g id="volume-down"><path d="M1 13H4.46667L8 16.5V3.5L4.46667 7H1V13ZM10 6.5V13.5C11.776 12.8652 12.5 11.0043 12.5 10C12.5 8.99565 11.776 7.14348 10 6.5Z"></path></g>
      <g id="volume-up"><path d="M3 9v6h4l5 5V4L7 9H3zm13.5 3c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 3.23v2.06c2.89.86 5 3.54 5 6.71s-2.11 5.85-5 6.71v2.06c4.01-.91 7-4.49 7-8.77s-2.99-7.86-7-8.77z"></path></g>
      <g id="volume-up-off"><path d="M16.25,13.42C16.4,12.97,16.5,12.5,16.5,12c0-1.77-1.02-3.29-2.5-4.03v3.2L16.25,13.42z"></path><path d="M19,12c0,1.21-0.31,2.34-0.85,3.32l1.46,1.46C20.48,15.39,21,13.76,21,12c0-4.28-2.99-7.86-7-8.77v2.06 C16.89,6.15,19,8.83,19,12z"></path><path d="M2.81,2.81L1.39,4.22L6.17,9H3v6h4l5,5v-5.17l3.32,3.32c-0.42,0.23-0.85,0.43-1.32,0.56v2.06c1-0.23,1.94-0.62,2.79-1.15 l2.99,2.99l1.41-1.41L2.81,2.81z"></path><polygon points="12,9.17 12,4 9.41,6.59"></polygon></g>
    </defs>
  </svg>
</cr-iconset>
`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
    document.head.appendChild(iconset);
}
