// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { loadTimeData } from './i18n_setup.js';
function createPageVisibility() {
    if (!loadTimeData.getBoolean('isGuest')) {
        return undefined;
    }
    // 
    // 
    const pageVisibility = {
        ai: false,
        autofill: false,
        people: false,
        onStartup: false,
        reset: false,
        safetyHub: false,
        appearance: {
            setTheme: false,
            homeButton: false,
            hoverCard: false,
            bookmarksBar: false,
            pageZoom: false,
            sidePanel: false,
        },
        privacy: {
            searchPrediction: false,
            networkPrediction: false,
        },
        downloads: true,
        a11y: true,
        extensions: false,
        languages: true,
        performance: false,
        yourSavedInfo: false,
    };
    // 
    return pageVisibility;
}
/**
 * Dictionary defining page visibility.
 */
export let pageVisibility = createPageVisibility();
export function resetPageVisibilityForTesting(testVisibility = createPageVisibility()) {
    pageVisibility = testVisibility;
}
