import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">.sync-row{align-items:center;flex:auto}#profile-icon{background:center/cover no-repeat;border-radius:20px;flex-shrink:0;height:40px;width:40px}#sync-setup{--cr-secondary-text-color:var(--settings-error-color)}#sync-not-allowed{border-top:var(--cr-separator-line);background:var(--google-grey-100)}#sync-not-allowed-text{margin-left:8px}cr-link-row{--cr-link-row-icon-width:40px;border-top:var(--cr-separator-line)}.icon-container{display:flex;flex-shrink:0;justify-content:center;width:40px}#toast{left:0;z-index:1}:host-context([dir='rtl']) #toast{left:auto;right:0}settings-sync-account-control[showing-promo]::part(banner){border-top-left-radius:var(--cr-card-border-radius);border-top-right-radius:var(--cr-card-border-radius)}settings-sync-account-control[showing-promo]::part(title){font-size:1.1rem;line-height:1.625rem}@media (prefers-color-scheme:dark){#sync-not-allowed{background:var(--google-grey-800)}}
    </style>
    <settings-section page-title="$i18n{peoplePageTitle}">
      <div>




        <div id="profile-row" class="cr-row first two-line"
            actionable$="[[isProfileActionable_]]" on-click="onProfileClick_">
          <template is="dom-if" if="[[syncStatus]]">
            <div id="profile-icon"
                style="background-image: [[getIconImageSet_(
                    profileIconUrl_)]]">
            </div>
            <div class="flex cr-row-gap cr-padded-text text-elide">
              <span id="profile-name">[[profileName_]]</span>
              <div class="secondary" hidden="[[!isSyncing_(
                    syncStatus.signedInState)]]">
                [[syncStatus.signedInUsername]]
              </div>
            </div>
            <cr-icon-button class="icon-external"
                id="profile-subpage-arrow"
                hidden="[[!isProfileActionable_]]"
                aria-label="$i18n{accountManagerSubMenuLabel}"
                aria-describedby="profile-name"></cr-icon-button>
          </template>
        </div>

        <cr-link-row id="sync-setup"
            label="$i18n{syncAndNonPersonalizedServices}"
            on-click="onSyncClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>


      </div>
    </settings-section>


    <cr-toast duration="3000" id="toast">
      <span>$i18n{syncSettingsSavedToast}</span>
    </cr-toast>
<!--_html_template_end_-->`;
}
