import '//resources/cr_elements/cr_icon/cr_iconset.js';
import { getTrustedHTML } from '//resources/js/static_types.js';
const div = document.createElement('div');
div.innerHTML = getTrustedHTML `<!-- Icons used in the privacy_page/*, site_settings/* and site_settings_page/*
 pages. Keep in alphabetical ordering. -->
<cr-iconset name="privacy20" size="20">
  <svg>
    <defs>
      <g id="ads-click" viewBox="0 -960 960 960">
        <path d="M480-240q-100 0-170-70t-70-170q0-100 70-170t170-70q100 0 170 70t70 170l-73-24q-9-62-56.5-103T480-648q-70 0-119 49t-49 119q0 63 41 110.5T456-313l24 73Zm44 141q-11 2-22 2.5t-22 .5q-79 0-149-30t-122.5-82.5Q156-261 126-331T96-480q0-80 30-149.5t82.5-122Q261-804 331-834t149-30q80 0 149.5 30t122 82.5Q804-699 834-629.5T864-480q0 11-.5 22t-1.5 22l-70-22v-22q0-130-91-221t-221-91q-130 0-221 91t-91 221q0 130 91 221t221 91q5 0 11-.5t11-.5l22 70Zm296 27L654-239 600-96 480-480l384 120-143 53 167 167-68 68Z"></path>
      </g>
      <g id="person-check" viewBox="0 -960 960 960">
        <path d="M695-456 576-575l51-51 68 68 153-152 51 50-204 204Zm-311-24q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42ZM96-192v-92q0-25.78 12.5-47.39T143-366q55-32 116-49t125-17q64 0 125 17t116 49q22 13 34.5 34.61T672-284v92H96Zm72-72h432v-20q0-6.47-3.03-11.76-3.02-5.3-7.97-8.24-47-27-99-41.5T384-360q-54 0-106 14.5T179-304q-4.95 2.94-7.98 8.24Q168-290.47 168-284v20Zm216.21-288Q414-552 435-573.21t21-51Q456-654 434.79-675t-51-21Q354-696 333-674.79t-21 51Q312-594 333.21-573t51 21ZM384-312Zm0-312Z"></path>
      </g>

      <g id="privacy-secure-dns" viewBox="0 0 18 18">
        <path fill-rule="evenodd" d="M9 17.167a8.205 8.205 0 0 1-3.187-.625 8.59 8.59 0 0 1-2.605-1.75 8.589 8.589 0 0 1-1.75-2.604A8.204 8.204 0 0 1 .833 9c0-1.125.223-2.18.667-3.167A8.557 8.557 0 0 1 3.27 3.23a8.112 8.112 0 0 1 2.605-1.75c1-.43 2.042-.646 3.125-.646.306 0 .59.014.854.042.264.028.465.062.604.104V6a30.905 30.905 0 0 0-.708-1.98c-.264-.665-.514-1.13-.75-1.394-.306.292-.562.778-.77 1.458-.195.68-.348 1.327-.46 1.938h2.688v1.5H7.583c-.027.278-.048.535-.062.77V9.73c.014.235.035.485.062.75h2.834c.027-.279.041-.536.041-.772v-.646c0-.194-.007-.423-.02-.687 0-.278-.007-.549-.021-.812h1.52c0 .319.007.61.021.875a11.264 11.264 0 0 1 .001 1.333c0 .236-.008.472-.021.708h3.312A5.462 5.462 0 0 0 15.438 9c0-.236-.021-.48-.063-.73a5.358 5.358 0 0 0-.125-.707h1.792c.041.277.07.527.083.75.028.222.042.45.042.687a7.872 7.872 0 0 1-.646 3.146c-.417.986-1 1.854-1.75 2.604a8.556 8.556 0 0 1-2.604 1.77A7.826 7.826 0 0 1 9 17.168Zm-6.25-6.688h3.313c-.028-.264-.05-.52-.063-.77v-1.48c.014-.236.035-.472.063-.708H2.75A5.466 5.466 0 0 0 2.563 9c0 .236.013.472.041.708.028.236.077.493.146.771Zm4.375 4.688a6.246 6.246 0 0 1-.52-1.396 17.79 17.79 0 0 1-.355-1.792H3.313A6.394 6.394 0 0 0 4.896 14c.667.556 1.41.944 2.229 1.167ZM3.313 6.02H6.25c.097-.653.215-1.25.354-1.792a6.973 6.973 0 0 1 .542-1.396 5.87 5.87 0 0 0-2.25 1.188 6.164 6.164 0 0 0-1.583 2ZM9 15.375c.222-.222.451-.653.688-1.292.236-.652.416-1.354.541-2.104H7.771c.125.75.298 1.452.52 2.104.237.64.473 1.07.709 1.292Zm1.875-.208A5.849 5.849 0 0 0 13.083 14a6.266 6.266 0 0 0 1.604-2.02H11.73c-.083.652-.201 1.25-.354 1.79a7.053 7.053 0 0 1-.5 1.397Zm1.063-9.104V.832h5.229v5.23h-5.23Zm2.687-2.688h1.354V2.021h-1.354v1.354Z"></path>
      </g>

      <g id="signpost" viewBox="0 -960 960 960">
        <path d="M444-96v-192H240l-96-108 96-108h204v-72H192v-216h252v-72h72v72h204l96 108-96 108H516v72h252v216H516v192h-72ZM264-648h424l32-36-32-36H264v72Zm8 288h424v-72H272l-32 36 32 36Zm-8-288v-72 72Zm432 288v-72 72Z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>
<cr-iconset name="privacy" size="24">
  <svg>
    <defs>
      <g id="account-circle" viewBox="0 -960 960 960">
        <path d="M237-285q54-38 115.5-56.5T480-360q66 0 127.5 18.5T723-285q35-41 52-91t17-104q0-129.67-91.23-220.84-91.23-91.16-221-91.16Q350-792 259-700.84 168-609.67 168-480q0 54 17 104t52 91Zm243-123q-60 0-102-42t-42-102q0-60 42-102t102-42q60 0 102 42t42 102q0 60-42 102t-102 42Zm.28 312Q401-96 331-126t-122.5-82.5Q156-261 126-330.96t-30-149.5Q96-560 126-629.5q30-69.5 82.5-122T330.96-834q69.96-30 149.5-30t149.04 30q69.5 30 122 82.5T834-629.28q30 69.73 30 149Q864-401 834-331t-82.5 122.5Q699-156 629.28-126q-69.73 30-149 30Zm-.28-72q52 0 100-16.5t90-48.5q-43-27-91-41t-99-14q-51 0-99.5 13.5T290-233q42 32 90 48.5T480-168Zm0-312q30 0 51-21t21-51q0-30-21-51t-51-21q-30 0-51 21t-21 51q0 30 21 51t51 21Zm0-72Zm0 319Z"></path>
      </g>
      <g id="account-circle-off" viewBox="0 -960 960 960">
        <path d="M527-535ZM420-420Zm59.96 252Q532-168 580-184.5q48-16.5 90-48.5-43-27-91-41t-99-14q-51 0-99.5 13.5T290-233q42 32 89.96 48.5 47.96 16.5 100 16.5ZM595-466l-52-52q5-8 7-16.67 2-8.66 2-17.33 0-30-21-51t-51-21q-8.67 0-17.33 2-8.67 2-16.67 7l-52-52q19-14 41-21.5t45-7.5q59.66 0 101.83 42.17T624-552q0 23-7.5 45T595-466Zm202 202-52-52q23-37 35-78.66 12-41.65 12-85.34 0-130-91-221t-221-91q-43.69 0-85.34 12Q353-768 316-745l-52-52q48-33 103.02-50 55.02-17 112.98-17 80 0 149.5 30t122 82.5Q804-699 834-629.5T864-480q0 57.96-17 112.98T797-264ZM480-96q-79.38 0-149.19-30T208.5-208.5Q156-261 126-330.81T96-480q0-57.62 17-112.31Q130-647 162-695l-72-73 51-51 678 678-51 51-554-553q-23 37-34.5 78T168-480q0 54 17 104t52 91q54-38 115.41-56.5Q413.83-360 479.66-360q37.34 0 73.34 6.5t71 18.5l127 127q-54 54-124.09 83Q556.81-96 480-96Z"></path>
      </g>
      <g id="cardboard" viewBox="0 -960 960 960">
        <path d="M216-336h153l29.75-58.35Q411-417 432.5-430.5t47.49-13.5q25.99 0 47.5 13T561-395.08L591-336h153v-288H216v288Zm96.21-72Q342-408 363-429.21t21-51Q384-510 362.79-531t-51-21Q282-552 261-530.79t-21 51Q240-450 261.21-429t51 21ZM144-336.06v-288.22Q144-654 165.15-675T216-696h528q29.7 0 50.85 21.17Q816-653.67 816-623.94v288.22Q816-306 794.85-285T744-264H591q-20 0-37.5-10.5T527-303l-30-58q-2.57-5.08-7.29-8.04Q485-372 480-372q-5 0-10 3t-7 8l-30 58q-9 18-26.5 28.5T369-264H216q-29.7 0-50.85-21.17Q144-306.33 144-336.06ZM648.21-408Q678-408 699-429.21t21-51Q720-510 698.79-531t-51-21Q618-552 597-530.79t-21 51Q576-450 597.21-429t51 21ZM480-480Z"></path>
      </g>
      <g id="cardboard-off" viewBox="0 -960 960 960">
        <path d="M768-90 90-768l51-51 678 678-51 51ZM378-480Zm417 195-51-51.25V-624H437l-71-72h378q29.7 0 50.85 21.13Q816-653.73 816-624.06v287.77q0 15.29-5.48 28.34T795-285ZM311.79-408Q282-408 261-429.21t-21-51Q240-510 261.21-531t51-21Q342-552 363-530.79t21 51Q384-450 362.79-429t-51 21ZM650-408l-74-75q2-29 22.5-49t49.5-20q29.7 0 50.85 21.15Q720-509.7 720-480q0 29-20.5 50T650-408Zm-71-72ZM216-264q-29.7 0-50.85-21.17Q144-306.33 144-336.06v-288.22Q144-654 165.15-675T216-696h48l72 72H216v288h153l29.75-58.35Q411-417 432.5-430.5T480-444h36l180 180H591q-20 0-37.5-10.5T527-303l-30-58q-2.57-5.08-7.29-8.04Q485-372 480-372q-5 0-10 3t-7 8l-30 58q-9 18-26.5 28.5T369-264H216Z"></path>
      </g>
      <g id="code" viewBox="0 -960 960 960">
        <path d="M336-240 96-480l240-240 51 51-189 189 189 189-51 51Zm288 0-51-51 189-189-189-189 51-51 240 240-240 240Z"></path>
      </g>
      <g id="code-off" viewBox="0 -960 960 960">
        <path d="M768-90 288-570l-90 90 189 189-51 51L96-480l141-141L90-768l51-51 678 678-51 51Zm-45-249-51-51 90-90-189-189 51-51 240 240-141 141Z"></path>
      </g>
      <g id="content-paste" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h171q8-31 33.5-51.5T480-888q34 0 59.5 20.5T573-816h171q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528h-72v120H288v-120h-72v528Zm263.79-528q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5Z"></path>
      </g>
      <g id="content-paste-off" viewBox="0 -960 960 960">
        <path d="m816-246-72-72v-426h-72v120H438L246-816h141q11-32 34.5-52t58.5-20q35 0 59 19.5t34 52.5h171q29.7 0 50.85 21.15Q816-773.7 816-744v498ZM479.79-744q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM642-216 216-642v426h426Zm-426 72q-29.7 0-50.85-21.15Q144-186.3 144-216v-498l-54-54 51-51 678 678-51 51-54-54H216Z"></path>
      </g>
      <g id="cookie" viewBox="0 -960 960 960">
        <path d="M480-96q-79.38 0-149.19-30T208.5-208.5Q156-261 126-330.81T96-480q0-81 31-151.5t82.5-123Q261-807 329-837.5T470-868q23 0 45 3t45 9q-8 45 5.5 82t42.03 60.96q28.53 23.96 68 33T759-681q-24 57 8.01 108.5 32.01 51.49 95.08 53.4.95 10.49 1.43 19.55T864-480q0 78-30.24 147.98-30.24 69.99-82.08 122.6t-121.92 83.01Q559.68-96 480-96Zm-60-456q25 0 42.5-17.5T480-612q0-25-17.5-42.5T420-672q-25 0-42.5 17.5T360-612q0 25 17.5 42.5T420-552Zm-96 192q25 0 42.5-17.5T384-420q0-25-17.5-42.5T324-480q-25 0-42.5 17.5T264-420q0 25 17.5 42.5T324-360Zm275.79 36q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM480-168q125 0 214.5-84.5T792-462q-45-18-75-55.5T679-603q-76-11-129-63t-63-126q-63-4-120.5 19.5t-102 66.5Q220-663 194-604.5T168-480q0 129.67 91.16 220.84Q350.33-168 480-168Zm0-311Z"></path>
      </g>
      <g id="credit-card" viewBox="0 -960 960 960">
        <path d="M864-696v432q0 29-21.15 50.5T792-192H168q-29 0-50.5-21.5T96-264v-432q0-29 21.5-50.5T168-768h624q29.7 0 50.85 21.5Q864-725 864-696Zm-696 72h624v-72H168v72Zm0 144v216h624v-216H168Zm0 216v-432 432Z"></path>
      </g>
      <g id="credit-card-off" viewBox="0 -960 960 960">
        <path d="m846-216-54-54v-210H582L438-624h354v-72H366l-72-72h498q29.7 0 50.85 21.15Q864-725.7 864-696v432q0 14-4 25.96-4 11.97-14 22.04ZM378-480Zm204 0Zm-204 0H168v216h426L378-480ZM803-56 666-192H168q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 116.86-747q20.85-21 50.14-21h25l78 78H168v66h66L56-803l51-50 746 746-50 51Z"></path>
      </g>
      <g id="database" viewBox="0 -960 960 960">
        <path d="M479.5-144q-140.5 0-238-41.85T144-288v-384q0-60 98-102t237.5-42q139.5 0 238 42T816-672v384q0 60.3-98 102.15Q620-144 479.5-144Zm.47-456Q566-600 646-621.5t98-50.5q-18-28-98.5-50t-165.53-22Q394-744 313.5-722T216-672q17 29 96.5 50.5T479.97-600Zm.03 192q42 0 80-4.5t71.5-12.5q33.5-8 62-20.5T744-474v-109q-24.25 13.22-53.62 23.61Q661-549 627.17-542.15q-33.83 6.85-71 10.5Q519-528 479.5-528t-77.11-3.65q-37.62-3.65-71-10.5Q298-549 268.5-559.5 239-570 216-583v109q22.41 15.94 50.21 28.47Q294-433 327.5-425q33.5 8 72 12.5T480-408Zm.32 192q43.32 0 88.05-6.4 44.73-6.39 82.4-16.9 37.67-10.5 63.09-23.75Q739.29-276.3 744-290v-101q-24.25 13.22-53.62 23.61Q661-357 627.17-350.15q-33.83 6.85-71 10.5Q519-336 479.5-336t-77.11-3.65q-37.62-3.65-71-10.5Q298-357 268.5-367.5 239-378 216-391v103q5 13 30.5 26t63 23q37.5 10 82.5 16.5t88.32 6.5Z"></path>
      </g>
      <g id="database-off" viewBox="0 -960 960 960">
        <path d="M449-449Zm97-87Zm-97 87Zm97-87Zm-97 87Zm97-87ZM768-90 90-768l51-51 678 678-51 51Zm-287.52-54Q339-144 241.5-185.85T144-288v-384q0-23 16-44.5t45-38.5l226 226q-65-4-120.5-18T216-583v109q44 32 111.5 49T480-408q17.96 0 35.02-.5 17.06-.5 34.12-2.5L612-348q-31 6-64.07 9-33.07 3-67.93 3-80 0-148.5-14.5T216-391v103q10 26 93.5 49T480-216q62 0 123-12t99-29l53 52q-45.91 28.22-117.59 44.61Q565.74-144 480.48-144ZM807-255l-63-63v-73q-11 6-23.94 11.33Q707.12-374.33 693-369l-57-57q32-8 59-20t49-28v-109q-40 22-94.5 35T532-530l-70-70q23 1 65-2.5t85.5-12q43.5-8.5 81-22.5t50.5-35q-18-28-98.5-50T480-744q-37 0-74 4.5T335-727l-59-59q43-14 94.5-22t109.5-8q139.07 0 237.53 42Q816-732 816-672v384q0 8-2 16.5t-7 16.5Z"></path>
      </g>
      <g id="developer-board" viewBox="0 -960 960 960">
        <path d="M168-144q-29 0-50.5-21.5T96-216v-528q0-29.7 21.5-50.85Q139-816 168-816h528q29 0 50.5 21.15T768-744v72h96v72h-96v84h96v72h-96v84h96v72h-96v71.5q0 29.5-21.5 51T696-144H168Zm0-72h528v-528H168v528Zm72-72h192v-144H240v144Zm240-288h144v-96H480v96Zm-240 96h192v-192H240v192Zm240 192h144v-240H480v240ZM168-744v528-528Z"></path>
      </g>
      <g id="developer-board-off" viewBox="0 -960 960 960">
        <path d="M803-56 56-803l51-50 746 746-50 51ZM246-816h449.54Q726-816 747-794.5t21 51v71.5h96v72h-96v84h96v72h-96v84h96v72h-90l-78-78v-378H318l-72-72Zm186 186-42-42h42v42Zm54 54-6-6v-90h144v96H486Zm138 138-90-90h90v90Zm-192 12Zm81-122ZM240-288v-144h192v144H240Zm-90-522 66 66h-48v528h529v-47l71 71q-9 19-29.5 33.5T696-144H168q-29 0-50.5-21.5T96-216v-528q0-22.66 16.5-40.33Q129-802 150-810Zm330 330 160 160v32H480v-192ZM288-672l158 158v34H240v-192h48Z"></path>
      </g>
      <g id="devices-off" viewBox="0 -960 960 960">
        <path d="m366-696-72-72h522v72H366Zm498 480-72-72v-264H648v138l-72-72v-102q0-15.3 10.34-25.65Q596.68-624 611.96-624h215.76q15.28 0 25.78 10.35Q864-603.3 864-588v372ZM768-90 666-192h-54q-15.3 0-25.65-10.35Q576-212.7 576-228v-54L264-594v306h216v96H96v-96h96v-378L90-768l51-51 678 678-51 51Zm-48-261Z"></path>
      </g>
      <g id="drive-pdf" viewBox="0 -960 960 960">
        <path d="M612-384h48v-64h48v-48h-48v-32h48v-48h-96v192Zm-360 0h48v-64h36q20.4 0 34.2-13.8Q384-475.6 384-496v-32q0-20.4-13.8-34.2Q356.4-576 336-576h-84v192Zm48-112v-32h36v32h-36Zm132 112h84q20.4 0 34.2-13.8Q564-411.6 564-432v-96q0-20.4-13.8-34.2Q536.4-576 516-576h-84v192Zm48-48v-96h36v96h-36ZM216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H216Zm0-72h528v-528H216v528Zm0-528v528-528Z"></path>
      </g>
      <g id="file-download-off" viewBox="0 -960 960 960">
        <path d="M768-90 666-192H264.09q-29.74 0-50.91-21.15Q192-234.3 192-264v-72h72v72h330l-93-93-21 21-192-192 21-21L90-768l51-51 678 678-51 51ZM603-459l-51-51 69-69 51 51-69 69Zm-87-87-72-72v-198h72v270Zm252 252-42-42h42v42Z"></path>
      </g>
      <g id="file-save" viewBox="0 -960 960 960">
        <path d="m732-120 144-144-51-51-57 57v-150h-72v150l-57-57-51 51 144 144ZM588 0v-72h288V0H588ZM264-144q-29 0-50.5-21.5T192-216v-576q0-29 21.5-50.5T264-864h312l192 192v192h-72v-144H528v-168H264v576h264v72H264Zm0-72v-576 576Z"></path>
      </g>
      <g id="file-save-off" viewBox="0 -960 960 960">
        <path d="m837-225-51-51 39-39 51 51-39 39Zm-69-69-72-71.81V-408h72v114ZM588 0v-72h198L264-594v378h265v72H264q-29 0-50.5-21.5T192-216v-450L56-803l51-50L888-72V0H588Zm108-480h72v-192L576-864H264q-13 0-26.5 5T216-846l54 54h258v168h168v144Zm-242 76Zm96-118Z"></path>
      </g>
      <g id="font-download" viewBox="0 -960 960 960">
        <path d="M257-240h83.34L384-363h193l43.31 123H703L523-720h-86L257-240Zm151-192 70-199h3l70 199H408ZM168-96q-29.7 0-50.85-21.15Q96-138.3 96-168v-624q0-29.7 21.15-50.85Q138.3-864 168-864h624q29.7 0 50.85 21.15Q864-821.7 864-792v624q0 29.7-21.15 50.85Q821.7-96 792-96H168Zm0-72h624v-624H168v624Zm0-624v624-624Z"></path>
      </g>
      <g id="font-download-off" viewBox="0 -960 960 960">
        <path d="m803-56-41-40H168q-29.7 0-50.85-21.15Q96-138.3 96-168v-594l-40-41 51-50 746 746-50 51ZM168-168h522L168-690v522Zm696-30-72-72v-522H270l-72-72h594q29.7 0 50.85 21.15Q864-821.7 864-792v594ZM632-430 509-553l-27-78h-4l-12 35-55-55 26-69h86l109 290Zm-205 2Zm82-124Zm105 301-51-146 130 130 6 16h-85Zm-358 11 127-337 57 57-31 88h119.1l68.9 69H386.98L344-240h-88Z"></path>
      </g>
      <g id="hand-gesture" viewBox="0 -960 960 960">
        <path d="M880-759q0-51-35-86t-86-35v-60q75 0 128 53t53 128h-60ZM240-40q-83 0-141.5-58.5T40-240h60q0 58 41 99t99 41v60Zm162 0q-30 0-56-13.5T303-92L48-465l24-23q19-19 45-22t47 12l116 81v-383q0-17 11.5-28.5T320-840q17 0 28.5 11.5T360-800v537L212-367l157 229q5 8 14 13t19 5h278q33 0 56.5-23.5T760-200v-560q0-17 11.5-28.5T800-800q17 0 28.5 11.5T840-760v560q0 66-47 113T680-40H402Zm38-440v-400q0-17 11.5-28.5T480-920q17 0 28.5 11.5T520-880v400h-80Zm160 0v-360q0-17 11.5-28.5T640-880q17 0 28.5 11.5T680-840v360h-80ZM486-300Z"></path>
      </g>
      <g id="hand-gesture-off" viewBox="0 -960 960 960">
        <path d="m840-234-80-80v-446q0-17 11.5-28.5T800-800q17 0 28.5 11.5T840-760v526ZM360-714l-80-80v-6q0-17 11.5-28.5T320-840q17 0 28.5 11.5T360-800v86Zm160 160-80-80v-246q0-17 11.5-28.5T480-920q17 0 28.5 11.5T520-880v326Zm160 75h-80v-361q0-17 11.5-28.5T640-880q17 0 28.5 11.5T680-840v361Zm37 349L360-487v252l-158-79 177 176q8 7 16 12.5t18 5.5h267q10 0 19.5-2.5T717-130ZM413-40q-24 0-46-9t-39-26L39-364l54-43q18-14 41-16.5t44 8.5l102 50v-202L27-820l57-57L876-85l-57 57-44-44q-20 15-44 23.5T680-40H413Zm187-439Zm280-280q0-51-35-86t-86-35v-60q75 0 128 53t53 128h-60ZM240-40q-83 0-141.5-58.5T40-240h60q0 58 41 99t99 41v60Zm304-264Z"></path>
      </g>
      <g id="hide-image" viewBox="0 -960 960 960">
        <path d="m816-246-72-72v-426H318l-72-72h498q29 0 50.5 21.5T816-744v498ZM768-90l-54-54H216q-29 0-50.5-21.5T144-216v-498l-54-54 51-51 678 678-51 51ZM264-288l108-144 72 96 34-45-262-261v426h426l-72-72H264Zm264-240ZM426-426Z"></path>
      </g>
      <g id="imagesmode" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.5Q144-187 144-216v-528q0-29 21.15-50.5T216-816h528q29.7 0 50.85 21.5Q816-773 816-744v528q0 29-21.15 50.5T744-144H216Zm0-72h528v-528H216v528Zm48-72h432L552-480 444-336l-72-96-108 144Zm-48 72v-528 528Zm120-360q20 0 34-14t14-34q0-20-14-34t-34-14q-20 0-34 14t-14 34q0 20 14 34t34 14Z"></path>
      </g>
      <g id="location-off" viewBox="0 -960 960 960">
        <path d="M480.28-96q-13.71 0-23.49-7.5Q447-111 443-123q-19-53-45.5-100.5T321-335q-49.21-63.41-79.61-121.06Q211-513.71 211-595.37q0-33.63 8-64.63 8-31 22-59l55 54q-6 17-9.5 34t-3.5 36q0 69.29 27 115.64Q337-433 378-379q42 55.45 63.5 88.73Q463-257 480-223q17-34 38.5-67.27Q540-323.55 582-379l51 52q-49 64-74 109t-42 95q-5 12-14.5 19.5T480.28-96ZM677-386l-52-52q23-35 37.5-71.3T677-595q0-81-58-139t-139-58q-44 0-81 17.5T335-728l-52-51q37.06-39.53 87.77-62.27Q421.49-864 480-864q112.4 0 190.7 78.3Q749-707.4 749-595q0 67.39-20.5 116.22T677-386Zm91 296L90-769l51-51 678 679-51 51ZM542-521q15.91-13.73 25.45-32.37Q577-572 577-595q0-40-28.5-68.5T480-692q-23 0-41.63 9.55Q419.73-672.91 406-657l136 136Zm-68-68Zm-63 141Z"></path>
      </g>
      <g id="lock" viewBox="0 -960 960 960">
        <path d="M266.59-88.59q-34.26 0-58.49-24.38-24.23-24.38-24.23-58.62v-378.26q0-34.24 24.38-58.62 24.38-24.38 58.62-24.38h17.54v-89.06q0-81.6 57.19-138.95 57.18-57.36 138.63-57.36 81.44 0 138.4 57.36 56.96 57.35 56.96 138.95v89.06h17.54q34.24 0 58.62 24.38 24.38 24.38 24.38 58.62v378.26q0 34.24-24.39 58.62-24.4 24.38-58.65 24.38h-426.5Zm.28-83h426.26v-378.26H266.87v378.26Zm213.34-117.13q29.79 0 50.79-21.21t21-51q0-29.79-21.21-50.79t-51-21q-29.79 0-50.79 21.21-21 21.22-21 51 0 29.79 21.21 50.79t51 21Zm-112.8-344.13h225.18v-89.06q0-47.21-32.73-80.26-32.73-33.05-79.86-33.05t-79.86 33.05q-32.73 33.05-32.73 80.26v89.06ZM266.87-171.59v-378.26 378.26Z"></path>
      </g>
      <g id="mic" viewBox="0 -960 960 960">
        <path d="M480-384q-50 0-85-35t-35-85v-240q0-50 35-85t85-35q50 0 85 35t35 85v240q0 50-35 85t-85 35Zm0-240Zm-36 480v-99q-98.8-13.1-163.4-87.05Q216-404 216-504h72q0 79.68 56.23 135.84 56.22 56.16 136 56.16Q560-312 616-368.16q56-56.16 56-135.84h72q0 100-64.6 173.95Q614.8-256.1 516-243v99h-72Zm36-312q20.4 0 34.2-13.8Q528-483.6 528-504v-240q0-20.4-13.8-34.2Q500.4-792 480-792q-20.4 0-34.2 13.8Q432-764.4 432-744v240q0 20.4 13.8 34.2Q459.6-456 480-456Z"></path>
      </g>
      <g id="mic-off" viewBox="0 -960 960 960">
        <path d="m701-361-53-53q11-21 17.33-43.4 6.33-22.41 6.33-46.6H744q0 38-11.18 74.38Q721.64-393.24 701-361ZM477-583Zm117.24 115L528-534v-210q0-20.4-13.8-34.2Q500.4-792 480-792q-20.4 0-34.2 13.8Q432-764.4 432-744v114l-72-72.38V-744q0-50 35-85t85-35q50 0 85 35t35 85v240q0 9-1.5 18t-4.26 18ZM444-144v-99q-99-12-163.5-86.5T216-504h72q0 79.68 56 135.84T480-312q34 0 64.5-13t56.5-35l52 52q-29.3 25.09-64.15 42.55Q554-248 516-243v99h-72Zm324 54L90-769l51-51 678 679-51 51Z"></path>
      </g>
      <g id="notifications" viewBox="0 -960 960 960">
        <path d="M192-216v-72h48v-240q0-87 53.5-153T432-763v-53q0-20 14-34t34-14q20 0 34 14t14 34v53q85 16 138.5 82T720-528v240h48v72H192Zm288-276Zm-.21 396Q450-96 429-117.15T408-168h144q0 30-21.21 51t-51 21ZM312-288h336v-240q0-70-49-119t-119-49q-70 0-119 49t-49 119v240Z"></path>
      </g>
      <g id="notifications-off" viewBox="0 -960 960 960">
        <path d="M192-216v-72h48v-240q0-41 13.5-78.5T290-677l53 53q-15 21-23 45.75T312-528v240h264L90-774l51-52 678 679-51 51-120-120H192Zm528-132-72-72v-108q0-70-49-119t-119-49q-22.84 0-43.92 6Q415-684 395-673l-52-52.51Q363-740 385.5-749q22.5-9 46.5-14v-53q0-20 14-34t34-14q20 0 34 14t14 34v53q85 16 138.5 82T720-528v180Zm-276-72Zm35.79 324Q450-96 429-117.15T408-168h144q0 30-21.21 51t-51 21ZM522-547Z"></path>
      </g>
      <g id="open-in-browser" viewBox="0 -960 960 960">
        <path d="M216-144q-29.7 0-50.85-21.15Q144-186.3 144-216v-528q0-29.7 21.15-50.85Q186.3-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29.7-21.15 50.85Q773.7-144 744-144H576v-72h168v-456H216v456h168v72H216Zm228 0v-246l-57 57-51-51 144-144 144 144-51 51-57-57v246h-72Z"></path>
      </g>
      <g id="open-in-new-off" viewBox="0 -960 960 960">
        <path d="m768-90-54-54H216q-29.7 0-50.85-21.15Q144-186.3 144-216v-498l-54-54 51-51 678 678-51 51ZM216-216h426L455-404l-68 68-51-51 68-68-188-187v426Zm102-528-72-72h234v72H318Zm238 239-51-51 188-188H576v-72h240v240h-72v-117L556-505Zm260 259-72-72v-162h72v234Z"></path>
      </g>
      <g id="page-info" viewBox="0 -960 960 960">
        <path d="M699.83-133.48q-62.16 0-105.23-43.07-43.08-43.08-43.08-105.23 0-62.16 43.08-105.23 43.07-43.08 105.23-43.08 62.15 0 105.23 43.08 43.07 43.07 43.07 105.23 0 62.15-43.07 105.23-43.08 43.07-105.23 43.07Zm.12-80.61q28.09 0 47.83-19.86t19.74-47.95q0-28.1-19.86-47.84-19.86-19.74-47.96-19.74-28.09 0-47.83 19.86t-19.74 47.96q0 28.09 19.86 47.83t47.96 19.74ZM150.3-240.28v-83h329.22v83H150.3Zm109.87-289.63q-62.15 0-105.23-43.08-43.07-43.07-43.07-105.23 0-62.15 43.07-105.23 43.08-43.07 105.23-43.07 62.16 0 105.23 43.07 43.08 43.08 43.08 105.23 0 62.16-43.08 105.23-43.07 43.08-105.23 43.08Zm.13-80.61q28.09 0 47.83-19.86t19.74-47.96q0-28.09-19.86-47.83t-47.96-19.74q-28.09 0-47.83 19.86t-19.74 47.95q0 28.1 19.86 47.84 19.86 19.74 47.96 19.74Zm220.18-26.2v-83H809.7v83H480.48Zm219.35 354.94ZM260.17-678.22Z"></path>
      </g>
      <g id="piano" viewBox="0 -960 960 960">
        <path d="M216-144q-29 0-50.5-21.5T144-216v-528q0-29.7 21.5-50.85Q187-816 216-816h528q29.7 0 50.85 21.15Q816-773.7 816-744v528q0 29-21.15 50.5T744-144H216Zm0-72h120v-168h-24q-10.2 0-17.1-6.9-6.9-6.9-6.9-17.1v-336h-72v528Zm408 0h120v-528h-72v336q0 10.2-6.9 17.1-6.9 6.9-17.1 6.9h-24v168Zm-240 0h192v-168h-24q-10.2 0-17.1-6.9-6.9-6.9-6.9-17.1v-336h-96v336q0 10.2-6.9 17.1-6.9 6.9-17.1 6.9h-24v168Z"></path>
      </g>
      <g id="piano-off" viewBox="0 -960 960 960">
        <path d="m768-90-54-54H216q-29.7 0-50.85-21.15Q144-186.3 144-216v-498l-54-54 51-51 678 678-51 51Zm48-156-72-72v-426h-72v336q0 3.67-1.5 7.33Q669-397 667-395L528-534v-210h-96v114L246-816h498q29.7 0 50.85 21.15Q816-773.7 816-744v498Zm-600 30h120v-168h-24q-10.2 0-17.1-6.9-6.9-6.9-6.9-17.1v-162l-72-72v426Zm168 0h192v-66L432-426v18q0 10-7 17t-17 7h-24v168Zm240-2h9l-9-9v9Z"></path>
      </g>
      <g id="protocol-handler" viewBox="0 -960 960 960">
        <path d="M378-173q-10 0-19-4t-17-12L108-448q-6-7-9-15.5T96-480q0-9 3-17t9-15l234-259q8-8 17-12t19-4q10 0 18.5 4t16.5 12l67 74 67-74q8-8 16.5-12t18.5-4q10 0 19 4t17 12l234 259q6 7 9 15.5t3 16.5q0 8-3 16.5t-9 15.5L618-189q-8 8-17 12t-19 4q-10 0-18.5-4T547-189l-67-74-67 74q-8 8-16.5 12t-18.5 4Zm0-84 54-59-120-132q-12-14-12-32t12-32l120-132-54-59-202 223 202 223Zm204 0 202-223-202-223-54 59 120 132q12 14 12 32t-12 32L528-316l54 59Z"></path>
      </g>
      <g id="protocol-handler-off" viewBox="0 -960 960 960">
        <path d="M768-90 642-216l-24 27q-7 8-16 12t-20 4q-11 0-20-4t-15-12l-67-74-67 74q-7 8-16 12t-19 4q-11 0-20-4t-16-12L108-448q-6-6-9-14.5T96-480q0-9 3-17t9-15l113-125L90-768l51-51 678 678-51 51ZM591-267l-56-57 56 57Zm-213 10 54-59-120-132q-12-14-12-32t12-32l16-18-56-56-96 106 202 223Zm361-66-51-51 96-106-209-216-47 52 120 132q12 14 12 32t-12 32l-16 18-208-208-55-55-51-51 24-27q8-8 16.5-12t19.5-4q10 0 19 4t16 12l67 74 67-74q7-8 16-12t19-4q11 0 20 4t16 12l234 259q6 7 9 15t3 17q0 9-3 17t-9 15L739-323Z"></path>
      </g>
      <g id="select-window" viewBox="0 -960 960 960">
        <path d="M168-96q-29.7 0-50.85-21.15Q96-138.3 96-168v-336q0-29.7 21.15-50.85Q138.3-576 168-576h72v-216q0-29.7 21.15-50.85Q282.3-864 312-864h480q29.7 0 50.85 21.15Q864-821.7 864-792v336q0 29.7-21.15 50.85Q821.7-384 792-384h-72v216q0 29.7-21.15 50.85Q677.7-96 648-96H168Zm0-72h480v-264H168v264Zm552-288h72v-264H312v144h336q29.7 0 50.85 21.15Q720-533.7 720-504v48Z"></path>
      </g>
      <g id="select-window-off" viewBox="0 -960 960 960">
        <path d="M803-56 427-432H168v264h480v-144l72 71.75v72.65q0 29.6-21.15 50.6T648-96H168q-29.7 0-50.85-21.15Q96-138.3 96-168v-336.18q0-30.82 21-52.32t51-19.5h72v-42L56-803l51-50 746 746-50 51Zm-83-286-98-98-136-136h162q31 0 51.5 20.5T720-504v48h72v-264H342l-97-97q7-22 25.64-34.5Q289.27-864 312-864h480q29.7 0 50.85 21.15Q864-821.7 864-792v336q0 29.7-21.15 50.85Q821.7-384 792-384h-72v42Z"></path>
      </g>
      <g id="sensors" viewBox="0 -960 960 960">
        <path d="M209-209q-53-52-83-121.48T96-479.5q0-80.5 30-150T208-752l51 51q-42 43-66.5 99.6Q168-544.8 168-480.39q0 65.39 24.47 121.93Q216.94-301.92 260-260l-51 51Zm101-101q-32-33-51-76.5t-19-93.23q0-50.73 19-94T310-650l51 51q-22.94 23.21-35.97 53.79Q312-514.62 312-479.81t13.03 65.26Q338.06-384.1 361-361l-51 51Zm169.75-86q-34.75 0-59.25-24.75t-24.5-59.5q0-34.75 24.75-59.25t59.5-24.5q34.75 0 59.25 24.75t24.5 59.5q0 34.75-24.75 59.25t-59.5 24.5ZM649-311l-50-50q22.94-23.21 35.97-53.79Q648-445.38 648-480.19t-13.03-65.26Q621.94-575.9 599-599l51-51q32 33 51 76.34t19 94.16q0 49.82-19 93.16Q682-343 649-311Zm102 102-51-51q43-42 67.5-98.6Q792-415.2 792-479.61q0-65.39-24.5-121.89T701-701l51-51q52 53 82 122.48t30 149.98q0 79.54-30 149.04Q804-261 751-209Z"></path>
      </g>
      <g id="sensors-off" viewBox="0 -960 960 960">
        <path d="M768-90 322-536q-5 13-7.5 27t-2.5 29q0 35 13 65.5t36 53.5l-50 50q-33-32-52-75.5T240-480q0-30 7.5-57.5T268-590l-53-54q-22 36-34.5 77.5T168-480q0 65 24.5 121.5T260-260l-51 51q-53-52-83-121.5T96-480q0-60 17-114.5T162-696l-72-72 51-51 678 678-51 51Zm30-174-53-52q22-36 34.5-77.5T792-480q0-65-24.5-121.5T700-700l51-51q53 52 83 121.5T864-480q0 60-17 115t-49 101ZM693-369l-55-55q5-14 7.5-27.5T648-480q0-35-13-65.5T599-599l50-50q33 32 52 75.5t19 93.5q0 30-6.5 58T693-369Z"></path>
      </g>
      <g id="smart-card-reader" viewBox="0 -960 960 960">
        <path d="M80-80v-120q0-33 23.5-56.5T160-280h640q33 0 56.5 23.5T880-200v120H80Zm80-80h640v-40H160v40Zm40-180v-460q0-33 23.5-56.5T280-880h400q33 0 56.5 23.5T760-800v460h-80v-460H280v460h-80Zm120-60h23q44 0 70.5-44T440-560q0-72-26.5-116T343-720h-23v320Zm240-80q33 0 56.5-23.5T640-560q0-33-23.5-56.5T560-640q-33 0-56.5 23.5T480-560q0 33 23.5 56.5T560-480Zm-80 320Zm0-410Z"></path>
      </g>
      <g id="smart-card-reader-off" viewBox="0 -960 960 960">
        <path d="M680-932q33 0 56.5 23.5T760-852v460h-28l-52-52v-408H273l-53-53q11-13 26.5-20t33.5-7h400Zm-91 396L485-639q9-23 29-38t46-15q33 0 56.5 23.5T640-612q0 26-14 46.5T589-536Zm-269 86v-242l118 118q-7 57-32 90.5T343-450h-23ZM160-212h527l-40-40H160v40ZM819-80l-52-52H80v-120q0-33 23.5-56.5T160-332h407L280-620v228h-80v-308L28-872l56-56 792 791-57 57ZM424-212Zm52-436Zm-82 142Z"></path>
      </g>
      <g id="storage-access" viewBox="0 -960 960 960">
        <path d="M312-255q-97-32-156.5-113.5T96-552q0-130 91-221t221-91q102 0 183.5 59.5T705-648h-77q-29-66-88.5-105T408-792q-100 0-170 70t-70 170q0 72 39 131t105 88v78ZM456-96q-29.7 0-50.85-21.15Q384-138.3 384-168v-336q0-29.7 21.15-50.85Q426.3-576 456-576h336q29.7 0 50.85 21.15Q864-533.7 864-504v336q0 29.7-21.15 50.85Q821.7-96 792-96H456Zm0-72h336v-336H456v336Zm24-48h288l-91-120-72 95-53-71-72 96Zm144-120ZM398-563Z"></path>
      </g>
      <g id="storage-access-off" viewBox="0 -960 960 960">
        <path d="m864-198-72-72v-234H558l-72-72h306q29.7 0 50.85 21.15Q864-533.7 864-504v306ZM628-648q-29-66-88.5-105T408-792q-28.71 0-56.35 7Q324-778 298-764l-54-53q38-23 79.33-35T408-864q102 0 183.5 59.5T705-648h-77Zm-55 363ZM803-55l-41-41H456q-29.7 0-50.85-21.15Q384-138.3 384-168v-306L195-663q-13 25-20 52.95-7 27.95-7 58.05 0 72 39 131t105 88v78q-97-32-156.5-113.5T96-552q0-45.35 12-86.68Q120-680 142-716l-86-86 51-51 747 747-51 51ZM434-646Zm-77 43Zm123 387 71-96 61 62 42-56 90 90H480Zm-24 48h234L456-402v234Zm219-219Z"></path>
      </g>
      <g id="sync-off" viewBox="0 -960 960 960">
        <path d="M768-141 625-284q-17 10-35 18.5T552-252v-76q5-2 10-4.5t10-4.5L286-624q-10 21-16 44.5t-6 48.5q0 48 19.5 89t52.5 70v-63h72v192H216v-72h74q-45-40-71.5-95.5T192-531q0-40 10.5-77t29.5-69L90-820l51-51 678 679-51 51Zm-40-244-54-54q10-21 16-44t6-48q0-48-19.5-89.5T624-691v64h-72v-192h192v72h-74q45 40 71.5 95.5T768-531q0 40-10.5 77T728-385ZM388-725l-53-54q17-10 35-18t38-13v76q-5 2-10 4.5t-10 4.5Z"></path>
      </g>
      <g id="sync-saved-locally" viewBox="0 -960 960 960">
        <path d="m437-402 221-221-55-54-166 166-81-81-55 54 136 136ZM48-144v-72h864v72H48Zm120-120q-29.7 0-50.85-21.15Q96-306.3 96-336v-408q0-29.7 21.15-50.85Q138.3-816 168-816h624q29.7 0 50.85 21.15Q864-773.7 864-744v408q0 29.7-21.15 50.85Q821.7-264 792-264H168Zm0-72h624v-408H168v408Zm0 0v-408 408Z"></path>
      </g>
      <g id="sync-saved-locally-off" viewBox="0 -960 960 960">
        <path d="m797-264-71-72h66v-408H318l-72-72h546q29.7 0 50.85 21.15Q864-773.7 864-744v408q0 27.6-19 48.3-19 20.7-48 23.7Zm6 208-89.05-88H48v-72h594l-48-48H168q-29.7 0-50.85-21.15Q96-306.3 96-336v-408q0-4 .5-8t1.5-8l-42-42 51-51 746 747-50 50ZM522-336 168-690v354h354Zm0-204Zm-177 27Zm149-55 109-109 55 54-109 109-55-54Z"></path>
      </g>
      <g id="usb" viewBox="0 -960 960 960">
        <path d="M479.79-96Q450-96 429-117.15T408-168q0-19.53 9.5-36.26Q427-221 444-230v-106H324q-29.7 0-50.85-21.04Q252-378.08 252-407.63V-490q-17-9-26.5-25.5T216-552q0-29.7 21.21-50.85 21.21-21.15 51-21.15T339-602.85q21 21.15 21 50.85 0 20-9.5 36.5T324-490v82h120v-312h-84l120-144 120 144h-84v312h120v-72h-36v-144h144v144h-36v72q0 29.7-21.15 50.85Q665.7-336 636-336H516v106q17.1 9.11 26.55 25.5 9.45 16.4 9.45 36.44Q552-138 530.79-117q-21.21 21-51 21Z"></path>
      </g>
      <g id="usb-off" viewBox="0 -960 960 960">
        <path d="M768-90 521.58-336H516v106q17.1 8.94 26.55 25.47T552-168q0 29.7-21.21 50.85Q509.58-96 479.79-96T429-117.15Q408-138.3 408-168q0-20 9.5-36t26.5-26v-106H324q-29.7 0-50.85-21.04Q252-378.08 252-407.63V-490q-17-8-26.5-25.22Q216-532.45 216-552q0-17 8.5-32.5T247-611L90-768l51-51 678 678-51 51Zm-73-277-59-59v-54h-36v-144h144v144h-36v72q0 11.08-2.89 21.61T695-367Zm-371-41h120v-6l-97-97q-5 7-10.5 11.5T324-490v82Zm192-138-72-72v-102h-84l120-144 120 144h-84v174Z"></path>
      </g>
      <g id="v8" viewBox="0 -960 960 960">
        <path d="M480-242q-82 0-140.5-58.5T281-441q0-37.71 14-72.36Q309-548 335-575q-9-18-14-36.56-5-18.56-5-38.42 0-68.2 48.21-116.11Q412.41-814 480-814q68.19 0 116.09 47.94Q644-718.11 644-649.87q0 19.87-5 38.87-5 19-14 36 26 27 40 61.64 14 34.65 14 72.36 0 82-58.5 140.5T480-242Zm-.05-48Q543-290 587-333.97T631-441q0-32-13.5-61T579-553l-16-14 12-18q10-14 15.5-30.5T596-650q0-48.18-33.87-82.09-33.87-33.91-82-33.91T398-732.09q-34 33.91-34 82.09 0 17 5.5 33.5T385-585l11 18-15 14q-25 22-38.5 51T329-441q0 63.06 43.95 107.03 43.96 43.97 107 43.97ZM248-523l-50-91h-52L72-744h219q-11 21-17 44.5t-6 49.5q0 16.67 3 33.33 3 16.67 8 33.67-10 14-17.5 29T248-523ZM480-96l-57-106q13.94 3.2 27.87 5.6 13.94 2.4 29.03 2.4 15.1 0 29.1-2.4 14-2.4 28-5.6L480-96Zm232-427q-6.3-15.74-13.65-30.87Q691-569 681-583q5-17 8-33.67 3-16.66 3-33.33 0-26-6-49.5T669-744h219l-74 130h-52l-50 91Zm-232-77q20 0 34-14t14-34q0-20-14-34t-34-14q-20 0-34 14t-14 34q0 20 14 34t34 14Zm.1 228q24.9 0 42.4-17.57T540-432q0-25-17.5-42.5T480-492q-24.86 0-42.43 17.6T420-431.9q0 24.9 17.6 42.4t42.5 17.5Zm-.1-156Z"></path>
      </g>
      <g id="videocam-off" viewBox="0 -960 960 960">
        <path d="M864-289 720-433v90l-72-72v-281H366l-72-72h354q29.7 0 50.85 21.15Q720-725.7 720-696v167l144-144v384ZM803-57 56-803l51-51 747 746-51 51ZM507-556ZM406-455ZM194-766l70 69h-48v433h432v-50l72 72q-8 20-25 35t-46.72 15H216q-29 0-50.5-21.19T144-264.14V-697q0-25.58 14.5-43.79T194-766Z"></path>
      </g>
      <g id="videogame-asset" viewBox="0 -960 960 960">
        <path d="M168-240q-29.7 0-50.85-21.5Q96-283 96-312v-336q0-29 21.15-50.5T168-720h624q29.7 0 50.85 21.5Q864-677 864-648v336q0 29-21.15 50.5T792-240H168Zm0-72h624v-336H168v336Zm122-48h72v-84h84v-72h-84v-84h-72v84h-84v72h84v84Zm286-12q25 0 42.5-17.5T636-432q0-25-17.5-42.5T576-492q-25 0-42.5 17.5T516-432q0 25 17.5 42.5T576-372Zm120-96q25 0 42.5-17.5T756-528q0-25-17.5-42.5T696-588q-25 0-42.5 17.5T636-528q0 25 17.5 42.5T696-468ZM168-312v-336 336Z"></path>
      </g>
      <g id="videogame-asset-off" viewBox="0 -960 960 960">
        <path d="M696-468q-25 0-42.5-17.5T636-528q0-25 17.5-42.5T696-588q25 0 42.5 17.5T756-528q0 25-17.5 42.5T696-468Zm-319-8Zm-89 116v-84h-84v-72h84v-84h72v84h84v72h-84v84h-72ZM168-240q-29 0-50.5-21.5T96-312v-336q0-29 20.2-50.5Q136.39-720 165-720h75l72 72H168v336h378L90-768l51-51 678 678-51 51-150-150H168Zm696-72q0 23.24-12 41.12T817-245l-25-25v-378H414l-72-72h450q29 0 50.5 21.5T864-648v336ZM603-459Z"></path>
      </g>
      <g id="volume-up" viewBox="0 -960 960 960">
        <path d="M552-152v-75q86-23 139-93.26 53-70.25 53-159.5 0-89.24-53.5-158.74Q637-708 552-734v-75q116 25 190 117t74 211q0 119-73.5 211.5T552-152ZM144-385v-192h144l192-192v576L288-385H144Zm408 55v-302q45.12 20.4 70.56 61.2Q648-530 648-480.52q0 48.52-25.44 89.23Q597.12-350.59 552-330ZM408-595l-90 90H216v48h102l90 90v-228Zm-91 113Z"></path>
      </g>
      <g id="volume-off" viewBox="0 -960 960 960">
        <path d="M768-90 661-197q-22 14-52.5 26.5T552-152v-74q12-5 28.5-11.5T608-250L480-378v187L288-383H144v-192h138L90-768l51-51 678 678-51 51Zm-6-209-52-52q16-29 25-61.5t9-66.5q0-89-53.5-158.5T552-733v-74q117 23 190.5 116T816-479q0 48-14 93.5T762-299ZM638-423l-86-86v-122q45 20 70.5 61.5T648-479q0 14-2 28t-8 28ZM480-581l-93-93 93-93v186Zm-72 216v-85l-72-72-18 19H216v48h102l90 90Zm-36-121Z"></path>
      </g>
      <g id="warning" viewBox="0 -960 960 960">
        <path d="m48-144 432-720 432 720H48Zm127-72h610L480-724 175-216Zm304.79-48q15.21 0 25.71-10.29t10.5-25.5q0-15.21-10.29-25.71t-25.5-10.5q-15.21 0-25.71 10.29t-10.5 25.5q0 15.21 10.29 25.71t25.5 10.5ZM444-384h72v-192h-72v192Zm36-86Z"></path>
      </g>
      <g id="web-asset" viewBox="0 -960 960 960">
        <path d="M168-192q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 117.15-747T168-768h624q29.7 0 50.85 21.16Q864-725.68 864-695.96v432.24Q864-234 842.85-213T792-192H168Zm0-72h624v-360H168v360Z"></path>
      </g>
      <g id="web-asset-off" viewBox="0 -960 960 960">
        <path d="M803-56 666-192H168q-29.7 0-50.85-21.16Q96-234.32 96-264.04v-432.24Q96-726 118.03-747T171-768h11v91L56-803l51-50 746 746-50 51ZM168-264h426L234-624h-66v360Zm678 48-54-54v-354H438L294-768h498q29.7 0 50.85 21.15Q864-725.7 864-696v432q0 13.79-5 26.9-5 13.1-13 21.1Z"></path>
      </g>
      <g id="zoom-in" viewBox="0 -960 960 960">
        <path d="M765-144 526-384q-30 23-65.79 35.5-35.79 12.5-76.18 12.5Q284-336 214-406t-70-170q0-100 70-170t170-70q100 0 170 70t70 170.03q0 40.39-12.5 76.18Q599-464 577-434l239 239-51 51ZM384-408q70 0 119-49t49-119q0-70-49-119t-119-49q-70 0-119 49t-49 119q0 70 49 119t119 49Zm-36-60v-72h-72v-72h72v-72h72v72h72v72h-72v72h-72Z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
    document.head.appendChild(iconset);
}
