import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">.toggle{padding:0 var(--cr-section-padding);margin-bottom:var(--cr-section-vertical-padding)}
    </style>
    <settings-toggle-button id="toggle" class="toggle"
      label="$i18n{doNotTrack}"
      pref="{{prefs.enable_do_not_track}}"
      on-settings-boolean-control-change="onToggleChange_"
      sub-label="$i18n{trackingProtectionDoNotTrackToggleSubLabel}"
      icon="settings:forward"
      no-set-pref>
    </settings-toggle-button>
    <template is="dom-if" if="[[showDialog_]]"
        on-dom-change="onDomChange_" restamp>
      <cr-dialog id="confirmDialog"
          close-text="$i18n{close}" on-cancel="onDialogCancel_"
          on-close="onDialogClosed_">
        <div slot="title">$i18n{doNotTrackDialogTitle}</div>
        <div slot="body">$i18n{doNotTrackDialogMessage}
          <a href="$i18nRaw{doNotTrackLearnMoreURL}" target="_blank"
              aria-description="$i18n{opensInNewTab}"
              aria-label="$i18n{doNotTrackDialogLearnMoreA11yLabel}">
            $i18n{learnMore}
          </a>
        </div>
        <div slot="button-container">
          <cr-button class="cancel-button"
              on-click="onDialogCancel_">
            $i18n{cancel}
          </cr-button>
          <cr-button class="action-button"
              on-click="onDialogConfirm_">
            $i18n{confirm}
          </cr-button>
        </div>
      </cr-dialog>
    </template>
<!--_html_template_end_-->`;
}
