// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'personalization-options' contains several toggles related to
 * personalizations.
 */
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_toggle/cr_toggle.js';
import '/shared/settings/prefs/prefs.js';
import '../controls/settings_toggle_button.js';
import '../people_page/signout_dialog.js';
import 'chrome://resources/cr_elements/md_select.css.js';
// 
import '../settings_shared.css.js';
import { WebUiListenerMixin } from '//resources/cr_elements/web_ui_listener_mixin.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { SignedInState, SyncBrowserProxyImpl } from '/shared/settings/people_page/sync_browser_proxy.js';
import { PrefsMixin } from '/shared/settings/prefs/prefs_mixin.js';
import { PrivacyPageBrowserProxyImpl } from '/shared/settings/privacy_page/privacy_page_browser_proxy.js';
import { HelpBubbleMixin } from 'chrome://resources/cr_components/help_bubble/help_bubble_mixin.js';
import { I18nMixin } from 'chrome://resources/cr_elements/i18n_mixin.js';
import { loadTimeData } from '../i18n_setup.js';
import { pageVisibility } from '../page_visibility.js';
import { RelaunchMixin, RestartType } from '../relaunch_mixin.js';
import { getTemplate } from './personalization_options.html.js';
const SettingsPersonalizationOptionsElementBase = HelpBubbleMixin(RelaunchMixin(WebUiListenerMixin(I18nMixin(PrefsMixin(PolymerElement)))));
// browser_element_identifiers constants
const ANONYMIZED_URL_COLLECTION_ID = 'kAnonymizedUrlCollectionPersonalizationSettingId';
export class SettingsPersonalizationOptionsElement extends SettingsPersonalizationOptionsElementBase {
    static get is() {
        return 'settings-personalization-options';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            syncStatus: Object,
            // 
            showSearchAggregatorSuggest_: {
                type: Boolean,
                value: () => loadTimeData.getBoolean('showSearchAggregatorSuggest'),
            },
            searchAggregatorSuggestFakePref_: {
                type: Object,
                value() {
                    return {
                        key: 'enterprise_search_aggregator_settings.fake_pref',
                        type: chrome.settingsPrivate.PrefType.BOOLEAN,
                        value: true,
                        enforcement: chrome.settingsPrivate.Enforcement.ENFORCED,
                        controlledBy: chrome.settingsPrivate.ControlledBy.USER_POLICY,
                    };
                },
            },
            showSignoutDialog_: Boolean,
            syncFirstSetupInProgress_: {
                type: Boolean,
                value: false,
                computed: 'computeSyncFirstSetupInProgress_(syncStatus)',
            },
            // 
        };
    }
    // 
    browserProxy_ = PrivacyPageBrowserProxyImpl.getInstance();
    syncBrowserProxy_ = SyncBrowserProxyImpl.getInstance();
    computeSyncFirstSetupInProgress_() {
        return !!this.syncStatus && !!this.syncStatus.firstSetupInProgress;
    }
    showPriceEmailNotificationsToggle_() {
        if (!loadTimeData.getBoolean('changePriceEmailNotificationsEnabled') ||
            !this.syncStatus) {
            return false;
        }
        // Only show the toggle when the user signed in.
        if (loadTimeData.getBoolean('replaceSyncPromosWithSignInPromos') &&
            this.syncStatus.signedInState === SignedInState.SIGNED_IN) {
            return true;
        }
        return this.syncStatus.signedInState === SignedInState.SYNCING;
    }
    getPriceEmailNotificationsPrefDesc_() {
        const username = this.syncStatus.signedInUsername || '';
        return loadTimeData.getStringF('priceEmailNotificationsPrefDesc', username);
    }
    ready() {
        super.ready();
        // 
        // 
        this.registerHelpBubble(ANONYMIZED_URL_COLLECTION_ID, this.$.urlCollectionToggle.getBubbleAnchor(), { anchorPaddingTop: 10 });
    }
    // 
    /**
     * @return the autocomplete search suggestions CrToggleElement.
     */
    getSearchSuggestToggle() {
        return this.shadowRoot.querySelector('#searchSuggestToggle');
    }
    /**
     * @return the anonymized URL collection CrToggleElement.
     */
    getUrlCollectionToggle() {
        return this.shadowRoot.querySelector('#urlCollectionToggle');
    }
    // 
    // 
    showSearchSuggestToggle_() {
        if (pageVisibility?.privacy === undefined) {
            // pageVisibility isn't defined in non-Guest profiles (crbug.com/1288911).
            return true;
        }
        return pageVisibility.privacy.searchPrediction;
    }
    // 
    navigateTo_(url) {
        window.location.href = url;
    }
    onMetricsReportingLinkClick_() {
        // TODO(wesokuhara) Deep link directly to metrics toggle via settingId.
        this.navigateTo_(loadTimeData.getString('osSettingsPrivacyHubSubpageUrl'));
    }
    // 
    // <!-- _google_chrome -->
    onSigninAllowedChange_() {
        if (this.syncStatus.signedInState === SignedInState.SYNCING &&
            !this.$.signinAllowedToggle.checked) {
            // Switch the toggle back on and show the signout dialog.
            this.$.signinAllowedToggle.checked = true;
            this.showSignoutDialog_ = true;
        }
        else {
            this.$.signinAllowedToggle.sendPrefChange();
            this.$.toast.show();
        }
    }
    onSignoutDialogClosed_() {
        if (this.shadowRoot
            .querySelector('settings-signout-dialog').wasConfirmed()) {
            this.$.signinAllowedToggle.checked = false;
            this.$.signinAllowedToggle.sendPrefChange();
            this.$.toast.show();
        }
        this.showSignoutDialog_ = false;
    }
    onRestartClick_(e) {
        e.stopPropagation();
        this.performRestart(RestartType.RESTART);
    }
}
customElements.define(SettingsPersonalizationOptionsElement.is, SettingsPersonalizationOptionsElement);
