import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="settings-shared"></style>
<settings-subpage page-title="$i18n{securityKeysTitle}"
    route-path$="[[routePath]]">
  <cr-link-row
      id="setPINButton"
      class="hr"
      label="$i18n{securityKeysSetPIN}"
      sub-label="$i18n{securityKeysSetPINDesc}"
      on-click="onSetPin_"></cr-link-row>
  <cr-link-row
      id="credentialManagementButton"
      class="hr"
      label="$i18n{securityKeysCredentialManagementLabel}"
      sub-label="$i18n{securityKeysCredentialManagementDesc}"
      on-click="onCredentialManagement_"></cr-link-row>
  <template is="dom-if" if="[[enableBioEnrollment_]]">
    <cr-link-row
        id="bioEnrollButton"
        class="hr"
        label="$i18n{securityKeysBioEnrollmentSubpageLabel}"
        sub-label="$i18n{securityKeysBioEnrollmentSubpageDescription}"
        on-click="onBioEnroll_"></cr-link-row>
  </template>
  <cr-link-row
      id="resetButton"
      class="hr"
      label="$i18n{securityKeysReset}"
      sub-label="$i18n{securityKeysResetDesc}"
      on-click="onReset_"></cr-link-row>

  <template is="dom-if" if="[[showSetPINDialog_]]" restamp>
    <settings-security-keys-set-pin-dialog on-close="onSetPinDialogClosed_">
    </settings-security-keys-set-pin-dialog>
  </template>

  <template is="dom-if" if="[[showCredentialManagementDialog_]]" restamp>
    <settings-security-keys-credential-management-dialog
        on-credential-management-set-pin="onSetPin_"
        on-close="onCredentialManagementDialogClosed_">
    </settings-security-keys-credential-management-dialog>
  </template>

  <template is="dom-if" if="[[showResetDialog_]]" restamp>
    <settings-security-keys-reset-dialog on-close="onResetDialogClosed_">
    </settings-security-keys-reset-dialog>
  </template>

  <template is="dom-if" if="[[showBioEnrollDialog_]]" restamp>
    <settings-security-keys-bio-enroll-dialog
        on-bio-enroll-set-pin="onSetPin_"
        on-close="onBioEnrollDialogClosed_">
    </settings-security-keys-bio-enroll-dialog>
  </template>
</settings-subpage>
<!--_html_template_end_-->`;
}
