import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">:host{display:flex;flex-direction:column}.box{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow)}.card-container{align-items:stretch;display:flex;gap:16px;justify-content:space-between;width:100%}.card:hover{background-color:var(--cr-hover-background-color);cursor:pointer}.module{height:fit-content;margin-bottom:16px;padding:12px 20px}.section-header{color:var(--cr-primary-text-color);flex:1;font-size:108%;font-weight:400;letter-spacing:.25px;margin-bottom:16px;margin-top:30px;width:100%;user-select:none}.section-header.first{margin-top:0px}</style>

<settings-subpage class="multi-card" page-title="$i18n{safetyHub}"
    learn-more-url="$i18n{safetyHubHelpCenterURL}" route-path$="[[routePath]]">
<h2 class="section-header cr-secondary-text first">
  $i18n{safetyHubPageCardSectionHeader}
</h2>
<div class="card-container">
  <settings-safety-hub-card id="passwords" class="card box"
      data="[[passwordCardData_]]" on-click="onPasswordsClick_"
      tabindex="0" on-keydown="onPasswordsKeyPress_" role="link"
      aria-description="$i18n{safetyHubPasswordNavigationAriaLabel}">
  </settings-safety-hub-card>
  <settings-safety-hub-card id="version" class="card box"
      data="[[versionCardData_]]" on-click="onVersionClick_"
      tabindex="0" on-keydown="onVersionKeyPress_" role="[[versionCardRole_]]"
      aria-description="[[versionCardAriaDescription_]]">
  </settings-safety-hub-card>
  <settings-safety-hub-card id="safeBrowsing" class="card box"
      data="[[safeBrowsingCardData_]]" on-click="onSafeBrowsingClick_"
      tabindex="0" on-keydown="onSafeBrowsingKeyPress_" role="link"
      aria-description="$i18n{safetyHubSBNavigationAriaLabel}">
  </settings-safety-hub-card>
</div>
<h2 class="section-header cr-secondary-text">
  $i18n{safetyHubPageModuleSectionHeader}
</h2>
<template is="dom-if" if="[[showNotificationPermissions_]]">
  <settings-safety-hub-notification-permissions-module class="module box">
  </settings-safety-hub-notification-permissions-module>
</template>
<template is="dom-if" if="[[showUnusedSitePermissions_]]">
  <settings-safety-hub-unused-site-permissions class="module box">
  </settings-safety-hub-unused-site-permissions>
</template>
<template is="dom-if" if="[[showExtensions_]]">
  <settings-safety-hub-extensions-module class="module box">
  </settings-safety-hub-extensions-module>
</template>
<template is="dom-if" if="[[showNoRecommendationsState_]]">
  <settings-safety-hub-module id="emptyStateModule" class="module box"
      header="$i18n{safetyHubEmptyStateModuleHeader}"
      subheader="$i18n{safetyHubEmptyStateModuleSubheader}"
      header-icon="cr:check">
  </settings-safety-hub-module>
  <settings-safety-hub-module
      id="userEducationModule"
      on-sh-module-item-link-click="onEducationLinkClick_"
      class="module box"
      header="$i18n{safetyHubUserEduModuleHeader}"
      header-icon="settings20:lightbulb"
      sites="[[userEducationItemList_]]">
  </settings-safety-hub-module>
</template>

</settings-supage>
<!--_html_template_end_-->`;
}
