import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared action-link">.favicon-image{margin:2px}#storage{padding-inline-end:0}#storageText{display:flex}#resetSettingsButton{margin-top:24px}#usageHeader{padding:0 var(--cr-section-padding)}#usageDetails{align-items:center;display:flex;flex:1;flex-direction:row}#fpsPolicyContainer{display:flex;padding:8px}
    </style>

  <settings-subpage page-title="[[pageTitle_]]" route-path$="[[routePath]]">
    <!-- Confirm reset settings dialog. -->
    <cr-dialog id="confirmResetSettings" close-text="$i18n{close}"
        on-close="onResetSettingsDialogClosed_">
      <div slot="title">$i18n{siteSettingsSiteResetDialogTitle}</div>
      <div slot="body">
        [[i18n('siteSettingsSiteResetConfirmation', pageTitle_)]]
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onResetSettings_">
          $i18n{siteSettingsSiteResetAll}
        </cr-button>
      </div>
    </cr-dialog>

    <!-- Confirm clear storage dialog. -->
    <cr-dialog id="confirmClearStorage" close-text="$i18n{close}"
        on-close="onClearStorageDialogClosed_">
      <style include="clear-storage-dialog-shared"></style>
      <div slot="title">
        $i18n{siteSettingsSiteDeleteStorageDialogTitle}
      </div>
      <div slot="body">
        [[i18n('siteSettingsSiteClearStorageConfirmationNew', pageTitle_)]]
        <div class="detail-list">
          <div class="detail">
            <cr-icon icon="all-sites:logout" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsSiteClearStorageSignOut}
          </div>
          <div class="detail">
            <cr-icon icon="all-sites:offline" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsSiteDeleteStorageOfflineData}
          </div>
          <div class="detail" id="adPersonalization">
            <cr-icon icon="all-sites:tag" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsRemoveSiteAdPersonalization}
          </div>
        </div>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onClearStorage_">
          $i18n{siteSettingsSiteClearStorage}
        </cr-button>
      </div>
    </cr-dialog>

    <div id="usage">
      <div id="usageHeader">
        <h2 class="first">$i18n{siteSettingsUsage}</h2>
      </div>
      <div class="list-frame">
        <div class="list-item" id="noStorage"
            hidden$="[[hasUsage_(storedData_, numCookies_)]]">
          <div class="start">$i18n{siteSettingsUsageNone}</div>
        </div>
        <div class="list-item" id="storage"
            hidden$="[[!hasUsage_(storedData_, numCookies_)]]">
          <div id="usageDetails">
            <div>
              <div id="storageText">
                <div id="storedData" hidden$="[[!storedData_]]">
                  [[storedData_]]
                </div>
                <div hidden$="[[!hasDataAndCookies_(
                    storedData_,numCookies_)]]">
                  &nbsp;&middot;&nbsp;
                </div>
                <div id="numCookies" hidden$="[[!numCookies_]]">
                  [[numCookies_]]
                </div>
              </div>
              <div id="rwsMembership" class="secondary"
                  hidden$="[[!rwsMembership_]]">
                [[rwsMembership_]]
              </div>
            </div>
            <template is="dom-if" if="[[rwsEnterprisePref_]]">
              <div id="fpsPolicyContainer">
                <cr-policy-pref-indicator
                    id="rwsPolicy" pref="[[rwsEnterprisePref_]]"
                    icon-aria-label="[[label]]" focus-row-control
                    focus-type="policy">
                </cr-policy-pref-indicator>
              </div>
            </template>
          </div>
          <cr-button id="clearStorage" role="button" aria-disabled="false"
              on-click="onConfirmClearStorage_"
              aria-label="$i18n{siteSettingsDelete}">
            $i18n{siteSettingsDelete}
          </cr-button>
        </div>
      </div>
    </div>

    <div class="cr-row first">
      <h2 class="flex">$i18n{siteSettingsPermissions}</h2>
      <cr-button id="resetSettingsButton" class="header-aligned-button"
          role="button" aria-disabled="false"
          on-click="onConfirmClearSettings_">
        $i18n{siteSettingsReset}
      </cr-button>
    </div>

    <div class="list-frame">
      <site-details-permission category="[[contentSettingsTypesEnum_.GEOLOCATION]]"
          icon="settings:location-on" label="$i18n{siteSettingsLocation}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.CAMERA]]"
          icon="cr:videocam" label="$i18n{siteSettingsCamera}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.MIC]]"
          icon="privacy:mic" label="$i18n{siteSettingsMic}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.SENSORS]]"
          icon="privacy:sensors" label="$i18n{siteSettingsSensors}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.NOTIFICATIONS]]"
          icon="privacy:notifications"
          label="$i18n{siteSettingsNotifications}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.JAVASCRIPT]]"
          icon="privacy:code" label="$i18n{siteSettingsJavascript}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.IMAGES]]"
          icon="privacy:imagesmode" label="$i18n{siteSettingsImages}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.POPUPS]]"
          icon="cr:open-in-new" label="$i18n{siteSettingsPopups}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.ADS]]"
          icon="privacy:web-asset" label="$i18n{siteSettingsAds}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.BACKGROUND_SYNC]]"
          icon="cr:sync" label="$i18n{siteSettingsBackgroundSync}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.SOUND]]"
          icon="privacy:volume-up" label="$i18n{siteSettingsSound}"
          use-automatic-label="[[blockAutoplayEnabled_]]">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.AUTOMATIC_DOWNLOADS]]"
          icon="cr:file-download" label="$i18n{siteSettingsAutomaticDownloads}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.MIDI_DEVICES]]"
          icon="privacy:piano" label="$i18n{siteSettingsMidiDevices}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.USB_DEVICES]]"
          icon="privacy:usb" label="$i18n{siteSettingsUsbDevices}"
          chooser-type="[[chooserTypeEnum_.USB_DEVICES]]">
      </site-details-permission>

      <template is="dom-if" if="[[enableSmartCardReadersContentSetting_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.SMART_CARD_READERS]]"
            icon="privacy:smart-card-reader"
            label="$i18n{siteSettingsSmartCardReaders}"
            chooser-type="[[chooserTypeEnum_.SMART_CARD_READERS_DEVICES]]">
        </site-details-permission>
      </template>

      <site-details-permission category="[[contentSettingsTypesEnum_.SERIAL_PORTS]]"
          icon="privacy:developer-board" label="$i18n{siteSettingsSerialPorts}"
          chooser-type="[[chooserTypeEnum_.SERIAL_PORTS]]">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.WEB_PRINTING]]"
          icon="settings:printer"
          label="$i18n{siteSettingsWebPrinting}">
      </site-details-permission>
      <template is="dom-if" if="[[enableWebBluetoothNewPermissionsBackend_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.BLUETOOTH_DEVICES]]"
            icon="settings:bluetooth"
            chooser-type="[[chooserTypeEnum_.BLUETOOTH_DEVICES]]"
            label="$i18n{siteSettingsBluetoothDevices}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.FILE_SYSTEM_WRITE]]"
          icon="privacy:file-save"
          label="$i18n{siteSettingsFileSystemWrite}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.HID_DEVICES]]"
          chooser-type="[[chooserTypeEnum_.HID_DEVICES]]"
          icon="privacy:videogame-asset" label="$i18n{siteSettingsHidDevices}">
      </site-details-permission>

      <site-details-permission
          category="[[contentSettingsTypesEnum_.PROTECTED_CONTENT]]"
          icon="privacy:sync-saved-locally"
          label="$i18n{siteSettingsProtectedContentIdentifiers}">
      </site-details-permission>

      <site-details-permission category="[[contentSettingsTypesEnum_.CLIPBOARD]]"
          icon="privacy:content-paste" label="$i18n{siteSettingsClipboard}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.PAYMENT_HANDLER]]"
          icon="privacy:credit-card"
          label="$i18n{siteSettingsPaymentHandler}">
      </site-details-permission>
      <template is="dom-if" if="[[enableExperimentalWebPlatformFeatures_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.BLUETOOTH_SCANNING]]"
            icon="settings:bluetooth-scanning"
            label="$i18n{siteSettingsBluetoothScanning}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.MIXEDSCRIPT]]"
          icon="privacy:warning"
          label="$i18n{siteSettingsInsecureContent}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.JAVASCRIPT_OPTIMIZER]]"
          use-block-if-unfamiliar-label-for-default="[[
              useBlockIfUnfamiliarLabelForV8OptimizerDefault_]]"
          icon="privacy:v8"
          label="$i18n{siteSettingsJavascriptOptimizer}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.FEDERATED_IDENTITY_API]]"
          icon="privacy:account-circle"
          label="$i18n{siteSettingsFederatedIdentityApi}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.AR]]"
          icon="privacy:cardboard" label="$i18n{siteSettingsAr}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.VR]]"
          icon="privacy:cardboard" label="$i18n{siteSettingsVr}">
      </site-details-permission>
      <template is="dom-if" if="[[enableHandTrackingContentSetting_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.HAND_TRACKING]]"
            icon="privacy:hand-gesture" label="$i18n{siteSettingsHandTracking}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.IDLE_DETECTION]]"
          icon="settings:devices"
          label="$i18n{siteSettingsIdleDetection}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.WINDOW_MANAGEMENT]]"
          icon="privacy:select-window"
          label="$i18n{siteSettingsWindowManagement}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.LOCAL_FONTS]]"
          icon="privacy:font-download" label="$i18n{fonts}">
      </site-details-permission>
      <template is="dom-if" if="[[enableAutoPictureInPicture_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.AUTO_PICTURE_IN_PICTURE]]"
            icon="settings:picture-in-picture"
            label="$i18n{siteSettingsAutoPictureInPicture}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableCapturedSurfaceControl_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.CAPTURED_SURFACE_CONTROL]]"
            icon="settings:touchpad-mouse"
            label="$i18n{siteSettingsCapturedSurfaceControl}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.AUTOMATIC_FULLSCREEN]]"
          icon="cr:fullscreen" label="$i18n{siteSettingsAutomaticFullscreen}">
      </site-details-permission>
      <template is="dom-if" if="[[enableKeyboardLockPrompt_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.KEYBOARD_LOCK]]"
            icon="settings20:keyboard-lock"
            label="$i18n{siteSettingsKeyboardLock}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableWebAppInstallation_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.WEB_APP_INSTALLATION]]"
            icon="settings:install-desktop"
            label="$i18n{siteSettingsWebAppInstallation}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableLocalNetworkAccessSetting_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.LOCAL_NETWORK_ACCESS]]"
            icon="settings20:router"
            label="$i18n{siteSettingsLocalNetworkAccess}">
        </site-details-permission>
      </template>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`;
}
