import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#profile-icon{background:center/cover no-repeat;border-radius:20px;flex-shrink:0;height:40px;width:40px}cr-link-row{--cr-link-row-icon-width:40px;border-top:var(--cr-separator-line)}settings-sync-account-control[showing-promo]::part(banner){border-top-left-radius:var(--cr-card-border-radius);border-top-right-radius:var(--cr-card-border-radius)}settings-sync-account-control[showing-promo]::part(title){font-size:1.1rem;line-height:1.625rem}#account-card{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow);flex:1;margin-bottom:20px;margin-top:16px;overflow:hidden}@media (forced-colors:active){#account-card{border:var(--cr-border-hcm)}}
    </style>




  <div id="account-card">
    <div id="profile-row" class="cr-row first two-line"
        actionable$="[[isProfileActionable_]]" on-click="onProfileClick_">
      <template is="dom-if" if="[[syncStatus]]">
        <div id="profile-icon"
            style="background-image: [[getIconImageSet_(
                profileIconUrl_)]]">
        </div>
        <div class="flex cr-row-gap cr-padded-text text-elide">
          <span id="profile-name">[[profileName_]]</span>
          <div class="secondary" hidden="[[!isSyncing_(
                syncStatus.signedInState)]]">
            [[syncStatus.signedInUsername]]
          </div>
        </div>
        <cr-icon-button class="icon-external"
            id="profile-subpage-arrow"
            hidden="[[!isProfileActionable_]]"
            aria-label="$i18n{accountManagerSubMenuLabel}"
            aria-describedby="profile-name"></cr-icon-button>
        </template>
    </div>
  </div>

<!--_html_template_end_-->`;
}
