/* Copyright 2015 The Chromium Authors
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file. */
import{assert}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CrSettingsPrefs}from"./prefs_types.js";function deepEqual(val1,val2){if(val1===val2){return true}if(Array.isArray(val1)||Array.isArray(val2)){if(!Array.isArray(val1)||!Array.isArray(val2)){return false}return arraysEqual(val1,val2)}if(val1 instanceof Object&&val2 instanceof Object){return objectsEqual(val1,val2)}return false}function arraysEqual(arr1,arr2){if(arr1.length!==arr2.length){return false}for(let i=0;i<arr1.length;i++){if(!deepEqual(arr1[i],arr2[i])){return false}}return true}function objectsEqual(obj1,obj2){const keys1=Object.keys(obj1);const keys2=Object.keys(obj2);if(keys1.length!==keys2.length){return false}for(let i=0;i<keys1.length;i++){const key=keys1[i];if(!deepEqual(obj1[key],obj2[key])){return false}}return true}export class SettingsPrefsElement extends PolymerElement{static get is(){return"settings-prefs"}static get properties(){return{prefs:{type:Object,notify:true}}}static get observers(){return["prefsChanged_(prefs.*)"]}lastPrefValues_=new Map;settingsApi_=chrome.settingsPrivate;initialized_=false;boundPrefsChanged_;constructor(){super();if(!CrSettingsPrefs.deferInitialization){this.initialize()}}disconnectedCallback(){super.disconnectedCallback();CrSettingsPrefs.resetForTesting()}initialize(settingsApi){if(this.initialized_){return}this.initialized_=true;if(settingsApi){this.settingsApi_=settingsApi}this.boundPrefsChanged_=this.onSettingsPrivatePrefsChanged_.bind(this);this.settingsApi_.onPrefsChanged.addListener(this.boundPrefsChanged_);this.settingsApi_.getAllPrefs().then((prefs=>{this.updatePrefs_(prefs);CrSettingsPrefs.setInitialized()}))}prefsChanged_(e){if(!CrSettingsPrefs.isInitialized||e.path==="prefs"){return}const key=this.getPrefKeyFromPath_(e.path);const prefStoreValue=this.lastPrefValues_.get(key);const prefObj=this.get(key,this.prefs);if(!deepEqual(prefStoreValue,prefObj.value)){this.dispatchEvent(new CustomEvent("user-action-setting-change",{bubbles:true,composed:true,detail:{prefKey:key,prefValue:prefObj.value}}));this.settingsApi_.setPref(key,prefObj.value,"").then((success=>{if(!success){this.refresh(key)}}))}}onSettingsPrivatePrefsChanged_(prefs){if(CrSettingsPrefs.isInitialized){this.updatePrefs_(prefs)}}refresh(key){this.settingsApi_.getPref(key).then((pref=>{this.updatePrefs_([pref])}))}updatePrefPath_(path,value,prefsObject){const parts=path.split(".");let cur=prefsObject;for(let part;parts.length&&(part=parts.shift());){if(!parts.length){cur[part]=value}else if(part in cur){cur=cur[part]}else{cur=cur[part]={}}}}updatePrefs_(newPrefs){const prefs=this.prefs||{};newPrefs.forEach((newPrefObj=>{this.lastPrefValues_.set(newPrefObj.key,structuredClone(newPrefObj.value));if(!deepEqual(this.get(newPrefObj.key,prefs),newPrefObj)){this.updatePrefPath_(newPrefObj.key,newPrefObj,prefs);if(prefs===this.prefs){this.notifyPath("prefs."+newPrefObj.key,newPrefObj)}}}));if(!this.prefs){this.prefs=prefs}}getPrefKeyFromPath_(path){const parts=path.split(".");assert(parts.shift()==="prefs","Path doesn't begin with 'prefs'");for(let i=1;i<=parts.length;i++){const key=parts.slice(0,i).join(".");if(this.lastPrefValues_.has(key)){return key}}return""}resetForTesting(){if(!this.initialized_){return}this.prefs=undefined;this.lastPrefValues_.clear();this.initialized_=false;this.settingsApi_.onPrefsChanged.removeListener(this.boundPrefsChanged_);this.settingsApi_=chrome.settingsPrivate}}customElements.define(SettingsPrefsElement.is,SettingsPrefsElement);