// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { dedupingMixin } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export const CrPolicyPrefMixin = dedupingMixin((superClass) => {
    class CrPolicyPrefMixin extends superClass {
        static get properties() {
            return {
                /**
                 * Showing that an extension is controlling a pref is sometimes done
                 * with a different UI (e.g. extension-controlled-indicator). In
                 * those cases, avoid showing an (extra) indicator here.
                 */
                noExtensionIndicator: Boolean,
                pref: Object,
            };
        }
        /**
         * Is the |pref| controlled by something that prevents user control of
         * the preference.
         * @return True if |this.pref| is controlled by an enforced policy.
         */
        isPrefEnforced() {
            return !!this.pref &&
                this.pref.enforcement ===
                    chrome.settingsPrivate.Enforcement.ENFORCED;
        }
        /**
         * @return True if |this.pref| has a recommended or enforced policy.
         */
        hasPrefPolicyIndicator() {
            if (!this.pref) {
                return false;
            }
            if (this.noExtensionIndicator &&
                this.pref.controlledBy ===
                    chrome.settingsPrivate.ControlledBy.EXTENSION) {
                return false;
            }
            return this.isPrefEnforced() ||
                this.pref.enforcement ===
                    chrome.settingsPrivate.Enforcement.RECOMMENDED;
        }
    }
    return CrPolicyPrefMixin;
});
