import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-icons cr-hidden-style sp-shared-style">:host{--cr-dialog-width:300px;--back-button-size:14px;--edit-footer-background:var(--google-grey-50)}@media (prefers-color-scheme:dark){:host{--edit-footer-background:var(--google-grey-900-white-4-percent)}}:host([drop-position='into']) power-bookmark-row{background:var(--cr-hover-background-color)}cr-icon-button{--cr-icon-button-icon-size:16px;--cr-icon-button-size:24px;margin:0}cr-toast{justify-content:space-between;left:50%;margin:58px 0;transform:translate(-50%,0);width:calc(100% - 16px)}:host-context([dir=rtl]) cr-toast{left:auto;right:50%;transform:translate(50%,0)}cr-toolbar-search-field{flex-shrink:0;margin:var(--sp-body-padding);width:auto}hr{border:var(--cr-hairline)}cr-icon{--icon-size:16px;height:var(--icon-size);width:var(--icon-size)}sp-list-item-badge cr-icon{--icon-size:12px}cr-icon[invisible]{visibility:hidden}.bookmarks{height:100%;overflow-y:auto}.column{display:flex;flex-direction:column;height:100%}.dialog-body{display:flex;font-size:var(--mwb-primary-text-font-size);gap:12px}.dialog-body>cr-icon{--icon-size:20px}.dropdown-item{gap:4px}sp-empty-state{padding-top:40px}#folderEmptyState{padding-bottom:40px}sp-empty-state[guest]{padding-top:66px}sp-heading{margin:8px 14px}.card-top{border-bottom-left-radius:0;border-bottom-right-radius:0;padding-block-end:0}.card-bottom:not([is-full-card]){border-top-left-radius:0;border-top-right-radius:0;padding-block-start:0}.sp-scroller:has([is-full-card]){border-bottom:solid 1px transparent;padding-bottom:var(--sp-body-padding)}.sp-scroller:has([is-full-card])::-webkit-scrollbar-track{margin-block-end:var(--sp-body-padding)}.icon-button-row{align-items:center;color:var(--cr-secondary-text-color);display:flex;font-size:var(--mwb-secondary-text-font-size);gap:8px}.label-row{display:flex;flex-direction:row;gap:4px;margin:4px var(--sp-body-padding) var(--sp-card-gap)}.label-row[header-hidden]{margin-bottom:14px}.new-folder-icon-container{align-items:center;background-color:var(--google-grey-50);border-radius:4px;display:flex;height:100%;justify-content:center;width:56px}.new-folder-row[compact]>.new-folder-icon-container{background-color:transparent;height:24px;width:24px}.new-folder-row>.new-folder-icon-container{background-color:var(--color-list-item-url-favicon-background)}@media (prefers-color-scheme:dark){.new-folder-icon-container{background-color:var(--google-grey-800)}}.new-folder-row{align-items:center;background:none;border:none;color:var(--cr-primary-text-color);display:flex;font-family:inherit;font-size:12px;font-weight:500;gap:16px;height:41px;padding:6px 16px;width:100%}.new-folder-row[compact]{gap:8px;height:32px;padding:6px 14px}.new-folder-row[disabled]{color:var(--google-grey-400)}.new-folder-row:not([disabled]):hover{background-color:var(--cr-hover-background-color)}.new-folder-row:not([disabled]):active,.new-folder-row:not([disabled]):focus{background-color:var(--cr-active-background-color);outline:none}cr-toolbar-selection-overlay{--cr-toolbar-selection-overlay-padding:16px;background:var(--edit-footer-background);color:var(--cr-secondary-text-color)}cr-toolbar-selection-overlay::part(clearIcon){--cr-icon-button-icon-size:16px;height:24px;margin-inline-end:8px;margin-inline-start:-6px;width:24px}cr-toolbar-selection-overlay{background:transparent;border:0;font-size:12px;font-weight:500}cr-toolbar-selection-overlay::part(clearIcon){margin-inline-end:0;margin-inline-start:-4px}:host(:not([has-scrollbars_])) sp-footer:has(cr-toolbar-selection-overlay[show]){border-top:solid 1px var(--color-side-panel-edit-footer-border)}</style>

<div class="column" id="powerBookmarksContainer">
  <cr-toolbar-search-field id="searchField" label="$i18n{searchBookmarks}"
      clear-label="$i18n{clearSearch}" on-search-changed="onSearchChanged_"
      disabled="[[editing_]]" hidden="[[!sectionVisibility_.search]]"
      on-blur="onSearchBlurred_">
  </cr-toolbar-search-field>
  <div class="label-row" hidden="[[!sectionVisibility_.labels]]"
      header-hidden$="[[!sectionVisibility_.heading]]" id="labelsContainer">
    <power-bookmarks-labels id="labels" disabled="[[editing_]]"
        tracked-product-infos="[[trackedProductInfos_]]"
        on-labels-changed="onLabelsChanged_">
    </power-bookmarks-labels>
  </div>

  <div class="sp-card card-top" hidden$="[[!sectionVisibility_.heading]]">
    <sp-heading id="heading"
        back-button-title="$i18n{tooltipBack}"
        back-button-aria-label="[[getBackButtonLabel_(activeFolderPath_.*)]]"
        on-back-button-click="onBackClicked_"
        hide-back-button="[[shouldHideBackButton_(activeFolderPath_.*)]]"
        disable-back-button="[[disableBackButton_(
            activeFolderPath_.*, editing_)]]">
      <h1 slot="heading">
        [[getActiveFolderLabel_(
             bookmarksTreeViewEnabled_, compact_, activeFolderPath_.*)]]
      </h1>
      <div aria-hidden="true" slot="metadata">
        [[getSortLabel_(activeSortIndex_)]]
      </div>
      <cr-icon-button slot="buttons" class="sort-menu-button"
          iron-icon="sp:filter-list"
          title="$i18n{tooltipOrganize}"
          aria-label="$i18n{sortMenuA11yLabel}"
          aria-description="[[getSortLabel_(activeSortIndex_)]]"
          on-click="onShowSortMenuClicked_">
      </cr-icon-button>
      <cr-icon-button id="viewButton" slot="buttons"
          iron-icon="[[getViewButtonIcon_(compact_)]]"
          title="[[getViewButtonTooltip_(compact_)]]"
          aria-label="[[getViewButtonTooltip_(compact_)]]"
          on-click="onViewToggleClicked_"></cr-icon-button>
      <cr-icon-button id="editButton" slot="buttons" class="icon-edit"
          disabled="[[!hasShownBookmarks_]]"
          title="$i18n{tooltipEdit}"
          aria-label="$i18n{editBookmarkListA11yLabel}"
          aria-pressed="[[editing_]]"
          on-click="onBulkEditClicked_"></cr-icon-button>
      </cr-icon-button>
    </sp-heading>
  </div>

  <template is="dom-if" if="[[!sectionVisibility_.bookmarksList]]">
    <div class="sp-card card-top card-bottom"
        hidden="[[!sectionVisibility_.newFolderButton]]">
      <button class="new-folder-row"
          disabled="[[editing_]]"
          compact$="[[compact_]]"
          aria-label="$i18n{createNewFolderA11yLabel}"
          on-click="onAddNewFolderClicked_">
        <div class="new-folder-icon-container">
          <cr-icon icon="cr:add"></cr-icon>
        </div>
        $i18n{tooltipNewFolder}
      </button>
    </div>
  </template>

  <div class="sp-scroller"
      hidden="[[!sectionVisibility_.folderEmptyState]]">
    <div class="sp-card card-bottom">
      <sp-empty-state id="folderEmptyState"
          image-path="./images/bookmarks_empty.svg"
          dark-image-path="./images/bookmarks_empty_dark.svg"
          heading="$i18n{emptyTitleFolder}"
          body="$i18n{emptyBodyFolder}">
      </sp-empty-state>
    </div>
  </div>

  <div id="bookmarks" class="bookmarks sp-scroller"
      hidden="[[!sectionVisibility_.bookmarksList]]"
      role="[[getBookmarksListRole_(editing_)]]"
      aria-multiselectable="[[editing_]]" scrollable>
    <div class="sp-card card-bottom"
        is-full-card$="[[!sectionVisibility_.heading]]">
      <button class="new-folder-row"
          hidden="[[!sectionVisibility_.newFolderButton]]"
          disabled="[[editing_]]"
          compact$="[[compact_]]"
          aria-label="$i18n{createNewFolderA11yLabel}"
          on-click="onAddNewFolderClicked_">
        <div class="new-folder-icon-container">
          <cr-icon icon="cr:add"></cr-icon>
        </div>
        $i18n{tooltipNewFolder}
      </button>
      <template is="dom-repeat" items="[[displayLists_]]" as="bookmarks">
        <template is="dom-if" restamp if="[[bookmarks.length]]">
          <sp-heading hidden="[[!sectionVisibility_.filterHeadings]]"
              hide-back-button>
            <h1 slot="heading">
              [[getFilterHeading_(index, activeFolderPath_.*)]]
            </h1>
          </sp-heading>
          <iron-list id="shownBookmarksIronList[[index]]"
              items="[[bookmarks]]" scroll-target="bookmarks">
            <template>
              <power-bookmark-row id="bookmark-[[item.id]]" bookmark="[[item]]"
                  compact="[[compact_]]"
                  search-query="[[searchQuery_]]"
                  updated-element-ids="[[updatedElementIds_]]"
                  trailing-icon-tooltip="$i18n{tooltipMore}"
                  has-checkbox="[[editing_]]"
                  selected-bookmarks=
                      "[[getSelectedBookmarksList_(selectedBookmarks_.*)]]"
                  renaming-id="[[renamingId_]]"
                  on-row-clicked="onRowClicked_"
                  on-context-menu="onShowContextMenuClicked_"
                  on-trailing-icon-clicked="onShowContextMenuClicked_"
                  on-checkbox-change="onRowSelectedChange_"
                  on-input-change="onRename_"
                  on-list-item-size-changed="notifyBookmarksListResize_"
                  on-power-bookmark-toggle="onRowToggled_"
                  tabindex$="[[tabIndex]]"
                  image-urls="[[imageUrls_]]"
                  shopping-collection-folder-id=
                      "[[shoppingCollectionFolderId_]]"
                  context-menu-bookmark="[[contextMenuBookmark_]]"
                  draggable="[[canDrag_]]"
                  can-drag="[[canDrag_]]"
                  active-folder-path="[[activeFolderPath_]]"
                  has-folders="[[hasFolders_]]">
              </power-bookmark-row>
            </template>
          </iron-list>
        </template>
      </template>
    </div>
  </div>

  <sp-empty-state id="topLevelEmptyState"
      hidden="[[!sectionVisibility_.topLevelEmptyState]]"
      guest$="[[guestMode_]]"
      image-path="[[getEmptyImagePath_(hasSomeActiveFilter_)]]"
      dark-image-path="[[getEmptyImagePathDark_(hasSomeActiveFilter_)]]"
      heading="[[getEmptyTitle_(hasSomeActiveFilter_)]]"
      body="[[getEmptyBody_(hasSomeActiveFilter_)]]">
  </sp-empty-state>
  <sp-footer id="footer"
      hidden="[[!sectionVisibility_.footer]]"
      pinned>
    <cr-button id="addCurrentTabButton"
        class="floating-button"
        hidden="[[hideAddTabButton_(editing_)]]"
        on-click="onAddTabClicked_"
        disabled="[[!canAddCurrentUrl_(
                    activeFolderPath_.*, currentUrl_, displayLists_)]]">
      <cr-icon slot="prefix-icon" icon="bookmarks:add-tab"></cr-icon>
      $i18n{addCurrentTab}
    </cr-button>

    <cr-toolbar-selection-overlay show="[[editing_]]"
        cancel-label="$i18n{cancelA11yLabel}"
        selection-label="[[getSelectedDescription_(selectedBookmarks_.*)]]"
        on-clear-selected-items="onBulkEditClicked_">
      <div class="sp-icon-buttons-row">
        <cr-icon-button id="deleteButton" iron-icon="bookmarks:delete"
            disabled="[[!getSelectedBookmarksLength_(selectedBookmarks_.*)]]"
            title="$i18n{tooltipDelete}" aria-label="$i18n{tooltipDelete}"
            on-click="onDeleteClicked_">
        </cr-icon-button>
        <cr-icon-button iron-icon="bookmarks:move"
            disabled="[[!getSelectedBookmarksLength_(selectedBookmarks_.*)]]"
            title="$i18n{tooltipMove}" aria-label="$i18n{tooltipMove}"
            on-click="onMoveClicked_">
        </cr-icon-button>
        <cr-icon-button iron-icon="cr:more-vert"
            disabled="[[!getSelectedBookmarksLength_(selectedBookmarks_.*)]]"
            title="$i18n{tooltipMore}" aria-label="$i18n{tooltipMore}"
            on-click="onBulkEditMenuClicked_">
        </cr-icon-button>
      </div>
    </cr-toolbar-selection-overlay>
  </sp-footer>
</div>

<cr-action-menu id="sortMenu">
  <template is="dom-repeat" items="[[sortTypes_]]">
    <button class="dropdown-item" on-click="onSortTypeClicked_">
      <cr-icon icon="cr:check"
          invisible$="[[!sortMenuItemIsSelected_(item, activeSortIndex_)]]">
      </cr-icon>
      [[getSortMenuItemLowerLabel_(item)]]
    </button>
  </template>
</cr-action-menu>

<power-bookmarks-edit-dialog id="editDialog"
    on-save="onBookmarksEdited_">
</power-bookmarks-edit-dialog>

<cr-dialog id="disabledFeatureDialog">
  <div slot="body" class="dialog-body">
    <cr-icon icon="cr:domain"></cr-icon>
    <div>$i18n{disabledFeature}</div>
  </div>
  <div class="button-row" slot="button-container">
    <cr-button on-click="closeDisabledFeatureDialog_">Ok</cr-button>
  </div>
</cr-dialog>

<power-bookmarks-context-menu id="contextMenu"
    on-delete-clicked="onContextMenuDeleteClicked_"
    on-disabled-feature="showDisabledFeatureDialog_"
    on-edit-clicked="onContextMenuEditClicked_"
    on-rename-clicked="setRenamingId_"
    on-close="onContextMenuClosed_">
</power-bookmarks-context-menu>

<cr-lazy-render id="deletionToast">
  <template>
    <cr-toast duration="5000">
      <div>[[deletionDescription_]]</div>
      <cr-button on-click="onUndoClicked_">
        $i18n{undoBookmarkDeletion}
      </cr-button>
    </cr-toast>
  </template>
</cr-lazy-render>
<!--_html_template_end_-->`;
}
