// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getHtml } from './app.html.js';
import { CommentsApiProxyImpl } from './comments_api_proxy.js';
export class CommentsApp extends CrLitElement {
    commentsApi_ = CommentsApiProxyImpl.getInstance();
    static get is() {
        return 'comments-app';
    }
    render() {
        return getHtml.bind(this)();
    }
    connectedCallback() {
        super.connectedCallback();
        this.commentsApi_.showUi();
    }
}
customElements.define(CommentsApp.is, CommentsApp);
