import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="support-tool-shared cr-shared-style">#pii-warning-text{width:520px}#radio-group{width:520px}cr-radio-button{color:var(--cr-title-text-color);padding:8px;padding-inline-start:0}#privacy-disclaimer{color:var(--cr-title-text-color);margin-inline-start:24px;margin-top:-16px}#detected-pii-container{margin-inline-start:36px;width:520px}#detected-pii-item{max-width:520px;padding-bottom:8px;padding-top:8px}cr-expand-button{height:var(--cr-expand-button-icon-size,20px)}.pii-item-collapse{color:var(--cr-title-text-color);margin-bottom:4px;margin-inline-start:36px;margin-top:4px}.pii-details{border:none;border-radius:var(--cr-card-border-radius,4px);padding-bottom:2px;padding-top:2px}cr-button{margin-inline-start:12px}</style>

<h1 tabindex="0">
  $i18n{reviewPiiPageTitle}
</h1>
<div id="pii-warning-text" class="support-tool-title" tabindex="0">
  $i18n{piiWarningText}
</div>
<div id="radio-group">
  <cr-radio-group selected="[[selectedRadioButton_]]"
      on-selected-changed="onSelectedRadioButtonChanged_">
    <cr-radio-button name="[[piiRadioButtonsEnum_.INCLUDE_ALL]]" tabindex="0">
      $i18n{includeAllPiiRadioButton}
    </cr-radio-button>
    <cr-radio-button name="[[piiRadioButtonsEnum_.INCLUDE_NONE]]" tabindex="0">
      $i18n{removePiiRadioButton}
    </cr-radio-button>
    <cr-collapse id="privacy-disclaimer"
        opened$="[[showDisclaimer_(selectedRadioButton_)]]">
      <div tabindex="0">
        $i18n{piiRemovalDisclaimer}
      </div>
    </cr-collapse>
    <cr-radio-button name="[[piiRadioButtonsEnum_.INCLUDE_SOME]]" tabindex="0">
      $i18n{manuallySelectPiiRadioButton}
    </cr-radio-button>
  </cr-radio-group>
</div>
<cr-collapse id="detected-pii-container" opened="[[showPIISelection_]]">
  <div>
    <template is="dom-repeat" items="[[detectedPIIItems_]]">
      <div id="detected-pii-item">
        <cr-expand-button expanded="{{item.expandDetails}}"
            aria-label$=
                "[[getPiiItemAriaLabel_(
                      item.piiTypeDescription, item.count)]]">
          <cr-checkbox checked="{{item.keep}}">
            <span>[[item.piiTypeDescription]]: [[item.count]]</span>
          </cr-checkbox>
        </cr-expand-button>
        <cr-collapse class="pii-item-collapse"
            opened="[[item.expandDetails]]">
          <div class="pii-details" tabindex="0">
            <template is="dom-repeat" items="[[item.detectedData]]">
              <div>
                [[item]]
              </div>
            </template>
          </div>
        </cr-collapse>
      </div>
    </template>
  </div>
</cr-collapse>
<div class="navigation-buttons">
  <cr-button id="cancelButton" on-click="onCancelClick_">
    $i18n{cancelButtonText}
  </cr-button>
  <cr-button id="exportButton" class="action-button"
      on-click="onExportClick_">
      $i18n{exportButtonText}
  </cr-button>
</div>
<!--_html_template_end_-->`}