import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="support-tool-shared">:host{block-size:fit-content;display:block;margin-inline-start:40px;margin-top:72px;width:fit-content}#info-text{color:var(--cr-secondary-text-color);display:inline}.navigation-buttons{margin-inline-start:12px;margin-top:-8px}</style>

<h1 tabindex="0">$i18n{urlGeneratorPageTitle}</h1>
<div class="support-tool-title">$i18n{supportCaseId}</div>
<cr-input id="caseIdInput" class="support-case-id" value="{{caseId_}}"
  spellcheck="false" maxlength="20" aria-label="$i18n{supportCaseId}">
</cr-input>
<div id="data-sources-title" class="support-tool-title" tabindex="0">
  $i18n{dataCollectorListTitle}
</div>

<cr-checkbox class="select-all-checkbox" id="selectAllCheckbox"
  checked="{{selectAll_}}" tabindex="0">
    $i18n{selectAll}
</cr-checkbox>

<div class="data-collector-list" role="group"
     aria-labelledby="data-sources-title">
  <template is="dom-repeat" items="[[dataCollectors_]]">
    <cr-checkbox class="data-collector-checkbox" checked="{{item.isIncluded}}"
        on-change="onDataCollectorItemChange_" tabindex="0">
      [[item.name]]
    </cr-checkbox>
  </template>
</div>

<div class="support-tool-title" tabindex="0">$i18n{getLinkText}</div>
<div>
  <p id="info-text">
    $i18n{copyLinkDescription}
  </p>
  <cr-button id="copyURLButton" class="navigation-buttons action-button"
      on-click="onCopyUrlClick_" disabled="[[buttonDisabled_]]">
      $i18n{copyLinkButtonText}
  </cr-button>
  <cr-button id="copyTokenButton" class="navigation-buttons action-button"
      on-click="onCopyTokenClick_" disabled="[[buttonDisabled_]]">
      $i18n{copyTokenButtonText}
  </cr-button>
</div>
<cr-toast id="copyToast" duration="5000" tabindex="0"
    aria-labelledby="link-copied-message">
  <span id="link-copied-message">[[copiedToastMessage_]]</span>
</cr-toast>
<cr-toast id="errorMessageToast" duration="0" tabindex="0"
    aria-labelledby="error-message">
  <span id="error-message">[[errorMessage_]]</span>
  <cr-button on-click="onErrorMessageToastCloseClicked_">
    $i18n{dismissButtonText}
  </cr-button>
</cr-toast>
<!--_html_template_end_-->`;
}
